/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SClassNode
extends Node {
    private Node receiverNode;
    private StaticScope scope;
    private Node bodyNode;

    public SClassNode(SourcePosition position, Node recvNode, StaticScope scope, Node bodyNode) {
        super(position);
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public void setBody(Node body) {
        this.bodyNode = body;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = receiver;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }
}

