/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node receiverNode;
    private Node argsNode;
    protected Node iterNode;
    protected String name;
    private boolean hasParens = false;

    public CallNode(SourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(SourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.setArgs(argsNode);
        this.iterNode = iterNode;
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Deprecated
    public Node getIterNode() {
        return this.getIter();
    }

    @Override
    public Node getIter() {
        return this.iterNode;
    }

    public Node setIterNode(Node iterNode) {
        this.setIter(iterNode);
        return this;
    }

    @Override
    public void setIter(Node iter) {
        this.iterNode = iter;
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getArgs();
    }

    @Override
    public Node getArgs() {
        return this.argsNode;
    }

    @Deprecated
    public Node setArgsNode(Node argsNode) {
        this.setArgs(argsNode);
        return this.getArgs();
    }

    @Override
    public void setArgs(Node argsNode) {
        if (argsNode == null) {
            argsNode = new ListNode(this.getReceiver().getPosition());
        }
        this.argsNode = argsNode;
    }

    @Override
    public boolean hasParens() {
        return this.hasParens;
    }

    @Override
    public void setHasParens(boolean hasParens) {
        this.hasParens = hasParens;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = receiver;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }
}

