/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterNode
extends Node {
    private Node varNode;
    private Node bodyNode;
    private StaticScope scope;

    public IterNode(SourcePosition position, Node varNode, StaticScope scope, Node bodyNode) {
        super(position);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    public IterNode(SourcePosition position, ArgsNode args, Node body, StaticScope scope) {
        super(position);
        this.varNode = args;
        this.bodyNode = body;
        this.scope = scope;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ITERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBody() {
        return this.bodyNode;
    }

    @Deprecated
    public Node getBodyNode() {
        return this.getBody();
    }

    public Node getVar() {
        return this.varNode;
    }

    @Deprecated
    public Node getVarNode() {
        return this.getVar();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }
}

