/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.asm.Attribute;
import clojure.asm.ByteVector;
import clojure.asm.ClassVisitor;
import clojure.asm.ClassWriter;
import clojure.asm.FieldVisitor;
import clojure.asm.Label;
import clojure.asm.MethodVisitor;
import clojure.asm.Opcodes;
import clojure.asm.Type;
import clojure.asm.commons.GeneratorAdapter;
import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.APersistentMap;
import clojure.lang.APersistentSet;
import clojure.lang.APersistentVector;
import clojure.lang.ArityException;
import clojure.lang.ArraySeq;
import clojure.lang.Associative;
import clojure.lang.DynamicClassLoader;
import clojure.lang.ExceptionInfo;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.ILookupSite;
import clojure.lang.ILookupThunk;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.ISeq;
import clojure.lang.IType;
import clojure.lang.Intrinsics;
import clojure.lang.Keyword;
import clojure.lang.KeywordLookupSite;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LazySeq;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.LispReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Reflector;
import clojure.lang.RestFn;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Util;
import clojure.lang.Var;
import clojure.lang.WarnBoxedMath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Compiler
implements Opcodes {
    static final Symbol DEF = Symbol.intern("def");
    static final Symbol LOOP = Symbol.intern("loop*");
    static final Symbol RECUR = Symbol.intern("recur");
    static final Symbol IF = Symbol.intern("if");
    static final Symbol LET = Symbol.intern("let*");
    static final Symbol LETFN = Symbol.intern("letfn*");
    static final Symbol DO = Symbol.intern("do");
    static final Symbol FN = Symbol.intern("fn*");
    static final Symbol FNONCE = (Symbol)Symbol.intern("fn*").withMeta(RT.map(Keyword.intern(null, "once"), RT.T));
    static final Symbol QUOTE = Symbol.intern("quote");
    static final Symbol THE_VAR = Symbol.intern("var");
    static final Symbol DOT = Symbol.intern(".");
    static final Symbol ASSIGN = Symbol.intern("set!");
    static final Symbol TRY = Symbol.intern("try");
    static final Symbol CATCH = Symbol.intern("catch");
    static final Symbol FINALLY = Symbol.intern("finally");
    static final Symbol THROW = Symbol.intern("throw");
    static final Symbol MONITOR_ENTER = Symbol.intern("monitor-enter");
    static final Symbol MONITOR_EXIT = Symbol.intern("monitor-exit");
    static final Symbol IMPORT = Symbol.intern("clojure.core", "import*");
    static final Symbol DEFTYPE = Symbol.intern("deftype*");
    static final Symbol CASE = Symbol.intern("case*");
    static final Symbol CLASS = Symbol.intern("Class");
    static final Symbol NEW = Symbol.intern("new");
    static final Symbol THIS = Symbol.intern("this");
    static final Symbol REIFY = Symbol.intern("reify*");
    static final Symbol LIST = Symbol.intern("clojure.core", "list");
    static final Symbol HASHMAP = Symbol.intern("clojure.core", "hash-map");
    static final Symbol VECTOR = Symbol.intern("clojure.core", "vector");
    static final Symbol IDENTITY = Symbol.intern("clojure.core", "identity");
    static final Symbol _AMP_ = Symbol.intern("&");
    static final Symbol ISEQ = Symbol.intern("clojure.lang.ISeq");
    static final Keyword loadNs = Keyword.intern(null, "load-ns");
    static final Keyword inlineKey = Keyword.intern(null, "inline");
    static final Keyword inlineAritiesKey = Keyword.intern(null, "inline-arities");
    static final Keyword staticKey = Keyword.intern(null, "static");
    static final Keyword arglistsKey = Keyword.intern(null, "arglists");
    static final Symbol INVOKE_STATIC = Symbol.intern("invokeStatic");
    static final Keyword volatileKey = Keyword.intern(null, "volatile");
    static final Keyword implementsKey = Keyword.intern(null, "implements");
    static final String COMPILE_STUB_PREFIX = "compile__stub";
    static final Keyword protocolKey = Keyword.intern(null, "protocol");
    static final Keyword onKey = Keyword.intern(null, "on");
    static Keyword dynamicKey = Keyword.intern("dynamic");
    static final Keyword redefKey = Keyword.intern(null, "redef");
    static final Symbol NS = Symbol.intern("ns");
    static final Symbol IN_NS = Symbol.intern("in-ns");
    public static final IPersistentMap specials = PersistentHashMap.create(DEF, new DefExpr.Parser(), LOOP, new LetExpr.Parser(), RECUR, new RecurExpr.Parser(), IF, new IfExpr.Parser(), CASE, new CaseExpr.Parser(), LET, new LetExpr.Parser(), LETFN, new LetFnExpr.Parser(), DO, new BodyExpr.Parser(), FN, null, QUOTE, new ConstantExpr.Parser(), THE_VAR, new TheVarExpr.Parser(), IMPORT, new ImportExpr.Parser(), DOT, new HostExpr.Parser(), ASSIGN, new AssignExpr.Parser(), DEFTYPE, new NewInstanceExpr.DeftypeParser(), REIFY, new NewInstanceExpr.ReifyParser(), TRY, new TryExpr.Parser(), THROW, new ThrowExpr.Parser(), MONITOR_ENTER, new MonitorEnterExpr.Parser(), MONITOR_EXIT, new MonitorExitExpr.Parser(), CATCH, null, FINALLY, null, NEW, new NewExpr.Parser(), _AMP_, null);
    private static final int MAX_POSITIONAL_ARITY = 20;
    private static final Type OBJECT_TYPE;
    private static final Type KEYWORD_TYPE;
    private static final Type VAR_TYPE;
    private static final Type SYMBOL_TYPE;
    private static final Type IFN_TYPE;
    private static final Type AFUNCTION_TYPE;
    private static final Type RT_TYPE;
    private static final Type NUMBERS_TYPE;
    static final Type CLASS_TYPE;
    static final Type NS_TYPE;
    static final Type UTIL_TYPE;
    static final Type REFLECTOR_TYPE;
    static final Type THROWABLE_TYPE;
    static final Type BOOLEAN_OBJECT_TYPE;
    static final Type IPERSISTENTMAP_TYPE;
    static final Type IOBJ_TYPE;
    static final Type TUPLE_TYPE;
    static final clojure.asm.commons.Method[] createTupleMethods;
    private static final Type[][] ARG_TYPES;
    private static final Type[] EXCEPTION_TYPES;
    public static final Var LOCAL_ENV;
    public static final Var LOOP_LOCALS;
    public static final Var LOOP_LABEL;
    public static final Var CONSTANTS;
    public static final Var CONSTANT_IDS;
    public static final Var KEYWORD_CALLSITES;
    public static final Var PROTOCOL_CALLSITES;
    public static final Var VAR_CALLSITES;
    public static final Var KEYWORDS;
    public static final Var VARS;
    public static final Var METHOD;
    public static final Var IN_CATCH_FINALLY;
    public static final Var NO_RECUR;
    public static final Var LOADER;
    public static final Var SOURCE;
    public static final Var SOURCE_PATH;
    public static final Var COMPILE_PATH;
    public static final Var COMPILE_FILES;
    public static final Var INSTANCE;
    public static final Var ADD_ANNOTATIONS;
    public static final Keyword disableLocalsClearingKey;
    public static final Keyword directLinkingKey;
    public static final Keyword elideMetaKey;
    public static final Var COMPILER_OPTIONS;
    public static final Var LINE;
    public static final Var COLUMN;
    public static final Var LINE_BEFORE;
    public static final Var COLUMN_BEFORE;
    public static final Var LINE_AFTER;
    public static final Var COLUMN_AFTER;
    public static final Var NEXT_LOCAL_NUM;
    public static final Var RET_LOCAL_NUM;
    public static final Var COMPILE_STUB_SYM;
    public static final Var COMPILE_STUB_CLASS;
    public static final Var CLEAR_PATH;
    public static final Var CLEAR_ROOT;
    public static final Var CLEAR_SITES;
    public static final Class RECUR_CLASS;
    static final NilExpr NIL_EXPR;
    static final BooleanExpr TRUE_EXPR;
    static final BooleanExpr FALSE_EXPR;
    public static final IPersistentMap CHAR_MAP;
    public static final IPersistentMap DEMUNGE_MAP;
    public static final Pattern DEMUNGE_PATTERN;
    private static final Object OPTS_COND_ALLOWED;

    public static Object getCompilerOption(Keyword k) {
        return RT.get(COMPILER_OPTIONS.deref(), k);
    }

    static Object elideMeta(Object m) {
        Collection elides = (Collection)Compiler.getCompilerOption(elideMetaKey);
        if (elides != null) {
            for (Object k : elides) {
                m = RT.dissoc(m, k);
            }
        }
        return m;
    }

    static int lineDeref() {
        return ((Number)LINE.deref()).intValue();
    }

    static int columnDeref() {
        return ((Number)COLUMN.deref()).intValue();
    }

    static boolean isSpecial(Object sym) {
        return specials.containsKey(sym);
    }

    static Symbol resolveSymbol(Symbol sym) {
        if (sym.name.indexOf(46) > 0) {
            return sym;
        }
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(sym);
            if (ns2 == null || (ns2.name.name == null ? sym.ns == null : ns2.name.name.equals(sym.ns))) {
                return sym;
            }
            return Symbol.intern(ns2.name.name, sym.name);
        }
        Object o = Compiler.currentNS().getMapping(sym);
        if (o == null) {
            return Symbol.intern(Compiler.currentNS().name.name, sym.name);
        }
        if (o instanceof Class) {
            return Symbol.intern(null, ((Class)o).getName());
        }
        if (o instanceof Var) {
            Var v = (Var)o;
            return Symbol.intern(v.ns.name.name, v.sym.name);
        }
        return null;
    }

    static Class maybePrimitiveType(Expr e2) {
        Class c;
        if (e2 instanceof MaybePrimitiveExpr && e2.hasJavaClass() && ((MaybePrimitiveExpr)e2).canEmitPrimitive() && Util.isPrimitive(c = e2.getJavaClass())) {
            return c;
        }
        return null;
    }

    static Class maybeJavaClass(Collection<Expr> exprs) {
        Class match = null;
        try {
            for (Expr e2 : exprs) {
                if (e2 instanceof ThrowExpr) continue;
                if (!e2.hasJavaClass()) {
                    return null;
                }
                Class c = e2.getJavaClass();
                if (match == null) {
                    match = c;
                    continue;
                }
                if (match == c) continue;
                return null;
            }
        }
        catch (Exception e3) {
            return null;
        }
        return match;
    }

    public static boolean subsumes(Class[] c1, Class[] c2) {
        Boolean better = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                better = true;
                continue;
            }
            return false;
        }
        return better;
    }

    static String getTypeStringForArgs(IPersistentVector args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.count(); ++i) {
            Expr arg = (Expr)args.nth(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(arg.hasJavaClass() && arg.getJavaClass() != null ? arg.getJavaClass().getName() : "unknown");
        }
        return sb.toString();
    }

    static int getMatchingParams(String methodName, ArrayList<Class[]> paramlists, IPersistentVector argexprs, List<Class> rets) {
        int matchIdx = -1;
        boolean tied = false;
        boolean foundExact = false;
        for (int i = 0; i < paramlists.size(); ++i) {
            boolean match = true;
            ISeq aseq = argexprs.seq();
            int exact = 0;
            for (int p = 0; match && p < argexprs.count() && aseq != null; ++p, aseq = aseq.next()) {
                Expr arg = (Expr)aseq.first();
                Class aclass = arg.hasJavaClass() ? arg.getJavaClass() : Object.class;
                Class pclass = paramlists.get(i)[p];
                if (arg.hasJavaClass() && aclass == pclass) {
                    ++exact;
                    continue;
                }
                match = Reflector.paramArgTypeMatch(pclass, aclass);
            }
            if (exact == argexprs.count()) {
                if (!foundExact || matchIdx == -1 || rets.get(matchIdx).isAssignableFrom(rets.get(i))) {
                    matchIdx = i;
                }
                tied = false;
                foundExact = true;
                continue;
            }
            if (!match || foundExact) continue;
            if (matchIdx == -1) {
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(i), paramlists.get(matchIdx))) {
                matchIdx = i;
                tied = false;
                continue;
            }
            if (Arrays.equals(paramlists.get(matchIdx), paramlists.get(i))) {
                if (!rets.get(matchIdx).isAssignableFrom(rets.get(i))) continue;
                matchIdx = i;
                continue;
            }
            if (Compiler.subsumes(paramlists.get(matchIdx), paramlists.get(i))) continue;
            tied = true;
        }
        if (tied) {
            throw new IllegalArgumentException("More than one matching method found: " + methodName);
        }
        return matchIdx;
    }

    public static String munge(String name2) {
        StringBuilder sb = new StringBuilder();
        for (char c : name2.toCharArray()) {
            String sub = (String)CHAR_MAP.valAt(Character.valueOf(c));
            if (sub != null) {
                sb.append(sub);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            Character origCh = (Character)DEMUNGE_MAP.valAt(m.group());
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        return sb.toString();
    }

    static PathNode clearPathRoot() {
        return (PathNode)CLEAR_ROOT.get();
    }

    private static LocalBinding registerLocal(Symbol sym, Symbol tag, Expr init, boolean isArg) {
        int num2 = Compiler.getAndIncLocalNum();
        LocalBinding b = new LocalBinding(num2, sym, tag, init, isArg, Compiler.clearPathRoot());
        IPersistentMap localsMap = (IPersistentMap)LOCAL_ENV.deref();
        LOCAL_ENV.set(RT.assoc(localsMap, b.sym, b));
        ObjMethod method = (ObjMethod)METHOD.deref();
        method.locals = (IPersistentMap)RT.assoc(method.locals, b, b);
        method.indexlocals = (IPersistentMap)RT.assoc(method.indexlocals, num2, b);
        return b;
    }

    private static int getAndIncLocalNum() {
        int num2 = ((Number)NEXT_LOCAL_NUM.deref()).intValue();
        ObjMethod m = (ObjMethod)METHOD.deref();
        if (num2 > m.maxLocal) {
            m.maxLocal = num2;
        }
        NEXT_LOCAL_NUM.set(num2 + 1);
        return num2;
    }

    public static Expr analyze(C context, Object form) {
        return Compiler.analyze(context, form, null);
    }

    private static Expr analyze(C context, Object form, String name2) {
        try {
            if (form instanceof LazySeq) {
                Object mform = form;
                if ((form = RT.seq(form)) == null) {
                    form = PersistentList.EMPTY;
                }
                form = ((IObj)form).withMeta(RT.meta(mform));
            }
            if (form == null) {
                return NIL_EXPR;
            }
            if (form == Boolean.TRUE) {
                return TRUE_EXPR;
            }
            if (form == Boolean.FALSE) {
                return FALSE_EXPR;
            }
            Class<?> fclass = form.getClass();
            if (fclass == Symbol.class) {
                return Compiler.analyzeSymbol((Symbol)form);
            }
            if (fclass == Keyword.class) {
                return Compiler.registerKeyword((Keyword)form);
            }
            if (form instanceof Number) {
                return NumberExpr.parse((Number)form);
            }
            if (fclass == String.class) {
                return new StringExpr(((String)form).intern());
            }
            if (form instanceof IPersistentCollection && !(form instanceof IRecord) && !(form instanceof IType) && ((IPersistentCollection)form).count() == 0) {
                Expr ret = new EmptyExpr(form);
                if (RT.meta(form) != null) {
                    ret = new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)form).meta()));
                }
                return ret;
            }
            if (form instanceof ISeq) {
                return Compiler.analyzeSeq(context, (ISeq)form, name2);
            }
            if (form instanceof IPersistentVector) {
                return VectorExpr.parse(context, (IPersistentVector)form);
            }
            if (form instanceof IRecord) {
                return new ConstantExpr(form);
            }
            if (form instanceof IType) {
                return new ConstantExpr(form);
            }
            if (form instanceof IPersistentMap) {
                return MapExpr.parse(context, (IPersistentMap)form);
            }
            if (form instanceof IPersistentSet) {
                return SetExpr.parse(context, (IPersistentSet)form);
            }
            return new ConstantExpr(form);
        }
        catch (Throwable e2) {
            if (!(e2 instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), Compiler.lineDeref(), Compiler.columnDeref(), e2);
            }
            throw (CompilerException)e2;
        }
    }

    public static Var isMacro(Object op) {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false, false);
            if (v != null && v.isMacro()) {
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                return v;
            }
        }
        return null;
    }

    public static IFn isInline(Object op, int arity) {
        if (op instanceof Symbol && Compiler.referenceLocal((Symbol)op) != null) {
            return null;
        }
        if (op instanceof Symbol || op instanceof Var) {
            Var v;
            Var var = v = op instanceof Var ? (Var)op : Compiler.lookupVar((Symbol)op, false);
            if (v != null) {
                IFn arityPred;
                if (v.ns != Compiler.currentNS() && !v.isPublic()) {
                    throw new IllegalStateException("var: " + v + " is not public");
                }
                IFn ret = (IFn)RT.get(v.meta(), inlineKey);
                if (ret != null && ((arityPred = (IFn)RT.get(v.meta(), inlineAritiesKey)) == null || RT.booleanCast(arityPred.invoke(arity)))) {
                    return ret;
                }
            }
        }
        return null;
    }

    public static boolean namesStaticMember(Symbol sym) {
        return sym.ns != null && Compiler.namespaceFor(sym) == null;
    }

    public static Object preserveTag(ISeq src, Object dst) {
        Symbol tag = Compiler.tagOf(src);
        if (tag != null && dst instanceof IObj) {
            IPersistentMap meta = RT.meta(dst);
            return ((IObj)dst).withMeta((IPersistentMap)RT.assoc(meta, RT.TAG_KEY, tag));
        }
        return dst;
    }

    public static Object macroexpand1(Object x) {
        if (x instanceof ISeq) {
            ISeq form = (ISeq)x;
            Object op = RT.first(form);
            if (Compiler.isSpecial(op)) {
                return x;
            }
            Var v = Compiler.isMacro(op);
            if (v != null) {
                try {
                    return v.applyTo(RT.cons(form, RT.cons(LOCAL_ENV.get(), form.next())));
                }
                catch (ArityException e2) {
                    throw new ArityException(e2.actual - 2, e2.name);
                }
            }
            if (op instanceof Symbol) {
                Symbol sym = (Symbol)op;
                String sname = sym.name;
                if (sym.name.charAt(0) == '.') {
                    if (RT.length(form) < 2) {
                        throw new IllegalArgumentException("Malformed member expression, expecting (.member target ...)");
                    }
                    Symbol meth = Symbol.intern(sname.substring(1));
                    Object target = RT.second(form);
                    if (HostExpr.maybeClass(target, false) != null) {
                        target = ((IObj)((Object)RT.list(IDENTITY, target))).withMeta(RT.map(RT.TAG_KEY, CLASS));
                    }
                    return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next().next()));
                }
                if (Compiler.namesStaticMember(sym)) {
                    Symbol target = Symbol.intern(sym.ns);
                    Class c = HostExpr.maybeClass(target, false);
                    if (c != null) {
                        Symbol meth = Symbol.intern(sym.name);
                        return Compiler.preserveTag(form, RT.listStar(DOT, target, meth, form.next()));
                    }
                } else {
                    int idx = sname.lastIndexOf(46);
                    if (idx == sname.length() - 1) {
                        return RT.listStar(NEW, Symbol.intern(sname.substring(0, idx)), form.next());
                    }
                }
            }
        }
        return x;
    }

    static Object macroexpand(Object form) {
        Object exf = Compiler.macroexpand1(form);
        if (exf != form) {
            return Compiler.macroexpand(exf);
        }
        return form;
    }

    private static Expr analyzeSeq(C context, ISeq form, String name2) {
        Object line = Compiler.lineDeref();
        Object column = Compiler.columnDeref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = RT.meta(form).valAt(RT.LINE_KEY);
        }
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.COLUMN_KEY)) {
            column = RT.meta(form).valAt(RT.COLUMN_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line, COLUMN, column));
        try {
            Object me = Compiler.macroexpand1(form);
            if (me != form) {
                Expr expr = Compiler.analyze(context, me, name2);
                return expr;
            }
            Object op = RT.first(form);
            if (op == null) {
                throw new IllegalArgumentException("Can't call nil, form: " + form);
            }
            IFn inline = Compiler.isInline(op, RT.count(RT.next(form)));
            if (inline != null) {
                Expr expr = Compiler.analyze(context, Compiler.preserveTag(form, inline.applyTo(RT.next(form))));
                return expr;
            }
            if (op.equals(FN)) {
                Expr expr = FnExpr.parse(context, form, name2);
                return expr;
            }
            IParser p = (IParser)specials.valAt(op);
            if (p != null) {
                Expr expr = p.parse(context, form);
                return expr;
            }
            Expr expr = InvokeExpr.parse(context, form);
            return expr;
        }
        catch (Throwable e2) {
            if (!(e2 instanceof CompilerException)) {
                throw new CompilerException((String)SOURCE_PATH.deref(), Compiler.lineDeref(), Compiler.columnDeref(), e2);
            }
            throw (CompilerException)e2;
        }
        finally {
            Var.popThreadBindings();
        }
    }

    static String errorMsg(String source2, int line, int column, String s) {
        return String.format("%s, compiling:(%s:%d:%d)", s, source2, line, column);
    }

    public static Object eval(Object form) {
        return Compiler.eval(form, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object eval(Object form, boolean freshLoader) {
        boolean createdLoader = false;
        Var.pushThreadBindings(RT.map(LOADER, RT.makeClassLoader()));
        createdLoader = true;
        try {
            block15: {
                block14: {
                    Object object;
                    Object line = Compiler.lineDeref();
                    Object column = Compiler.columnDeref();
                    if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
                        line = RT.meta(form).valAt(RT.LINE_KEY);
                    }
                    if (RT.meta(form) != null && RT.meta(form).containsKey(RT.COLUMN_KEY)) {
                        column = RT.meta(form).valAt(RT.COLUMN_KEY);
                    }
                    Var.pushThreadBindings(RT.map(LINE, line, COLUMN, column));
                    try {
                        form = Compiler.macroexpand(form);
                        if (!(form instanceof ISeq) || !Util.equals(RT.first(form), DO)) break block14;
                        ISeq s = RT.next(form);
                        while (RT.next(s) != null) {
                            Compiler.eval(RT.first(s), false);
                            s = RT.next(s);
                        }
                        object = Compiler.eval(RT.first(s), false);
                    }
                    catch (Throwable throwable) {
                        Var.popThreadBindings();
                        throw throwable;
                    }
                    Var.popThreadBindings();
                    return object;
                }
                if (!(form instanceof IType) && (!(form instanceof IPersistentCollection) || RT.first(form) instanceof Symbol && ((Symbol)RT.first((Object)form)).name.startsWith("def"))) break block15;
                ObjExpr fexpr = (ObjExpr)Compiler.analyze(C.EXPRESSION, RT.list(FN, PersistentVector.EMPTY, form), "eval" + RT.nextID());
                IFn fn2 = (IFn)fexpr.eval();
                Object object = fn2.invoke();
                Var.popThreadBindings();
                return object;
            }
            Expr expr = Compiler.analyze(C.EVAL, form);
            Object object = expr.eval();
            Var.popThreadBindings();
            return object;
        }
        finally {
            if (createdLoader) {
                Var.popThreadBindings();
            }
        }
    }

    private static int registerConstant(Object o) {
        if (!CONSTANTS.isBound()) {
            return -1;
        }
        PersistentVector v = (PersistentVector)CONSTANTS.deref();
        IdentityHashMap ids = (IdentityHashMap)CONSTANT_IDS.deref();
        Integer i = (Integer)ids.get(o);
        if (i != null) {
            return i;
        }
        CONSTANTS.set(RT.conj(v, o));
        ids.put(o, v.count());
        return v.count();
    }

    private static KeywordExpr registerKeyword(Keyword keyword2) {
        if (!KEYWORDS.isBound()) {
            return new KeywordExpr(keyword2);
        }
        IPersistentMap keywordsMap = (IPersistentMap)KEYWORDS.deref();
        Object id = RT.get(keywordsMap, keyword2);
        if (id == null) {
            KEYWORDS.set(RT.assoc(keywordsMap, keyword2, Compiler.registerConstant(keyword2)));
        }
        return new KeywordExpr(keyword2);
    }

    private static int registerKeywordCallsite(Keyword keyword2) {
        if (!KEYWORD_CALLSITES.isBound()) {
            throw new IllegalAccessError("KEYWORD_CALLSITES is not bound");
        }
        IPersistentVector keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
        keywordCallsites = keywordCallsites.cons(keyword2);
        KEYWORD_CALLSITES.set(keywordCallsites);
        return keywordCallsites.count() - 1;
    }

    private static int registerProtocolCallsite(Var v) {
        if (!PROTOCOL_CALLSITES.isBound()) {
            throw new IllegalAccessError("PROTOCOL_CALLSITES is not bound");
        }
        IPersistentVector protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
        protocolCallsites = protocolCallsites.cons(v);
        PROTOCOL_CALLSITES.set(protocolCallsites);
        return protocolCallsites.count() - 1;
    }

    private static void registerVarCallsite(Var v) {
        if (!VAR_CALLSITES.isBound()) {
            throw new IllegalAccessError("VAR_CALLSITES is not bound");
        }
        IPersistentCollection varCallsites = (IPersistentCollection)VAR_CALLSITES.deref();
        varCallsites = varCallsites.cons(v);
        VAR_CALLSITES.set(varCallsites);
    }

    static ISeq fwdPath(PathNode p1) {
        ISeq ret = null;
        while (p1 != null) {
            ret = RT.cons(p1, ret);
            p1 = p1.parent;
        }
        return ret;
    }

    static PathNode commonPath(PathNode n1, PathNode n2) {
        ISeq xp = Compiler.fwdPath(n1);
        ISeq yp = Compiler.fwdPath(n2);
        if (RT.first(xp) != RT.first(yp)) {
            return null;
        }
        while (RT.second(xp) != null && RT.second(xp) == RT.second(yp)) {
            xp = xp.next();
            yp = yp.next();
        }
        return (PathNode)RT.first(xp);
    }

    static void addAnnotation(Object visitor, IPersistentMap meta) {
        if (meta != null && ADD_ANNOTATIONS.isBound()) {
            ADD_ANNOTATIONS.invoke(visitor, meta);
        }
    }

    static void addParameterAnnotation(Object visitor, IPersistentMap meta, int i) {
        if (meta != null && ADD_ANNOTATIONS.isBound()) {
            ADD_ANNOTATIONS.invoke(visitor, meta, i);
        }
    }

    private static Expr analyzeSymbol(Symbol sym) {
        Object o;
        Symbol nsSym;
        Class c;
        Symbol tag = Compiler.tagOf(sym);
        if (sym.ns == null) {
            LocalBinding b = Compiler.referenceLocal(sym);
            if (b != null) {
                return new LocalBindingExpr(b, tag);
            }
        } else if (Compiler.namespaceFor(sym) == null && (c = HostExpr.maybeClass(nsSym = Symbol.intern(sym.ns), false)) != null) {
            if (Reflector.getField(c, sym.name, true) != null) {
                return new StaticFieldExpr(Compiler.lineDeref(), Compiler.columnDeref(), c, sym.name, tag);
            }
            throw Util.runtimeException("Unable to find static field: " + sym.name + " in " + c);
        }
        if ((o = Compiler.resolve(sym)) instanceof Var) {
            Var v = (Var)o;
            if (Compiler.isMacro(v) != null) {
                throw Util.runtimeException("Can't take value of a macro: " + v);
            }
            if (RT.booleanCast(RT.get(v.meta(), RT.CONST_KEY))) {
                return Compiler.analyze(C.EXPRESSION, RT.list(QUOTE, v.get()));
            }
            Compiler.registerVar(v);
            return new VarExpr(v, tag);
        }
        if (o instanceof Class) {
            return new ConstantExpr(o);
        }
        if (o instanceof Symbol) {
            return new UnresolvedVarExpr((Symbol)o);
        }
        throw Util.runtimeException("Unable to resolve symbol: " + sym + " in this context");
    }

    static String destubClassName(String className) {
        if (className.startsWith(COMPILE_STUB_PREFIX)) {
            return className.substring(COMPILE_STUB_PREFIX.length() + 1);
        }
        return className;
    }

    static Type getType(Class c) {
        String descriptor2 = Type.getType(c).getDescriptor();
        if (descriptor2.startsWith("L")) {
            descriptor2 = "L" + Compiler.destubClassName(descriptor2.substring(1));
        }
        return Type.getType(descriptor2);
    }

    static Object resolve(Symbol sym, boolean allowPrivate) {
        return Compiler.resolveIn(Compiler.currentNS(), sym, allowPrivate);
    }

    static Object resolve(Symbol sym) {
        return Compiler.resolveIn(Compiler.currentNS(), sym, false);
    }

    static Namespace namespaceFor(Symbol sym) {
        return Compiler.namespaceFor(Compiler.currentNS(), sym);
    }

    static Namespace namespaceFor(Namespace inns, Symbol sym) {
        Symbol nsSym = Symbol.intern(sym.ns);
        Namespace ns2 = inns.lookupAlias(nsSym);
        if (ns2 == null) {
            ns2 = Namespace.find(nsSym);
        }
        return ns2;
    }

    public static Object resolveIn(Namespace n, Symbol sym, boolean allowPrivate) {
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(n, sym);
            if (ns2 == null) {
                throw Util.runtimeException("No such namespace: " + sym.ns);
            }
            Var v = ns2.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                throw Util.runtimeException("No such var: " + sym);
            }
            if (v.ns != Compiler.currentNS() && !v.isPublic() && !allowPrivate) {
                throw new IllegalStateException("var: " + sym + " is not public");
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
            return COMPILE_STUB_CLASS.get();
        }
        Object o = n.getMapping(sym);
        if (o == null) {
            if (RT.booleanCast(RT.ALLOW_UNRESOLVED_VARS.deref())) {
                return sym;
            }
            throw Util.runtimeException("Unable to resolve symbol: " + sym + " in this context");
        }
        return o;
    }

    public static Object maybeResolveIn(Namespace n, Symbol sym) {
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(n, sym);
            if (ns2 == null) {
                return null;
            }
            Var v = ns2.findInternedVar(Symbol.intern(sym.name));
            if (v == null) {
                return null;
            }
            return v;
        }
        if (sym.name.indexOf(46) > 0 && !sym.name.endsWith(".") || sym.name.charAt(0) == '[') {
            return RT.classForName(sym.name);
        }
        if (sym.equals(NS)) {
            return RT.NS_VAR;
        }
        if (sym.equals(IN_NS)) {
            return RT.IN_NS_VAR;
        }
        Object o = n.getMapping(sym);
        return o;
    }

    static Var lookupVar(Symbol sym, boolean internNew, boolean registerMacro) {
        Var var = null;
        if (sym.ns != null) {
            Namespace ns2 = Compiler.namespaceFor(sym);
            if (ns2 == null) {
                return null;
            }
            Symbol name2 = Symbol.intern(sym.name);
            var = internNew && ns2 == Compiler.currentNS() ? Compiler.currentNS().intern(name2) : ns2.findInternedVar(name2);
        } else if (sym.equals(NS)) {
            var = RT.NS_VAR;
        } else if (sym.equals(IN_NS)) {
            var = RT.IN_NS_VAR;
        } else {
            Object o = Compiler.currentNS().getMapping(sym);
            if (o == null) {
                if (internNew) {
                    var = Compiler.currentNS().intern(Symbol.intern(sym.name));
                }
            } else if (o instanceof Var) {
                var = (Var)o;
            } else {
                throw Util.runtimeException("Expecting var, but " + sym + " is mapped to " + o);
            }
        }
        if (var != null && (!var.isMacro() || registerMacro)) {
            Compiler.registerVar(var);
        }
        return var;
    }

    static Var lookupVar(Symbol sym, boolean internNew) {
        return Compiler.lookupVar(sym, internNew, true);
    }

    private static void registerVar(Var var) {
        if (!VARS.isBound()) {
            return;
        }
        IPersistentMap varsMap = (IPersistentMap)VARS.deref();
        Object id = RT.get(varsMap, var);
        if (id == null) {
            VARS.set(RT.assoc(varsMap, var, Compiler.registerConstant(var)));
        }
    }

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static void closeOver(LocalBinding b, ObjMethod method) {
        if (b != null && method != null) {
            LocalBinding lb = (LocalBinding)RT.get(method.locals, b);
            if (lb == null) {
                method.objx.closes = (IPersistentMap)RT.assoc(method.objx.closes, b, b);
                Compiler.closeOver(b, method.parent);
            } else {
                if (lb.idx == 0) {
                    method.usesThis = true;
                }
                if (IN_CATCH_FINALLY.deref() != null) {
                    method.localsUsedInCatchFinally = (PersistentHashSet)method.localsUsedInCatchFinally.cons(b.idx);
                }
            }
        }
    }

    static LocalBinding referenceLocal(Symbol sym) {
        if (!LOCAL_ENV.isBound()) {
            return null;
        }
        LocalBinding b = (LocalBinding)RT.get(LOCAL_ENV.deref(), sym);
        if (b != null) {
            ObjMethod method = (ObjMethod)METHOD.deref();
            if (b.idx == 0) {
                method.usesThis = true;
            }
            Compiler.closeOver(b, method);
        }
        return b;
    }

    private static Symbol tagOf(Object o) {
        Object tag = RT.get(RT.meta(o), RT.TAG_KEY);
        if (tag instanceof Symbol) {
            return (Symbol)tag;
        }
        if (tag instanceof String) {
            return Symbol.intern(null, (String)tag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadFile(String file2) throws IOException {
        FileInputStream f = new FileInputStream(file2);
        try {
            Object object = Compiler.load(new InputStreamReader((InputStream)f, RT.UTF8), new File(file2).getAbsolutePath(), new File(file2).getName());
            return object;
        }
        finally {
            f.close();
        }
    }

    public static Object load(Reader rdr) {
        return Compiler.load(rdr, null, "NO_SOURCE_FILE");
    }

    static void consumeWhitespaces(LineNumberingPushbackReader pushbackReader) {
        int ch = LispReader.read1(pushbackReader);
        while (LispReader.isWhitespace(ch)) {
            ch = LispReader.read1(pushbackReader);
        }
        LispReader.unread(pushbackReader, ch);
    }

    private static Object readerOpts(String sourceName) {
        if (sourceName != null && sourceName.endsWith(".cljc")) {
            return OPTS_COND_ALLOWED;
        }
        return null;
    }

    public static Object load(Reader rdr, String sourcePath, String sourceName) {
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Compiler.consumeWhitespaces(pushbackReader);
        Var.pushThreadBindings(RT.mapUniqueKeys(LOADER, RT.makeClassLoader(), SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.READEVAL, RT.T, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), COLUMN_BEFORE, pushbackReader.getColumnNumber(), LINE_AFTER, pushbackReader.getLineNumber(), COLUMN_AFTER, pushbackReader.getColumnNumber(), RT.UNCHECKED_MATH, RT.UNCHECKED_MATH.deref(), RT.WARN_ON_REFLECTION, RT.WARN_ON_REFLECTION.deref(), RT.DATA_READERS, RT.DATA_READERS.deref()));
        Object readerOpts = Compiler.readerOpts(sourceName);
        try {
            Object r = LispReader.read(pushbackReader, false, EOF, false, readerOpts);
            while (r != EOF) {
                Compiler.consumeWhitespaces(pushbackReader);
                LINE_AFTER.set(pushbackReader.getLineNumber());
                COLUMN_AFTER.set(pushbackReader.getColumnNumber());
                ret = Compiler.eval(r, false);
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                COLUMN_BEFORE.set(pushbackReader.getColumnNumber());
                r = LispReader.read(pushbackReader, false, EOF, false, readerOpts);
            }
        }
        catch (LispReader.ReaderException e2) {
            throw new CompilerException(sourcePath, e2.line, e2.column, e2.getCause());
        }
        catch (Throwable e3) {
            if (!(e3 instanceof CompilerException)) {
                throw new CompilerException(sourcePath, (Integer)LINE_BEFORE.deref(), (Integer)COLUMN_BEFORE.deref(), e3);
            }
            throw (CompilerException)e3;
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClassFile(String internalName, byte[] bytecode) throws IOException {
        String genPath = (String)COMPILE_PATH.deref();
        if (genPath == null) {
            throw Util.runtimeException("*compile-path* not set");
        }
        String[] dirs = internalName.split("/");
        String p = genPath;
        for (int i = 0; i < dirs.length - 1; ++i) {
            p = p + File.separator + dirs[i];
            new File(p).mkdir();
        }
        String path2 = genPath + File.separator + internalName + ".class";
        File cf = new File(path2);
        cf.createNewFile();
        FileOutputStream cfs = new FileOutputStream(cf);
        try {
            cfs.write(bytecode);
            cfs.flush();
        }
        finally {
            cfs.close();
        }
    }

    public static void pushNS() {
        Var.pushThreadBindings(PersistentHashMap.create(Var.intern(Symbol.intern("clojure.core"), Symbol.intern("*ns*")).setDynamic(), null));
    }

    public static void pushNSandLoader(ClassLoader loader) {
        Var.pushThreadBindings(RT.map(Var.intern(Symbol.intern("clojure.core"), Symbol.intern("*ns*")).setDynamic(), null, RT.FN_LOADER_VAR, loader, RT.READEVAL, RT.T));
    }

    public static ILookupThunk getLookupThunk(Object target, Keyword k) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compile1(GeneratorAdapter gen, ObjExpr objx, Object form) {
        Object line = Compiler.lineDeref();
        Object column = Compiler.columnDeref();
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.LINE_KEY)) {
            line = RT.meta(form).valAt(RT.LINE_KEY);
        }
        if (RT.meta(form) != null && RT.meta(form).containsKey(RT.COLUMN_KEY)) {
            column = RT.meta(form).valAt(RT.COLUMN_KEY);
        }
        Var.pushThreadBindings(RT.map(LINE, line, COLUMN, column, LOADER, RT.makeClassLoader()));
        try {
            form = Compiler.macroexpand(form);
            if (form instanceof ISeq && Util.equals(RT.first(form), DO)) {
                ISeq s = RT.next(form);
                while (s != null) {
                    Compiler.compile1(gen, objx, RT.first(s));
                    s = RT.next(s);
                }
            } else {
                Expr expr = Compiler.analyze(C.EVAL, form);
                objx.keywords = (IPersistentMap)KEYWORDS.deref();
                objx.vars = (IPersistentMap)VARS.deref();
                objx.constants = (PersistentVector)CONSTANTS.deref();
                expr.emit(C.EXPRESSION, objx, gen);
                expr.eval();
            }
        }
        finally {
            Var.popThreadBindings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object compile(Reader rdr, String sourcePath, String sourceName) throws IOException {
        if (COMPILE_PATH.deref() == null) {
            throw Util.runtimeException("*compile-path* not set");
        }
        Object EOF = new Object();
        Object ret = null;
        LineNumberingPushbackReader pushbackReader = rdr instanceof LineNumberingPushbackReader ? (LineNumberingPushbackReader)rdr : new LineNumberingPushbackReader(rdr);
        Var.pushThreadBindings(RT.mapUniqueKeys(SOURCE_PATH, sourcePath, SOURCE, sourceName, METHOD, null, LOCAL_ENV, null, LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, RT.READEVAL, RT.T, RT.CURRENT_NS, RT.CURRENT_NS.deref(), LINE_BEFORE, pushbackReader.getLineNumber(), COLUMN_BEFORE, pushbackReader.getColumnNumber(), LINE_AFTER, pushbackReader.getLineNumber(), COLUMN_AFTER, pushbackReader.getColumnNumber(), CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, RT.UNCHECKED_MATH, RT.UNCHECKED_MATH.deref(), RT.WARN_ON_REFLECTION, RT.WARN_ON_REFLECTION.deref(), RT.DATA_READERS, RT.DATA_READERS.deref()));
        try {
            ClassWriter cw;
            ObjExpr objx = new ObjExpr(null);
            objx.internalName = sourcePath.replace(File.separator, "/").substring(0, sourcePath.lastIndexOf(46)) + "__init";
            objx.objtype = Type.getObjectType(objx.internalName);
            ClassWriter cv = cw = new ClassWriter(1);
            ((ClassVisitor)cv).visit(49, 33, objx.internalName, null, "java/lang/Object", null);
            GeneratorAdapter gen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void load ()"), null, null, cv);
            gen.visitCode();
            Object readerOpts = Compiler.readerOpts(sourceName);
            Object r = LispReader.read(pushbackReader, false, EOF, false, readerOpts);
            while (r != EOF) {
                LINE_AFTER.set(pushbackReader.getLineNumber());
                COLUMN_AFTER.set(pushbackReader.getColumnNumber());
                Compiler.compile1(gen, objx, r);
                LINE_BEFORE.set(pushbackReader.getLineNumber());
                COLUMN_BEFORE.set(pushbackReader.getColumnNumber());
                r = LispReader.read(pushbackReader, false, EOF, false, readerOpts);
            }
            gen.returnValue();
            gen.endMethod();
            for (int i = 0; i < objx.constants.count(); ++i) {
                if (!objx.usedConstants.contains(i)) continue;
                ((ClassVisitor)cv).visitField(25, objx.constantName(i), objx.constantType(i).getDescriptor(), null, null);
            }
            int INITS_PER = 100;
            int numInits = objx.constants.count() / 100;
            if (objx.constants.count() % 100 != 0) {
                ++numInits;
            }
            for (int n = 0; n < numInits; ++n) {
                GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void __init" + n + "()"), null, null, cv);
                clinitgen.visitCode();
                try {
                    Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                    for (int i = n * 100; i < objx.constants.count() && i < (n + 1) * 100; ++i) {
                        if (!objx.usedConstants.contains(i)) continue;
                        objx.emitValue(objx.constants.nth(i), clinitgen);
                        clinitgen.checkCast(objx.constantType(i));
                        clinitgen.putStatic(objx.objtype, objx.constantName(i), objx.constantType(i));
                    }
                }
                finally {
                    Var.popThreadBindings();
                }
                clinitgen.returnValue();
                clinitgen.endMethod();
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            Label startTry = clinitgen.newLabel();
            Label endTry = clinitgen.newLabel();
            Label end = clinitgen.newLabel();
            Label finallyLabel = clinitgen.newLabel();
            for (int n = 0; n < numInits; ++n) {
                clinitgen.invokeStatic(objx.objtype, clojure.asm.commons.Method.getMethod("void __init" + n + "()"));
            }
            clinitgen.push(objx.internalName.replace('/', '.'));
            clinitgen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("Class classForName(String)"));
            clinitgen.invokeVirtual(CLASS_TYPE, clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()"));
            clinitgen.invokeStatic(Type.getType(Compiler.class), clojure.asm.commons.Method.getMethod("void pushNSandLoader(ClassLoader)"));
            clinitgen.mark(startTry);
            clinitgen.invokeStatic(objx.objtype, clojure.asm.commons.Method.getMethod("void load()"));
            clinitgen.mark(endTry);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.goTo(end);
            clinitgen.mark(finallyLabel);
            clinitgen.invokeStatic(VAR_TYPE, clojure.asm.commons.Method.getMethod("void popThreadBindings()"));
            clinitgen.throwException();
            clinitgen.mark(end);
            clinitgen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
            clinitgen.returnValue();
            clinitgen.endMethod();
            ((ClassVisitor)cv).visitEnd();
            Compiler.writeClassFile(objx.internalName, cw.toByteArray());
        }
        catch (LispReader.ReaderException e2) {
            throw new CompilerException(sourcePath, e2.line, e2.column, e2.getCause());
        }
        finally {
            Var.popThreadBindings();
        }
        return ret;
    }

    static boolean inty(Class c) {
        return c == Integer.TYPE || c == Short.TYPE || c == Byte.TYPE || c == Character.TYPE;
    }

    static Class retType(Class tc, Class ret) {
        if (tc == null) {
            return ret;
        }
        if (ret == null) {
            return tc;
        }
        if (ret.isPrimitive() && tc.isPrimitive()) {
            if (Compiler.inty(ret) && Compiler.inty(tc) || ret == tc) {
                return tc;
            }
            throw new UnsupportedOperationException("Cannot coerce " + ret + " to " + tc + ", use a cast instead");
        }
        return tc;
    }

    static Class primClass(Symbol sym) {
        if (sym == null) {
            return null;
        }
        Class<Object> c = null;
        if (sym.name.equals("int")) {
            c = Integer.TYPE;
        } else if (sym.name.equals("long")) {
            c = Long.TYPE;
        } else if (sym.name.equals("float")) {
            c = Float.TYPE;
        } else if (sym.name.equals("double")) {
            c = Double.TYPE;
        } else if (sym.name.equals("char")) {
            c = Character.TYPE;
        } else if (sym.name.equals("short")) {
            c = Short.TYPE;
        } else if (sym.name.equals("byte")) {
            c = Byte.TYPE;
        } else if (sym.name.equals("boolean")) {
            c = Boolean.TYPE;
        } else if (sym.name.equals("void")) {
            c = Void.TYPE;
        }
        return c;
    }

    static Class tagClass(Object tag) {
        if (tag == null) {
            return Object.class;
        }
        Class c = null;
        if (tag instanceof Symbol) {
            c = Compiler.primClass((Symbol)tag);
        }
        if (c == null) {
            c = HostExpr.tagToClass(tag);
        }
        return c;
    }

    static Class primClass(Class c) {
        return c.isPrimitive() ? c : Object.class;
    }

    static Class boxClass(Class p) {
        if (!p.isPrimitive()) {
            return p;
        }
        Class c = null;
        if (p == Integer.TYPE) {
            c = Integer.class;
        } else if (p == Long.TYPE) {
            c = Long.class;
        } else if (p == Float.TYPE) {
            c = Float.class;
        } else if (p == Double.TYPE) {
            c = Double.class;
        } else if (p == Character.TYPE) {
            c = Character.class;
        } else if (p == Short.TYPE) {
            c = Short.class;
        } else if (p == Byte.TYPE) {
            c = Byte.class;
        } else if (p == Boolean.TYPE) {
            c = Boolean.class;
        }
        return c;
    }

    static IPersistentCollection emptyVarCallSites() {
        return PersistentHashSet.EMPTY;
    }

    static {
        KEYWORD_TYPE = Type.getType(Keyword.class);
        VAR_TYPE = Type.getType(Var.class);
        SYMBOL_TYPE = Type.getType(Symbol.class);
        IFN_TYPE = Type.getType(IFn.class);
        AFUNCTION_TYPE = Type.getType(AFunction.class);
        RT_TYPE = Type.getType(RT.class);
        NUMBERS_TYPE = Type.getType(Numbers.class);
        CLASS_TYPE = Type.getType(Class.class);
        NS_TYPE = Type.getType(Namespace.class);
        UTIL_TYPE = Type.getType(Util.class);
        REFLECTOR_TYPE = Type.getType(Reflector.class);
        THROWABLE_TYPE = Type.getType(Throwable.class);
        BOOLEAN_OBJECT_TYPE = Type.getType(Boolean.class);
        IPERSISTENTMAP_TYPE = Type.getType(IPersistentMap.class);
        IOBJ_TYPE = Type.getType(IObj.class);
        TUPLE_TYPE = Type.getType(Tuple.class);
        createTupleMethods = new clojure.asm.commons.Method[]{clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create()"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object)"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object,Object)"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object,Object,Object)"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object,Object,Object,Object)"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object,Object,Object,Object,Object)"), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector create(Object,Object,Object,Object,Object,Object)")};
        EXCEPTION_TYPES = new Type[0];
        OBJECT_TYPE = Type.getType(Object.class);
        ARG_TYPES = new Type[22][];
        for (int i = 0; i <= 20; ++i) {
            Type[] a = new Type[i];
            for (int j = 0; j < i; ++j) {
                a[j] = OBJECT_TYPE;
            }
            Compiler.ARG_TYPES[i] = a;
        }
        Type[] a = new Type[21];
        for (int j = 0; j < 20; ++j) {
            a[j] = OBJECT_TYPE;
        }
        a[20] = Type.getType("[Ljava/lang/Object;");
        Compiler.ARG_TYPES[21] = a;
        LOCAL_ENV = Var.create(null).setDynamic();
        LOOP_LOCALS = Var.create().setDynamic();
        LOOP_LABEL = Var.create().setDynamic();
        CONSTANTS = Var.create().setDynamic();
        CONSTANT_IDS = Var.create().setDynamic();
        KEYWORD_CALLSITES = Var.create().setDynamic();
        PROTOCOL_CALLSITES = Var.create().setDynamic();
        VAR_CALLSITES = Var.create().setDynamic();
        KEYWORDS = Var.create().setDynamic();
        VARS = Var.create().setDynamic();
        METHOD = Var.create(null).setDynamic();
        IN_CATCH_FINALLY = Var.create(null).setDynamic();
        NO_RECUR = Var.create(null).setDynamic();
        LOADER = Var.create().setDynamic();
        SOURCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*source-path*"), "NO_SOURCE_FILE").setDynamic();
        SOURCE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*file*"), "NO_SOURCE_PATH").setDynamic();
        COMPILE_PATH = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-path*"), null).setDynamic();
        COMPILE_FILES = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compile-files*"), Boolean.FALSE).setDynamic();
        INSTANCE = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("instance?"));
        ADD_ANNOTATIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("add-annotations"));
        disableLocalsClearingKey = Keyword.intern("disable-locals-clearing");
        directLinkingKey = Keyword.intern("direct-linking");
        elideMetaKey = Keyword.intern("elide-meta");
        Associative compilerOptions = null;
        for (Map.Entry<Object, Object> e2 : System.getProperties().entrySet()) {
            String name2 = (String)e2.getKey();
            String v = (String)e2.getValue();
            if (!name2.startsWith("clojure.compiler.")) continue;
            compilerOptions = RT.assoc(compilerOptions, RT.keyword(null, name2.substring(1 + name2.lastIndexOf(46))), RT.readString(v));
        }
        COMPILER_OPTIONS = Var.intern(Namespace.findOrCreate(Symbol.intern("clojure.core")), Symbol.intern("*compiler-options*"), compilerOptions).setDynamic();
        LINE = Var.create(0).setDynamic();
        COLUMN = Var.create(0).setDynamic();
        LINE_BEFORE = Var.create(0).setDynamic();
        COLUMN_BEFORE = Var.create(0).setDynamic();
        LINE_AFTER = Var.create(0).setDynamic();
        COLUMN_AFTER = Var.create(0).setDynamic();
        NEXT_LOCAL_NUM = Var.create(0).setDynamic();
        RET_LOCAL_NUM = Var.create().setDynamic();
        COMPILE_STUB_SYM = Var.create(null).setDynamic();
        COMPILE_STUB_CLASS = Var.create(null).setDynamic();
        CLEAR_PATH = Var.create(null).setDynamic();
        CLEAR_ROOT = Var.create(null).setDynamic();
        CLEAR_SITES = Var.create(null).setDynamic();
        RECUR_CLASS = Recur.class;
        NIL_EXPR = new NilExpr();
        TRUE_EXPR = new BooleanExpr(true);
        FALSE_EXPR = new BooleanExpr(false);
        CHAR_MAP = PersistentHashMap.create(Character.valueOf('-'), "_", Character.valueOf(':'), "_COLON_", Character.valueOf('+'), "_PLUS_", Character.valueOf('>'), "_GT_", Character.valueOf('<'), "_LT_", Character.valueOf('='), "_EQ_", Character.valueOf('~'), "_TILDE_", Character.valueOf('!'), "_BANG_", Character.valueOf('@'), "_CIRCA_", Character.valueOf('#'), "_SHARP_", Character.valueOf('\''), "_SINGLEQUOTE_", Character.valueOf('\"'), "_DOUBLEQUOTE_", Character.valueOf('%'), "_PERCENT_", Character.valueOf('^'), "_CARET_", Character.valueOf('&'), "_AMPERSAND_", Character.valueOf('*'), "_STAR_", Character.valueOf('|'), "_BAR_", Character.valueOf('{'), "_LBRACE_", Character.valueOf('}'), "_RBRACE_", Character.valueOf('['), "_LBRACK_", Character.valueOf(']'), "_RBRACK_", Character.valueOf('/'), "_SLASH_", Character.valueOf('\\'), "_BSLASH_", Character.valueOf('?'), "_QMARK_");
        IPersistentMap m = RT.map("$", Character.valueOf('/'));
        for (ISeq s = RT.seq(CHAR_MAP); s != null; s = s.next()) {
            IMapEntry e3 = (IMapEntry)s.first();
            Character origCh = (Character)e3.key();
            String escapeStr = (String)e3.val();
            m = m.assoc(escapeStr, origCh);
        }
        DEMUNGE_MAP = m;
        Object[] mungeStrs = RT.toArray(RT.keys(m));
        Arrays.sort(mungeStrs, new Comparator(){

            public int compare(Object s1, Object s2) {
                return ((String)s2).length() - ((String)s1).length();
            }
        });
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object s : mungeStrs) {
            String escapeStr = (String)s;
            if (!first) {
                sb.append("|");
            }
            first = false;
            sb.append("\\Q");
            sb.append(escapeStr);
            sb.append("\\E");
        }
        DEMUNGE_PATTERN = Pattern.compile(sb.toString());
        OPTS_COND_ALLOWED = RT.mapUniqueKeys(LispReader.OPT_READ_COND, LispReader.COND_ALLOW);
    }

    public static class CaseExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final LocalBindingExpr expr;
        public final int shift;
        public final int mask;
        public final int low;
        public final int high;
        public final Expr defaultExpr;
        public final SortedMap<Integer, Expr> tests;
        public final HashMap<Integer, Expr> thens;
        public final Keyword switchType;
        public final Keyword testType;
        public final Set<Integer> skipCheck;
        public final Class returnType;
        public final int line;
        public final int column;
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method hashMethod = clojure.asm.commons.Method.getMethod("int hash(Object)");
        static final clojure.asm.commons.Method hashCodeMethod = clojure.asm.commons.Method.getMethod("int hashCode()");
        static final clojure.asm.commons.Method equivMethod = clojure.asm.commons.Method.getMethod("boolean equiv(Object, Object)");
        static final Keyword compactKey = Keyword.intern(null, "compact");
        static final Keyword sparseKey = Keyword.intern(null, "sparse");
        static final Keyword hashIdentityKey = Keyword.intern(null, "hash-identity");
        static final Keyword hashEquivKey = Keyword.intern(null, "hash-equiv");
        static final Keyword intKey = Keyword.intern(null, "int");

        public CaseExpr(int line, int column, LocalBindingExpr expr, int shift, int mask, int low, int high, Expr defaultExpr, SortedMap<Integer, Expr> tests, HashMap<Integer, Expr> thens, Keyword switchType, Keyword testType, Set<Integer> skipCheck) {
            this.expr = expr;
            this.shift = shift;
            this.mask = mask;
            this.low = low;
            this.high = high;
            this.defaultExpr = defaultExpr;
            this.tests = tests;
            this.thens = thens;
            this.line = line;
            this.column = column;
            if (switchType != compactKey && switchType != sparseKey) {
                throw new IllegalArgumentException("Unexpected switch type: " + switchType);
            }
            this.switchType = switchType;
            if (testType != intKey && testType != hashEquivKey && testType != hashIdentityKey) {
                throw new IllegalArgumentException("Unexpected test type: " + switchType);
            }
            this.testType = testType;
            this.skipCheck = skipCheck;
            ArrayList<Expr> returns = new ArrayList<Expr>(thens.values());
            returns.add(defaultExpr);
            this.returnType = Compiler.maybeJavaClass(returns);
            if (RT.count(skipCheck) > 0 && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Performance warning, %s:%d:%d - hash collision of some case test constants; if selected, those entries will be tested sequentially.\n", SOURCE_PATH.deref(), line, column);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.returnType != null;
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.returnType);
        }

        @Override
        public Class getJavaClass() {
            return this.returnType;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval case");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, false);
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, true);
        }

        public void doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            Label[] la;
            Type primExprType;
            Label defaultLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            TreeMap<Integer, Label> labels = new TreeMap<Integer, Label>();
            for (Integer i : this.tests.keySet()) {
                labels.put(i, gen.newLabel());
            }
            gen.visitLineNumber(this.line, gen.mark());
            Class primExprClass = Compiler.maybePrimitiveType(this.expr);
            Type type2 = primExprType = primExprClass == null ? null : Type.getType(primExprClass);
            if (this.testType == intKey) {
                this.emitExprForInts(objx, gen, primExprType, defaultLabel);
            } else {
                this.emitExprForHashes(objx, gen);
            }
            if (this.switchType == sparseKey) {
                la = new Label[labels.size()];
                la = labels.values().toArray(la);
                int[] ints2 = Numbers.int_array(this.tests.keySet());
                gen.visitLookupSwitchInsn(defaultLabel, ints2, la);
            } else {
                la = new Label[this.high - this.low + 1];
                for (int i = this.low; i <= this.high; ++i) {
                    la[i - this.low] = labels.containsKey(i) ? (Label)labels.get(i) : defaultLabel;
                }
                gen.visitTableSwitchInsn(this.low, this.high, defaultLabel, la);
            }
            for (Integer i : labels.keySet()) {
                gen.mark((Label)labels.get(i));
                if (this.testType == intKey) {
                    this.emitThenForInts(objx, gen, primExprType, (Expr)this.tests.get(i), this.thens.get(i), defaultLabel, emitUnboxed);
                } else if (RT.contains(this.skipCheck, i) == RT.T) {
                    CaseExpr.emitExpr(objx, gen, this.thens.get(i), emitUnboxed);
                } else {
                    this.emitThenForHashes(objx, gen, (Expr)this.tests.get(i), this.thens.get(i), defaultLabel, emitUnboxed);
                }
                gen.goTo(endLabel);
            }
            gen.mark(defaultLabel);
            CaseExpr.emitExpr(objx, gen, this.defaultExpr, emitUnboxed);
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        private boolean isShiftMasked() {
            return this.mask != 0;
        }

        private void emitShiftMask(GeneratorAdapter gen) {
            if (this.isShiftMasked()) {
                gen.push(this.shift);
                gen.visitInsn(122);
                gen.push(this.mask);
                gen.visitInsn(126);
            }
        }

        private void emitExprForInts(ObjExpr objx, GeneratorAdapter gen, Type exprType, Label defaultLabel) {
            if (exprType == null) {
                if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                    RT.errPrintWriter().format("Performance warning, %s:%d:%d - case has int tests, but tested expression is not primitive.\n", SOURCE_PATH.deref(), this.line, this.column);
                }
                this.expr.emit(C.EXPRESSION, objx, gen);
                gen.instanceOf(NUMBER_TYPE);
                gen.ifZCmp(153, defaultLabel);
                this.expr.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(NUMBER_TYPE);
                gen.invokeVirtual(NUMBER_TYPE, intValueMethod);
                this.emitShiftMask(gen);
            } else if (exprType == Type.LONG_TYPE || exprType == Type.INT_TYPE || exprType == Type.SHORT_TYPE || exprType == Type.BYTE_TYPE) {
                this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                gen.cast(exprType, Type.INT_TYPE);
                this.emitShiftMask(gen);
            } else {
                gen.goTo(defaultLabel);
            }
        }

        private void emitThenForInts(ObjExpr objx, GeneratorAdapter gen, Type exprType, Expr test2, Expr then, Label defaultLabel, boolean emitUnboxed) {
            if (exprType == null) {
                this.expr.emit(C.EXPRESSION, objx, gen);
                test2.emit(C.EXPRESSION, objx, gen);
                gen.invokeStatic(UTIL_TYPE, equivMethod);
                gen.ifZCmp(153, defaultLabel);
                CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
            } else if (exprType == Type.LONG_TYPE) {
                ((NumberExpr)test2).emitUnboxed(C.EXPRESSION, objx, gen);
                this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                gen.ifCmp(Type.LONG_TYPE, 154, defaultLabel);
                CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
            } else if (exprType == Type.INT_TYPE || exprType == Type.SHORT_TYPE || exprType == Type.BYTE_TYPE) {
                if (this.isShiftMasked()) {
                    ((NumberExpr)test2).emitUnboxed(C.EXPRESSION, objx, gen);
                    this.expr.emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.cast(exprType, Type.LONG_TYPE);
                    gen.ifCmp(Type.LONG_TYPE, 154, defaultLabel);
                }
                CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
            } else {
                gen.goTo(defaultLabel);
            }
        }

        private void emitExprForHashes(ObjExpr objx, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.invokeStatic(UTIL_TYPE, hashMethod);
            this.emitShiftMask(gen);
        }

        private void emitThenForHashes(ObjExpr objx, GeneratorAdapter gen, Expr test2, Expr then, Label defaultLabel, boolean emitUnboxed) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            test2.emit(C.EXPRESSION, objx, gen);
            if (this.testType == hashIdentityKey) {
                gen.visitJumpInsn(166, defaultLabel);
            } else {
                gen.invokeStatic(UTIL_TYPE, equivMethod);
                gen.ifZCmp(153, defaultLabel);
            }
            CaseExpr.emitExpr(objx, gen, then, emitUnboxed);
        }

        private static void emitExpr(ObjExpr objx, GeneratorAdapter gen, Expr expr, boolean emitUnboxed) {
            if (emitUnboxed && expr instanceof MaybePrimitiveExpr) {
                ((MaybePrimitiveExpr)expr).emitUnboxed(C.EXPRESSION, objx, gen);
            } else {
                expr.emit(C.EXPRESSION, objx, gen);
            }
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expr parse(C context, Object frm) {
                Expr defaultExpr;
                ISeq form = (ISeq)frm;
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                IPersistentVector args = LazilyPersistentVector.create(form.next());
                Object exprForm = args.nth(0);
                int shift = ((Number)args.nth(1)).intValue();
                int mask = ((Number)args.nth(2)).intValue();
                Object defaultForm = args.nth(3);
                Map caseMap = (Map)args.nth(4);
                Keyword switchType = (Keyword)args.nth(5);
                Keyword testType = (Keyword)args.nth(6);
                Set skipCheck = RT.count(args) < 8 ? null : (Set)args.nth(7);
                ISeq keys2 = RT.keys(caseMap);
                int low = ((Number)RT.first(keys2)).intValue();
                int high = ((Number)RT.nth(keys2, RT.count(keys2) - 1)).intValue();
                LocalBindingExpr testexpr = (LocalBindingExpr)Compiler.analyze(C.EXPRESSION, exprForm);
                testexpr.shouldClear = false;
                TreeMap<Integer, Expr> tests = new TreeMap<Integer, Expr>();
                HashMap<Integer, Expr> thens = new HashMap<Integer, Expr>();
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Iterator i$ = caseMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Expr thenExpr;
                    Map.Entry o;
                    Map.Entry e2 = o = i$.next();
                    Integer minhash = ((Number)e2.getKey()).intValue();
                    Object pair = e2.getValue();
                    Expr testExpr = testType == intKey ? NumberExpr.parse(((Number)RT.first(pair)).intValue()) : new ConstantExpr(RT.first(pair));
                    tests.put(minhash, testExpr);
                    try {
                        Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                        thenExpr = Compiler.analyze(context, RT.second(pair));
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                    thens.put(minhash, thenExpr);
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    defaultExpr = Compiler.analyze(context, args.nth(3));
                }
                finally {
                    Var.popThreadBindings();
                }
                int line = ((Number)LINE.deref()).intValue();
                int column = ((Number)COLUMN.deref()).intValue();
                return new CaseExpr(line, column, testexpr, shift, mask, low, high, defaultExpr, tests, thens, switchType, testType, skipCheck);
            }
        }
    }

    public static class MethodParamExpr
    implements Expr,
    MaybePrimitiveExpr {
        final Class c;

        public MethodParamExpr(Class c) {
            this.c = c;
        }

        @Override
        public Object eval() {
            throw Util.runtimeException("Can't eval");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw Util.runtimeException("Can't emit");
        }

        @Override
        public boolean hasJavaClass() {
            return this.c != null;
        }

        @Override
        public Class getJavaClass() {
            return this.c;
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.c);
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            throw Util.runtimeException("Can't emit");
        }
    }

    public static class NewInstanceMethod
    extends ObjMethod {
        String name;
        Type[] argTypes;
        Type retType;
        Class retClass;
        Class[] exclasses;
        static Symbol dummyThis = Symbol.intern(null, "dummy_this_dlskjsdfower");
        private IPersistentVector parms;

        public NewInstanceMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        @Override
        int numParams() {
            return this.argLocals.count();
        }

        @Override
        String getMethodName() {
            return this.name;
        }

        @Override
        Type getReturnType() {
            return this.retType;
        }

        @Override
        Type[] getArgTypes() {
            return this.argTypes;
        }

        public static IPersistentVector msig(String name2, Class[] paramTypes) {
            return RT.vector(name2, RT.seq(paramTypes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static NewInstanceMethod parse(ObjExpr objx, ISeq form, Symbol thistag, Map overrideables) {
            NewInstanceMethod method = new NewInstanceMethod(objx, (ObjMethod)METHOD.deref());
            Symbol dotname = (Symbol)RT.first(form);
            Symbol name2 = (Symbol)Symbol.intern(null, Compiler.munge(dotname.name)).withMeta(RT.meta(dotname));
            IPersistentVector parms = (IPersistentVector)RT.second(form);
            if (parms.count() == 0) {
                throw new IllegalArgumentException("Must supply at least one argument for 'this' in: " + dotname);
            }
            Symbol thisName = (Symbol)parms.nth(0);
            parms = RT.subvec(parms, 1, parms.count());
            ISeq body = RT.next(RT.next(form));
            try {
                int i;
                method.line = Compiler.lineDeref();
                method.column = Compiler.columnDeref();
                PathNode pnode = new PathNode(PATHTYPE.PATH, (PathNode)CLEAR_PATH.get());
                Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                if (thisName != null) {
                    Compiler.registerLocal(thisName == null ? NewInstanceMethod.dummyThis : thisName, thistag, null, false);
                } else {
                    Compiler.getAndIncLocalNum();
                }
                PersistentVector argLocals = PersistentVector.EMPTY;
                method.retClass = Compiler.tagClass(Compiler.tagOf(name2));
                method.argTypes = new Type[parms.count()];
                boolean hinted = Compiler.tagOf(name2) != null;
                Class[] pclasses = new Class[parms.count()];
                Symbol[] psyms = new Symbol[parms.count()];
                for (int i2 = 0; i2 < parms.count(); ++i2) {
                    Class pclass;
                    if (!(parms.nth(i2) instanceof Symbol)) {
                        throw new IllegalArgumentException("params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i2);
                    Symbol tag = Compiler.tagOf(p);
                    if (tag != null) {
                        hinted = true;
                    }
                    if (p.getNamespace() != null) {
                        p = Symbol.intern(p.name);
                    }
                    pclasses[i2] = pclass = Compiler.tagClass(tag);
                    psyms[i2] = p;
                }
                Map matches = NewInstanceMethod.findMethodsWithNameAndArity(name2.name, parms.count(), overrideables);
                IPersistentVector mk = NewInstanceMethod.msig(name2.name, pclasses);
                Method m = null;
                if (matches.size() > 0) {
                    if (matches.size() > 1) {
                        if (!hinted) {
                            throw new IllegalArgumentException("Must hint overloaded method: " + name2.name);
                        }
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching overloaded method: " + name2.name);
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name2.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else if (hinted) {
                        m = (Method)matches.get(mk);
                        if (m == null) {
                            throw new IllegalArgumentException("Can't find matching method: " + name2.name + ", leave off hints for auto match.");
                        }
                        if (m.getReturnType() != method.retClass) {
                            throw new IllegalArgumentException("Mismatched return type: " + name2.name + ", expected: " + m.getReturnType().getName() + ", had: " + method.retClass.getName());
                        }
                    } else {
                        m = (Method)matches.values().iterator().next();
                        method.retClass = m.getReturnType();
                        pclasses = m.getParameterTypes();
                    }
                } else {
                    throw new IllegalArgumentException("Can't define method not in interfaces: " + name2.name);
                }
                method.retType = Type.getType(method.retClass);
                method.exclasses = m.getExceptionTypes();
                for (i = 0; i < parms.count(); ++i) {
                    LocalBinding lb = Compiler.registerLocal(psyms[i], null, new MethodParamExpr(pclasses[i]), true);
                    argLocals = argLocals.assocN(i, lb);
                    method.argTypes[i] = Type.getType(pclasses[i]);
                }
                for (i = 0; i < parms.count(); ++i) {
                    if (pclasses[i] != Long.TYPE && pclasses[i] != Double.TYPE) continue;
                    Compiler.getAndIncLocalNum();
                }
                LOOP_LOCALS.set(argLocals);
                method.name = name2.name;
                method.methodMeta = RT.meta(name2);
                method.parms = parms;
                method.argLocals = argLocals;
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                NewInstanceMethod newInstanceMethod = method;
                return newInstanceMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        private static Map findMethodsWithNameAndArity(String name2, int arity, Map mm) {
            HashMap ret = new HashMap();
            for (Map.Entry o : mm.entrySet()) {
                Map.Entry e2 = o;
                Method m = (Method)e2.getValue();
                if (!name2.equals(m.getName()) || m.getParameterTypes().length != arity) continue;
                ret.put(e2.getKey(), e2.getValue());
            }
            return ret;
        }

        private static Map findMethodsWithName(String name2, Map mm) {
            HashMap ret = new HashMap();
            for (Map.Entry o : mm.entrySet()) {
                Map.Entry e2 = o;
                Method m = (Method)e2.getValue();
                if (!name2.equals(m.getName())) continue;
                ret.put(e2.getKey(), e2.getValue());
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void emit(ObjExpr obj, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            Type[] extypes = null;
            if (this.exclasses.length > 0) {
                extypes = new Type[this.exclasses.length];
                for (int i = 0; i < this.exclasses.length; ++i) {
                    extypes[i] = Type.getType(this.exclasses[i]);
                }
            }
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, extypes, cv);
            Compiler.addAnnotation(gen, this.methodMeta);
            for (int i = 0; i < this.parms.count(); ++i) {
                IPersistentMap meta = RT.meta(this.parms.nth(i));
                Compiler.addParameterAnnotation(gen, meta, i);
            }
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                NewInstanceMethod.emitBody(this.objx, gen, this.retClass, this.body);
                Label end = gen.mark();
                gen.visitLocalVariable("this", obj.objtype.getDescriptor(), null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, this.argTypes[lb.idx - 1].getDescriptor(), null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }
    }

    public static class NewInstanceExpr
    extends ObjExpr {
        IPersistentCollection methods;
        Map<IPersistentVector, Method> mmap;
        Map<IPersistentVector, Set<Class>> covariants;

        public NewInstanceExpr(Object tag) {
            super(tag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ObjExpr build(IPersistentVector interfaceSyms, IPersistentVector fieldSyms, Symbol thisSym, String tagName, Symbol className, Symbol typeTag, ISeq methodForms, Object frm, IPersistentMap opts) {
            NewInstanceExpr ret = new NewInstanceExpr(null);
            ret.src = frm;
            ret.name = className.toString();
            ret.classMeta = RT.meta(className);
            ret.internalName = ret.name.replace('.', '/');
            ret.objtype = Type.getObjectType(ret.internalName);
            ret.opts = opts;
            if (thisSym != null) {
                ret.thisName = thisSym.name;
            }
            if (fieldSyms != null) {
                int i;
                IPersistentMap fmap = PersistentHashMap.EMPTY;
                Object[] closesvec = new Object[2 * fieldSyms.count()];
                for (i = 0; i < fieldSyms.count(); ++i) {
                    Symbol sym = (Symbol)fieldSyms.nth(i);
                    LocalBinding lb = new LocalBinding(-1, sym, null, new MethodParamExpr(Compiler.tagClass(Compiler.tagOf(sym))), false, null);
                    fmap = fmap.assoc(sym, lb);
                    closesvec[i * 2] = lb;
                    closesvec[i * 2 + 1] = lb;
                }
                ret.closes = new PersistentArrayMap(closesvec);
                ret.fields = fmap;
                for (i = fieldSyms.count() - 1; i >= 0 && (((Symbol)fieldSyms.nth((int)i)).name.equals("__meta") || ((Symbol)fieldSyms.nth((int)i)).name.equals("__extmap")); --i) {
                    ++ret.altCtorDrops;
                }
            }
            PersistentVector interfaces = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(interfaceSyms); s != null; s = s.next()) {
                Class c = (Class)Compiler.resolve((Symbol)s.first());
                if (!c.isInterface()) {
                    throw new IllegalArgumentException("only interfaces are supported, had: " + c.getName());
                }
                interfaces = interfaces.cons(c);
            }
            Class<Object> superClass = Object.class;
            Map[] mc = NewInstanceExpr.gatherMethods(superClass, RT.seq(interfaces));
            Map overrideables = mc[0];
            Map covariants = mc[1];
            ret.mmap = overrideables;
            ret.covariants = covariants;
            String[] inames = NewInstanceExpr.interfaceNames(interfaces);
            Class stub = NewInstanceExpr.compileStub(NewInstanceExpr.slashname(superClass), ret, inames, frm);
            Symbol thistag = Symbol.intern(null, stub.getName());
            try {
                Var.pushThreadBindings(RT.mapUniqueKeys(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, Compiler.emptyVarCallSites(), NO_RECUR, null));
                if (ret.isDeftype()) {
                    Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, null, LOCAL_ENV, ret.fields, COMPILE_STUB_SYM, Symbol.intern(null, tagName), COMPILE_STUB_CLASS, stub));
                    ret.hintedFields = RT.subvec(fieldSyms, 0, fieldSyms.count() - ret.altCtorDrops);
                }
                ret.line = Compiler.lineDeref();
                ret.column = Compiler.columnDeref();
                IPersistentCollection methods2 = null;
                ISeq s = methodForms;
                while (s != null) {
                    NewInstanceMethod m = NewInstanceMethod.parse(ret, (ISeq)RT.first(s), thistag, overrideables);
                    methods2 = RT.conj(methods2, m);
                    s = RT.next(s);
                }
                ret.methods = methods2;
                ret.keywords = (IPersistentMap)KEYWORDS.deref();
                ret.vars = (IPersistentMap)VARS.deref();
                ret.constants = (PersistentVector)CONSTANTS.deref();
                ret.constantsID = RT.nextID();
                ret.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                ret.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                ret.varCallsites = (IPersistentSet)VAR_CALLSITES.deref();
            }
            finally {
                if (ret.isDeftype()) {
                    Var.popThreadBindings();
                }
                Var.popThreadBindings();
            }
            try {
                ret.compile(NewInstanceExpr.slashname(superClass), inames, false);
            }
            catch (IOException e2) {
                throw Util.sneakyThrow(e2);
            }
            ret.getCompiledClass();
            return ret;
        }

        static Class compileStub(String superName, NewInstanceExpr ret, String[] interfaceNames, Object frm) {
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            ((ClassVisitor)cv).visit(49, 33, "compile__stub/" + ret.internalName, null, superName, interfaceNames);
            for (ISeq s = RT.keys(ret.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                int access = 1 + (ret.isVolatile(lb) ? 64 : (ret.isMutable(lb) ? 0 : 16));
                if (lb.getPrimitiveType() != null) {
                    ((ClassVisitor)cv).visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    continue;
                }
                ((ClassVisitor)cv).visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ret.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            ctorgen.visitCode();
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            ctorgen.returnValue();
            ctorgen.endMethod();
            if (ret.altCtorDrops > 0) {
                Type[] ctorTypes = ret.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - ret.altCtorDrops];
                for (int i = 0; i < altCtorTypes.length; ++i) {
                    altCtorTypes[i] = ctorTypes[i];
                }
                clojure.asm.commons.Method alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                for (int i = 0; i < ret.altCtorDrops; ++i) {
                    ctorgen.visitInsn(1);
                }
                ctorgen.invokeConstructor(Type.getObjectType("compile__stub/" + ret.internalName), new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            ((ClassVisitor)cv).visitEnd();
            byte[] bytecode = cw.toByteArray();
            DynamicClassLoader loader = (DynamicClassLoader)LOADER.deref();
            return loader.defineClass("compile__stub." + ret.name, bytecode, frm);
        }

        static String[] interfaceNames(IPersistentVector interfaces) {
            int icnt = interfaces.count();
            String[] inames = icnt > 0 ? new String[icnt] : null;
            for (int i = 0; i < icnt; ++i) {
                inames[i] = NewInstanceExpr.slashname((Class)interfaces.nth(i));
            }
            return inames;
        }

        static String slashname(Class c) {
            return c.getName().replace('.', '/');
        }

        @Override
        protected void emitStatics(ClassVisitor cv) {
            if (this.isDeftype()) {
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector getBasis()");
                GeneratorAdapter gen = new GeneratorAdapter(9, meth, null, null, cv);
                this.emitValue(this.hintedFields, gen);
                gen.returnValue();
                gen.endMethod();
                if (this.isDeftype() && this.fields.count() > this.hintedFields.count()) {
                    String className = this.name.replace('.', '/');
                    int i = 1;
                    int fieldCount = this.hintedFields.count();
                    MethodVisitor mv = cv.visitMethod(9, "create", "(Lclojure/lang/IPersistentMap;)L" + className + ";", null, null);
                    mv.visitCode();
                    ISeq s = RT.seq(this.hintedFields);
                    while (s != null) {
                        String bName = ((Symbol)s.first()).name;
                        Class k = Compiler.tagClass(Compiler.tagOf(s.first()));
                        mv.visitVarInsn(25, 0);
                        mv.visitLdcInsn(bName);
                        mv.visitMethodInsn(184, "clojure/lang/Keyword", "intern", "(Ljava/lang/String;)Lclojure/lang/Keyword;");
                        mv.visitInsn(1);
                        mv.visitMethodInsn(185, "clojure/lang/IPersistentMap", "valAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        if (k.isPrimitive()) {
                            mv.visitTypeInsn(192, Type.getType(Compiler.boxClass(k)).getInternalName());
                        }
                        mv.visitVarInsn(58, i);
                        mv.visitVarInsn(25, 0);
                        mv.visitLdcInsn(bName);
                        mv.visitMethodInsn(184, "clojure/lang/Keyword", "intern", "(Ljava/lang/String;)Lclojure/lang/Keyword;");
                        mv.visitMethodInsn(185, "clojure/lang/IPersistentMap", "without", "(Ljava/lang/Object;)Lclojure/lang/IPersistentMap;");
                        mv.visitVarInsn(58, 0);
                        s = s.next();
                        ++i;
                    }
                    mv.visitTypeInsn(187, className);
                    mv.visitInsn(89);
                    clojure.asm.commons.Method ctor = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
                    if (this.hintedFields.count() > 0) {
                        for (i = 1; i <= fieldCount; ++i) {
                            mv.visitVarInsn(25, i);
                            Class k = Compiler.tagClass(Compiler.tagOf(this.hintedFields.nth(i - 1)));
                            if (!k.isPrimitive()) continue;
                            String b = Type.getType(Compiler.boxClass(k)).getInternalName();
                            String p = Type.getType(k).getDescriptor();
                            String n = k.getName();
                            mv.visitMethodInsn(182, b, n + "Value", "()" + p);
                        }
                    }
                    mv.visitInsn(1);
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(184, "clojure/lang/RT", "seqOrElse", "(Ljava/lang/Object;)Ljava/lang/Object;");
                    mv.visitMethodInsn(183, className, "<init>", ctor.getDescriptor());
                    mv.visitInsn(176);
                    mv.visitMaxs(4 + fieldCount, 1 + fieldCount);
                    mv.visitEnd();
                }
            }
        }

        @Override
        protected void emitMethods(ClassVisitor cv) {
            for (ISeq s = RT.seq(this.methods); s != null; s = s.next()) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
            }
            for (Map.Entry<IPersistentVector, Set<Class>> e2 : this.covariants.entrySet()) {
                Method m = this.mmap.get(e2.getKey());
                Class<?>[] params = m.getParameterTypes();
                Type[] argTypes = new Type[params.length];
                for (int i = 0; i < params.length; ++i) {
                    argTypes[i] = Type.getType(params[i]);
                }
                clojure.asm.commons.Method target = new clojure.asm.commons.Method(m.getName(), Type.getType(m.getReturnType()), argTypes);
                for (Class retType : e2.getValue()) {
                    clojure.asm.commons.Method meth = new clojure.asm.commons.Method(m.getName(), Type.getType(retType), argTypes);
                    GeneratorAdapter gen = new GeneratorAdapter(65, meth, null, EXCEPTION_TYPES, cv);
                    gen.visitCode();
                    gen.loadThis();
                    gen.loadArgs();
                    gen.invokeInterface(Type.getType(m.getDeclaringClass()), target);
                    gen.returnValue();
                    gen.endMethod();
                }
            }
        }

        public static IPersistentVector msig(Method m) {
            return RT.vector(m.getName(), RT.seq(m.getParameterTypes()), m.getReturnType());
        }

        static void considerMethod(Method m, Map mm) {
            IPersistentVector mk = NewInstanceExpr.msig(m);
            int mods = m.getModifiers();
            if (!(mm.containsKey(mk) || !Modifier.isPublic(mods) && !Modifier.isProtected(mods) || Modifier.isStatic(mods) || Modifier.isFinal(mods))) {
                mm.put(mk, m);
            }
        }

        static void gatherMethods(Class c, Map mm) {
            while (c != null) {
                for (Method m : c.getDeclaredMethods()) {
                    NewInstanceExpr.considerMethod(m, mm);
                }
                for (Method m : c.getMethods()) {
                    NewInstanceExpr.considerMethod(m, mm);
                }
                c = c.getSuperclass();
            }
        }

        public static Map[] gatherMethods(Class sc, ISeq interfaces) {
            HashMap allm = new HashMap();
            NewInstanceExpr.gatherMethods(sc, allm);
            while (interfaces != null) {
                NewInstanceExpr.gatherMethods((Class)interfaces.first(), allm);
                interfaces = interfaces.next();
            }
            HashMap<IPersistentVector, Method> mm = new HashMap<IPersistentVector, Method>();
            HashMap covariants = new HashMap();
            Iterator i$ = allm.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry e2 = o = i$.next();
                IPersistentVector mk = (IPersistentVector)e2.getKey();
                mk = (IPersistentVector)mk.pop();
                Method m = (Method)e2.getValue();
                if (mm.containsKey(mk)) {
                    Method om;
                    HashSet cvs = (HashSet)covariants.get(mk);
                    if (cvs == null) {
                        cvs = new HashSet();
                        covariants.put(mk, cvs);
                    }
                    if ((om = (Method)mm.get(mk)).getReturnType().isAssignableFrom(m.getReturnType())) {
                        cvs.add(om.getReturnType());
                        mm.put(mk, m);
                        continue;
                    }
                    cvs.add(m.getReturnType());
                    continue;
                }
                mm.put(mk, m);
            }
            return new Map[]{mm, covariants};
        }

        static class ReifyParser
        implements IParser {
            ReifyParser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
                String basename = enclosingMethod != null ? ObjExpr.trimGenID(enclosingMethod.objx.name) + "$" : Compiler.munge(Compiler.currentNS().name.name) + "$";
                String simpleName = "reify__" + RT.nextID();
                String classname = basename + simpleName;
                ISeq rform = RT.next(form);
                IPersistentVector interfaces = ((IPersistentVector)RT.first(rform)).cons(Symbol.intern("clojure.lang.IObj"));
                rform = RT.next(rform);
                ObjExpr ret = NewInstanceExpr.build(interfaces, null, null, classname, Symbol.intern(classname), null, rform, frm, null);
                if (frm instanceof IObj && ((IObj)frm).meta() != null) {
                    return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)frm).meta()));
                }
                return ret;
            }
        }

        static class DeftypeParser
        implements IParser {
            DeftypeParser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq rform = (ISeq)frm;
                rform = RT.next(rform);
                String tagname = ((Symbol)rform.first()).getName();
                rform = rform.next();
                Symbol classname = (Symbol)rform.first();
                rform = rform.next();
                IPersistentVector fields = (IPersistentVector)rform.first();
                rform = rform.next();
                IPersistentMap opts = PersistentHashMap.EMPTY;
                while (rform != null && rform.first() instanceof Keyword) {
                    opts = opts.assoc(rform.first(), RT.second(rform));
                    rform = rform.next().next();
                }
                ObjExpr ret = NewInstanceExpr.build((IPersistentVector)RT.get(opts, implementsKey, PersistentVector.EMPTY), fields, null, tagname, classname, (Symbol)RT.get(opts, RT.TAG_KEY), rform, frm, opts);
                return ret;
            }
        }
    }

    public static class CompilerException
    extends RuntimeException {
        public final String source;
        public final int line;

        public CompilerException(String source2, int line, int column, Throwable cause) {
            super(Compiler.errorMsg(source2, line, column, cause.toString()), cause);
            this.source = source2;
            this.line = line;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static class RecurExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final IPersistentVector args;
        public final IPersistentVector loopLocals;
        final int line;
        final int column;
        final String source;

        public RecurExpr(IPersistentVector loopLocals, IPersistentVector args, int line, int column, String source2) {
            this.loopLocals = loopLocals;
            this.args = args;
            this.line = line;
            this.column = column;
            this.source = source2;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval recur");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            LocalBinding lb;
            int i;
            Label loopLabel = (Label)LOOP_LABEL.deref();
            if (loopLabel == null) {
                throw new IllegalStateException();
            }
            for (i = 0; i < this.loopLocals.count(); ++i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Expr arg = (Expr)this.args.nth(i);
                if (lb.getPrimitiveType() != null) {
                    Class primc = lb.getPrimitiveType();
                    Class pc = Compiler.maybePrimitiveType(arg);
                    if (pc == primc) {
                        ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                        continue;
                    }
                    if (primc == Long.TYPE && pc == Integer.TYPE) {
                        ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(133);
                        continue;
                    }
                    if (primc == Double.TYPE && pc == Float.TYPE) {
                        ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(141);
                        continue;
                    }
                    if (primc == Integer.TYPE && pc == Long.TYPE) {
                        ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                        continue;
                    }
                    if (primc == Float.TYPE && pc == Double.TYPE) {
                        ((MaybePrimitiveExpr)arg).emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(144);
                        continue;
                    }
                    throw new IllegalArgumentException(" recur arg for primitive local: " + lb.name + " is not matching primitive, had: " + (arg.hasJavaClass() ? arg.getJavaClass().getName() : "Object") + ", needed: " + primc.getName());
                }
                arg.emit(C.EXPRESSION, objx, gen);
            }
            for (i = this.loopLocals.count() - 1; i >= 0; --i) {
                lb = (LocalBinding)this.loopLocals.nth(i);
                Class primc = lb.getPrimitiveType();
                if (lb.isArg) {
                    gen.storeArg(lb.idx - (objx.canBeDirect ? 0 : 1));
                    continue;
                }
                if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), lb.idx);
                    continue;
                }
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
            }
            gen.goTo(loopLabel);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return RECUR_CLASS;
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                String source2 = (String)SOURCE.deref();
                ISeq form = (ISeq)frm;
                IPersistentVector loopLocals = (IPersistentVector)LOOP_LOCALS.deref();
                if (context != C.RETURN || loopLocals == null) {
                    throw new UnsupportedOperationException("Can only recur from tail position");
                }
                if (NO_RECUR.deref() != null) {
                    throw new UnsupportedOperationException("Cannot recur across try");
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(C.EXPRESSION, s.first()));
                }
                if (args.count() != loopLocals.count()) {
                    throw new IllegalArgumentException(String.format("Mismatched argument count to recur, expected: %d args, got: %d", loopLocals.count(), args.count()));
                }
                for (int i = 0; i < loopLocals.count(); ++i) {
                    LocalBinding lb = (LocalBinding)loopLocals.nth(i);
                    Class primc = lb.getPrimitiveType();
                    if (primc == null) continue;
                    boolean mismatch = false;
                    Class pc = Compiler.maybePrimitiveType((Expr)args.nth(i));
                    if (primc == Long.TYPE) {
                        if (pc != Long.TYPE && pc != Integer.TYPE && pc != Short.TYPE && pc != Character.TYPE && pc != Byte.TYPE) {
                            mismatch = true;
                        }
                    } else if (primc == Double.TYPE && pc != Double.TYPE && pc != Float.TYPE) {
                        mismatch = true;
                    }
                    if (!mismatch) continue;
                    lb.recurMistmatch = true;
                    if (!RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) continue;
                    RT.errPrintWriter().println(source2 + ":" + line + " recur arg for primitive local: " + lb.name + " is not matching primitive, had: " + (pc != null ? pc.getName() : "Object") + ", needed: " + primc.getName());
                }
                return new RecurExpr(loopLocals, args, line, column, source2);
            }
        }
    }

    public static class LetExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final PersistentVector bindingInits;
        public final Expr body;
        public final boolean isLoop;

        public LetExpr(PersistentVector bindingInits, Expr body, boolean isLoop) {
            this.bindingInits = bindingInits;
            this.body = body;
            this.isLoop = isLoop;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval let/loop");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, false);
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            HashMap<BindingInit, Label> bindingLabels = new HashMap<BindingInit, Label>();
            for (int i = 0; i < this.bindingInits.count(); ++i) {
                BindingInit bi = (BindingInit)this.bindingInits.nth(i);
                Class primc = Compiler.maybePrimitiveType(bi.init);
                if (primc != null) {
                    ((MaybePrimitiveExpr)bi.init).emitUnboxed(C.EXPRESSION, objx, gen);
                    gen.visitVarInsn(Type.getType(primc).getOpcode(54), bi.binding.idx);
                } else {
                    bi.init.emit(C.EXPRESSION, objx, gen);
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
                }
                bindingLabels.put(bi, gen.mark());
            }
            Label loopLabel = gen.mark();
            if (this.isLoop) {
                try {
                    Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel));
                    if (emitUnboxed) {
                        ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen);
                    }
                    this.body.emit(context, objx, gen);
                }
                finally {
                    Var.popThreadBindings();
                }
            } else if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.body).emitUnboxed(context, objx, gen);
            } else {
                this.body.emit(context, objx, gen);
            }
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi = (BindingInit)bis.first();
                String lname = bi.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, (Label)bindingLabels.get(bi), end, bi.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, (Label)bindingLabels.get(bi), end, bi.binding.idx);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.body.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.body.getJavaClass();
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.body instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.body).canEmitPrimitive();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                boolean isLoop = RT.first(form).equals(LOOP);
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL || context == C.EXPRESSION && isLoop) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                ObjMethod method = (ObjMethod)METHOD.deref();
                IPersistentMap backupMethodLocals = method.locals;
                IPersistentMap backupMethodIndexLocals = method.indexlocals;
                IPersistentVector recurMismatches = PersistentVector.EMPTY;
                for (int i = 0; i < bindings.count() / 2; ++i) {
                    recurMismatches = recurMismatches.cons(RT.F);
                }
                while (true) {
                    IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                    method.locals = backupMethodLocals;
                    method.indexlocals = backupMethodIndexLocals;
                    PathNode looproot = new PathNode(PATHTYPE.PATH, (PathNode)CLEAR_PATH.get());
                    PathNode clearroot = new PathNode(PATHTYPE.PATH, looproot);
                    PathNode clearpath = new PathNode(PATHTYPE.PATH, looproot);
                    if (isLoop) {
                        dynamicBindings = dynamicBindings.assoc(LOOP_LOCALS, null);
                    }
                    try {
                        Expr bodyExpr;
                        LocalBinding lb;
                        Var.pushThreadBindings(dynamicBindings);
                        PersistentVector bindingInits = PersistentVector.EMPTY;
                        PersistentVector loopLocals = PersistentVector.EMPTY;
                        for (int i = 0; i < bindings.count(); i += 2) {
                            if (!(bindings.nth(i) instanceof Symbol)) {
                                throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                            }
                            Symbol sym = (Symbol)bindings.nth(i);
                            if (sym.getNamespace() != null) {
                                throw Util.runtimeException("Can't let qualified name: " + sym);
                            }
                            Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                            if (isLoop) {
                                if (recurMismatches != null && RT.booleanCast(recurMismatches.nth(i / 2))) {
                                    init = new StaticMethodExpr("", 0, 0, null, RT.class, "box", RT.vector(init));
                                    if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                                        RT.errPrintWriter().println("Auto-boxing loop arg: " + sym);
                                    }
                                } else if (Compiler.maybePrimitiveType(init) == Integer.TYPE) {
                                    init = new StaticMethodExpr("", 0, 0, null, RT.class, "longCast", RT.vector(init));
                                } else if (Compiler.maybePrimitiveType(init) == Float.TYPE) {
                                    init = new StaticMethodExpr("", 0, 0, null, RT.class, "doubleCast", RT.vector(init));
                                }
                            }
                            try {
                                if (isLoop) {
                                    Var.pushThreadBindings(RT.map(CLEAR_PATH, clearpath, CLEAR_ROOT, clearroot, NO_RECUR, null));
                                }
                                lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), init, false);
                                BindingInit bi = new BindingInit(lb, init);
                                bindingInits = bindingInits.cons(bi);
                                if (!isLoop) continue;
                                loopLocals = loopLocals.cons(lb);
                                continue;
                            }
                            finally {
                                if (isLoop) {
                                    Var.popThreadBindings();
                                }
                            }
                        }
                        if (isLoop) {
                            LOOP_LOCALS.set(loopLocals);
                        }
                        boolean moreMismatches = false;
                        try {
                            if (isLoop) {
                                Var.pushThreadBindings(RT.map(CLEAR_PATH, clearpath, CLEAR_ROOT, clearroot, NO_RECUR, null));
                            }
                            bodyExpr = new BodyExpr.Parser().parse(isLoop ? C.RETURN : context, body);
                        }
                        finally {
                            if (isLoop) {
                                Var.popThreadBindings();
                                for (int i = 0; i < loopLocals.count(); ++i) {
                                    lb = (LocalBinding)loopLocals.nth(i);
                                    if (!lb.recurMistmatch) continue;
                                    recurMismatches = (IPersistentVector)recurMismatches.assoc(i, RT.T);
                                    moreMismatches = true;
                                }
                            }
                        }
                        if (moreMismatches) continue;
                        LetExpr letExpr = new LetExpr(bindingInits, bodyExpr, isLoop);
                        return letExpr;
                    }
                    finally {
                        Var.popThreadBindings();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static class LetFnExpr
    implements Expr {
        public final PersistentVector bindingInits;
        public final Expr body;

        public LetFnExpr(PersistentVector bindingInits, Expr body) {
            this.bindingInits = bindingInits;
            this.body = body;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval letfns");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            BindingInit bi;
            int i;
            for (int i2 = 0; i2 < this.bindingInits.count(); ++i2) {
                BindingInit bi2 = (BindingInit)this.bindingInits.nth(i2);
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi2.binding.idx);
            }
            IPersistentSet lbset = PersistentHashSet.EMPTY;
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                lbset = (IPersistentSet)lbset.cons(bi.binding);
                bi.init.emit(C.EXPRESSION, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), bi.binding.idx);
            }
            for (i = 0; i < this.bindingInits.count(); ++i) {
                bi = (BindingInit)this.bindingInits.nth(i);
                ObjExpr fe = (ObjExpr)bi.init;
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), bi.binding.idx);
                fe.emitLetFnInits(gen, objx, lbset);
            }
            Label loopLabel = gen.mark();
            this.body.emit(context, objx, gen);
            Label end = gen.mark();
            for (ISeq bis = this.bindingInits.seq(); bis != null; bis = bis.next()) {
                Class primc;
                BindingInit bi3 = (BindingInit)bis.first();
                String lname = bi3.binding.name;
                if (lname.endsWith("__auto__")) {
                    lname = lname + RT.nextID();
                }
                if ((primc = Compiler.maybePrimitiveType(bi3.init)) != null) {
                    gen.visitLocalVariable(lname, Type.getDescriptor(primc), null, loopLabel, end, bi3.binding.idx);
                    continue;
                }
                gen.visitLocalVariable(lname, "Ljava/lang/Object;", null, loopLabel, end, bi3.binding.idx);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.body.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.body.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (!(RT.second(form) instanceof IPersistentVector)) {
                    throw new IllegalArgumentException("Bad binding form, expected vector");
                }
                IPersistentVector bindings = (IPersistentVector)RT.second(form);
                if (bindings.count() % 2 != 0) {
                    throw new IllegalArgumentException("Bad binding form, expected matched symbol expression pairs");
                }
                ISeq body = RT.next(RT.next(form));
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref());
                try {
                    Var.pushThreadBindings(dynamicBindings);
                    PersistentVector lbs = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        if (!(bindings.nth(i) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + bindings.nth(i));
                        }
                        Symbol sym = (Symbol)bindings.nth(i);
                        if (sym.getNamespace() != null) {
                            throw Util.runtimeException("Can't let qualified name: " + sym);
                        }
                        LocalBinding lb = Compiler.registerLocal(sym, Compiler.tagOf(sym), null, false);
                        lb.canBeCleared = false;
                        lbs = lbs.cons(lb);
                    }
                    PersistentVector bindingInits = PersistentVector.EMPTY;
                    for (int i = 0; i < bindings.count(); i += 2) {
                        Symbol sym = (Symbol)bindings.nth(i);
                        Expr init = Compiler.analyze(C.EXPRESSION, bindings.nth(i + 1), sym.name);
                        LocalBinding lb = (LocalBinding)lbs.nth(i / 2);
                        lb.init = init;
                        BindingInit bi = new BindingInit(lb, init);
                        bindingInits = bindingInits.cons(bi);
                    }
                    LetFnExpr letFnExpr = new LetFnExpr(bindingInits, new BodyExpr.Parser().parse(context, body));
                    return letFnExpr;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }
    }

    public static class BindingInit {
        LocalBinding binding;
        Expr init;

        public final LocalBinding binding() {
            return this.binding;
        }

        public final Expr init() {
            return this.init;
        }

        public BindingInit(LocalBinding binding2, Expr init) {
            this.binding = binding2;
            this.init = init;
        }
    }

    public static class BodyExpr
    implements Expr,
    MaybePrimitiveExpr {
        PersistentVector exprs;

        public final PersistentVector exprs() {
            return this.exprs;
        }

        public BodyExpr(PersistentVector exprs) {
            this.exprs = exprs;
        }

        @Override
        public Object eval() {
            Object ret = null;
            for (Object o : this.exprs) {
                Expr e2 = (Expr)o;
                ret = e2.eval();
            }
            return ret;
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.lastExpr() instanceof MaybePrimitiveExpr && ((MaybePrimitiveExpr)this.lastExpr()).canEmitPrimitive();
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = 0; i < this.exprs.count() - 1; ++i) {
                Expr e2 = (Expr)this.exprs.nth(i);
                e2.emit(C.STATEMENT, objx, gen);
            }
            MaybePrimitiveExpr last = (MaybePrimitiveExpr)this.exprs.nth(this.exprs.count() - 1);
            last.emitUnboxed(context, objx, gen);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = 0; i < this.exprs.count() - 1; ++i) {
                Expr e2 = (Expr)this.exprs.nth(i);
                e2.emit(C.STATEMENT, objx, gen);
            }
            Expr last = (Expr)this.exprs.nth(this.exprs.count() - 1);
            last.emit(context, objx, gen);
        }

        @Override
        public boolean hasJavaClass() {
            return this.lastExpr().hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.lastExpr().getJavaClass();
        }

        private Expr lastExpr() {
            return (Expr)this.exprs.nth(this.exprs.count() - 1);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frms) {
                ISeq forms = (ISeq)frms;
                if (Util.equals(RT.first(forms), DO)) {
                    forms = RT.next(forms);
                }
                PersistentVector exprs = PersistentVector.EMPTY;
                while (forms != null) {
                    Expr e2 = context != C.EVAL && (context == C.STATEMENT || forms.next() != null) ? Compiler.analyze(C.STATEMENT, forms.first()) : Compiler.analyze(context, forms.first());
                    exprs = exprs.cons(e2);
                    forms = forms.next();
                }
                if (exprs.count() == 0) {
                    exprs = exprs.cons(NIL_EXPR);
                }
                return new BodyExpr(exprs);
            }
        }
    }

    public static class LocalBindingExpr
    implements Expr,
    MaybePrimitiveExpr,
    AssignableExpr {
        public final LocalBinding b;
        public final Symbol tag;
        public final PathNode clearPath;
        public final PathNode clearRoot;
        public boolean shouldClear = false;

        public LocalBindingExpr(LocalBinding b, Symbol tag) {
            if (b.getPrimitiveType() != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a primitive local");
            }
            this.b = b;
            this.tag = tag;
            this.clearPath = (PathNode)CLEAR_PATH.get();
            this.clearRoot = (PathNode)CLEAR_ROOT.get();
            IPersistentCollection sites = (IPersistentCollection)RT.get(CLEAR_SITES.get(), b);
            if (b.idx > 0) {
                if (sites != null) {
                    for (ISeq s = sites.seq(); s != null; s = s.next()) {
                        LocalBindingExpr o = (LocalBindingExpr)s.first();
                        PathNode common = Compiler.commonPath(this.clearPath, o.clearPath);
                        if (common == null || common.type != PATHTYPE.PATH) continue;
                        o.shouldClear = false;
                    }
                }
                if (this.clearRoot == b.clearPathRoot) {
                    this.shouldClear = true;
                    sites = RT.conj(sites, this);
                    CLEAR_SITES.set(RT.assoc(CLEAR_SITES.get(), b, sites));
                }
            }
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.b.getPrimitiveType() != null;
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitUnboxedLocal(gen, this.b);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                objx.emitLocal(gen, this.b, this.shouldClear);
            }
        }

        @Override
        public Object evalAssign(Expr val2) {
            throw new UnsupportedOperationException("Can't eval locals");
        }

        @Override
        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            objx.emitAssignLocal(gen, this.b, val2);
            if (context != C.STATEMENT) {
                objx.emitLocal(gen, this.b, false);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null || this.b.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            if (this.tag != null) {
                return HostExpr.tagToClass(this.tag);
            }
            return this.b.getJavaClass();
        }
    }

    public static class LocalBinding {
        public final Symbol sym;
        public final Symbol tag;
        public Expr init;
        int idx;
        public final String name;
        public final boolean isArg;
        public final PathNode clearPathRoot;
        public boolean canBeCleared = !RT.booleanCast(Compiler.getCompilerOption(disableLocalsClearingKey));
        public boolean recurMistmatch = false;

        public LocalBinding(int num2, Symbol sym, Symbol tag, Expr init, boolean isArg, PathNode clearPathRoot) {
            if (Compiler.maybePrimitiveType(init) != null && tag != null) {
                throw new UnsupportedOperationException("Can't type hint a local with a primitive initializer");
            }
            this.idx = num2;
            this.sym = sym;
            this.tag = tag;
            this.init = init;
            this.isArg = isArg;
            this.clearPathRoot = clearPathRoot;
            this.name = Compiler.munge(sym.name);
        }

        public boolean hasJavaClass() {
            if (this.init != null && this.init.hasJavaClass() && Util.isPrimitive(this.init.getJavaClass()) && !(this.init instanceof MaybePrimitiveExpr)) {
                return false;
            }
            return this.tag != null || this.init != null && this.init.hasJavaClass();
        }

        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.init.getJavaClass();
        }

        public Class getPrimitiveType() {
            return Compiler.maybePrimitiveType(this.init);
        }
    }

    public static abstract class ObjMethod {
        public final ObjMethod parent;
        IPersistentMap locals = null;
        IPersistentMap indexlocals = null;
        Expr body = null;
        ObjExpr objx;
        PersistentVector argLocals;
        int maxLocal = 0;
        int line;
        int column;
        boolean usesThis = false;
        PersistentHashSet localsUsedInCatchFinally = PersistentHashSet.EMPTY;
        protected IPersistentMap methodMeta;

        public final IPersistentMap locals() {
            return this.locals;
        }

        public final Expr body() {
            return this.body;
        }

        public final ObjExpr objx() {
            return this.objx;
        }

        public final PersistentVector argLocals() {
            return this.argLocals;
        }

        public final int maxLocal() {
            return this.maxLocal;
        }

        public final int line() {
            return this.line;
        }

        public final int column() {
            return this.column;
        }

        public ObjMethod(ObjExpr objx, ObjMethod parent) {
            this.parent = parent;
            this.objx = objx;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static void emitBody(ObjExpr objx, GeneratorAdapter gen, Class retClass, Expr body) {
            MaybePrimitiveExpr be = (MaybePrimitiveExpr)body;
            if (Util.isPrimitive(retClass) && be.canEmitPrimitive()) {
                Class bc = Compiler.maybePrimitiveType(be);
                if (bc == retClass) {
                    be.emitUnboxed(C.RETURN, objx, gen);
                    return;
                } else if (retClass == Long.TYPE && bc == Integer.TYPE) {
                    be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(133);
                    return;
                } else if (retClass == Double.TYPE && bc == Float.TYPE) {
                    be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(141);
                    return;
                } else if (retClass == Integer.TYPE && bc == Long.TYPE) {
                    be.emitUnboxed(C.RETURN, objx, gen);
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                    return;
                } else {
                    if (retClass != Float.TYPE || bc != Double.TYPE) throw new IllegalArgumentException("Mismatched primitive return, expected: " + retClass + ", had: " + be.getJavaClass());
                    be.emitUnboxed(C.RETURN, objx, gen);
                    gen.visitInsn(144);
                }
                return;
            } else {
                body.emit(C.RETURN, objx, gen);
                if (retClass == Void.TYPE) {
                    gen.pop();
                    return;
                } else {
                    gen.unbox(Type.getType(retClass));
                }
            }
        }

        abstract int numParams();

        abstract String getMethodName();

        abstract Type getReturnType();

        abstract Type[] getArgTypes();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(ObjExpr fn2, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                this.body.emit(C.RETURN, fn2, gen);
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }

        void emitClearLocals(GeneratorAdapter gen) {
        }

        void emitClearLocalsOld(GeneratorAdapter gen) {
            int i;
            for (i = 0; i < this.argLocals.count(); ++i) {
                LocalBinding lb = (LocalBinding)this.argLocals.nth(i);
                if (this.localsUsedInCatchFinally.contains(lb.idx) || lb.getPrimitiveType() != null) continue;
                gen.visitInsn(1);
                gen.storeArg(lb.idx - 1);
            }
            for (i = this.numParams() + 1; i < this.maxLocal + 1; ++i) {
                LocalBinding b;
                if (this.localsUsedInCatchFinally.contains(i) || (b = (LocalBinding)RT.get(this.indexlocals, i)) != null && Compiler.maybePrimitiveType(b.init) != null) continue;
                gen.visitInsn(1);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), i);
            }
        }
    }

    public static class FnMethod
    extends ObjMethod {
        PersistentVector reqParms = PersistentVector.EMPTY;
        LocalBinding restParm = null;
        Type[] argtypes;
        Class[] argclasses;
        Class retClass;
        String prim;

        public FnMethod(ObjExpr objx, ObjMethod parent) {
            super(objx, parent);
        }

        public static char classChar(Object x) {
            Class c = null;
            if (x instanceof Class) {
                c = (Class)x;
            } else if (x instanceof Symbol) {
                c = Compiler.primClass((Symbol)x);
            }
            if (c == null || !c.isPrimitive()) {
                return 'O';
            }
            if (c == Long.TYPE) {
                return 'L';
            }
            if (c == Double.TYPE) {
                return 'D';
            }
            throw new IllegalArgumentException("Only long and double primitives are supported");
        }

        public static String primInterface(IPersistentVector arglist) {
            boolean prim;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arglist.count(); ++i) {
                sb.append(FnMethod.classChar(Compiler.tagOf(arglist.nth(i))));
            }
            sb.append(FnMethod.classChar(Compiler.tagOf(arglist)));
            String ret = sb.toString();
            boolean bl = prim = ret.contains("L") || ret.contains("D");
            if (prim && arglist.count() > 4) {
                throw new IllegalArgumentException("fns taking primitives support only 4 or fewer args");
            }
            if (prim) {
                return "clojure.lang.IFn$" + ret;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FnMethod parse(ObjExpr objx, ISeq form, Object rettag) {
            IPersistentVector parms = (IPersistentVector)RT.first(form);
            ISeq body = RT.next(form);
            try {
                int i;
                String retstr;
                FnMethod method = new FnMethod(objx, (ObjMethod)METHOD.deref());
                method.line = Compiler.lineDeref();
                method.column = Compiler.columnDeref();
                PathNode pnode = (PathNode)CLEAR_PATH.get();
                if (pnode == null) {
                    pnode = new PathNode(PATHTYPE.PATH, null);
                }
                Var.pushThreadBindings(RT.mapUniqueKeys(METHOD, method, LOCAL_ENV, LOCAL_ENV.deref(), LOOP_LOCALS, null, NEXT_LOCAL_NUM, 0, CLEAR_PATH, pnode, CLEAR_ROOT, pnode, CLEAR_SITES, PersistentHashMap.EMPTY));
                method.prim = FnMethod.primInterface(parms);
                if (method.prim != null) {
                    method.prim = method.prim.replace('.', '/');
                }
                if (rettag instanceof String) {
                    rettag = Symbol.intern(null, (String)rettag);
                }
                if (!(rettag instanceof Symbol)) {
                    rettag = null;
                }
                if (rettag != null && !(retstr = ((Symbol)rettag).getName()).equals("long") && !retstr.equals("double")) {
                    rettag = null;
                }
                method.retClass = Compiler.tagClass(Compiler.tagOf(parms) != null ? Compiler.tagOf(parms) : rettag);
                if (method.retClass.isPrimitive()) {
                    if (method.retClass != Double.TYPE && method.retClass != Long.TYPE) {
                        throw new IllegalArgumentException("Only long and double primitives are supported");
                    }
                } else {
                    method.retClass = Object.class;
                }
                if (objx.thisName != null) {
                    Compiler.registerLocal(Symbol.intern(objx.thisName), null, null, false);
                } else {
                    Compiler.getAndIncLocalNum();
                }
                PSTATE state = PSTATE.REQ;
                PersistentVector argLocals = PersistentVector.EMPTY;
                ArrayList<Type> argtypes = new ArrayList<Type>();
                ArrayList<Class<ISeq>> argclasses = new ArrayList<Class<ISeq>>();
                block7: for (i = 0; i < parms.count(); ++i) {
                    if (!(parms.nth(i) instanceof Symbol)) {
                        throw new IllegalArgumentException("fn params must be Symbols");
                    }
                    Symbol p = (Symbol)parms.nth(i);
                    if (p.getNamespace() != null) {
                        throw Util.runtimeException("Can't use qualified name as parameter: " + p);
                    }
                    if (p.equals(_AMP_)) {
                        if (state == PSTATE.REQ) {
                            state = PSTATE.REST;
                            continue;
                        }
                        throw Util.runtimeException("Invalid parameter list");
                    }
                    Class<ISeq> pc = Compiler.primClass(Compiler.tagClass(Compiler.tagOf(p)));
                    if (pc.isPrimitive() && pc != Double.TYPE && pc != Long.TYPE) {
                        throw new IllegalArgumentException("Only long and double primitives are supported: " + p);
                    }
                    if (state == PSTATE.REST && Compiler.tagOf(p) != null) {
                        throw Util.runtimeException("& arg cannot have type hint");
                    }
                    if (state == PSTATE.REST && method.prim != null) {
                        throw Util.runtimeException("fns taking primitives cannot be variadic");
                    }
                    if (state == PSTATE.REST) {
                        pc = ISeq.class;
                    }
                    argtypes.add(Type.getType(pc));
                    argclasses.add(pc);
                    LocalBinding lb = pc.isPrimitive() ? Compiler.registerLocal(p, null, new MethodParamExpr(pc), true) : Compiler.registerLocal(p, state == PSTATE.REST ? ISEQ : Compiler.tagOf(p), null, true);
                    argLocals = argLocals.cons(lb);
                    switch (state) {
                        case REQ: {
                            method.reqParms = method.reqParms.cons(lb);
                            continue block7;
                        }
                        case REST: {
                            method.restParm = lb;
                            state = PSTATE.DONE;
                            continue block7;
                        }
                        default: {
                            throw Util.runtimeException("Unexpected parameter");
                        }
                    }
                }
                if (method.reqParms.count() > 20) {
                    throw Util.runtimeException("Can't specify more than 20 params");
                }
                LOOP_LOCALS.set(argLocals);
                method.argLocals = argLocals;
                method.argtypes = argtypes.toArray(new Type[argtypes.size()]);
                method.argclasses = argclasses.toArray(new Class[argtypes.size()]);
                if (method.prim != null) {
                    for (i = 0; i < method.argclasses.length; ++i) {
                        if (method.argclasses[i] != Long.TYPE && method.argclasses[i] != Double.TYPE) continue;
                        Compiler.getAndIncLocalNum();
                    }
                }
                method.body = new BodyExpr.Parser().parse(C.RETURN, body);
                FnMethod fnMethod = method;
                return fnMethod;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        @Override
        public void emit(ObjExpr fn2, ClassVisitor cv) {
            if (fn2.canBeDirect) {
                this.doEmitStatic(fn2, cv);
            } else if (this.prim != null) {
                this.doEmitPrim(fn2, cv);
            } else {
                this.doEmit(fn2, cv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEmitStatic(ObjExpr fn2, ClassVisitor cv) {
            Type returnType = Type.getType(this.retClass);
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokeStatic", returnType, this.argtypes);
            GeneratorAdapter gen = new GeneratorAdapter(9, ms, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                FnMethod.emitBody(this.objx, gen, this.retClass, this.body);
                Label end = gen.mark();
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, this.argtypes[lb.idx].getDescriptor(), null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), OBJECT_TYPE, this.getArgTypes());
            gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            for (int i = 0; i < this.argtypes.length; ++i) {
                gen.loadArg(i);
                HostExpr.emitUnboxArg(fn2, gen, this.argclasses[i]);
                if (this.argclasses[i].isPrimitive()) continue;
                gen.visitInsn(1);
                gen.storeArg(i);
            }
            Label callLabel = gen.mark();
            gen.visitLineNumber(this.line, callLabel);
            gen.invokeStatic(this.objx.objtype, ms);
            gen.box(returnType);
            gen.returnValue();
            gen.endMethod();
            if (this.prim != null) {
                returnType = this.retClass == Double.TYPE || this.retClass == Long.TYPE ? this.getReturnType() : OBJECT_TYPE;
                clojure.asm.commons.Method pm = new clojure.asm.commons.Method("invokePrim", returnType, this.argtypes);
                gen = new GeneratorAdapter(17, pm, null, EXCEPTION_TYPES, cv);
                gen.visitCode();
                for (int i = 0; i < this.argtypes.length; ++i) {
                    gen.loadArg(i);
                    if (this.argclasses[i].isPrimitive()) continue;
                    gen.visitInsn(1);
                    gen.storeArg(i);
                }
                gen.invokeStatic(this.objx.objtype, ms);
                gen.returnValue();
                gen.endMethod();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEmitPrim(ObjExpr fn2, ClassVisitor cv) {
            Type returnType = this.retClass == Double.TYPE || this.retClass == Long.TYPE ? this.getReturnType() : OBJECT_TYPE;
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokePrim", returnType, this.argtypes);
            GeneratorAdapter gen = new GeneratorAdapter(17, ms, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                FnMethod.emitBody(this.objx, gen, this.retClass, this.body);
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, this.argtypes[lb.idx - 1].getDescriptor(), null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), OBJECT_TYPE, this.getArgTypes());
            gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            gen.loadThis();
            for (int i = 0; i < this.argtypes.length; ++i) {
                gen.loadArg(i);
                HostExpr.emitUnboxArg(fn2, gen, this.argclasses[i]);
            }
            gen.invokeInterface(Type.getType("L" + this.prim + ";"), ms);
            gen.box(this.getReturnType());
            gen.returnValue();
            gen.endMethod();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doEmit(ObjExpr fn2, ClassVisitor cv) {
            clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.getMethodName(), this.getReturnType(), this.getArgTypes());
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, EXCEPTION_TYPES, cv);
            gen.visitCode();
            Label loopLabel = gen.mark();
            gen.visitLineNumber(this.line, loopLabel);
            try {
                Var.pushThreadBindings(RT.map(LOOP_LABEL, loopLabel, METHOD, this));
                this.body.emit(C.RETURN, fn2, gen);
                Label end = gen.mark();
                gen.visitLocalVariable("this", "Ljava/lang/Object;", null, loopLabel, end, 0);
                for (ISeq lbs = this.argLocals.seq(); lbs != null; lbs = lbs.next()) {
                    LocalBinding lb = (LocalBinding)lbs.first();
                    gen.visitLocalVariable(lb.name, "Ljava/lang/Object;", null, loopLabel, end, lb.idx);
                }
            }
            finally {
                Var.popThreadBindings();
            }
            gen.returnValue();
            gen.endMethod();
        }

        public final PersistentVector reqParms() {
            return this.reqParms;
        }

        public final LocalBinding restParm() {
            return this.restParm;
        }

        boolean isVariadic() {
            return this.restParm != null;
        }

        @Override
        int numParams() {
            return this.reqParms.count() + (this.isVariadic() ? 1 : 0);
        }

        @Override
        String getMethodName() {
            return this.isVariadic() ? "doInvoke" : "invoke";
        }

        @Override
        Type getReturnType() {
            if (this.prim != null) {
                return Type.getType(this.retClass);
            }
            return OBJECT_TYPE;
        }

        @Override
        Type[] getArgTypes() {
            if (this.isVariadic() && this.reqParms.count() == 20) {
                Type[] ret = new Type[21];
                for (int i = 0; i < 21; ++i) {
                    ret[i] = OBJECT_TYPE;
                }
                return ret;
            }
            return ARG_TYPES[this.numParams()];
        }

        @Override
        void emitClearLocals(GeneratorAdapter gen) {
        }
    }

    static enum PSTATE {
        REQ,
        REST,
        DONE;

    }

    static class PathNode {
        final PATHTYPE type;
        final PathNode parent;

        PathNode(PATHTYPE type2, PathNode parent) {
            this.type = type2;
            this.parent = parent;
        }
    }

    static enum PATHTYPE {
        PATH,
        BRANCH;

    }

    public static class ObjExpr
    implements Expr {
        static final String CONST_PREFIX = "const__";
        String name;
        String internalName;
        String thisName;
        Type objtype;
        public final Object tag;
        IPersistentMap closes = PersistentHashMap.EMPTY;
        IPersistentVector closesExprs = PersistentVector.EMPTY;
        IPersistentSet volatiles = PersistentHashSet.EMPTY;
        IPersistentMap fields = null;
        IPersistentVector hintedFields = PersistentVector.EMPTY;
        IPersistentMap keywords = PersistentHashMap.EMPTY;
        IPersistentMap vars = PersistentHashMap.EMPTY;
        Class compiledClass;
        int line;
        int column;
        PersistentVector constants;
        IPersistentSet usedConstants = PersistentHashSet.EMPTY;
        int constantsID;
        int altCtorDrops = 0;
        IPersistentVector keywordCallsites;
        IPersistentVector protocolCallsites;
        IPersistentSet varCallsites;
        boolean onceOnly = false;
        Object src;
        IPersistentMap opts = PersistentHashMap.EMPTY;
        static final clojure.asm.commons.Method voidctor = clojure.asm.commons.Method.getMethod("void <init>()");
        protected IPersistentMap classMeta;
        protected boolean canBeDirect;
        static final clojure.asm.commons.Method kwintern = clojure.asm.commons.Method.getMethod("clojure.lang.Keyword intern(String, String)");
        static final clojure.asm.commons.Method symintern = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String)");
        static final clojure.asm.commons.Method varintern = clojure.asm.commons.Method.getMethod("clojure.lang.Var intern(clojure.lang.Symbol, clojure.lang.Symbol)");
        static final Type DYNAMIC_CLASSLOADER_TYPE = Type.getType(DynamicClassLoader.class);
        static final clojure.asm.commons.Method getClassMethod = clojure.asm.commons.Method.getMethod("Class getClass()");
        static final clojure.asm.commons.Method getClassLoaderMethod = clojure.asm.commons.Method.getMethod("ClassLoader getClassLoader()");
        static final clojure.asm.commons.Method getConstantsMethod = clojure.asm.commons.Method.getMethod("Object[] getConstants(int)");
        static final clojure.asm.commons.Method readStringMethod = clojure.asm.commons.Method.getMethod("Object readString(String)");
        static final Type ILOOKUP_SITE_TYPE = Type.getType(ILookupSite.class);
        static final Type ILOOKUP_THUNK_TYPE = Type.getType(ILookupThunk.class);
        static final Type KEYWORD_LOOKUPSITE_TYPE = Type.getType(KeywordLookupSite.class);
        private DynamicClassLoader loader;
        private byte[] bytecode;
        static final clojure.asm.commons.Method varGetMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method varGetRawMethod = clojure.asm.commons.Method.getMethod("Object getRawRoot()");

        public final String name() {
            return this.name;
        }

        public final String internalName() {
            return this.internalName;
        }

        public final String thisName() {
            return this.thisName;
        }

        public final Type objtype() {
            return this.objtype;
        }

        public final IPersistentMap closes() {
            return this.closes;
        }

        public final IPersistentMap keywords() {
            return this.keywords;
        }

        public final IPersistentMap vars() {
            return this.vars;
        }

        public final Class compiledClass() {
            return this.compiledClass;
        }

        public final int line() {
            return this.line;
        }

        public final int column() {
            return this.column;
        }

        public final PersistentVector constants() {
            return this.constants;
        }

        public final int constantsID() {
            return this.constantsID;
        }

        public ObjExpr(Object tag) {
            this.tag = tag;
        }

        static String trimGenID(String name2) {
            int i = name2.lastIndexOf("__");
            return i == -1 ? name2 : name2.substring(0, i);
        }

        Type[] ctorTypes() {
            IPersistentVector tv = !this.supportsMeta() ? PersistentVector.EMPTY : RT.vector(IPERSISTENTMAP_TYPE);
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                tv = lb.getPrimitiveType() != null ? tv.cons(Type.getType(lb.getPrimitiveType())) : tv.cons(OBJECT_TYPE);
            }
            Type[] ret = new Type[tv.count()];
            for (int i = 0; i < tv.count(); ++i) {
                ret[i] = (Type)tv.nth(i);
            }
            return ret;
        }

        void compile(String superName, String[] interfaceNames, boolean oneTimeUse) throws IOException {
            String nsname;
            int i;
            clojure.asm.commons.Method alt;
            Type[] ctorTypes;
            ClassWriter cw;
            ClassWriter cv = cw = new ClassWriter(1);
            ((ClassVisitor)cv).visit(49, 49, this.internalName, null, superName, interfaceNames);
            String source2 = (String)SOURCE.deref();
            int lineBefore = (Integer)LINE_BEFORE.deref();
            int lineAfter = (Integer)LINE_AFTER.deref() + 1;
            int columnBefore = (Integer)COLUMN_BEFORE.deref();
            int columnAfter = (Integer)COLUMN_AFTER.deref() + 1;
            if (source2 != null && SOURCE_PATH.deref() != null) {
                String smap = "SMAP\n" + (source2.lastIndexOf(46) > 0 ? source2.substring(0, source2.lastIndexOf(46)) : source2) + ".java\n" + "Clojure\n" + "*S Clojure\n" + "*F\n" + "+ 1 " + source2 + "\n" + (String)SOURCE_PATH.deref() + "\n" + "*L\n" + String.format("%d#1,%d:%d\n", lineBefore, lineAfter - lineBefore, lineBefore) + "*E";
                ((ClassVisitor)cv).visitSource(source2, smap);
            }
            Compiler.addAnnotation(cv, this.classMeta);
            if (this.supportsMeta()) {
                ((ClassVisitor)cv).visitField(16, "__meta", IPERSISTENTMAP_TYPE.getDescriptor(), null, null);
            }
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (this.isDeftype()) {
                    int access = this.isVolatile(lb) ? 64 : (this.isMutable(lb) ? 0 : 17);
                    FieldVisitor fv = lb.getPrimitiveType() != null ? ((ClassVisitor)cv).visitField(access, lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null) : ((ClassVisitor)cv).visitField(access, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
                    Compiler.addAnnotation(fv, RT.meta(lb.sym));
                    continue;
                }
                if (lb.getPrimitiveType() != null) {
                    ((ClassVisitor)cv).visitField(0 + (this.isVolatile(lb) ? 64 : 0), lb.name, Type.getType(lb.getPrimitiveType()).getDescriptor(), null, null);
                    continue;
                }
                ((ClassVisitor)cv).visitField(0, lb.name, OBJECT_TYPE.getDescriptor(), null, null);
            }
            for (int i2 = 0; i2 < this.protocolCallsites.count(); ++i2) {
                ((ClassVisitor)cv).visitField(10, this.cachedClassName(i2), CLASS_TYPE.getDescriptor(), null, null);
            }
            clojure.asm.commons.Method m = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes());
            GeneratorAdapter ctorgen = new GeneratorAdapter(1, m, null, null, cv);
            Label start = ctorgen.newLabel();
            Label end = ctorgen.newLabel();
            ctorgen.visitCode();
            ctorgen.visitLineNumber(this.line, ctorgen.mark());
            ctorgen.visitLabel(start);
            ctorgen.loadThis();
            ctorgen.invokeConstructor(Type.getObjectType(superName), voidctor);
            if (this.supportsMeta()) {
                ctorgen.loadThis();
                ctorgen.visitVarInsn(IPERSISTENTMAP_TYPE.getOpcode(21), 1);
                ctorgen.putField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
            }
            int a = this.supportsMeta() ? 2 : 1;
            ISeq s = RT.keys(this.closes);
            while (s != null) {
                LocalBinding lb = (LocalBinding)s.first();
                ctorgen.loadThis();
                Class primc = lb.getPrimitiveType();
                if (primc != null) {
                    ctorgen.visitVarInsn(Type.getType(primc).getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, Type.getType(primc));
                    if (primc == Long.TYPE || primc == Double.TYPE) {
                        ++a;
                    }
                } else {
                    ctorgen.visitVarInsn(OBJECT_TYPE.getOpcode(21), a);
                    ctorgen.putField(this.objtype, lb.name, OBJECT_TYPE);
                }
                this.closesExprs = this.closesExprs.cons(new LocalBindingExpr(lb, null));
                s = s.next();
                ++a;
            }
            ctorgen.visitLabel(end);
            ctorgen.returnValue();
            ctorgen.endMethod();
            if (this.altCtorDrops > 0) {
                ctorTypes = this.ctorTypes();
                Type[] altCtorTypes = new Type[ctorTypes.length - this.altCtorDrops];
                for (int i3 = 0; i3 < altCtorTypes.length; ++i3) {
                    altCtorTypes[i3] = ctorTypes[i3];
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, altCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.loadArgs();
                for (int i4 = 0; i4 < this.altCtorDrops; ++i4) {
                    ctorgen.visitInsn(1);
                }
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
            }
            if (this.supportsMeta()) {
                ctorTypes = this.ctorTypes();
                Type[] noMetaCtorTypes = new Type[ctorTypes.length - 1];
                for (int i5 = 1; i5 < ctorTypes.length; ++i5) {
                    noMetaCtorTypes[i5 - 1] = ctorTypes[i5];
                }
                alt = new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, noMetaCtorTypes);
                ctorgen = new GeneratorAdapter(1, alt, null, null, cv);
                ctorgen.visitCode();
                ctorgen.loadThis();
                ctorgen.visitInsn(1);
                ctorgen.loadArgs();
                ctorgen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                ctorgen.returnValue();
                ctorgen.endMethod();
                clojure.asm.commons.Method meth = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap meta()");
                GeneratorAdapter gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.loadThis();
                gen.getField(this.objtype, "__meta", IPERSISTENTMAP_TYPE);
                gen.returnValue();
                gen.endMethod();
                meth = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");
                gen = new GeneratorAdapter(1, meth, null, null, cv);
                gen.visitCode();
                gen.newInstance(this.objtype);
                gen.dup();
                gen.loadArg(0);
                ISeq s2 = RT.keys(this.closes);
                while (s2 != null) {
                    LocalBinding lb = (LocalBinding)s2.first();
                    gen.loadThis();
                    Class primc = lb.getPrimitiveType();
                    if (primc != null) {
                        gen.getField(this.objtype, lb.name, Type.getType(primc));
                    } else {
                        gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                    }
                    s2 = s2.next();
                    ++a;
                }
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, ctorTypes));
                gen.returnValue();
                gen.endMethod();
            }
            this.emitStatics(cv);
            this.emitMethods(cv);
            for (i = 0; i < this.constants.count(); ++i) {
                if (!this.usedConstants.contains(i)) continue;
                ((ClassVisitor)cv).visitField(25, this.constantName(i), this.constantType(i).getDescriptor(), null, null);
            }
            for (i = 0; i < this.keywordCallsites.count(); ++i) {
                ((ClassVisitor)cv).visitField(24, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE.getDescriptor(), null, null);
                ((ClassVisitor)cv).visitField(8, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE.getDescriptor(), null, null);
            }
            GeneratorAdapter clinitgen = new GeneratorAdapter(9, clojure.asm.commons.Method.getMethod("void <clinit> ()"), null, null, cv);
            clinitgen.visitCode();
            clinitgen.visitLineNumber(this.line, clinitgen.mark());
            if (this.constants.count() > 0) {
                this.emitConstants(clinitgen);
            }
            if (this.keywordCallsites.count() > 0) {
                this.emitKeywordCallsites(clinitgen);
            }
            if (this.isDeftype() && RT.booleanCast(RT.get(this.opts, loadNs)) && !(nsname = ((Symbol)RT.second(this.src)).getNamespace()).equals("clojure.core")) {
                clinitgen.push("clojure.core");
                clinitgen.push("require");
                clinitgen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
                clinitgen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("Object getRawRoot()"));
                clinitgen.checkCast(IFN_TYPE);
                clinitgen.push(nsname);
                clinitgen.invokeStatic(SYMBOL_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Symbol create(String)"));
                clinitgen.invokeInterface(IFN_TYPE, clojure.asm.commons.Method.getMethod("Object invoke(Object)"));
                clinitgen.pop();
            }
            clinitgen.returnValue();
            clinitgen.endMethod();
            ((ClassVisitor)cv).visitEnd();
            this.bytecode = cw.toByteArray();
            if (RT.booleanCast(COMPILE_FILES.deref())) {
                Compiler.writeClassFile(this.internalName, this.bytecode);
            }
        }

        private void emitKeywordCallsites(GeneratorAdapter clinitgen) {
            for (int i = 0; i < this.keywordCallsites.count(); ++i) {
                Keyword k = (Keyword)this.keywordCallsites.nth(i);
                clinitgen.newInstance(KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.dup();
                this.emitValue(k, clinitgen);
                clinitgen.invokeConstructor(KEYWORD_LOOKUPSITE_TYPE, clojure.asm.commons.Method.getMethod("void <init>(clojure.lang.Keyword)"));
                clinitgen.dup();
                clinitgen.putStatic(this.objtype, this.siteNameStatic(i), KEYWORD_LOOKUPSITE_TYPE);
                clinitgen.putStatic(this.objtype, this.thunkNameStatic(i), ILOOKUP_THUNK_TYPE);
            }
        }

        protected void emitStatics(ClassVisitor gen) {
        }

        protected void emitMethods(ClassVisitor gen) {
        }

        void emitListAsObjectArray(Object value, GeneratorAdapter gen) {
            gen.push(((List)value).size());
            gen.newArray(OBJECT_TYPE);
            int i = 0;
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                gen.dup();
                gen.push(i);
                this.emitValue(it.next(), gen);
                gen.arrayStore(OBJECT_TYPE);
                ++i;
            }
        }

        void emitValue(Object value, GeneratorAdapter gen) {
            boolean partial2 = true;
            if (value == null) {
                gen.visitInsn(1);
            } else if (value instanceof String) {
                gen.push((String)value);
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                } else {
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                }
            } else if (value instanceof Integer) {
                gen.push((Integer)value);
                gen.invokeStatic(Type.getType(Integer.class), clojure.asm.commons.Method.getMethod("Integer valueOf(int)"));
            } else if (value instanceof Long) {
                gen.push((Long)value);
                gen.invokeStatic(Type.getType(Long.class), clojure.asm.commons.Method.getMethod("Long valueOf(long)"));
            } else if (value instanceof Double) {
                gen.push((Double)value);
                gen.invokeStatic(Type.getType(Double.class), clojure.asm.commons.Method.getMethod("Double valueOf(double)"));
            } else if (value instanceof Character) {
                gen.push(((Character)value).charValue());
                gen.invokeStatic(Type.getType(Character.class), clojure.asm.commons.Method.getMethod("Character valueOf(char)"));
            } else if (value instanceof Class) {
                Class cc = (Class)value;
                if (cc.isPrimitive()) {
                    Type bt;
                    if (cc == Boolean.TYPE) {
                        bt = Type.getType(Boolean.class);
                    } else if (cc == Byte.TYPE) {
                        bt = Type.getType(Byte.class);
                    } else if (cc == Character.TYPE) {
                        bt = Type.getType(Character.class);
                    } else if (cc == Double.TYPE) {
                        bt = Type.getType(Double.class);
                    } else if (cc == Float.TYPE) {
                        bt = Type.getType(Float.class);
                    } else if (cc == Integer.TYPE) {
                        bt = Type.getType(Integer.class);
                    } else if (cc == Long.TYPE) {
                        bt = Type.getType(Long.class);
                    } else if (cc == Short.TYPE) {
                        bt = Type.getType(Short.class);
                    } else {
                        throw Util.runtimeException("Can't embed unknown primitive in code: " + value);
                    }
                    gen.getStatic(bt, "TYPE", Type.getType(Class.class));
                } else {
                    gen.push(Compiler.destubClassName(cc.getName()));
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("Class classForName(String)"));
                }
            } else if (value instanceof Symbol) {
                gen.push(((Symbol)value).ns);
                gen.push(((Symbol)value).name);
                gen.invokeStatic(Type.getType(Symbol.class), clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String,String)"));
            } else if (value instanceof Keyword) {
                gen.push(((Keyword)value).sym.ns);
                gen.push(((Keyword)value).sym.name);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Keyword keyword(String,String)"));
            } else if (value instanceof Var) {
                Var var = (Var)value;
                gen.push(var.ns.name.toString());
                gen.push(var.sym.toString());
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.Var var(String,String)"));
            } else if (value instanceof IType) {
                clojure.asm.commons.Method ctor = new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(value.getClass().getConstructors()[0]));
                gen.newInstance(Type.getType(value.getClass()));
                gen.dup();
                IPersistentVector fields = (IPersistentVector)Reflector.invokeStaticMethod(value.getClass(), "getBasis", new Object[0]);
                for (ISeq s = RT.seq(fields); s != null; s = s.next()) {
                    Symbol field = (Symbol)s.first();
                    Class k = Compiler.tagClass(Compiler.tagOf(field));
                    Object val2 = Reflector.getInstanceField(value, Compiler.munge(field.name));
                    this.emitValue(val2, gen);
                    if (!k.isPrimitive()) continue;
                    Type b = Type.getType(Compiler.boxClass(k));
                    String p = Type.getType(k).getDescriptor();
                    String n = k.getName();
                    gen.invokeVirtual(b, new clojure.asm.commons.Method(n + "Value", "()" + p));
                }
                gen.invokeConstructor(Type.getType(value.getClass()), ctor);
            } else if (value instanceof IRecord) {
                clojure.asm.commons.Method createMethod = clojure.asm.commons.Method.getMethod(value.getClass().getName() + " create(clojure.lang.IPersistentMap)");
                this.emitValue(PersistentArrayMap.create((Map)value), gen);
                gen.invokeStatic(Compiler.getType(value.getClass()), createMethod);
            } else if (value instanceof IPersistentMap) {
                ArrayList<Object> entries = new ArrayList<Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    entries.add(entry.getKey());
                    entries.add(entry.getValue());
                }
                this.emitListAsObjectArray(entries, gen);
                gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])"));
            } else if (value instanceof IPersistentVector) {
                IPersistentVector args = (IPersistentVector)value;
                if (args.count() <= 6) {
                    for (int i = 0; i < args.count(); ++i) {
                        this.emitValue(args.nth(i), gen);
                    }
                    gen.invokeStatic(TUPLE_TYPE, createTupleMethods[args.count()]);
                } else {
                    this.emitListAsObjectArray(value, gen);
                    gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])"));
                }
            } else if (value instanceof PersistentHashSet) {
                ISeq vs = RT.seq(value);
                if (vs == null) {
                    gen.getStatic(Type.getType(PersistentHashSet.class), "EMPTY", Type.getType(PersistentHashSet.class));
                } else {
                    this.emitListAsObjectArray(vs, gen);
                    gen.invokeStatic(Type.getType(PersistentHashSet.class), clojure.asm.commons.Method.getMethod("clojure.lang.PersistentHashSet create(Object[])"));
                }
            } else if (value instanceof ISeq || value instanceof IPersistentList) {
                this.emitListAsObjectArray(value, gen);
                gen.invokeStatic(Type.getType(Arrays.class), clojure.asm.commons.Method.getMethod("java.util.List asList(Object[])"));
                gen.invokeStatic(Type.getType(PersistentList.class), clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentList create(java.util.List)"));
            } else if (value instanceof Pattern) {
                this.emitValue(value.toString(), gen);
                gen.invokeStatic(Type.getType(Pattern.class), clojure.asm.commons.Method.getMethod("java.util.regex.Pattern compile(String)"));
            } else {
                String cs = null;
                try {
                    cs = RT.printString(value);
                }
                catch (Exception e2) {
                    throw Util.runtimeException("Can't embed object in code, maybe print-dup not defined: " + value);
                }
                if (cs.length() == 0) {
                    throw Util.runtimeException("Can't embed unreadable object in code: " + value);
                }
                if (cs.startsWith("#<")) {
                    throw Util.runtimeException("Can't embed unreadable object in code: " + cs);
                }
                gen.push(cs);
                gen.invokeStatic(RT_TYPE, readStringMethod);
                partial2 = false;
            }
            if (partial2 && value instanceof IObj && RT.count(((IObj)value).meta()) > 0) {
                gen.checkCast(IOBJ_TYPE);
                IPersistentMap m = ((IObj)value).meta();
                this.emitValue(Compiler.elideMeta(m), gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeInterface(IOBJ_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitConstants(GeneratorAdapter clinitgen) {
            try {
                Var.pushThreadBindings(RT.map(RT.PRINT_DUP, RT.T));
                for (int i = 0; i < this.constants.count(); ++i) {
                    if (!this.usedConstants.contains(i)) continue;
                    this.emitValue(this.constants.nth(i), clinitgen);
                    clinitgen.checkCast(this.constantType(i));
                    clinitgen.putStatic(this.objtype, this.constantName(i), this.constantType(i));
                }
            }
            finally {
                Var.popThreadBindings();
            }
        }

        boolean isMutable(LocalBinding lb) {
            return this.isVolatile(lb) || RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("unsynchronized-mutable")));
        }

        boolean isVolatile(LocalBinding lb) {
            return RT.booleanCast(RT.contains(this.fields, lb.sym)) && RT.booleanCast(RT.get(lb.sym.meta(), Keyword.intern("volatile-mutable")));
        }

        boolean isDeftype() {
            return this.fields != null;
        }

        boolean supportsMeta() {
            return !this.isDeftype();
        }

        void emitClearCloses(GeneratorAdapter gen) {
        }

        synchronized Class getCompiledClass() {
            if (this.compiledClass == null) {
                this.loader = (DynamicClassLoader)LOADER.deref();
                this.compiledClass = this.loader.defineClass(this.name, this.bytecode, this.src);
            }
            return this.compiledClass;
        }

        @Override
        public Object eval() {
            if (this.isDeftype()) {
                return null;
            }
            try {
                return this.getCompiledClass().newInstance();
            }
            catch (Exception e2) {
                throw Util.sneakyThrow(e2);
            }
        }

        public void emitLetFnInits(GeneratorAdapter gen, ObjExpr objx, IPersistentSet letFnLocals) {
            gen.checkCast(this.objtype);
            for (ISeq s = RT.keys(this.closes); s != null; s = s.next()) {
                LocalBinding lb = (LocalBinding)s.first();
                if (!letFnLocals.contains(lb)) continue;
                Class primc = lb.getPrimitiveType();
                gen.dup();
                if (primc != null) {
                    objx.emitUnboxedLocal(gen, lb);
                    gen.putField(this.objtype, lb.name, Type.getType(primc));
                    continue;
                }
                objx.emitLocal(gen, lb, false);
                gen.putField(this.objtype, lb.name, OBJECT_TYPE);
            }
            gen.pop();
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.isDeftype()) {
                gen.visitInsn(1);
            } else {
                gen.newInstance(this.objtype);
                gen.dup();
                if (this.supportsMeta()) {
                    gen.visitInsn(1);
                }
                for (ISeq s = RT.seq(this.closesExprs); s != null; s = s.next()) {
                    LocalBindingExpr lbe = (LocalBindingExpr)s.first();
                    LocalBinding lb = lbe.b;
                    if (lb.getPrimitiveType() != null) {
                        objx.emitUnboxedLocal(gen, lb);
                        continue;
                    }
                    objx.emitLocal(gen, lb, lbe.shouldClear);
                }
                gen.invokeConstructor(this.objtype, new clojure.asm.commons.Method("<init>", Type.VOID_TYPE, this.ctorTypes()));
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.compiledClass != null ? this.compiledClass : (this.tag != null ? HostExpr.tagToClass(this.tag) : IFn.class);
        }

        public void emitAssignLocal(GeneratorAdapter gen, LocalBinding lb, Expr val2) {
            if (!this.isMutable(lb)) {
                throw new IllegalArgumentException("Cannot assign to non-mutable: " + lb.name);
            }
            Class primc = lb.getPrimitiveType();
            gen.loadThis();
            if (primc != null) {
                if (!(val2 instanceof MaybePrimitiveExpr) || !((MaybePrimitiveExpr)val2).canEmitPrimitive()) {
                    throw new IllegalArgumentException("Must assign primitive to primitive mutable: " + lb.name);
                }
                MaybePrimitiveExpr me = (MaybePrimitiveExpr)val2;
                me.emitUnboxed(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, Type.getType(primc));
            } else {
                val2.emit(C.EXPRESSION, this, gen);
                gen.putField(this.objtype, lb.name, OBJECT_TYPE);
            }
        }

        private void emitLocal(GeneratorAdapter gen, LocalBinding lb, boolean clear2) {
            if (this.closes.containsKey(lb)) {
                Class primc = lb.getPrimitiveType();
                gen.loadThis();
                if (primc != null) {
                    gen.getField(this.objtype, lb.name, Type.getType(primc));
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.getField(this.objtype, lb.name, OBJECT_TYPE);
                    if (this.onceOnly && clear2 && lb.canBeCleared) {
                        gen.loadThis();
                        gen.visitInsn(1);
                        gen.putField(this.objtype, lb.name, OBJECT_TYPE);
                    }
                }
            } else {
                int argoff = this.canBeDirect ? 0 : 1;
                Class primc = lb.getPrimitiveType();
                if (lb.isArg) {
                    gen.loadArg(lb.idx - argoff);
                    if (primc != null) {
                        HostExpr.emitBoxReturn(this, gen, primc);
                    } else if (clear2 && lb.canBeCleared) {
                        gen.visitInsn(1);
                        gen.storeArg(lb.idx - argoff);
                    }
                } else if (primc != null) {
                    gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
                    HostExpr.emitBoxReturn(this, gen, primc);
                } else {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), lb.idx);
                    if (clear2 && lb.canBeCleared) {
                        gen.visitInsn(1);
                        gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), lb.idx);
                    }
                }
            }
        }

        private void emitUnboxedLocal(GeneratorAdapter gen, LocalBinding lb) {
            int argoff = this.canBeDirect ? 0 : 1;
            Class primc = lb.getPrimitiveType();
            if (this.closes.containsKey(lb)) {
                gen.loadThis();
                gen.getField(this.objtype, lb.name, Type.getType(primc));
            } else if (lb.isArg) {
                gen.loadArg(lb.idx - argoff);
            } else {
                gen.visitVarInsn(Type.getType(primc).getOpcode(21), lb.idx);
            }
        }

        public void emitVar(GeneratorAdapter gen, Var var) {
            Integer i = (Integer)this.vars.valAt(var);
            this.emitConstant(gen, i);
        }

        public void emitVarValue(GeneratorAdapter gen, Var v) {
            Integer i = (Integer)this.vars.valAt(v);
            if (!v.isDynamic()) {
                this.emitConstant(gen, i);
                gen.invokeVirtual(VAR_TYPE, varGetRawMethod);
            } else {
                this.emitConstant(gen, i);
                gen.invokeVirtual(VAR_TYPE, varGetMethod);
            }
        }

        public void emitKeyword(GeneratorAdapter gen, Keyword k) {
            Integer i = (Integer)this.keywords.valAt(k);
            this.emitConstant(gen, i);
        }

        public void emitConstant(GeneratorAdapter gen, int id) {
            this.usedConstants = (IPersistentSet)this.usedConstants.cons(id);
            gen.getStatic(this.objtype, this.constantName(id), this.constantType(id));
        }

        String constantName(int id) {
            return CONST_PREFIX + id;
        }

        String siteName(int n) {
            return "__site__" + n;
        }

        String siteNameStatic(int n) {
            return this.siteName(n) + "__";
        }

        String thunkName(int n) {
            return "__thunk__" + n;
        }

        String cachedClassName(int n) {
            return "__cached_class__" + n;
        }

        String cachedVarName(int n) {
            return "__cached_var__" + n;
        }

        String varCallsiteName(int n) {
            return "__var__callsite__" + n;
        }

        String thunkNameStatic(int n) {
            return this.thunkName(n) + "__";
        }

        Type constantType(int id) {
            Object o = this.constants.nth(id);
            Class c = Util.classOf(o);
            if (c != null && Modifier.isPublic(c.getModifiers())) {
                if (LazySeq.class.isAssignableFrom(c)) {
                    return Type.getType(ISeq.class);
                }
                if (c == Keyword.class) {
                    return Type.getType(Keyword.class);
                }
                if (RestFn.class.isAssignableFrom(c)) {
                    return Type.getType(RestFn.class);
                }
                if (AFn.class.isAssignableFrom(c)) {
                    return Type.getType(AFn.class);
                }
                if (c == Var.class) {
                    return Type.getType(Var.class);
                }
                if (c == String.class) {
                    return Type.getType(String.class);
                }
            }
            return OBJECT_TYPE;
        }
    }

    public static class FnExpr
    extends ObjExpr {
        static final Type aFnType = Type.getType(AFunction.class);
        static final Type restFnType = Type.getType(RestFn.class);
        FnMethod variadicMethod = null;
        IPersistentCollection methods;
        private boolean hasPrimSigs;
        private boolean hasMeta;
        private boolean hasEnclosingMethod;

        public FnExpr(Object tag) {
            super(tag);
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        boolean supportsMeta() {
            return this.hasMeta;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : AFunction.class;
        }

        @Override
        protected void emitMethods(ClassVisitor cv) {
            for (ISeq s = RT.seq(this.methods); s != null; s = s.next()) {
                ObjMethod method = (ObjMethod)s.first();
                method.emit(this, cv);
            }
            if (this.isVariadic()) {
                GeneratorAdapter gen = new GeneratorAdapter(1, clojure.asm.commons.Method.getMethod("int getRequiredArity()"), null, null, cv);
                gen.visitCode();
                gen.push(this.variadicMethod.reqParms.count());
                gen.returnValue();
                gen.endMethod();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Expr parse(C context, ISeq form, String name2) {
            ISeq origForm = form;
            FnExpr fn2 = new FnExpr(Compiler.tagOf(form));
            Keyword retkey = Keyword.intern(null, "rettag");
            Object rettag = RT.get(RT.meta(form), retkey);
            fn2.src = form;
            ObjMethod enclosingMethod = (ObjMethod)METHOD.deref();
            boolean bl = fn2.hasEnclosingMethod = enclosingMethod != null;
            if (((IMeta)form.first()).meta() != null) {
                fn2.onceOnly = RT.booleanCast(RT.get(RT.meta(form.first()), Keyword.intern(null, "once")));
            }
            String basename = (enclosingMethod != null ? enclosingMethod.objx.name : Compiler.munge(Compiler.currentNS().name.name)) + "$";
            Symbol nm = null;
            if (RT.second(form) instanceof Symbol) {
                nm = (Symbol)RT.second(form);
                name2 = nm.name + "__" + RT.nextID();
            } else if (name2 == null) {
                name2 = "fn__" + RT.nextID();
            } else if (enclosingMethod != null) {
                name2 = name2 + "__" + RT.nextID();
            }
            String simpleName = Compiler.munge(name2).replace(".", "_DOT_");
            fn2.name = basename + simpleName;
            fn2.internalName = fn2.name.replace('.', '/');
            fn2.objtype = Type.getObjectType(fn2.internalName);
            ArrayList<String> prims = new ArrayList<String>();
            try {
                Var.pushThreadBindings(RT.mapUniqueKeys(CONSTANTS, PersistentVector.EMPTY, CONSTANT_IDS, new IdentityHashMap(), KEYWORDS, PersistentHashMap.EMPTY, VARS, PersistentHashMap.EMPTY, KEYWORD_CALLSITES, PersistentVector.EMPTY, PROTOCOL_CALLSITES, PersistentVector.EMPTY, VAR_CALLSITES, Compiler.emptyVarCallSites(), NO_RECUR, null));
                if (nm != null) {
                    fn2.thisName = nm.name;
                    form = RT.cons(FN, RT.next(RT.next(form)));
                }
                if (RT.second(form) instanceof IPersistentVector) {
                    form = RT.list(FN, RT.next(form));
                }
                fn2.line = Compiler.lineDeref();
                fn2.column = Compiler.columnDeref();
                FnMethod[] methodArray = new FnMethod[21];
                FnMethod variadicMethod = null;
                boolean usesThis = false;
                ISeq s = RT.next(form);
                while (s != null) {
                    FnMethod f = FnMethod.parse(fn2, (ISeq)RT.first(s), rettag);
                    if (f.usesThis) {
                        usesThis = true;
                    }
                    if (f.isVariadic()) {
                        if (variadicMethod != null) throw Util.runtimeException("Can't have more than 1 variadic overload");
                        variadicMethod = f;
                    } else {
                        if (methodArray[f.reqParms.count()] != null) throw Util.runtimeException("Can't have 2 overloads with same arity");
                        methodArray[f.reqParms.count()] = f;
                    }
                    if (f.prim != null) {
                        prims.add(f.prim);
                    }
                    s = RT.next(s);
                }
                if (variadicMethod != null) {
                    for (int i = variadicMethod.reqParms.count() + 1; i <= 20; ++i) {
                        if (methodArray[i] == null) continue;
                        throw Util.runtimeException("Can't have fixed arity function with more params than variadic function");
                    }
                }
                fn2.canBeDirect = !fn2.hasEnclosingMethod && fn2.closes.count() == 0 && !usesThis;
                IPersistentCollection methods2 = null;
                for (int i = 0; i < methodArray.length; ++i) {
                    if (methodArray[i] == null) continue;
                    methods2 = RT.conj(methods2, methodArray[i]);
                }
                if (variadicMethod != null) {
                    methods2 = RT.conj(methods2, variadicMethod);
                }
                if (fn2.canBeDirect) {
                    for (FnMethod fm : (Collection)((Object)methods2)) {
                        if (fm.locals == null) continue;
                        for (LocalBinding lb : (Collection)((Object)RT.keys(fm.locals))) {
                            if (!lb.isArg) continue;
                            --lb.idx;
                        }
                    }
                }
                fn2.methods = methods2;
                fn2.variadicMethod = variadicMethod;
                fn2.keywords = (IPersistentMap)KEYWORDS.deref();
                fn2.vars = (IPersistentMap)VARS.deref();
                fn2.constants = (PersistentVector)CONSTANTS.deref();
                fn2.keywordCallsites = (IPersistentVector)KEYWORD_CALLSITES.deref();
                fn2.protocolCallsites = (IPersistentVector)PROTOCOL_CALLSITES.deref();
                fn2.varCallsites = (IPersistentSet)VAR_CALLSITES.deref();
                fn2.constantsID = RT.nextID();
            }
            finally {
                Var.popThreadBindings();
            }
            fn2.hasPrimSigs = prims.size() > 0;
            IPersistentMap fmeta = RT.meta(origForm);
            if (fmeta != null) {
                fmeta = fmeta.without(RT.LINE_KEY).without(RT.COLUMN_KEY).without(RT.FILE_KEY).without(retkey);
            }
            fn2.hasMeta = RT.count(fmeta) > 0;
            try {
                fn2.compile(fn2.isVariadic() ? "clojure/lang/RestFn" : "clojure/lang/AFunction", prims.size() == 0 ? null : prims.toArray(new String[prims.size()]), fn2.onceOnly);
            }
            catch (IOException e2) {
                throw Util.sneakyThrow(e2);
            }
            fn2.getCompiledClass();
            if (!fn2.supportsMeta()) return fn2;
            return new MetaExpr(fn2, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, fmeta));
        }

        public final ObjMethod variadicMethod() {
            return this.variadicMethod;
        }

        boolean isVariadic() {
            return this.variadicMethod != null;
        }

        public final IPersistentCollection methods() {
            return this.methods;
        }

        public void emitForDefn(ObjExpr objx, GeneratorAdapter gen) {
            this.emit(C.EXPRESSION, objx, gen);
        }
    }

    static class SourceDebugExtensionAttribute
    extends Attribute {
        public SourceDebugExtensionAttribute() {
            super("SourceDebugExtension");
        }

        void writeSMAP(ClassWriter cw, String smap) {
            ByteVector bv = this.write(cw, null, -1, -1, -1);
            bv.putUTF8(smap);
        }
    }

    static class InvokeExpr
    implements Expr {
        public final Expr fexpr;
        public final Object tag;
        public final IPersistentVector args;
        public final int line;
        public final int column;
        public final String source;
        public boolean isProtocol = false;
        public boolean isDirect = false;
        public int siteIndex = -1;
        public Class protocolOn;
        public Method onMethod;
        static Keyword onKey = Keyword.intern("on");
        static Keyword methodMapKey = Keyword.intern("method-map");

        static Object sigTag(int argcount, Var v) {
            Object arglists = RT.get(RT.meta(v), arglistsKey);
            Object sigTag = null;
            for (ISeq s = RT.seq(arglists); s != null; s = s.next()) {
                APersistentVector sig = (APersistentVector)s.first();
                int restOffset = sig.indexOf(_AMP_);
                if (argcount != sig.count() && (restOffset <= -1 || argcount < restOffset)) continue;
                return Compiler.tagOf(sig);
            }
            return null;
        }

        public InvokeExpr(String source2, int line, int column, Symbol tag, Expr fexpr, IPersistentVector args) {
            Var fvar;
            Var pvar;
            this.source = source2;
            this.fexpr = fexpr;
            this.args = args;
            this.line = line;
            this.column = column;
            if (fexpr instanceof VarExpr && (pvar = (Var)RT.get((fvar = ((VarExpr)fexpr).var).meta(), protocolKey)) != null && PROTOCOL_CALLSITES.isBound()) {
                this.isProtocol = true;
                this.siteIndex = Compiler.registerProtocolCallsite(((VarExpr)fexpr).var);
                Object pon = RT.get(pvar.get(), onKey);
                this.protocolOn = HostExpr.maybeClass(pon, false);
                if (this.protocolOn != null) {
                    IPersistentMap mmap = (IPersistentMap)RT.get(pvar.get(), methodMapKey);
                    Keyword mmapVal = (Keyword)mmap.valAt(Keyword.intern(fvar.sym));
                    if (mmapVal == null) {
                        throw new IllegalArgumentException("No method of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym + " (The protocol method may have been defined before and removed.)");
                    }
                    String mname = Compiler.munge(mmapVal.sym.toString());
                    List methods2 = Reflector.getMethods(this.protocolOn, args.count() - 1, mname, false);
                    if (methods2.size() != 1) {
                        throw new IllegalArgumentException("No single method: " + mname + " of interface: " + this.protocolOn.getName() + " found for function: " + fvar.sym + " of protocol: " + pvar.sym);
                    }
                    this.onMethod = (Method)methods2.get(0);
                }
            }
            if (tag != null) {
                this.tag = tag;
            } else if (fexpr instanceof VarExpr) {
                Var v = ((VarExpr)fexpr).var;
                Object arglists = RT.get(RT.meta(v), arglistsKey);
                Object sigTag = InvokeExpr.sigTag(args.count(), v);
                this.tag = sigTag == null ? ((VarExpr)fexpr).tag : sigTag;
            } else {
                this.tag = null;
            }
        }

        @Override
        public Object eval() {
            try {
                IFn fn2 = (IFn)this.fexpr.eval();
                PersistentVector argvs = PersistentVector.EMPTY;
                for (int i = 0; i < this.args.count(); ++i) {
                    argvs = argvs.cons(((Expr)this.args.nth(i)).eval());
                }
                PersistentVector persistentVector = argvs;
                argvs = null;
                return fn2.applyTo(RT.seq(Util.ret1(persistentVector, null)));
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e2);
                }
                throw (CompilerException)e2;
            }
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.isProtocol) {
                gen.visitLineNumber(this.line, gen.mark());
                this.emitProto(context, objx, gen);
            } else {
                this.fexpr.emit(C.EXPRESSION, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                gen.checkCast(IFN_TYPE);
                this.emitArgsAndCall(0, context, objx, gen);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        public void emitProto(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label onLabel = gen.newLabel();
            Label callLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            Var v = ((VarExpr)this.fexpr).var;
            Expr e2 = (Expr)this.args.nth(0);
            e2.emit(C.EXPRESSION, objx, gen);
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.getStatic(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            gen.visitJumpInsn(165, callLabel);
            if (this.protocolOn != null) {
                gen.dup();
                gen.instanceOf(Type.getType(this.protocolOn));
                gen.ifZCmp(154, onLabel);
            }
            gen.dup();
            gen.invokeStatic(UTIL_TYPE, clojure.asm.commons.Method.getMethod("Class classOf(Object)"));
            gen.putStatic(objx.objtype, objx.cachedClassName(this.siteIndex), CLASS_TYPE);
            gen.mark(callLabel);
            objx.emitVar(gen, v);
            gen.invokeVirtual(VAR_TYPE, clojure.asm.commons.Method.getMethod("Object getRawRoot()"));
            gen.swap();
            this.emitArgsAndCall(1, context, objx, gen);
            gen.goTo(endLabel);
            gen.mark(onLabel);
            if (this.protocolOn != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.onMethod.getParameterTypes(), RT.subvec(this.args, 1, this.args.count()));
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.onMethod.getName(), Type.getReturnType(this.onMethod), Type.getArgumentTypes(this.onMethod));
                gen.invokeInterface(Type.getType(this.protocolOn), m);
                HostExpr.emitBoxReturn(objx, gen, this.onMethod.getReturnType());
            }
            gen.mark(endLabel);
        }

        void emitArgsAndCall(int firstArgToEmit, C context, ObjExpr objx, GeneratorAdapter gen) {
            for (int i = firstArgToEmit; i < Math.min(20, this.args.count()); ++i) {
                Expr e2 = (Expr)this.args.nth(i);
                e2.emit(C.EXPRESSION, objx, gen);
            }
            if (this.args.count() > 20) {
                PersistentVector restArgs = PersistentVector.EMPTY;
                for (int i = 20; i < this.args.count(); ++i) {
                    restArgs = restArgs.cons(this.args.nth(i));
                }
                MethodExpr.emitArgsAsArray(restArgs, objx, gen);
            }
            gen.visitLineNumber(this.line, gen.mark());
            if (context == C.RETURN) {
                ObjMethod method = (ObjMethod)METHOD.deref();
                method.emitClearLocals(gen);
            }
            gen.invokeInterface(IFN_TYPE, new clojure.asm.commons.Method("invoke", OBJECT_TYPE, ARG_TYPES[Math.min(21, this.args.count())]));
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }

        public static Expr parse(C context, ISeq form) {
            Var v;
            Object val2;
            Expr sexpr;
            Expr fexpr;
            if (context != C.EVAL) {
                context = C.EXPRESSION;
            }
            if ((fexpr = Compiler.analyze(context, form.first())) instanceof VarExpr && ((VarExpr)fexpr).var.equals(INSTANCE) && RT.count(form) == 3 && (sexpr = Compiler.analyze(C.EXPRESSION, RT.second(form))) instanceof ConstantExpr && (val2 = ((ConstantExpr)sexpr).val()) instanceof Class) {
                return new InstanceOfExpr((Class)val2, Compiler.analyze(context, RT.third(form)));
            }
            if (RT.booleanCast(Compiler.getCompilerOption(directLinkingKey)) && fexpr instanceof VarExpr && context != C.EVAL && !(v = ((VarExpr)fexpr).var).isDynamic() && !RT.booleanCast(RT.get(v.meta(), redefKey, false))) {
                Symbol formtag = Compiler.tagOf(form);
                Object arglists = RT.get(RT.meta(v), arglistsKey);
                int arity = RT.count(form.next());
                Object sigtag = InvokeExpr.sigTag(arity, v);
                Object vtag = RT.get(RT.meta(v), RT.TAG_KEY);
                Expr ret = StaticInvokeExpr.parse(v, RT.next(form), formtag != null ? formtag : (sigtag != null ? sigtag : vtag));
                if (ret != null) {
                    return ret;
                }
            }
            if (fexpr instanceof VarExpr && context != C.EVAL) {
                v = ((VarExpr)fexpr).var;
                Object arglists = RT.get(RT.meta(v), arglistsKey);
                int arity = RT.count(form.next());
                for (ISeq s = RT.seq(arglists); s != null; s = s.next()) {
                    IPersistentVector args = (IPersistentVector)s.first();
                    if (args.count() != arity) continue;
                    String primc = FnMethod.primInterface(args);
                    if (primc == null) break;
                    return Compiler.analyze(context, ((IObj)((Object)RT.listStar(Symbol.intern(".invokePrim"), ((Symbol)form.first()).withMeta(RT.map(RT.TAG_KEY, Symbol.intern(primc))), form.next()))).withMeta((IPersistentMap)RT.conj(RT.meta(v), RT.meta(form))));
                }
            }
            if (fexpr instanceof KeywordExpr && RT.count(form) == 2 && KEYWORD_CALLSITES.isBound()) {
                Expr target = Compiler.analyze(context, RT.second(form));
                return new KeywordInvokeExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), Compiler.tagOf(form), (KeywordExpr)fexpr, target);
            }
            PersistentVector args = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(form.next()); s != null; s = s.next()) {
                args = args.cons(Compiler.analyze(context, s.first()));
            }
            return new InvokeExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), Compiler.tagOf(form), fexpr, args);
        }
    }

    static class StaticInvokeExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final Type target;
        public final Class retClass;
        public final Class[] paramclasses;
        public final Type[] paramtypes;
        public final IPersistentVector args;
        public final boolean variadic;
        public final Object tag;

        StaticInvokeExpr(Type target, Class retClass, Class[] paramclasses, Type[] paramtypes, boolean variadic, IPersistentVector args, Object tag) {
            this.target = target;
            this.retClass = retClass;
            this.paramclasses = paramclasses;
            this.paramtypes = paramtypes;
            this.args = args;
            this.variadic = variadic;
            this.tag = tag;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval StaticInvokeExpr");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.emitUnboxed(context, objx, gen);
            if (context != C.STATEMENT) {
                HostExpr.emitBoxReturn(objx, gen, this.retClass);
            }
            if (context == C.STATEMENT) {
                if (this.retClass == Long.TYPE || this.retClass == Double.TYPE) {
                    gen.pop2();
                } else {
                    gen.pop();
                }
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Compiler.retType(this.tag != null ? HostExpr.tagToClass(this.tag) : null, this.retClass);
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.retClass.isPrimitive();
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            clojure.asm.commons.Method ms = new clojure.asm.commons.Method("invokeStatic", this.getReturnType(), this.paramtypes);
            if (this.variadic) {
                for (int i = 0; i < this.paramclasses.length - 1; ++i) {
                    Expr e2 = (Expr)this.args.nth(i);
                    if (Compiler.maybePrimitiveType(e2) == this.paramclasses[i]) {
                        ((MaybePrimitiveExpr)e2).emitUnboxed(C.EXPRESSION, objx, gen);
                        continue;
                    }
                    e2.emit(C.EXPRESSION, objx, gen);
                    HostExpr.emitUnboxArg(objx, gen, this.paramclasses[i]);
                }
                IPersistentVector restArgs = RT.subvec(this.args, this.paramclasses.length - 1, this.args.count());
                MethodExpr.emitArgsAsArray(restArgs, objx, gen);
                gen.invokeStatic(Type.getType(ArraySeq.class), clojure.asm.commons.Method.getMethod("clojure.lang.ArraySeq create(Object[])"));
            } else {
                MethodExpr.emitTypedArgs(objx, gen, this.paramclasses, this.args);
            }
            gen.invokeStatic(this.target, ms);
        }

        private Type getReturnType() {
            return Type.getType(this.retClass);
        }

        public static Expr parse(Var v, ISeq args, Object tag) {
            if (!v.isBound() || v.get() == null) {
                return null;
            }
            Class<?> c = v.get().getClass();
            String cname = c.getName();
            Method[] allmethods = c.getMethods();
            boolean variadic = false;
            int argcount = RT.count(args);
            Method method = null;
            for (Method m : allmethods) {
                if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals("invokeStatic")) continue;
                Class<?>[] params = m.getParameterTypes();
                if (argcount == params.length) {
                    method = m;
                    variadic = argcount > 0 && params[params.length - 1] == ISeq.class;
                    break;
                }
                if (argcount <= params.length || params.length <= 0 || params[params.length - 1] != ISeq.class) continue;
                method = m;
                variadic = true;
                break;
            }
            if (method == null) {
                return null;
            }
            Class<?> retClass = method.getReturnType();
            Class[] paramClasses = method.getParameterTypes();
            Type[] paramTypes = new Type[paramClasses.length];
            for (int i = 0; i < paramClasses.length; ++i) {
                paramTypes[i] = Type.getType(paramClasses[i]);
            }
            Type target = Type.getType(c);
            PersistentVector argv = PersistentVector.EMPTY;
            for (ISeq s = RT.seq(args); s != null; s = s.next()) {
                argv = argv.cons(Compiler.analyze(C.EXPRESSION, s.first()));
            }
            return new StaticInvokeExpr(target, retClass, paramClasses, paramTypes, variadic, argv, tag);
        }
    }

    public static class InstanceOfExpr
    implements Expr,
    MaybePrimitiveExpr {
        Expr expr;
        Class c;

        public InstanceOfExpr(Class c, Expr expr) {
            this.expr = expr;
            this.c = c;
        }

        @Override
        public Object eval() {
            if (this.c.isInstance(this.expr.eval())) {
                return RT.T;
            }
            return RT.F;
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.instanceOf(Compiler.getType(this.c));
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.emitUnboxed(context, objx, gen);
            HostExpr.emitBoxReturn(objx, gen, Boolean.TYPE);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Boolean.TYPE;
        }
    }

    static class KeywordInvokeExpr
    implements Expr {
        public final KeywordExpr kw;
        public final Object tag;
        public final Expr target;
        public final int line;
        public final int column;
        public final int siteIndex;
        public final String source;
        static Type ILOOKUP_TYPE = Type.getType(ILookup.class);

        public KeywordInvokeExpr(String source2, int line, int column, Symbol tag, KeywordExpr kw, Expr target) {
            this.source = source2;
            this.kw = kw;
            this.target = target;
            this.line = line;
            this.column = column;
            this.tag = tag;
            this.siteIndex = Compiler.registerKeywordCallsite(kw.k);
        }

        @Override
        public Object eval() {
            try {
                return this.kw.k.invoke(this.target.eval());
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e2);
                }
                throw (CompilerException)e2;
            }
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            Label endLabel = gen.newLabel();
            Label faultLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.dup();
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.visitLineNumber(this.line, gen.mark());
            gen.dupX2();
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object)"));
            gen.dupX2();
            gen.visitJumpInsn(165, faultLabel);
            gen.pop();
            gen.goTo(endLabel);
            gen.mark(faultLabel);
            gen.swap();
            gen.pop();
            gen.dup();
            gen.getStatic(objx.objtype, objx.siteNameStatic(this.siteIndex), ObjExpr.KEYWORD_LOOKUPSITE_TYPE);
            gen.swap();
            gen.invokeInterface(ObjExpr.ILOOKUP_SITE_TYPE, clojure.asm.commons.Method.getMethod("clojure.lang.ILookupThunk fault(Object)"));
            gen.dup();
            gen.putStatic(objx.objtype, objx.thunkNameStatic(this.siteIndex), ObjExpr.ILOOKUP_THUNK_TYPE);
            gen.swap();
            gen.invokeInterface(ObjExpr.ILOOKUP_THUNK_TYPE, clojure.asm.commons.Method.getMethod("Object get(Object)"));
            gen.mark(endLabel);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }
    }

    public static class VectorExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method vectorMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentVector vector(Object[])");

        public VectorExpr(IPersistentVector args) {
            this.args = args;
        }

        @Override
        public Object eval() {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.args.count() <= 6) {
                for (int i = 0; i < this.args.count(); ++i) {
                    ((Expr)this.args.nth(i)).emit(C.EXPRESSION, objx, gen);
                }
                gen.invokeStatic(TUPLE_TYPE, createTupleMethods[this.args.count()]);
            } else {
                MethodExpr.emitArgsAsArray(this.args, objx, gen);
                gen.invokeStatic(RT_TYPE, vectorMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentVector.class;
        }

        public static Expr parse(C context, IPersistentVector form) {
            boolean constant = true;
            IPersistentVector args = PersistentVector.EMPTY;
            for (int i = 0; i < form.count(); ++i) {
                Expr v = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, form.nth(i));
                args = args.cons(v);
                if (v instanceof LiteralExpr) continue;
                constant = false;
            }
            VectorExpr ret = new VectorExpr(args);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (constant) {
                IPersistentVector rv = PersistentVector.EMPTY;
                for (int i = 0; i < args.count(); ++i) {
                    LiteralExpr ve = (LiteralExpr)args.nth(i);
                    rv = rv.cons(ve.val());
                }
                return new ConstantExpr(rv);
            }
            return ret;
        }
    }

    public static class SetExpr
    implements Expr {
        public final IPersistentVector keys;
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentSet set(Object[])");

        public SetExpr(IPersistentVector keys2) {
            this.keys = keys2;
        }

        @Override
        public Object eval() {
            Object[] ret = new Object[this.keys.count()];
            for (int i = 0; i < this.keys.count(); ++i) {
                ret[i] = ((Expr)this.keys.nth(i)).eval();
            }
            return RT.set(ret);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.keys, objx, gen);
            gen.invokeStatic(RT_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentSet.class;
        }

        public static Expr parse(C context, IPersistentSet form) {
            IPersistentVector keys2 = PersistentVector.EMPTY;
            boolean constant = true;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                Object e2 = s.first();
                Expr expr = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2);
                keys2 = keys2.cons(expr);
                if (expr instanceof LiteralExpr) continue;
                constant = false;
            }
            SetExpr ret = new SetExpr(keys2);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (constant) {
                IPersistentSet set2 = PersistentHashSet.EMPTY;
                for (int i = 0; i < keys2.count(); ++i) {
                    LiteralExpr ve = (LiteralExpr)keys2.nth(i);
                    set2 = (IPersistentSet)set2.cons(ve.val());
                }
                return new ConstantExpr(set2);
            }
            return ret;
        }
    }

    public static class MapExpr
    implements Expr {
        public final IPersistentVector keyvals;
        static final clojure.asm.commons.Method mapMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap map(Object[])");
        static final clojure.asm.commons.Method mapUniqueKeysMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IPersistentMap mapUniqueKeys(Object[])");

        public MapExpr(IPersistentVector keyvals) {
            this.keyvals = keyvals;
        }

        @Override
        public Object eval() {
            Object[] ret = new Object[this.keyvals.count()];
            for (int i = 0; i < this.keyvals.count(); ++i) {
                ret[i] = ((Expr)this.keyvals.nth(i)).eval();
            }
            return RT.map(ret);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            boolean allKeysConstant = true;
            boolean allConstantKeysUnique = true;
            IPersistentSet constantKeys = PersistentHashSet.EMPTY;
            for (int i = 0; i < this.keyvals.count(); i += 2) {
                Expr k = (Expr)this.keyvals.nth(i);
                if (k instanceof LiteralExpr) {
                    Object kval = k.eval();
                    if (constantKeys.contains(kval)) {
                        allConstantKeysUnique = false;
                        continue;
                    }
                    constantKeys = (IPersistentSet)constantKeys.cons(kval);
                    continue;
                }
                allKeysConstant = false;
            }
            MethodExpr.emitArgsAsArray(this.keyvals, objx, gen);
            if (allKeysConstant && allConstantKeysUnique || this.keyvals.count() <= 2) {
                gen.invokeStatic(RT_TYPE, mapUniqueKeysMethod);
            } else {
                gen.invokeStatic(RT_TYPE, mapMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentMap.class;
        }

        public static Expr parse(C context, IPersistentMap form) {
            IPersistentVector keyvals = PersistentVector.EMPTY;
            boolean keysConstant = true;
            boolean valsConstant = true;
            boolean allConstantKeysUnique = true;
            IPersistentSet constantKeys = PersistentHashSet.EMPTY;
            for (ISeq s = RT.seq(form); s != null; s = s.next()) {
                IMapEntry e2 = (IMapEntry)s.first();
                Expr k = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2.key());
                Expr v = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, e2.val());
                keyvals = keyvals.cons(k);
                keyvals = keyvals.cons(v);
                if (k instanceof LiteralExpr) {
                    Object kval = k.eval();
                    if (constantKeys.contains(kval)) {
                        allConstantKeysUnique = false;
                    } else {
                        constantKeys = (IPersistentSet)constantKeys.cons(kval);
                    }
                } else {
                    keysConstant = false;
                }
                if (v instanceof LiteralExpr) continue;
                valsConstant = false;
            }
            MapExpr ret = new MapExpr(keyvals);
            if (form instanceof IObj && ((IObj)((Object)form)).meta() != null) {
                return new MetaExpr(ret, MapExpr.parse(context == C.EVAL ? context : C.EXPRESSION, ((IObj)((Object)form)).meta()));
            }
            if (keysConstant) {
                if (!allConstantKeysUnique) {
                    throw new IllegalArgumentException("Duplicate constant keys in map");
                }
                if (valsConstant) {
                    IPersistentMap m = PersistentArrayMap.EMPTY;
                    for (int i = 0; i < keyvals.length(); i += 2) {
                        m = m.assoc(((LiteralExpr)keyvals.nth(i)).val(), ((LiteralExpr)keyvals.nth(i + 1)).val());
                    }
                    return new ConstantExpr(m);
                }
                return ret;
            }
            return ret;
        }
    }

    public static class ListExpr
    implements Expr {
        public final IPersistentVector args;
        static final clojure.asm.commons.Method arrayToListMethod = clojure.asm.commons.Method.getMethod("clojure.lang.ISeq arrayToList(Object[])");

        public ListExpr(IPersistentVector args) {
            this.args = args;
        }

        @Override
        public Object eval() {
            IPersistentVector ret = PersistentVector.EMPTY;
            for (int i = 0; i < this.args.count(); ++i) {
                ret = ret.cons(((Expr)this.args.nth(i)).eval());
            }
            return ret.seq();
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            MethodExpr.emitArgsAsArray(this.args, objx, gen);
            gen.invokeStatic(RT_TYPE, arrayToListMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return IPersistentList.class;
        }
    }

    public static class EmptyExpr
    implements Expr {
        public final Object coll;
        static final Type HASHMAP_TYPE = Type.getType(PersistentArrayMap.class);
        static final Type HASHSET_TYPE = Type.getType(PersistentHashSet.class);
        static final Type VECTOR_TYPE = Type.getType(PersistentVector.class);
        static final Type IVECTOR_TYPE = Type.getType(IPersistentVector.class);
        static final Type TUPLE_TYPE = Type.getType(Tuple.class);
        static final Type LIST_TYPE = Type.getType(PersistentList.class);
        static final Type EMPTY_LIST_TYPE = Type.getType(PersistentList.EmptyList.class);

        public EmptyExpr(Object coll) {
            this.coll = coll;
        }

        @Override
        public Object eval() {
            return this.coll;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.coll instanceof IPersistentList) {
                gen.getStatic(LIST_TYPE, "EMPTY", EMPTY_LIST_TYPE);
            } else if (this.coll instanceof IPersistentVector) {
                gen.getStatic(VECTOR_TYPE, "EMPTY", VECTOR_TYPE);
            } else if (this.coll instanceof IPersistentMap) {
                gen.getStatic(HASHMAP_TYPE, "EMPTY", HASHMAP_TYPE);
            } else if (this.coll instanceof IPersistentSet) {
                gen.getStatic(HASHSET_TYPE, "EMPTY", HASHSET_TYPE);
            } else {
                throw new UnsupportedOperationException("Unknown Collection type");
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            if (this.coll instanceof IPersistentList) {
                return IPersistentList.class;
            }
            if (this.coll instanceof IPersistentVector) {
                return IPersistentVector.class;
            }
            if (this.coll instanceof IPersistentMap) {
                return IPersistentMap.class;
            }
            if (this.coll instanceof IPersistentSet) {
                return IPersistentSet.class;
            }
            throw new UnsupportedOperationException("Unknown Collection type");
        }
    }

    public static class IfExpr
    implements Expr,
    MaybePrimitiveExpr {
        public final Expr testExpr;
        public final Expr thenExpr;
        public final Expr elseExpr;
        public final int line;
        public final int column;

        public IfExpr(int line, int column, Expr testExpr, Expr thenExpr, Expr elseExpr) {
            this.testExpr = testExpr;
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.line = line;
            this.column = column;
        }

        @Override
        public Object eval() {
            Object t = this.testExpr.eval();
            if (t != null && t != Boolean.FALSE) {
                return this.thenExpr.eval();
            }
            return this.elseExpr.eval();
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, false);
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.doEmit(context, objx, gen, true);
        }

        public void doEmit(C context, ObjExpr objx, GeneratorAdapter gen, boolean emitUnboxed) {
            Label nullLabel = gen.newLabel();
            Label falseLabel = gen.newLabel();
            Label endLabel = gen.newLabel();
            gen.visitLineNumber(this.line, gen.mark());
            if (this.testExpr instanceof StaticMethodExpr && ((StaticMethodExpr)this.testExpr).canEmitIntrinsicPredicate()) {
                ((StaticMethodExpr)this.testExpr).emitIntrinsicPredicate(C.EXPRESSION, objx, gen, falseLabel);
            } else if (Compiler.maybePrimitiveType(this.testExpr) == Boolean.TYPE) {
                ((MaybePrimitiveExpr)this.testExpr).emitUnboxed(C.EXPRESSION, objx, gen);
                gen.ifZCmp(153, falseLabel);
            } else {
                this.testExpr.emit(C.EXPRESSION, objx, gen);
                gen.dup();
                gen.ifNull(nullLabel);
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                gen.visitJumpInsn(165, falseLabel);
            }
            if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.thenExpr).emitUnboxed(context, objx, gen);
            } else {
                this.thenExpr.emit(context, objx, gen);
            }
            gen.goTo(endLabel);
            gen.mark(nullLabel);
            gen.pop();
            gen.mark(falseLabel);
            if (emitUnboxed) {
                ((MaybePrimitiveExpr)this.elseExpr).emitUnboxed(context, objx, gen);
            } else {
                this.elseExpr.emit(context, objx, gen);
            }
            gen.mark(endLabel);
        }

        @Override
        public boolean hasJavaClass() {
            return this.thenExpr.hasJavaClass() && this.elseExpr.hasJavaClass() && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == RECUR_CLASS || this.elseExpr.getJavaClass() == RECUR_CLASS || this.thenExpr.getJavaClass() == null && !this.elseExpr.getJavaClass().isPrimitive() || this.elseExpr.getJavaClass() == null && !this.thenExpr.getJavaClass().isPrimitive());
        }

        @Override
        public boolean canEmitPrimitive() {
            try {
                return this.thenExpr instanceof MaybePrimitiveExpr && this.elseExpr instanceof MaybePrimitiveExpr && (this.thenExpr.getJavaClass() == this.elseExpr.getJavaClass() || this.thenExpr.getJavaClass() == RECUR_CLASS || this.elseExpr.getJavaClass() == RECUR_CLASS) && ((MaybePrimitiveExpr)this.thenExpr).canEmitPrimitive() && ((MaybePrimitiveExpr)this.elseExpr).canEmitPrimitive();
            }
            catch (Exception e2) {
                return false;
            }
        }

        @Override
        public Class getJavaClass() {
            Class thenClass = this.thenExpr.getJavaClass();
            if (thenClass != null && thenClass != RECUR_CLASS) {
                return thenClass;
            }
            return this.elseExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expr parse(C context, Object frm) {
                Expr elseexpr;
                Expr thenexpr;
                ISeq form = (ISeq)frm;
                if (form.count() > 4) {
                    throw Util.runtimeException("Too many arguments to if");
                }
                if (form.count() < 3) {
                    throw Util.runtimeException("Too few arguments to if");
                }
                PathNode branch = new PathNode(PATHTYPE.BRANCH, (PathNode)CLEAR_PATH.get());
                Expr testexpr = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    thenexpr = Compiler.analyze(context, RT.third(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                try {
                    Var.pushThreadBindings(RT.map(CLEAR_PATH, new PathNode(PATHTYPE.PATH, branch)));
                    elseexpr = Compiler.analyze(context, RT.fourth(form));
                }
                finally {
                    Var.popThreadBindings();
                }
                return new IfExpr(Compiler.lineDeref(), Compiler.columnDeref(), testexpr, thenexpr, elseexpr);
            }
        }
    }

    public static class MetaExpr
    implements Expr {
        public final Expr expr;
        public final Expr meta;
        static final Type IOBJ_TYPE = Type.getType(IObj.class);
        static final clojure.asm.commons.Method withMetaMethod = clojure.asm.commons.Method.getMethod("clojure.lang.IObj withMeta(clojure.lang.IPersistentMap)");

        public MetaExpr(Expr expr, Expr meta) {
            this.expr = expr;
            this.meta = meta;
        }

        @Override
        public Object eval() {
            return ((IObj)this.expr.eval()).withMeta((IPersistentMap)this.meta.eval());
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.expr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IOBJ_TYPE);
            this.meta.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(IPERSISTENTMAP_TYPE);
            gen.invokeInterface(IOBJ_TYPE, withMetaMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.expr.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.expr.getJavaClass();
        }
    }

    public static class NewExpr
    implements Expr {
        public final IPersistentVector args;
        public final Constructor ctor;
        public final Class c;
        static final clojure.asm.commons.Method invokeConstructorMethod = clojure.asm.commons.Method.getMethod("Object invokeConstructor(Class,Object[])");
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class classForName(String)");

        public NewExpr(Class c, IPersistentVector args, int line, int column) {
            this.args = args;
            this.c = c;
            Constructor<?>[] allctors = c.getConstructors();
            ArrayList ctors = new ArrayList();
            ArrayList<Class[]> params = new ArrayList<Class[]>();
            ArrayList<Class> rets = new ArrayList<Class>();
            for (int i = 0; i < allctors.length; ++i) {
                Constructor<?> ctor = allctors[i];
                if (ctor.getParameterTypes().length != args.count()) continue;
                ctors.add(ctor);
                params.add(ctor.getParameterTypes());
                rets.add(c);
            }
            if (ctors.isEmpty()) {
                throw new IllegalArgumentException("No matching ctor found for " + c);
            }
            int ctoridx = 0;
            if (ctors.size() > 1) {
                ctoridx = Compiler.getMatchingParams(c.getName(), params, args, rets);
            }
            Constructor constructor = this.ctor = ctoridx >= 0 ? (Constructor)ctors.get(ctoridx) : null;
            if (this.ctor == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to %s ctor can't be resolved.\n", SOURCE_PATH.deref(), line, column, c.getName());
            }
        }

        @Override
        public Object eval() {
            Object[] argvals = new Object[this.args.count()];
            for (int i = 0; i < this.args.count(); ++i) {
                argvals[i] = ((Expr)this.args.nth(i)).eval();
            }
            if (this.ctor != null) {
                try {
                    return this.ctor.newInstance(Reflector.boxArgs(this.ctor.getParameterTypes(), argvals));
                }
                catch (Exception e2) {
                    throw Util.sneakyThrow(e2);
                }
            }
            return Reflector.invokeConstructor(this.c, argvals);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.ctor != null) {
                Type type2 = Compiler.getType(this.c);
                gen.newInstance(type2);
                gen.dup();
                MethodExpr.emitTypedArgs(objx, gen, this.ctor.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeConstructor(type2, new clojure.asm.commons.Method("<init>", Type.getConstructorDescriptor(this.ctor)));
            } else {
                gen.push(Compiler.destubClassName(this.c.getName()));
                gen.invokeStatic(RT_TYPE, forNameMethod);
                MethodExpr.emitArgsAsArray(this.args, objx, gen);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeConstructorMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.c;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                ISeq form = (ISeq)frm;
                if (form.count() < 2) {
                    throw Util.runtimeException("wrong number of arguments, expecting: (new Classname args...)");
                }
                Class c = HostExpr.maybeClass(RT.second(form), false);
                if (c == null) {
                    throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(form));
                }
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(RT.next(form)); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                return new NewExpr(c, args, line, column);
            }
        }
    }

    static class ThrowExpr
    extends UntypedExpr {
        public final Expr excExpr;

        public ThrowExpr(Expr excExpr) {
            this.excExpr = excExpr;
        }

        @Override
        public Object eval() {
            throw Util.runtimeException("Can't eval throw");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.excExpr.emit(C.EXPRESSION, objx, gen);
            gen.checkCast(THROWABLE_TYPE);
            gen.throwException();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                if (context == C.EVAL) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                if (RT.count(form) == 1) {
                    throw Util.runtimeException("Too few arguments to throw, throw expects a single Throwable instance");
                }
                if (RT.count(form) > 2) {
                    throw Util.runtimeException("Too many arguments to throw, throw expects a single Throwable instance");
                }
                return new ThrowExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    public static class TryExpr
    implements Expr {
        public final Expr tryExpr;
        public final Expr finallyExpr;
        public final PersistentVector catchExprs;
        public final int retLocal;
        public final int finallyLocal;

        public TryExpr(Expr tryExpr, PersistentVector catchExprs, Expr finallyExpr, int retLocal, int finallyLocal) {
            this.tryExpr = tryExpr;
            this.catchExprs = catchExprs;
            this.finallyExpr = finallyExpr;
            this.retLocal = retLocal;
            this.finallyLocal = finallyLocal;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval try");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            CatchClause clause;
            int i;
            Label startTry = gen.newLabel();
            Label endTry = gen.newLabel();
            Label end = gen.newLabel();
            Label ret = gen.newLabel();
            Label finallyLabel = gen.newLabel();
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                clause.label = gen.newLabel();
                clause.endLabel = gen.newLabel();
            }
            gen.mark(startTry);
            this.tryExpr.emit(context, objx, gen);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
            }
            gen.mark(endTry);
            if (this.finallyExpr != null) {
                this.finallyExpr.emit(C.STATEMENT, objx, gen);
            }
            gen.goTo(ret);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.mark(clause.label);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), clause.lb.idx);
                clause.handler.emit(context, objx, gen);
                if (context != C.STATEMENT) {
                    gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.retLocal);
                }
                gen.mark(clause.endLabel);
                if (this.finallyExpr != null) {
                    this.finallyExpr.emit(C.STATEMENT, objx, gen);
                }
                gen.goTo(ret);
            }
            if (this.finallyExpr != null) {
                gen.mark(finallyLabel);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(54), this.finallyLocal);
                this.finallyExpr.emit(C.STATEMENT, objx, gen);
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.finallyLocal);
                gen.throwException();
            }
            gen.mark(ret);
            if (context != C.STATEMENT) {
                gen.visitVarInsn(OBJECT_TYPE.getOpcode(21), this.retLocal);
            }
            gen.mark(end);
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitTryCatchBlock(startTry, endTry, clause.label, clause.c.getName().replace('.', '/'));
            }
            if (this.finallyExpr != null) {
                gen.visitTryCatchBlock(startTry, endTry, finallyLabel, null);
                for (i = 0; i < this.catchExprs.count(); ++i) {
                    clause = (CatchClause)this.catchExprs.nth(i);
                    gen.visitTryCatchBlock(clause.label, clause.endLabel, finallyLabel, null);
                }
            }
            for (i = 0; i < this.catchExprs.count(); ++i) {
                clause = (CatchClause)this.catchExprs.nth(i);
                gen.visitLocalVariable(clause.lb.name, "Ljava/lang/Object;", null, clause.label, clause.endLabel, clause.lb.idx);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.tryExpr.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.tryExpr.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (context != C.RETURN) {
                    return Compiler.analyze(context, RT.list(RT.list(FNONCE, PersistentVector.EMPTY, form)));
                }
                PersistentVector body = PersistentVector.EMPTY;
                PersistentVector catches = PersistentVector.EMPTY;
                Expr bodyExpr = null;
                Expr finallyExpr = null;
                boolean caught = false;
                int retLocal = Compiler.getAndIncLocalNum();
                int finallyLocal = Compiler.getAndIncLocalNum();
                for (ISeq fs = form.next(); fs != null; fs = fs.next()) {
                    Object op;
                    Object f = fs.first();
                    Object object = op = f instanceof ISeq ? ((ISeq)f).first() : null;
                    if (!Util.equals(op, CATCH) && !Util.equals(op, FINALLY)) {
                        if (caught) {
                            throw Util.runtimeException("Only catch or finally clause can follow catch in try expression");
                        }
                        body = body.cons(f);
                        continue;
                    }
                    if (bodyExpr == null) {
                        try {
                            Var.pushThreadBindings(RT.map(NO_RECUR, true));
                            bodyExpr = new BodyExpr.Parser().parse(context, RT.seq(body));
                        }
                        finally {
                            Var.popThreadBindings();
                        }
                    }
                    if (Util.equals(op, CATCH)) {
                        Class c = HostExpr.maybeClass(RT.second(f), false);
                        if (c == null) {
                            throw new IllegalArgumentException("Unable to resolve classname: " + RT.second(f));
                        }
                        if (!(RT.third(f) instanceof Symbol)) {
                            throw new IllegalArgumentException("Bad binding form, expected symbol, got: " + RT.third(f));
                        }
                        Symbol sym = (Symbol)RT.third(f);
                        if (sym.getNamespace() != null) {
                            throw Util.runtimeException("Can't bind qualified name:" + sym);
                        }
                        IPersistentMap dynamicBindings = RT.map(LOCAL_ENV, LOCAL_ENV.deref(), NEXT_LOCAL_NUM, NEXT_LOCAL_NUM.deref(), IN_CATCH_FINALLY, RT.T);
                        try {
                            Var.pushThreadBindings(dynamicBindings);
                            LocalBinding lb = Compiler.registerLocal(sym, (Symbol)(RT.second(f) instanceof Symbol ? RT.second(f) : null), null, false);
                            Expr handler = new BodyExpr.Parser().parse(C.EXPRESSION, RT.next(RT.next(RT.next(f))));
                            catches = catches.cons(new CatchClause(c, lb, handler));
                        }
                        finally {
                            Var.popThreadBindings();
                        }
                        caught = true;
                        continue;
                    }
                    if (fs.next() != null) {
                        throw Util.runtimeException("finally clause must be last in try expression");
                    }
                    try {
                        Var.pushThreadBindings(RT.map(IN_CATCH_FINALLY, RT.T));
                        finallyExpr = new BodyExpr.Parser().parse(C.STATEMENT, RT.next(f));
                        continue;
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                }
                if (bodyExpr == null) {
                    try {
                        Var.pushThreadBindings(RT.map(NO_RECUR, true));
                        bodyExpr = new BodyExpr.Parser().parse(C.EXPRESSION, RT.seq(body));
                    }
                    finally {
                        Var.popThreadBindings();
                    }
                }
                return new TryExpr(bodyExpr, catches, finallyExpr, retLocal, finallyLocal);
            }
        }

        public static class CatchClause {
            public final Class c;
            public final LocalBinding lb;
            public final Expr handler;
            Label label;
            Label endLabel;

            public CatchClause(Class c, LocalBinding lb, Expr handler) {
                this.c = c;
                this.lb = lb;
                this.handler = handler;
            }
        }
    }

    static class MonitorExitExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorExitExpr(Expr target) {
            this.target = target;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval monitor-exit");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorExit();
            NIL_EXPR.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new MonitorExitExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class MonitorEnterExpr
    extends UntypedExpr {
        final Expr target;

        public MonitorEnterExpr(Expr target) {
            this.target = target;
        }

        @Override
        public Object eval() {
            throw new UnsupportedOperationException("Can't eval monitor-enter");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.monitorEnter();
            NIL_EXPR.emit(context, objx, gen);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new MonitorEnterExpr(Compiler.analyze(C.EXPRESSION, RT.second(form)));
            }
        }
    }

    static class StringExpr
    extends LiteralExpr {
        public final String str;

        public StringExpr(String str2) {
            this.str = str2;
        }

        @Override
        Object val() {
            return this.str;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                gen.push(this.str);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return String.class;
        }
    }

    static class BooleanExpr
    extends LiteralExpr {
        public final boolean val;

        public BooleanExpr(boolean val2) {
            this.val = val2;
        }

        @Override
        Object val() {
            return this.val ? RT.T : RT.F;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.val) {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
            } else {
                gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Boolean.class;
        }
    }

    static class NilExpr
    extends LiteralExpr {
        NilExpr() {
        }

        @Override
        Object val() {
            return null;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitInsn(1);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return null;
        }
    }

    static class ConstantExpr
    extends LiteralExpr {
        public final Object v;
        public final int id;

        public ConstantExpr(Object v) {
            this.v = v;
            this.id = Compiler.registerConstant(v);
        }

        @Override
        Object val() {
            return this.v;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitConstant(gen, this.id);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return Modifier.isPublic(this.v.getClass().getModifiers());
        }

        @Override
        public Class getJavaClass() {
            if (this.v instanceof APersistentMap) {
                return APersistentMap.class;
            }
            if (this.v instanceof APersistentSet) {
                return APersistentSet.class;
            }
            if (this.v instanceof APersistentVector) {
                return APersistentVector.class;
            }
            return this.v.getClass();
        }

        static class Parser
        implements IParser {
            static Keyword formKey = Keyword.intern("form");

            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                int argCount = RT.count(form) - 1;
                if (argCount != 1) {
                    PersistentArrayMap exData = new PersistentArrayMap(new Object[]{formKey, form});
                    throw new ExceptionInfo("Wrong number of args (" + argCount + ") passed to quote", exData);
                }
                Object v = RT.second(form);
                if (v == null) {
                    return NIL_EXPR;
                }
                if (v == Boolean.TRUE) {
                    return TRUE_EXPR;
                }
                if (v == Boolean.FALSE) {
                    return FALSE_EXPR;
                }
                if (v instanceof Number) {
                    return NumberExpr.parse((Number)v);
                }
                if (v instanceof String) {
                    return new StringExpr((String)v);
                }
                if (v instanceof IPersistentCollection && ((IPersistentCollection)v).count() == 0) {
                    return new EmptyExpr(v);
                }
                return new ConstantExpr(v);
            }
        }
    }

    static class NumberExpr
    extends LiteralExpr
    implements MaybePrimitiveExpr {
        final Number n;
        public final int id;

        public NumberExpr(Number n) {
            this.n = n;
            this.id = Compiler.registerConstant(n);
        }

        @Override
        Object val() {
            return this.n;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (context != C.STATEMENT) {
                objx.emitConstant(gen, this.id);
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            if (this.n instanceof Integer) {
                return Long.TYPE;
            }
            if (this.n instanceof Double) {
                return Double.TYPE;
            }
            if (this.n instanceof Long) {
                return Long.TYPE;
            }
            throw new IllegalStateException("Unsupported Number type: " + this.n.getClass().getName());
        }

        @Override
        public boolean canEmitPrimitive() {
            return true;
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.n instanceof Integer) {
                gen.push(this.n.longValue());
            } else if (this.n instanceof Double) {
                gen.push(this.n.doubleValue());
            } else if (this.n instanceof Long) {
                gen.push(this.n.longValue());
            }
        }

        public static Expr parse(Number form) {
            if (form instanceof Integer || form instanceof Double || form instanceof Long) {
                return new NumberExpr(form);
            }
            return new ConstantExpr(form);
        }
    }

    static class UnresolvedVarExpr
    implements Expr {
        public final Symbol symbol;

        public UnresolvedVarExpr(Symbol symbol2) {
            this.symbol = symbol2;
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }

        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("UnresolvedVarExpr has no Java class");
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
        }

        @Override
        public Object eval() {
            throw new IllegalArgumentException("UnresolvedVarExpr cannot be evalled");
        }
    }

    static class StaticMethodExpr
    extends MethodExpr {
        public final Class c;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final int column;
        public final Method method;
        public final Symbol tag;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class classForName(String)");
        static final clojure.asm.commons.Method invokeStaticMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeStaticMethod(Class,String,Object[])");
        static final Keyword warnOnBoxedKeyword = Keyword.intern("warn-on-boxed");

        public StaticMethodExpr(String source2, int line, int column, Symbol tag, Class c, String methodName, IPersistentVector args) {
            this.c = c;
            this.methodName = methodName;
            this.args = args;
            this.source = source2;
            this.line = line;
            this.column = column;
            this.tag = tag;
            List methods2 = Reflector.getMethods(c, args.count(), methodName, true);
            if (methods2.isEmpty()) {
                throw new IllegalArgumentException("No matching method: " + methodName);
            }
            int methodidx = 0;
            if (methods2.size() > 1) {
                ArrayList<Class[]> params = new ArrayList<Class[]>();
                ArrayList<Class> rets = new ArrayList<Class>();
                for (int i = 0; i < methods2.size(); ++i) {
                    Method m = (Method)methods2.get(i);
                    params.add(m.getParameterTypes());
                    rets.add(m.getReturnType());
                }
                methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
            }
            this.method = methodidx >= 0 ? methods2.get(methodidx) : null;
            if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to static method %s on %s can't be resolved (argument types: %s).\n", SOURCE_PATH.deref(), line, column, methodName, c.getName(), Compiler.getTypeStringForArgs(args));
            }
            if (this.method != null && warnOnBoxedKeyword.equals(RT.UNCHECKED_MATH.deref()) && StaticMethodExpr.isBoxedMath(this.method)) {
                RT.errPrintWriter().format("Boxed math warning, %s:%d:%d - call: %s.\n", SOURCE_PATH.deref(), line, column, this.method.toString());
            }
        }

        public static boolean isBoxedMath(Method m) {
            Class<?> c = m.getDeclaringClass();
            if (c.equals(Numbers.class)) {
                Class<?>[] argTypes;
                WarnBoxedMath boxedMath = m.getAnnotation(WarnBoxedMath.class);
                if (boxedMath != null) {
                    return boxedMath.value();
                }
                for (Class<?> argType : argTypes = m.getParameterTypes()) {
                    if (!argType.equals(Object.class) && !argType.equals(Number.class)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object eval() {
            try {
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, null, argvals);
                }
                return Reflector.invokeStaticMethod(this.c, this.methodName, argvals);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e2);
                }
                throw (CompilerException)e2;
            }
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        public boolean canEmitIntrinsicPredicate() {
            return this.method != null && RT.get(Intrinsics.preds, this.method.toString()) != null;
        }

        public void emitIntrinsicPredicate(C context, ObjExpr objx, GeneratorAdapter gen, Label falseLabel) {
            Object[] predOps;
            gen.visitLineNumber(this.line, gen.mark());
            if (this.method != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                predOps = (Object[])RT.get(Intrinsics.preds, this.method.toString());
                for (int i = 0; i < predOps.length - 1; ++i) {
                    gen.visitInsn((Integer)predOps[i]);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            gen.visitJumpInsn((Integer)predOps[predOps.length - 1], falseLabel);
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.method != null) {
                Object ops;
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                if ((ops = RT.get(Intrinsics.ops, this.method.toString())) != null) {
                    if (ops instanceof Object[]) {
                        for (Object op : (Object[])ops) {
                            gen.visitInsn((Integer)op);
                        }
                    } else {
                        gen.visitInsn((Integer)ops);
                    }
                } else {
                    Type type2 = Type.getType(this.c);
                    clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                    gen.invokeStatic(type2, m);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.method != null) {
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                Type type2 = Type.getType(this.c);
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                gen.invokeStatic(type2, m);
                Class<?> retClass = this.method.getReturnType();
                if (context == C.STATEMENT) {
                    if (retClass == Long.TYPE || retClass == Double.TYPE) {
                        gen.pop2();
                    } else if (retClass != Void.TYPE) {
                        gen.pop();
                    }
                } else {
                    HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType());
                }
            } else {
                gen.visitLineNumber(this.line, gen.mark());
                gen.push(this.c.getName());
                gen.invokeStatic(RT_TYPE, forNameMethod);
                gen.push(this.methodName);
                StaticMethodExpr.emitArgsAsArray(this.args, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeStaticMethodMethod);
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return Compiler.retType(this.tag != null ? HostExpr.tagToClass(this.tag) : null, this.method != null ? this.method.getReturnType() : null);
        }
    }

    static class InstanceMethodExpr
    extends MethodExpr {
        public final Expr target;
        public final String methodName;
        public final IPersistentVector args;
        public final String source;
        public final int line;
        public final int column;
        public final Symbol tag;
        public final Method method;
        static final clojure.asm.commons.Method invokeInstanceMethodMethod = clojure.asm.commons.Method.getMethod("Object invokeInstanceMethod(Object,String,Object[])");

        public InstanceMethodExpr(String source2, int line, int column, Symbol tag, Expr target, String methodName, IPersistentVector args) {
            this.source = source2;
            this.line = line;
            this.column = column;
            this.args = args;
            this.methodName = methodName;
            this.target = target;
            this.tag = tag;
            if (target.hasJavaClass() && target.getJavaClass() != null) {
                List methods2 = Reflector.getMethods(target.getJavaClass(), args.count(), methodName, false);
                if (methods2.isEmpty()) {
                    this.method = null;
                    if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                        RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to method %s on %s can't be resolved (no such method).\n", SOURCE_PATH.deref(), line, column, methodName, target.getJavaClass().getName());
                    }
                } else {
                    Method m;
                    int methodidx = 0;
                    if (methods2.size() > 1) {
                        ArrayList<Class[]> params = new ArrayList<Class[]>();
                        ArrayList<Class> rets = new ArrayList<Class>();
                        for (int i = 0; i < methods2.size(); ++i) {
                            Method m2 = (Method)methods2.get(i);
                            params.add(m2.getParameterTypes());
                            rets.add(m2.getReturnType());
                        }
                        methodidx = Compiler.getMatchingParams(methodName, params, args, rets);
                    }
                    if ((m = (Method)(methodidx >= 0 ? methods2.get(methodidx) : null)) != null && !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                        m = Reflector.getAsMethodOfPublicBase(m.getDeclaringClass(), m);
                    }
                    this.method = m;
                    if (this.method == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                        RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to method %s on %s can't be resolved (argument types: %s).\n", SOURCE_PATH.deref(), line, column, methodName, target.getJavaClass().getName(), Compiler.getTypeStringForArgs(args));
                    }
                }
            } else {
                this.method = null;
                if (RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                    RT.errPrintWriter().format("Reflection warning, %s:%d:%d - call to method %s can't be resolved (target class is unknown).\n", SOURCE_PATH.deref(), line, column, methodName);
                }
            }
        }

        @Override
        public Object eval() {
            try {
                Object targetval = this.target.eval();
                Object[] argvals = new Object[this.args.count()];
                for (int i = 0; i < this.args.count(); ++i) {
                    argvals[i] = ((Expr)this.args.nth(i)).eval();
                }
                if (this.method != null) {
                    LinkedList<Method> ms = new LinkedList<Method>();
                    ms.add(this.method);
                    return Reflector.invokeMatchingMethod(this.methodName, ms, targetval, argvals);
                }
                return Reflector.invokeInstanceMethod(targetval, this.methodName, argvals);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e2);
                }
                throw (CompilerException)e2;
            }
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.method != null && Util.isPrimitive(this.method.getReturnType());
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.method != null) {
                Type type2 = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type2);
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type2, m);
                } else {
                    gen.invokeVirtual(type2, m);
                }
            } else {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.method != null) {
                Type type2 = Type.getType(this.method.getDeclaringClass());
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(type2);
                MethodExpr.emitTypedArgs(objx, gen, this.method.getParameterTypes(), this.args);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                clojure.asm.commons.Method m = new clojure.asm.commons.Method(this.methodName, Type.getReturnType(this.method), Type.getArgumentTypes(this.method));
                if (this.method.getDeclaringClass().isInterface()) {
                    gen.invokeInterface(type2, m);
                } else {
                    gen.invokeVirtual(type2, m);
                }
                HostExpr.emitBoxReturn(objx, gen, this.method.getReturnType());
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.methodName);
                InstanceMethodExpr.emitArgsAsArray(this.args, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                if (context == C.RETURN) {
                    ObjMethod method = (ObjMethod)METHOD.deref();
                    method.emitClearLocals(gen);
                }
                gen.invokeStatic(REFLECTOR_TYPE, invokeInstanceMethodMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.method != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return Compiler.retType(this.tag != null ? HostExpr.tagToClass(this.tag) : null, this.method != null ? this.method.getReturnType() : null);
        }
    }

    static abstract class MethodExpr
    extends HostExpr {
        MethodExpr() {
        }

        static void emitArgsAsArray(IPersistentVector args, ObjExpr objx, GeneratorAdapter gen) {
            gen.push(args.count());
            gen.newArray(OBJECT_TYPE);
            for (int i = 0; i < args.count(); ++i) {
                gen.dup();
                gen.push(i);
                ((Expr)args.nth(i)).emit(C.EXPRESSION, objx, gen);
                gen.arrayStore(OBJECT_TYPE);
            }
        }

        public static void emitTypedArgs(ObjExpr objx, GeneratorAdapter gen, Class[] parameterTypes, IPersistentVector args) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Expr e2 = (Expr)args.nth(i);
                try {
                    MaybePrimitiveExpr pe;
                    Class primc = Compiler.maybePrimitiveType(e2);
                    if (primc == parameterTypes[i]) {
                        pe = (MaybePrimitiveExpr)e2;
                        pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        continue;
                    }
                    if (primc == Integer.TYPE && parameterTypes[i] == Long.TYPE) {
                        pe = (MaybePrimitiveExpr)e2;
                        pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(133);
                        continue;
                    }
                    if (primc == Long.TYPE && parameterTypes[i] == Integer.TYPE) {
                        pe = (MaybePrimitiveExpr)e2;
                        pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        if (RT.booleanCast(RT.UNCHECKED_MATH.deref())) {
                            gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int uncheckedIntCast(long)"));
                            continue;
                        }
                        gen.invokeStatic(RT_TYPE, clojure.asm.commons.Method.getMethod("int intCast(long)"));
                        continue;
                    }
                    if (primc == Float.TYPE && parameterTypes[i] == Double.TYPE) {
                        pe = (MaybePrimitiveExpr)e2;
                        pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(141);
                        continue;
                    }
                    if (primc == Double.TYPE && parameterTypes[i] == Float.TYPE) {
                        pe = (MaybePrimitiveExpr)e2;
                        pe.emitUnboxed(C.EXPRESSION, objx, gen);
                        gen.visitInsn(144);
                        continue;
                    }
                    e2.emit(C.EXPRESSION, objx, gen);
                    HostExpr.emitUnboxArg(objx, gen, parameterTypes[i]);
                    continue;
                }
                catch (Exception e1) {
                    throw Util.sneakyThrow(e1);
                }
            }
        }
    }

    static class StaticFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final String fieldName;
        public final Class c;
        public final Field field;
        public final Symbol tag;
        final int line;
        final int column;

        public StaticFieldExpr(int line, int column, Class c, String fieldName, Symbol tag) {
            this.fieldName = fieldName;
            this.line = line;
            this.column = column;
            this.c = c;
            try {
                this.field = c.getField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                throw Util.sneakyThrow(e2);
            }
            this.tag = tag;
        }

        @Override
        public Object eval() {
            return Reflector.getStaticField(this.c, this.fieldName);
        }

        @Override
        public boolean canEmitPrimitive() {
            return Util.isPrimitive(this.field.getType());
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.visitLineNumber(this.line, gen.mark());
            gen.getStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            HostExpr.emitBoxReturn(objx, gen, this.field.getType());
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        @Override
        public Object evalAssign(Expr val2) {
            return Reflector.setStaticField(this.c, this.fieldName, val2.eval());
        }

        @Override
        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            val2.emit(C.EXPRESSION, objx, gen);
            gen.visitLineNumber(this.line, gen.mark());
            gen.dup();
            HostExpr.emitUnboxArg(objx, gen, this.field.getType());
            gen.putStatic(Type.getType(this.c), this.fieldName, Type.getType(this.field.getType()));
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static class InstanceFieldExpr
    extends FieldExpr
    implements AssignableExpr {
        public final Expr target;
        public final Class targetClass;
        public final Field field;
        public final String fieldName;
        public final int line;
        public final int column;
        public final Symbol tag;
        public final boolean requireField;
        static final clojure.asm.commons.Method invokeNoArgInstanceMember = clojure.asm.commons.Method.getMethod("Object invokeNoArgInstanceMember(Object,String,boolean)");
        static final clojure.asm.commons.Method setInstanceFieldMethod = clojure.asm.commons.Method.getMethod("Object setInstanceField(Object,String,Object)");

        public InstanceFieldExpr(int line, int column, Expr target, String fieldName, Symbol tag, boolean requireField) {
            this.target = target;
            this.targetClass = target.hasJavaClass() ? target.getJavaClass() : null;
            this.field = this.targetClass != null ? Reflector.getField(this.targetClass, fieldName, false) : null;
            this.fieldName = fieldName;
            this.line = line;
            this.column = column;
            this.tag = tag;
            this.requireField = requireField;
            if (this.field == null && RT.booleanCast(RT.WARN_ON_REFLECTION.deref())) {
                if (this.targetClass == null) {
                    RT.errPrintWriter().format("Reflection warning, %s:%d:%d - reference to field %s can't be resolved.\n", SOURCE_PATH.deref(), line, column, fieldName);
                } else {
                    RT.errPrintWriter().format("Reflection warning, %s:%d:%d - reference to field %s on %s can't be resolved.\n", SOURCE_PATH.deref(), line, column, fieldName, this.targetClass.getName());
                }
            }
        }

        @Override
        public Object eval() {
            return Reflector.invokeNoArgInstanceMember(this.target.eval(), this.fieldName, this.requireField);
        }

        @Override
        public boolean canEmitPrimitive() {
            return this.targetClass != null && this.field != null && Util.isPrimitive(this.field.getType());
        }

        @Override
        public void emitUnboxed(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.targetClass == null || this.field == null) {
                throw new UnsupportedOperationException("Unboxed emit of unknown member");
            }
            this.target.emit(C.EXPRESSION, objx, gen);
            gen.visitLineNumber(this.line, gen.mark());
            gen.checkCast(Compiler.getType(this.targetClass));
            gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            if (this.targetClass != null && this.field != null) {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                gen.checkCast(Compiler.getType(this.targetClass));
                gen.getField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
                HostExpr.emitBoxReturn(objx, gen, this.field.getType());
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                gen.push(this.fieldName);
                gen.push(this.requireField);
                gen.invokeStatic(REFLECTOR_TYPE, invokeNoArgInstanceMember);
                if (context == C.STATEMENT) {
                    gen.pop();
                }
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.field != null || this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return this.tag != null ? HostExpr.tagToClass(this.tag) : this.field.getType();
        }

        @Override
        public Object evalAssign(Expr val2) {
            return Reflector.setInstanceField(this.target.eval(), this.fieldName, val2.eval());
        }

        @Override
        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            if (this.targetClass != null && this.field != null) {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(Compiler.getType(this.targetClass));
                val2.emit(C.EXPRESSION, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                gen.dupX1();
                HostExpr.emitUnboxArg(objx, gen, this.field.getType());
                gen.putField(Compiler.getType(this.targetClass), this.fieldName, Type.getType(this.field.getType()));
            } else {
                this.target.emit(C.EXPRESSION, objx, gen);
                gen.push(this.fieldName);
                val2.emit(C.EXPRESSION, objx, gen);
                gen.visitLineNumber(this.line, gen.mark());
                gen.invokeStatic(REFLECTOR_TYPE, setInstanceFieldMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    static abstract class FieldExpr
    extends HostExpr {
        FieldExpr() {
        }
    }

    public static abstract class HostExpr
    implements Expr,
    MaybePrimitiveExpr {
        static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
        static final Type CHAR_TYPE = Type.getType(Character.class);
        static final Type INTEGER_TYPE = Type.getType(Integer.class);
        static final Type LONG_TYPE = Type.getType(Long.class);
        static final Type FLOAT_TYPE = Type.getType(Float.class);
        static final Type DOUBLE_TYPE = Type.getType(Double.class);
        static final Type SHORT_TYPE = Type.getType(Short.class);
        static final Type BYTE_TYPE = Type.getType(Byte.class);
        static final Type NUMBER_TYPE = Type.getType(Number.class);
        static final clojure.asm.commons.Method charValueMethod = clojure.asm.commons.Method.getMethod("char charValue()");
        static final clojure.asm.commons.Method booleanValueMethod = clojure.asm.commons.Method.getMethod("boolean booleanValue()");
        static final clojure.asm.commons.Method charValueOfMethod = clojure.asm.commons.Method.getMethod("Character valueOf(char)");
        static final clojure.asm.commons.Method intValueOfMethod = clojure.asm.commons.Method.getMethod("Integer valueOf(int)");
        static final clojure.asm.commons.Method longValueOfMethod = clojure.asm.commons.Method.getMethod("Long valueOf(long)");
        static final clojure.asm.commons.Method floatValueOfMethod = clojure.asm.commons.Method.getMethod("Float valueOf(float)");
        static final clojure.asm.commons.Method doubleValueOfMethod = clojure.asm.commons.Method.getMethod("Double valueOf(double)");
        static final clojure.asm.commons.Method shortValueOfMethod = clojure.asm.commons.Method.getMethod("Short valueOf(short)");
        static final clojure.asm.commons.Method byteValueOfMethod = clojure.asm.commons.Method.getMethod("Byte valueOf(byte)");
        static final clojure.asm.commons.Method intValueMethod = clojure.asm.commons.Method.getMethod("int intValue()");
        static final clojure.asm.commons.Method longValueMethod = clojure.asm.commons.Method.getMethod("long longValue()");
        static final clojure.asm.commons.Method floatValueMethod = clojure.asm.commons.Method.getMethod("float floatValue()");
        static final clojure.asm.commons.Method doubleValueMethod = clojure.asm.commons.Method.getMethod("double doubleValue()");
        static final clojure.asm.commons.Method byteValueMethod = clojure.asm.commons.Method.getMethod("byte byteValue()");
        static final clojure.asm.commons.Method shortValueMethod = clojure.asm.commons.Method.getMethod("short shortValue()");
        static final clojure.asm.commons.Method fromIntMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(int)");
        static final clojure.asm.commons.Method fromLongMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(long)");
        static final clojure.asm.commons.Method fromDoubleMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Num from(double)");

        public static void emitBoxReturn(ObjExpr objx, GeneratorAdapter gen, Class returnType) {
            if (returnType.isPrimitive()) {
                if (returnType == Boolean.TYPE) {
                    Label falseLabel = gen.newLabel();
                    Label endLabel = gen.newLabel();
                    gen.ifZCmp(153, falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "TRUE", BOOLEAN_OBJECT_TYPE);
                    gen.goTo(endLabel);
                    gen.mark(falseLabel);
                    gen.getStatic(BOOLEAN_OBJECT_TYPE, "FALSE", BOOLEAN_OBJECT_TYPE);
                    gen.mark(endLabel);
                } else if (returnType == Void.TYPE) {
                    NIL_EXPR.emit(C.EXPRESSION, objx, gen);
                } else if (returnType == Character.TYPE) {
                    gen.invokeStatic(CHAR_TYPE, charValueOfMethod);
                } else if (returnType == Integer.TYPE) {
                    gen.invokeStatic(INTEGER_TYPE, intValueOfMethod);
                } else if (returnType == Float.TYPE) {
                    gen.invokeStatic(FLOAT_TYPE, floatValueOfMethod);
                } else if (returnType == Double.TYPE) {
                    gen.invokeStatic(DOUBLE_TYPE, doubleValueOfMethod);
                } else if (returnType == Long.TYPE) {
                    gen.invokeStatic(NUMBERS_TYPE, clojure.asm.commons.Method.getMethod("Number num(long)"));
                } else if (returnType == Byte.TYPE) {
                    gen.invokeStatic(BYTE_TYPE, byteValueOfMethod);
                } else if (returnType == Short.TYPE) {
                    gen.invokeStatic(SHORT_TYPE, shortValueOfMethod);
                }
            }
        }

        public static void emitUnboxArg(ObjExpr objx, GeneratorAdapter gen, Class paramType) {
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    gen.checkCast(BOOLEAN_TYPE);
                    gen.invokeVirtual(BOOLEAN_TYPE, booleanValueMethod);
                } else if (paramType == Character.TYPE) {
                    gen.checkCast(CHAR_TYPE);
                    gen.invokeVirtual(CHAR_TYPE, charValueMethod);
                } else {
                    clojure.asm.commons.Method m = null;
                    gen.checkCast(NUMBER_TYPE);
                    if (RT.booleanCast(RT.UNCHECKED_MATH.deref())) {
                        if (paramType == Integer.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("int uncheckedIntCast(Object)");
                        } else if (paramType == Float.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("float uncheckedFloatCast(Object)");
                        } else if (paramType == Double.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("double uncheckedDoubleCast(Object)");
                        } else if (paramType == Long.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("long uncheckedLongCast(Object)");
                        } else if (paramType == Byte.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("byte uncheckedByteCast(Object)");
                        } else if (paramType == Short.TYPE) {
                            m = clojure.asm.commons.Method.getMethod("short uncheckedShortCast(Object)");
                        }
                    } else if (paramType == Integer.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("int intCast(Object)");
                    } else if (paramType == Float.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("float floatCast(Object)");
                    } else if (paramType == Double.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("double doubleCast(Object)");
                    } else if (paramType == Long.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("long longCast(Object)");
                    } else if (paramType == Byte.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("byte byteCast(Object)");
                    } else if (paramType == Short.TYPE) {
                        m = clojure.asm.commons.Method.getMethod("short shortCast(Object)");
                    }
                    gen.invokeStatic(RT_TYPE, m);
                }
            } else {
                gen.checkCast(Type.getType(paramType));
            }
        }

        public static Class maybeClass(Object form, boolean stringOk) {
            if (form instanceof Class) {
                return (Class)form;
            }
            Class c = null;
            if (form instanceof Symbol) {
                Symbol sym = (Symbol)form;
                if (sym.ns == null) {
                    if (Util.equals(sym, COMPILE_STUB_SYM.get())) {
                        return (Class)COMPILE_STUB_CLASS.get();
                    }
                    if (sym.name.indexOf(46) > 0 || sym.name.charAt(0) == '[') {
                        c = RT.classForName(sym.name);
                    } else {
                        Object o = Compiler.currentNS().getMapping(sym);
                        if (o instanceof Class) {
                            c = (Class)o;
                        } else {
                            if (LOCAL_ENV.deref() != null && ((Map)LOCAL_ENV.deref()).containsKey(form)) {
                                return null;
                            }
                            try {
                                c = RT.classForName(sym.name);
                            }
                            catch (Exception e2) {}
                        }
                    }
                }
            } else if (stringOk && form instanceof String) {
                c = RT.classForName((String)form);
            }
            return c;
        }

        public static Class maybeSpecialTag(Symbol sym) {
            Class<Object[]> c = Compiler.primClass(sym);
            if (c != null) {
                return c;
            }
            if (sym.name.equals("objects")) {
                c = Object[].class;
            } else if (sym.name.equals("ints")) {
                c = int[].class;
            } else if (sym.name.equals("longs")) {
                c = long[].class;
            } else if (sym.name.equals("floats")) {
                c = float[].class;
            } else if (sym.name.equals("doubles")) {
                c = double[].class;
            } else if (sym.name.equals("chars")) {
                c = char[].class;
            } else if (sym.name.equals("shorts")) {
                c = short[].class;
            } else if (sym.name.equals("bytes")) {
                c = byte[].class;
            } else if (sym.name.equals("booleans")) {
                c = boolean[].class;
            }
            return c;
        }

        static Class tagToClass(Object tag) {
            Class c = null;
            if (tag instanceof Symbol) {
                Symbol sym = (Symbol)tag;
                if (sym.ns == null) {
                    c = HostExpr.maybeSpecialTag(sym);
                }
            }
            if (c == null) {
                c = HostExpr.maybeClass(tag, true);
            }
            if (c != null) {
                return c;
            }
            throw new IllegalArgumentException("Unable to resolve classname: " + tag);
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                Symbol sym;
                boolean maybeField;
                ISeq form = (ISeq)frm;
                if (RT.length(form) < 3) {
                    throw new IllegalArgumentException("Malformed member expression, expecting (. target member ...)");
                }
                int line = Compiler.lineDeref();
                int column = Compiler.columnDeref();
                String source2 = (String)SOURCE.deref();
                Class c = HostExpr.maybeClass(RT.second(form), false);
                Expr instance = null;
                if (c == null) {
                    instance = Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.second(form));
                }
                boolean bl = maybeField = RT.length(form) == 3 && RT.third(form) instanceof Symbol;
                if (maybeField && ((Symbol)RT.third((Object)form)).name.charAt(0) != '-') {
                    sym = (Symbol)RT.third(form);
                    if (c != null) {
                        maybeField = Reflector.getMethods(c, 0, Compiler.munge(sym.name), true).size() == 0;
                    } else if (instance != null && instance.hasJavaClass() && instance.getJavaClass() != null) {
                        boolean bl2 = maybeField = Reflector.getMethods(instance.getJavaClass(), 0, Compiler.munge(sym.name), false).size() == 0;
                    }
                }
                if (maybeField) {
                    sym = ((Symbol)RT.third((Object)form)).name.charAt(0) == '-' ? Symbol.intern(((Symbol)RT.third((Object)form)).name.substring(1)) : (Symbol)RT.third(form);
                    Symbol tag = Compiler.tagOf(form);
                    if (c != null) {
                        return new StaticFieldExpr(line, column, c, Compiler.munge(sym.name), tag);
                    }
                    return new InstanceFieldExpr(line, column, instance, Compiler.munge(sym.name), tag, ((Symbol)RT.third((Object)form)).name.charAt(0) == '-');
                }
                ISeq call = (ISeq)(RT.third(form) instanceof ISeq ? RT.third(form) : RT.next(RT.next(form)));
                if (!(RT.first(call) instanceof Symbol)) {
                    throw new IllegalArgumentException("Malformed member expression");
                }
                Symbol sym2 = (Symbol)RT.first(call);
                Symbol tag = Compiler.tagOf(form);
                PersistentVector args = PersistentVector.EMPTY;
                for (ISeq s = RT.next(call); s != null; s = s.next()) {
                    args = args.cons(Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, s.first()));
                }
                if (c != null) {
                    return new StaticMethodExpr(source2, line, column, tag, c, Compiler.munge(sym2.name), args);
                }
                return new InstanceMethodExpr(source2, line, column, tag, instance, Compiler.munge(sym2.name), args);
            }
        }
    }

    public static interface MaybePrimitiveExpr
    extends Expr {
        public boolean canEmitPrimitive();

        public void emitUnboxed(C var1, ObjExpr var2, GeneratorAdapter var3);
    }

    static interface AssignableExpr {
        public Object evalAssign(Expr var1);

        public void emitAssign(C var1, ObjExpr var2, GeneratorAdapter var3, Expr var4);
    }

    public static abstract class LiteralExpr
    implements Expr {
        abstract Object val();

        @Override
        public Object eval() {
            return this.val();
        }
    }

    public static class ImportExpr
    implements Expr {
        public final String c;
        static final clojure.asm.commons.Method forNameMethod = clojure.asm.commons.Method.getMethod("Class classForNameNonLoading(String)");
        static final clojure.asm.commons.Method importClassMethod = clojure.asm.commons.Method.getMethod("Class importClass(Class)");
        static final clojure.asm.commons.Method derefMethod = clojure.asm.commons.Method.getMethod("Object deref()");

        public ImportExpr(String c) {
            this.c = c;
        }

        @Override
        public Object eval() {
            Namespace ns2 = (Namespace)RT.CURRENT_NS.deref();
            ns2.importClass(RT.classForNameNonLoading(this.c));
            return null;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            gen.getStatic(RT_TYPE, "CURRENT_NS", VAR_TYPE);
            gen.invokeVirtual(VAR_TYPE, derefMethod);
            gen.checkCast(NS_TYPE);
            gen.push(this.c);
            gen.invokeStatic(RT_TYPE, forNameMethod);
            gen.invokeVirtual(NS_TYPE, importClassMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }

        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("ImportExpr has no Java class");
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                return new ImportExpr((String)RT.second(form));
            }
        }
    }

    public static class KeywordExpr
    extends LiteralExpr {
        public final Keyword k;

        public KeywordExpr(Keyword k) {
            this.k = k;
        }

        @Override
        Object val() {
            return this.k;
        }

        @Override
        public Object eval() {
            return this.k;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitKeyword(gen, this.k);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Keyword.class;
        }
    }

    public static class TheVarExpr
    implements Expr {
        public final Var var;

        public TheVarExpr(Var var) {
            this.var = var;
        }

        @Override
        public Object eval() {
            return this.var;
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVar(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, false);
                if (v != null) {
                    return new TheVarExpr(v);
                }
                throw Util.runtimeException("Unable to resolve var: " + sym + " in this context");
            }
        }
    }

    public static class VarExpr
    implements Expr,
    AssignableExpr {
        public final Var var;
        public final Object tag;
        static final clojure.asm.commons.Method getMethod = clojure.asm.commons.Method.getMethod("Object get()");
        static final clojure.asm.commons.Method setMethod = clojure.asm.commons.Method.getMethod("Object set(Object)");

        public VarExpr(Var var, Symbol tag) {
            this.var = var;
            this.tag = tag != null ? tag : var.getTag();
        }

        @Override
        public Object eval() {
            return this.var.deref();
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVarValue(gen, this.var);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return this.tag != null;
        }

        @Override
        public Class getJavaClass() {
            return HostExpr.tagToClass(this.tag);
        }

        @Override
        public Object evalAssign(Expr val2) {
            return this.var.set(val2.eval());
        }

        @Override
        public void emitAssign(C context, ObjExpr objx, GeneratorAdapter gen, Expr val2) {
            objx.emitVar(gen, this.var);
            val2.emit(C.EXPRESSION, objx, gen);
            gen.invokeVirtual(VAR_TYPE, setMethod);
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }
    }

    public static class AssignExpr
    implements Expr {
        public final AssignableExpr target;
        public final Expr val;

        public AssignExpr(AssignableExpr target, Expr val2) {
            this.target = target;
            this.val = val2;
        }

        @Override
        public Object eval() {
            return this.target.evalAssign(this.val);
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            this.target.emitAssign(context, objx, gen, this.val);
        }

        @Override
        public boolean hasJavaClass() {
            return this.val.hasJavaClass();
        }

        @Override
        public Class getJavaClass() {
            return this.val.getJavaClass();
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object frm) {
                ISeq form = (ISeq)frm;
                if (RT.length(form) != 3) {
                    throw new IllegalArgumentException("Malformed assignment, expecting (set! target val)");
                }
                Expr target = Compiler.analyze(C.EXPRESSION, RT.second(form));
                if (!(target instanceof AssignableExpr)) {
                    throw new IllegalArgumentException("Invalid assignment target");
                }
                return new AssignExpr((AssignableExpr)((Object)target), Compiler.analyze(C.EXPRESSION, RT.third(form)));
            }
        }
    }

    static class DefExpr
    implements Expr {
        public final Var var;
        public final Expr init;
        public final Expr meta;
        public final boolean initProvided;
        public final boolean isDynamic;
        public final boolean shadowsCoreMapping;
        public final String source;
        public final int line;
        public final int column;
        static final clojure.asm.commons.Method bindRootMethod = clojure.asm.commons.Method.getMethod("void bindRoot(Object)");
        static final clojure.asm.commons.Method setTagMethod = clojure.asm.commons.Method.getMethod("void setTag(clojure.lang.Symbol)");
        static final clojure.asm.commons.Method setMetaMethod = clojure.asm.commons.Method.getMethod("void setMeta(clojure.lang.IPersistentMap)");
        static final clojure.asm.commons.Method setDynamicMethod = clojure.asm.commons.Method.getMethod("clojure.lang.Var setDynamic(boolean)");
        static final clojure.asm.commons.Method symintern = clojure.asm.commons.Method.getMethod("clojure.lang.Symbol intern(String, String)");
        static final clojure.asm.commons.Method internVar = clojure.asm.commons.Method.getMethod("clojure.lang.Var refer(clojure.lang.Symbol, clojure.lang.Var)");

        public DefExpr(String source2, int line, int column, Var var, Expr init, Expr meta, boolean initProvided, boolean isDynamic, boolean shadowsCoreMapping) {
            this.source = source2;
            this.line = line;
            this.column = column;
            this.var = var;
            this.init = init;
            this.meta = meta;
            this.isDynamic = isDynamic;
            this.shadowsCoreMapping = shadowsCoreMapping;
            this.initProvided = initProvided;
        }

        private boolean includesExplicitMetadata(MapExpr expr) {
            for (int i = 0; i < expr.keyvals.count(); i += 2) {
                Keyword k = ((KeywordExpr)expr.keyvals.nth((int)i)).k;
                if (k == RT.FILE_KEY || k == RT.DECLARED_KEY || k == RT.LINE_KEY || k == RT.COLUMN_KEY) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object eval() {
            try {
                if (this.initProvided) {
                    this.var.bindRoot(this.init.eval());
                }
                if (this.meta != null) {
                    IPersistentMap metaMap = (IPersistentMap)this.meta.eval();
                    if (!this.initProvided) {
                        // empty if block
                    }
                    this.var.setMeta(metaMap);
                }
                return this.var.setDynamic(this.isDynamic);
            }
            catch (Throwable e2) {
                if (!(e2 instanceof CompilerException)) {
                    throw new CompilerException(this.source, this.line, this.column, e2);
                }
                throw (CompilerException)e2;
            }
        }

        @Override
        public void emit(C context, ObjExpr objx, GeneratorAdapter gen) {
            objx.emitVar(gen, this.var);
            if (this.shadowsCoreMapping) {
                gen.dup();
                gen.getField(VAR_TYPE, "ns", NS_TYPE);
                gen.swap();
                gen.dup();
                gen.getField(VAR_TYPE, "sym", SYMBOL_TYPE);
                gen.swap();
                gen.invokeVirtual(NS_TYPE, internVar);
            }
            if (this.isDynamic) {
                gen.push(this.isDynamic);
                gen.invokeVirtual(VAR_TYPE, setDynamicMethod);
            }
            if (this.meta != null) {
                if (!this.initProvided) {
                    // empty if block
                }
                gen.dup();
                this.meta.emit(C.EXPRESSION, objx, gen);
                gen.checkCast(IPERSISTENTMAP_TYPE);
                gen.invokeVirtual(VAR_TYPE, setMetaMethod);
            }
            if (this.initProvided) {
                gen.dup();
                if (this.init instanceof FnExpr) {
                    ((FnExpr)this.init).emitForDefn(objx, gen);
                } else {
                    this.init.emit(C.EXPRESSION, objx, gen);
                }
                gen.invokeVirtual(VAR_TYPE, bindRootMethod);
            }
            if (context == C.STATEMENT) {
                gen.pop();
            }
        }

        @Override
        public boolean hasJavaClass() {
            return true;
        }

        @Override
        public Class getJavaClass() {
            return Var.class;
        }

        static class Parser
        implements IParser {
            Parser() {
            }

            @Override
            public Expr parse(C context, Object form) {
                Object source_path;
                IPersistentMap mm;
                boolean isDynamic;
                String docstring = null;
                if (RT.count(form) == 4 && RT.third(form) instanceof String) {
                    docstring = (String)RT.third(form);
                    form = RT.list(RT.first(form), RT.second(form), RT.fourth(form));
                }
                if (RT.count(form) > 3) {
                    throw Util.runtimeException("Too many arguments to def");
                }
                if (RT.count(form) < 2) {
                    throw Util.runtimeException("Too few arguments to def");
                }
                if (!(RT.second(form) instanceof Symbol)) {
                    throw Util.runtimeException("First argument to def must be a Symbol");
                }
                Symbol sym = (Symbol)RT.second(form);
                Var v = Compiler.lookupVar(sym, true);
                if (v == null) {
                    throw Util.runtimeException("Can't refer to qualified var that doesn't exist");
                }
                boolean shadowsCoreMapping = false;
                if (!v.ns.equals(Compiler.currentNS())) {
                    if (sym.ns == null) {
                        v = Compiler.currentNS().intern(sym);
                        shadowsCoreMapping = true;
                        Compiler.registerVar(v);
                    } else {
                        throw Util.runtimeException("Can't create defs outside of current ns");
                    }
                }
                if (isDynamic = RT.booleanCast(RT.get(mm = sym.meta(), dynamicKey))) {
                    v.setDynamic();
                }
                if (!isDynamic && sym.name.startsWith("*") && sym.name.endsWith("*") && sym.name.length() > 2) {
                    RT.errPrintWriter().format("Warning: %1$s not declared dynamic and thus is not dynamically rebindable, but its name suggests otherwise. Please either indicate ^:dynamic %1$s or change the name. (%2$s:%3$d)\n", sym, SOURCE_PATH.get(), LINE.get());
                }
                if (RT.booleanCast(RT.get(mm, arglistsKey))) {
                    IPersistentMap vm = v.meta();
                    vm = (IPersistentMap)RT.assoc(vm, arglistsKey, RT.second(mm.valAt(arglistsKey)));
                    v.setMeta(vm);
                }
                source_path = (source_path = SOURCE_PATH.get()) == null ? "NO_SOURCE_FILE" : source_path;
                mm = (IPersistentMap)RT.assoc(mm, RT.LINE_KEY, LINE.get()).assoc(RT.COLUMN_KEY, COLUMN.get()).assoc(RT.FILE_KEY, source_path);
                if (docstring != null) {
                    mm = (IPersistentMap)RT.assoc(mm, RT.DOC_KEY, docstring);
                }
                Expr meta = (mm = (IPersistentMap)Compiler.elideMeta(mm)).count() == 0 ? null : Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, mm);
                return new DefExpr((String)SOURCE.deref(), Compiler.lineDeref(), Compiler.columnDeref(), v, Compiler.analyze(context == C.EVAL ? context : C.EXPRESSION, RT.third(form), v.sym.name), meta, RT.count(form) == 3, isDynamic, shadowsCoreMapping);
            }
        }
    }

    static interface IParser {
        public Expr parse(C var1, Object var2);
    }

    public static abstract class UntypedExpr
    implements Expr {
        @Override
        public Class getJavaClass() {
            throw new IllegalArgumentException("Has no Java class");
        }

        @Override
        public boolean hasJavaClass() {
            return false;
        }
    }

    static interface Expr {
        public Object eval();

        public void emit(C var1, ObjExpr var2, GeneratorAdapter var3);

        public boolean hasJavaClass();

        public Class getJavaClass();
    }

    private class Recur {
        private Recur() {
        }
    }

    public static enum C {
        STATEMENT,
        EXPRESSION,
        RETURN,
        EVAL;

    }
}

