/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.IntrospectionConfiguration;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.expression.DynaBeanExpression;
import org.apache.commons.betwixt.expression.DynaBeanUpdater;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.betwixt.strategy.SimpleTypeMapper;
import org.apache.commons.betwixt.strategy.TypeBindingStrategy;
import org.apache.commons.logging.Log;

public class BeanProperty {
    private final String propertyName;
    private final Class propertyType;
    private Expression propertyExpression;
    private Updater propertyUpdater;
    static /* synthetic */ Class class$java$util$Map;

    public BeanProperty(String propertyName, Class propertyType, Expression propertyExpression, Updater propertyUpdater) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.propertyExpression = propertyExpression;
        this.propertyUpdater = propertyUpdater;
    }

    public BeanProperty(PropertyDescriptor descriptor) {
        Method writeMethod;
        this.propertyName = descriptor.getName();
        this.propertyType = descriptor.getPropertyType();
        Method readMethod = descriptor.getReadMethod();
        if (readMethod != null) {
            this.propertyExpression = new MethodExpression(readMethod);
        }
        if ((writeMethod = descriptor.getWriteMethod()) != null) {
            this.propertyUpdater = new MethodUpdater(writeMethod);
        }
    }

    public BeanProperty(DynaProperty dynaProperty) {
        this.propertyName = dynaProperty.getName();
        this.propertyType = dynaProperty.getType();
        this.propertyExpression = new DynaBeanExpression(this.propertyName);
        this.propertyUpdater = new DynaBeanUpdater(this.propertyName, this.propertyType);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Expression getPropertyExpression() {
        return this.propertyExpression;
    }

    public Updater getPropertyUpdater() {
        return this.propertyUpdater;
    }

    public Descriptor createXMLDescriptor(IntrospectionConfiguration configuration) {
        TypeBindingStrategy.BindingType bindingType;
        Log log = configuration.getIntrospectionLog();
        if (log.isTraceEnabled()) {
            log.trace("Creating descriptor for property: name=" + this.getPropertyName() + " type=" + this.getPropertyType());
        }
        NodeDescriptor descriptor = null;
        Expression propertyExpression = this.getPropertyExpression();
        Updater propertyUpdater = this.getPropertyUpdater();
        if (propertyExpression == null) {
            if (log.isTraceEnabled()) {
                log.trace("No read method for property: name=" + this.getPropertyName() + " type=" + this.getPropertyType());
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Property expression=" + propertyExpression);
        }
        if ((bindingType = configuration.getTypeBindingStrategy().bindingType(this.getPropertyType())).equals(TypeBindingStrategy.BindingType.PRIMITIVE)) {
            descriptor = this.createDescriptorForPrimitive(configuration, propertyExpression, propertyUpdater);
        } else if (configuration.isLoopType(this.getPropertyType())) {
            if (log.isTraceEnabled()) {
                log.trace("Loop type: " + this.getPropertyName());
                log.trace("Wrap in collections? " + configuration.isWrapCollectionsInElement());
            }
            descriptor = (class$java$util$Map == null ? (class$java$util$Map = BeanProperty.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.getPropertyType()) ? this.createDescriptorForMap(configuration, propertyExpression) : this.createDescriptorForCollective(configuration, propertyUpdater, propertyExpression);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Standard property: " + this.getPropertyName());
            }
            descriptor = this.createDescriptorForStandard(propertyExpression, propertyUpdater, configuration);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created descriptor:");
            log.trace(descriptor);
        }
        return descriptor;
    }

    private void configureDescriptor(NodeDescriptor descriptor, IntrospectionConfiguration configuration) {
        NameMapper nameMapper = configuration.getElementNameMapper();
        if (descriptor instanceof AttributeDescriptor) {
            nameMapper = configuration.getAttributeNameMapper();
        }
        descriptor.setLocalName(nameMapper.mapTypeToElementName(this.propertyName));
        descriptor.setPropertyName(this.getPropertyName());
        descriptor.setPropertyType(this.getPropertyType());
    }

    private ElementDescriptor createDescriptorForStandard(Expression propertyExpression, Updater propertyUpdater, IntrospectionConfiguration configuration) {
        ElementDescriptor elementDescriptor = new ElementDescriptor();
        elementDescriptor.setContextExpression(propertyExpression);
        if (propertyUpdater != null) {
            elementDescriptor.setUpdater(propertyUpdater);
        }
        elementDescriptor.setHollow(true);
        ElementDescriptor result = elementDescriptor;
        this.configureDescriptor(result, configuration);
        return result;
    }

    private ElementDescriptor createDescriptorForMap(IntrospectionConfiguration configuration, Expression propertyExpression) {
        ElementDescriptor result;
        ElementDescriptor entryDescriptor = new ElementDescriptor();
        entryDescriptor.setContextExpression(new IteratorExpression(propertyExpression));
        entryDescriptor.setLocalName("entry");
        entryDescriptor.setPropertyName(this.getPropertyName());
        entryDescriptor.setPropertyType(this.getPropertyType());
        ElementDescriptor keyDescriptor = new ElementDescriptor("key");
        keyDescriptor.setHollow(true);
        entryDescriptor.addElementDescriptor(keyDescriptor);
        ElementDescriptor valueDescriptor = new ElementDescriptor("value");
        valueDescriptor.setHollow(true);
        entryDescriptor.addElementDescriptor(valueDescriptor);
        if (configuration.isWrapCollectionsInElement()) {
            ElementDescriptor wrappingDescriptor = new ElementDescriptor();
            wrappingDescriptor.setElementDescriptors(new ElementDescriptor[]{entryDescriptor});
            NameMapper nameMapper = configuration.getElementNameMapper();
            wrappingDescriptor.setLocalName(nameMapper.mapTypeToElementName(this.propertyName));
            result = wrappingDescriptor;
        } else {
            result = entryDescriptor;
        }
        result.setCollective(true);
        return result;
    }

    private ElementDescriptor createDescriptorForCollective(IntrospectionConfiguration configuration, Updater propertyUpdater, Expression propertyExpression) {
        ElementDescriptor result;
        ElementDescriptor loopDescriptor = new ElementDescriptor();
        loopDescriptor.setContextExpression(new IteratorExpression(propertyExpression));
        loopDescriptor.setPropertyName(this.getPropertyName());
        loopDescriptor.setPropertyType(this.getPropertyType());
        loopDescriptor.setHollow(true);
        loopDescriptor.setUpdater(propertyUpdater);
        loopDescriptor.setCollective(true);
        if (configuration.isWrapCollectionsInElement()) {
            ElementDescriptor wrappingDescriptor = new ElementDescriptor();
            wrappingDescriptor.setElementDescriptors(new ElementDescriptor[]{loopDescriptor});
            wrappingDescriptor.setLocalName(configuration.getElementNameMapper().mapTypeToElementName(this.propertyName));
            result = wrappingDescriptor;
        } else {
            result = loopDescriptor;
        }
        return result;
    }

    private NodeDescriptor createDescriptorForPrimitive(IntrospectionConfiguration configuration, Expression propertyExpression, Updater propertyUpdater) {
        NodeDescriptor descriptor;
        SimpleTypeMapper.Binding binding;
        Log log = configuration.getIntrospectionLog();
        if (log.isTraceEnabled()) {
            log.trace("Primitive type: " + this.getPropertyName());
        }
        if (SimpleTypeMapper.Binding.ATTRIBUTE.equals(binding = configuration.getSimpleTypeMapper().bind(this.propertyName, this.propertyType, configuration))) {
            if (log.isTraceEnabled()) {
                log.trace("Adding property as attribute: " + this.getPropertyName());
            }
            descriptor = new AttributeDescriptor();
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Adding property as element: " + this.getPropertyName());
            }
            descriptor = new ElementDescriptor();
        }
        descriptor.setTextExpression(propertyExpression);
        if (propertyUpdater != null) {
            descriptor.setUpdater(propertyUpdater);
        }
        this.configureDescriptor(descriptor, configuration);
        return descriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

