/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.TextDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.MappingAction;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class BeanBindAction
extends MappingAction.Base {
    public static final BeanBindAction INSTANCE = new BeanBindAction();
    static /* synthetic */ Class class$java$util$Map;

    public MappingAction begin(String namespace, String name, Attributes attributes, ReadContext context) throws Exception {
        Log log = context.getLog();
        ElementDescriptor computedDescriptor = context.getCurrentDescriptor();
        if (log.isTraceEnabled()) {
            log.trace("Element Pushed: " + name);
        }
        MappingAction action = MappingAction.EMPTY;
        Object instance = null;
        Class<?> beanClass = null;
        if (computedDescriptor == null) {
            log.trace("No Descriptor");
        } else {
            beanClass = computedDescriptor.getSingularPropertyType();
        }
        if (beanClass != null && !(class$java$util$Map == null ? (class$java$util$Map = BeanBindAction.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(beanClass) && (instance = this.createBean(namespace, name, attributes, computedDescriptor, context)) != null) {
            String id;
            action = this;
            if (computedDescriptor.isUseBindTimeTypeForMapping()) {
                beanClass = instance.getClass();
            }
            context.markClassMap(beanClass);
            if (log.isTraceEnabled()) {
                log.trace("Marked: " + beanClass);
            }
            context.pushBean(instance);
            ElementDescriptor typeDescriptor = this.getElementDescriptor(computedDescriptor, context);
            AttributeDescriptor[] attributeDescriptors = typeDescriptor.getAttributeDescriptors();
            context.populateAttributes(attributeDescriptors, attributes);
            if (log.isTraceEnabled()) {
                log.trace("Created bean " + instance);
            }
            if (context.getMapIDs() && (id = attributes.getValue("id")) != null) {
                context.putBean(id, instance);
            }
        }
        return action;
    }

    public void body(String text, ReadContext context) throws Exception {
        Log log = context.getLog();
        ElementDescriptor currentDescriptor = context.getCurrentDescriptor();
        if (currentDescriptor == null) {
            if (log.isTraceEnabled()) {
                log.trace("path descriptor is null:");
            }
        } else {
            TextDescriptor bodyTextdescriptor = currentDescriptor.getPrimaryBodyTextDescriptor();
            if (bodyTextdescriptor != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Setting mixed content for:");
                    log.trace(bodyTextdescriptor);
                }
                Updater updater = bodyTextdescriptor.getUpdater();
                if (log.isTraceEnabled()) {
                    log.trace("Updating mixed content with:");
                    log.trace(updater);
                }
                if (updater != null && text != null) {
                    updater.update(context, text);
                }
            }
        }
    }

    public void end(ReadContext context) throws Exception {
        Object instance = context.popBean();
        this.update(context, instance);
    }

    private void update(ReadContext context, Object value) throws Exception {
        Log log = context.getLog();
        Updater updater = context.getCurrentUpdater();
        if (updater == null) {
            if (context.getLog().isTraceEnabled()) {
                context.getLog().trace("No updater for " + context.getCurrentElement());
            }
        } else {
            updater.update(context, value);
        }
        String poppedElement = context.popElement();
    }

    protected Object createBean(String namespace, String name, Attributes attributes, ElementDescriptor descriptor, ReadContext context) {
        ElementMapping mapping = new ElementMapping();
        Class<?> beanClass = descriptor.getSingularPropertyType();
        if (beanClass != null && beanClass.isArray()) {
            beanClass = beanClass.getComponentType();
        }
        mapping.setType(beanClass);
        mapping.setNamespace(namespace);
        mapping.setName(name);
        mapping.setAttributes(attributes);
        mapping.setDescriptor(descriptor);
        Object newInstance = context.getBeanCreationChain().create(mapping, context);
        return newInstance;
    }

    private ElementDescriptor getElementDescriptor(ElementDescriptor propertyDescriptor, ReadContext context) {
        Object current;
        Log log = context.getLog();
        Class<?> beanClass = propertyDescriptor.getSingularPropertyType();
        if (propertyDescriptor.isUseBindTimeTypeForMapping() && (current = context.getBean()) != null) {
            beanClass = current.getClass();
        }
        if (beanClass != null && !(class$java$util$Map == null ? (class$java$util$Map = BeanBindAction.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(beanClass)) {
            if (beanClass.isArray()) {
                beanClass = beanClass.getComponentType();
            }
            if (log.isTraceEnabled()) {
                log.trace("Filling descriptor for: " + beanClass);
            }
            try {
                XMLBeanInfo xmlInfo = context.getXMLIntrospector().introspect(beanClass);
                return xmlInfo.getElementDescriptor();
            }
            catch (Exception e) {
                log.warn("Could not introspect class: " + beanClass, e);
            }
        }
        return propertyDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

