/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.providers.ssh.ScpHelper;
import org.apache.maven.wagon.providers.ssh.jsch.AbstractJschWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.IOUtil;

public class ScpWagon
extends AbstractJschWagon {
    private static final char COPY_START_CHAR = 'C';
    private static final char ACK_SEPARATOR = ' ';
    private static final String END_OF_FILES_MSG = "E\n";
    private static final int LINE_BUFFER_SIZE = 8192;
    private static final byte LF = 10;

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        Resource resource = AbstractSshWagon.getResource(destination);
        String dir = AbstractSshWagon.getResourceDirectory(resource.getName());
        this.firePutInitiated(resource, source);
        ScpHelper.createRemoteDirectories(AbstractWagon.getPath(basedir, dir), this.getRepository().getPermissions(), this);
        RepositoryPermissions permissions = this.getRepository().getPermissions();
        this.put(source, basedir, resource, this.getOctalMode(permissions));
        this.setFileGroup(permissions, basedir, resource);
    }

    private void setFileGroup(RepositoryPermissions permissions, String basedir, Resource resource) throws TransferFailedException {
        try {
            if (permissions != null && permissions.getGroup() != null) {
                this.executeCommand("chgrp -f " + permissions.getGroup() + " " + AbstractWagon.getPath(basedir, resource.getName()));
            }
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", e);
        }
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        this.get(basedir, resource, destination);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(File source, String basedir, Resource resource, String octalMode) throws TransferFailedException {
        String path = AbstractWagon.getPath(basedir, resource.getName());
        String resourceName = resource.getName();
        Channel channel = null;
        OutputStream out = null;
        try {
            try {
                String command = "scp -t " + path;
                this.fireTransferDebug("Executing command: " + command);
                channel = (ChannelExec)this.session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                this.checkAck(in);
                long filesize = source.length();
                command = "C" + octalMode + " " + filesize + " ";
                command = resourceName.lastIndexOf(47) > 0 ? command + resourceName.substring(resourceName.lastIndexOf(47) + 1) : command + resourceName;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                this.checkAck(in);
                this.putTransfer(resource, source, out, false);
                ScpWagon.sendEom(out);
                this.checkAck(in);
                out.write(END_OF_FILES_MSG.getBytes());
                out.flush();
            }
            catch (IOException e) {
                String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                throw new TransferFailedException(msg, e);
            }
            catch (JSchException e) {
                String msg = "Error occured while deploying '" + resourceName + "' to remote repository: " + this.getRepository().getUrl();
                throw new TransferFailedException(msg, e);
            }
            Object var14_16 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (channel == null) throw throwable;
            IOUtil.close(out);
            channel.disconnect();
            throw throwable;
        }
        IOUtil.close(out);
        channel.disconnect();
    }

    private void checkAck(InputStream in) throws IOException, TransferFailedException {
        int code = in.read();
        if (code == -1) {
            throw new TransferFailedException("Unexpected end of data");
        }
        if (code == 1) {
            String line = this.readLine(in);
            throw new TransferFailedException("SCP terminated with error: '" + line + "'");
        }
        if (code == 2) {
            throw new TransferFailedException("SCP terminated with error (code: " + code + ")");
        }
        if (code != 0) {
            throw new TransferFailedException("SCP terminated with unknown error code");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void get(String basedir, Resource resource, File destination) throws ResourceDoesNotExistException, TransferFailedException {
        String path = AbstractWagon.getPath(basedir, resource.getName());
        OutputStream out = null;
        Channel channel = null;
        try {
            try {
                String cmd = "scp -f " + path;
                this.fireTransferDebug("Executing command: " + cmd);
                channel = (ChannelExec)this.session.openChannel("exec");
                ((ChannelExec)channel).setCommand(cmd);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                ScpWagon.sendEom(out);
                int exitCode = in.read();
                if (exitCode == 80) {
                    exitCode = in.read();
                }
                String line = this.readLine(in);
                if (exitCode != 67) {
                    if (exitCode != 1) throw new TransferFailedException("Exit code: " + exitCode + " - " + line);
                    if (!line.endsWith("No such file or directory")) throw new TransferFailedException("Exit code: " + exitCode + " - " + line);
                    throw new ResourceDoesNotExistException(line);
                }
                if (line == null) {
                    throw new EOFException("Unexpected end of data");
                }
                String perms = line.substring(0, 4);
                this.fireTransferDebug("Remote file permissions: " + perms);
                if (line.charAt(4) != ' ' && line.charAt(5) != ' ') {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int index = line.indexOf(32, 5);
                if (index < 0) {
                    throw new TransferFailedException("Invalid transfer header: " + line);
                }
                int filesize = Integer.valueOf(line.substring(5, index));
                this.fireTransferDebug("Remote file size: " + filesize);
                resource.setContentLength(filesize);
                String filename = line.substring(index + 1);
                this.fireTransferDebug("Remote filename: " + filename);
                ScpWagon.sendEom(out);
                this.getTransfer(resource, destination, in, false, filesize);
                if (destination.length() != (long)filesize) {
                    throw new TransferFailedException("Expected file length: " + filesize + "; received = " + destination.length());
                }
                this.checkAck(in);
                ScpWagon.sendEom(out);
            }
            catch (JSchException e) {
                this.handleGetException(resource, e, destination);
                Object var16_18 = null;
                IOUtil.close(out);
                if (channel == null) return;
                channel.disconnect();
                return;
            }
            catch (IOException e) {
                this.handleGetException(resource, e, destination);
                Object var16_19 = null;
                IOUtil.close(out);
                if (channel == null) return;
                channel.disconnect();
                return;
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            IOUtil.close(out);
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        IOUtil.close(out);
        if (channel == null) return;
        channel.disconnect();
    }

    protected String readLine(InputStream in) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote server sent a too long line");
            }
            int c = in.read();
            if (c < 0) {
                throw new IOException("Remote connection terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected static void sendEom(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }
}

