/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractExecMojo
extends AbstractMojo {
    protected MavenProject project;
    private File sourceRoot;
    private File testSourceRoot;
    private String commandlineArgs;
    protected String classpathScope;
    private boolean skip;

    protected void collectProjectArtifactsAndClasspath(List artifacts, List theClasspathFiles) {
        if ("compile".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getCompileArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("test".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getTestArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getTestOutputDirectory()));
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("runtime".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getRuntimeArtifacts());
            theClasspathFiles.add(new File(this.project.getBuild().getOutputDirectory()));
        } else if ("system".equals(this.classpathScope)) {
            artifacts.addAll(this.project.getSystemArtifacts());
        } else {
            throw new IllegalStateException("Invalid classpath scope: " + this.classpathScope);
        }
        this.getLog().debug("Collected project artifacts " + artifacts);
        this.getLog().debug("Collected project classpath " + theClasspathFiles);
    }

    protected String[] parseCommandlineArgs() throws MojoExecutionException {
        if (this.commandlineArgs == null) {
            return null;
        }
        try {
            return CommandLineUtils.translateCommandline(this.commandlineArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected boolean hasCommandlineArgs() {
        return this.commandlineArgs != null;
    }

    protected void registerSourceRoots() {
        if (this.sourceRoot != null) {
            this.getLog().info("Registering compile source root " + this.sourceRoot);
            this.project.addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info("Registering compile test source root " + this.testSourceRoot);
            this.project.addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    protected boolean isSkip() {
        return this.skip;
    }
}

