/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.Persistable;
import krati.array.DataArray;
import krati.array.LongArray;
import krati.core.array.AddressArray;
import krati.core.array.SimpleDataArrayCompactor;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryPersistAdapter;
import krati.core.array.entry.EntryValue;
import krati.core.segment.AddressFormat;
import krati.core.segment.Segment;
import krati.core.segment.SegmentException;
import krati.core.segment.SegmentManager;
import krati.core.segment.SegmentOverflowException;
import org.apache.log4j.Logger;

public class SimpleDataArray
implements DataArray,
Persistable {
    private static final Logger _log = Logger.getLogger(SimpleDataArray.class);
    protected volatile Segment _segment;
    protected final AddressFormat _addressFormat;
    protected final AddressArray _addressArray;
    protected final SegmentManager _segmentManager;
    protected final SimpleDataArrayCompactor _compactor;
    protected final double _segmentCompactFactor;
    private long _metaUpdateOnAppendPosition = 128L;

    public SimpleDataArray(AddressArray addressArray, SegmentManager segmentManager) {
        this(addressArray, segmentManager, 0.5);
    }

    public SimpleDataArray(AddressArray addressArray, SegmentManager segmentManager, double segmentCompactFactor) {
        this._addressArray = addressArray;
        this._segmentManager = segmentManager;
        this._segmentCompactFactor = segmentCompactFactor;
        this._addressFormat = new AddressFormat();
        addressArray.setPersistListener(new SegmentPersistListener());
        this._compactor = new SimpleDataArrayCompactor(this, this.getSegmentCompactFactor());
        this._compactor.start();
        this.init();
    }

    private void consumeCompaction(SimpleDataArrayCompactor.CompactionUpdateBatch updateBatch) throws Exception {
        int ignoreCount = 0;
        int updateCount = updateBatch.size();
        int totalIgnoreBytes = 0;
        int totalUpdateBytes = updateBatch.getDataSizeTotal();
        Segment segTarget = updateBatch.getTargetSegment();
        for (int i = 0; i < updateCount; ++i) {
            int index = updateBatch.getUpdateIndex(i);
            long origAddr = updateBatch.getOriginDataAddr(i);
            long currAddr = this.getAddress(index);
            if (currAddr == 0L || currAddr != origAddr) {
                int updateBytes = updateBatch.getUpdateDataSize(i);
                totalIgnoreBytes += updateBytes;
                ++ignoreCount;
                continue;
            }
            this.setCompactionAddress(index, updateBatch.getUpdateDataAddr(i), updateBatch.getLWMark());
        }
        int consumeCount = updateCount - ignoreCount;
        int totalConsumeBytes = totalUpdateBytes - totalIgnoreBytes;
        _log.info((Object)("consumed compaction batch " + updateBatch.getDescriptiveId() + " updates " + consumeCount + "/" + updateCount + " bytes " + totalConsumeBytes + "/" + totalUpdateBytes));
        segTarget.decrLoadSize(totalIgnoreBytes);
        _log.info((Object)("Segment " + segTarget.getSegmentId() + " catchup " + segTarget.getStatus()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean consumeCompactionBatch() {
        SimpleDataArrayCompactor.CompactionUpdateBatch updateBatch = this._compactor.pollCompactionBatch();
        if (updateBatch != null) {
            try {
                this.consumeCompaction(updateBatch);
            }
            catch (Exception e) {
                _log.error((Object)("failed to consume compaction batch " + updateBatch.getDescriptiveId()), (Throwable)e);
            }
            finally {
                this._compactor.recycleCompactionBatch(updateBatch);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeCompactionBatches() {
        SimpleDataArrayCompactor.CompactionUpdateBatch updateBatch;
        while ((updateBatch = this._compactor.pollCompactionBatch()) != null) {
            try {
                this.consumeCompaction(updateBatch);
            }
            catch (Exception e) {
                _log.error((Object)("failed to consume compaction batch " + updateBatch.getDescriptiveId()), (Throwable)e);
            }
            finally {
                this._compactor.recycleCompactionBatch(updateBatch);
            }
        }
    }

    protected void syncCompactor() {
        ConcurrentLinkedQueue<Segment> queue = this._compactor.getCompactedQueue();
        while (!queue.isEmpty()) {
            Segment seg = (Segment)queue.remove();
            try {
                this.consumeCompactionBatches();
                this._segmentManager.freeSegment(seg);
            }
            catch (IOException e) {
                _log.error((Object)("failed to free Segment " + seg.getSegmentId() + ": " + seg.getStatus()), (Throwable)e);
            }
        }
        this.consumeCompactionBatches();
    }

    protected void init() {
        try {
            this._metaUpdateOnAppendPosition = 128L;
            this._segment = this._segmentManager.nextSegment();
            this._compactor.startsCycle();
            _log.info((Object)("Segment " + this._segment.getSegmentId() + " online: " + this._segment.getStatus()));
        }
        catch (IOException ioe) {
            _log.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new SegmentException("Instantiation failed due to " + ioe.getMessage());
        }
    }

    protected long getAddress(int index) {
        return this._addressArray.get(index);
    }

    protected void setAddress(int index, long value, long scn) throws Exception {
        this._addressArray.set(index, value, scn);
    }

    protected void setCompactionAddress(int index, long value, long scn) throws Exception {
        this._addressArray.setCompactionAddress(index, value, scn);
    }

    protected LongArray getAddressArray() {
        return this._addressArray;
    }

    protected double getSegmentCompactFactor() {
        return this._segmentCompactFactor;
    }

    protected SegmentManager getSegmentManager() {
        return this._segmentManager;
    }

    protected Segment getCurrentSegment() {
        return this._segment;
    }

    protected void decrOriginalSegmentLoad(int index) {
        try {
            Segment seg;
            long address = this.getAddress(index);
            int segPos = this._addressFormat.getOffset(address);
            int segInd = this._addressFormat.getSegment(address);
            int length = this._addressFormat.getDataSize(address);
            if (segPos >= 128 && (seg = this._segmentManager.getSegment(segInd)) != null) {
                seg.decrLoadSize(4 + (length == 0 ? seg.readInt(segPos) : length));
            }
        }
        catch (IOException e1) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private final void doThrottling(int lastWriteSize) {
        Segment writerSegment = this._segment;
        if (writerSegment == null) {
            return;
        }
        Segment compactorTarget = this._compactor.getTargetSegment();
        if (compactorTarget == null || compactorTarget == writerSegment) {
            return;
        }
        int writerLoadSize = writerSegment.getLoadSize();
        int targetLoadSize = compactorTarget.getLoadSize();
        if (targetLoadSize < writerLoadSize) {
            long totalWait = 1L;
            long startTime = System.currentTimeMillis();
            targetLoadSize += targetLoadSize == 0 ? lastWriteSize * 2 : (int)((double)writerLoadSize / (double)targetLoadSize * (double)lastWriteSize);
            while (compactorTarget.getLoadSize() < targetLoadSize) {
                long elapsedTime;
                if (!this.consumeCompactionBatch()) {
                    try {
                        Thread.sleep(0L, 200000);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((elapsedTime = System.currentTimeMillis() - startTime) < 1L) continue;
                _log.info((Object)("throttle " + elapsedTime + " ms"));
                return;
            }
        }
    }

    private final void rangeCheck(int index) {
        if (!this._addressArray.hasIndex(index)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public boolean hasData(int index) {
        this.rangeCheck(index);
        long address = this.getAddress(index);
        int segPos = this._addressFormat.getOffset(address);
        int segInd = this._addressFormat.getSegment(address);
        if (segPos < 128) {
            return false;
        }
        Segment seg = this._segmentManager.getSegment(segInd);
        return seg != null;
    }

    public int getLength(int index) {
        try {
            long address = this.getAddress(index);
            int segPos = this._addressFormat.getOffset(address);
            int segInd = this._addressFormat.getSegment(address);
            if (segPos < 128) {
                return -1;
            }
            Segment seg = this._segmentManager.getSegment(segInd);
            if (seg == null) {
                return -1;
            }
            int size = this._addressFormat.getDataSize(address);
            return size == 0 ? seg.readInt(segPos) : size;
        }
        catch (Exception e) {
            _log.warn((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public byte[] get(int index) {
        this.rangeCheck(index);
        try {
            long address = this.getAddress(index);
            int segPos = this._addressFormat.getOffset(address);
            int segInd = this._addressFormat.getSegment(address);
            if (segPos < 128) {
                return null;
            }
            Segment seg = this._segmentManager.getSegment(segInd);
            if (seg == null) {
                return null;
            }
            int size = this._addressFormat.getDataSize(address);
            int len = size == 0 ? seg.readInt(segPos) : size;
            byte[] data = new byte[len];
            if (len > 0) {
                seg.read(segPos + 4, data);
            }
            return data;
        }
        catch (Exception e) {
            _log.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int get(int index, byte[] data) {
        return this.get(index, data, 0);
    }

    public int get(int index, byte[] data, int offset) {
        this.rangeCheck(index);
        try {
            int len;
            long address = this.getAddress(index);
            int segPos = this._addressFormat.getOffset(address);
            int segInd = this._addressFormat.getSegment(address);
            if (segPos < 128) {
                return -1;
            }
            Segment seg = this._segmentManager.getSegment(segInd);
            if (seg == null) {
                return -1;
            }
            int size = this._addressFormat.getDataSize(address);
            int n = len = size == 0 ? seg.readInt(segPos) : size;
            if (len > 0) {
                seg.read(segPos + 4, data, offset, len);
            }
            return len;
        }
        catch (Exception e) {
            _log.warn((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int transferTo(int index, WritableByteChannel channel) {
        this.rangeCheck(index);
        try {
            int len;
            long address = this.getAddress(index);
            int segPos = this._addressFormat.getOffset(address);
            int segInd = this._addressFormat.getSegment(address);
            if (segPos < 128) {
                return -1;
            }
            Segment seg = this._segmentManager.getSegment(segInd);
            if (seg == null) {
                return -1;
            }
            int size = this._addressFormat.getDataSize(address);
            int n = len = size == 0 ? seg.readInt(segPos) : size;
            if (len > 0) {
                seg.transferTo(segPos + 4, len, channel);
            }
            return len;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void set(int index, byte[] data, long scn) throws Exception {
        if (data == null) {
            this.set(index, data, 0, 0, scn);
        } else {
            this.set(index, data, 0, data.length, scn);
        }
    }

    public void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this.rangeCheck(index);
        this.decrOriginalSegmentLoad(index);
        if (data == null) {
            this.setAddress(index, 0L, scn);
            return;
        }
        if (offset > data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException(data.length);
        }
        while (true) {
            long pos = this._segment.getAppendPosition();
            try {
                if (pos >> this._addressFormat.getSegmentShift() > 0L) {
                    throw new SegmentOverflowException(this._segment);
                }
                this._segment.appendInt(length);
                if (length > 0) {
                    this._segment.append(data, offset, length);
                }
                long address = this._addressFormat.composeAddress((int)pos, this._segment.getSegmentId(), length);
                this.setAddress(index, address, scn);
                if (pos >= this._metaUpdateOnAppendPosition) {
                    this._segmentManager.updateMeta();
                    this._metaUpdateOnAppendPosition = this._segment.getInitialSize();
                }
                if (this._compactor.isStarted()) {
                    this.consumeCompactionBatch();
                    this.doThrottling(length + 4);
                }
                return;
            }
            catch (SegmentOverflowException soe) {
                _log.info((Object)("Segment " + this._segment.getSegmentId() + " filled: " + this._segment.getStatus()));
                Segment nextSegment = this._compactor.peekTargetSegment();
                if (nextSegment != null) {
                    this.persist();
                    this._segment = nextSegment;
                    this._compactor.pollTargetSegment();
                    this._metaUpdateOnAppendPosition = this._segment.getInitialSize();
                    _log.info((Object)"nextSegment from compactor");
                    _log.info((Object)("Segment " + this._segment.getSegmentId() + " online: " + this._segment.getStatus()));
                    continue;
                }
                if (this._compactor.isStarted()) {
                    if (this._compactor.getAndDecrementSegmentPermit()) {
                        _log.info((Object)"nextSegment permit granted");
                        this.persist();
                        this._metaUpdateOnAppendPosition = 128L;
                        this._segment = this._segmentManager.nextSegment();
                        _log.info((Object)("Segment " + this._segment.getSegmentId() + " online: " + this._segment.getStatus()));
                        continue;
                    }
                    _log.info((Object)"nextSegment permit refused");
                    while (this._compactor.isStarted()) {
                        this.consumeCompactionBatch();
                        _log.info((Object)"wait for compactor");
                        Thread.sleep(10L);
                    }
                    this.persist();
                    this._segment = this._compactor.pollTargetSegment();
                    if (this._segment == null) {
                        this._segment = this._segmentManager.nextSegment();
                        this._metaUpdateOnAppendPosition = 128L;
                    } else {
                        this._metaUpdateOnAppendPosition = this._segment.getInitialSize();
                    }
                    _log.info((Object)("Segment " + this._segment.getSegmentId() + " online: " + this._segment.getStatus()));
                    continue;
                }
                _log.info((Object)"nextSegment");
                this.persist();
                this._metaUpdateOnAppendPosition = 128L;
                this._segment = this._segmentManager.nextSegment();
                this._compactor.startsCycle();
                _log.info((Object)("Segment " + this._segment.getSegmentId() + " online: " + this._segment.getStatus()));
                continue;
            }
            catch (Exception e) {
                this._segment.setAppendPosition(pos);
                this._segment.force();
                throw e;
            }
            break;
        }
    }

    public boolean hasIndex(int index) {
        return this._addressArray.hasIndex(index);
    }

    public int length() {
        return this._addressArray.length();
    }

    public long getHWMark() {
        return this._addressArray.getHWMark();
    }

    public long getLWMark() {
        return this._addressArray.getLWMark();
    }

    public void saveHWMark(long endOfPeriod) throws Exception {
        this._addressArray.saveHWMark(endOfPeriod);
    }

    public synchronized void sync() throws IOException {
        this.syncCompactor();
        this._segment.force();
        this._addressArray.sync();
        this._segmentManager.updateMeta();
    }

    public synchronized void persist() throws IOException {
        this.syncCompactor();
        this._segment.force();
        this._addressArray.persist();
        this._segmentManager.updateMeta();
    }

    public synchronized void clear() {
        this._compactor.reset();
        this._addressArray.clear();
        this._segmentManager.clear();
        this.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SegmentPersistListener
    extends EntryPersistAdapter {
        private SegmentPersistListener() {
        }

        @Override
        public void beforePersist(Entry<? extends EntryValue> e) throws IOException {
            if (SimpleDataArray.this._segment != null) {
                SimpleDataArray.this._segment.force();
            }
        }

        @Override
        public void afterPersist(Entry<? extends EntryValue> e) throws IOException {
            if (SimpleDataArray.this._segmentManager != null) {
                SimpleDataArray.this._segmentManager.updateMeta();
            }
        }
    }
}

