/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import java.util.List;
import krati.core.array.basic.ArrayEntryManager;
import krati.core.array.basic.ArrayFile;
import krati.core.array.basic.RecoverableArray;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryFactory;
import krati.core.array.entry.EntryValue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRecoverableArray<V extends EntryValue>
implements RecoverableArray<V> {
    static final Logger _log = Logger.getLogger(RecoverableArray.class);
    protected int _length;
    protected File _directory;
    protected ArrayFile _arrayFile;
    protected EntryFactory<V> _entryFactory;
    protected ArrayEntryManager<V> _entryManager;

    protected AbstractRecoverableArray(int length, int elemSize, int entrySize, int maxEntries, File directory, EntryFactory<V> entryFactory) throws Exception {
        this._length = length;
        this._directory = directory;
        this._entryFactory = entryFactory;
        this._entryManager = new ArrayEntryManager(this, maxEntries, entrySize);
        if (!this._directory.exists()) {
            this._directory.mkdirs();
        }
        File file = new File(directory, "indexes.dat");
        this._arrayFile = this.openArrayFile(file, length, elemSize);
        this._length = this._arrayFile.getArrayLength();
        this.init();
        _log.info((Object)("length:" + this._length + " entrySize:" + entrySize + " maxEntries:" + maxEntries + " directory:" + directory.getAbsolutePath() + " arrayFile:" + this._arrayFile.getName()));
    }

    protected void init() throws IOException {
        try {
            long lwmScn = this._arrayFile.getLwmScn();
            long hwmScn = this._arrayFile.getHwmScn();
            if (hwmScn < lwmScn) {
                throw new IOException(this._arrayFile.getAbsolutePath() + " is corrupted: lwmScn=" + lwmScn + " hwmScn=" + hwmScn);
            }
            this._entryManager.init(lwmScn, hwmScn);
            this.loadArrayFileData();
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected final ArrayFile openArrayFile(File file, int initialLength, int elementSize) throws IOException {
        boolean isNew = true;
        if (file.exists()) {
            isNew = false;
        }
        ArrayFile arrayFile = new ArrayFile(file, initialLength, elementSize);
        if (isNew) {
            this.initArrayFile();
        }
        return arrayFile;
    }

    protected void initArrayFile() {
    }

    protected abstract void loadArrayFileData();

    @Override
    public File getDirectory() {
        return this._directory;
    }

    @Override
    public EntryFactory<V> getEntryFactory() {
        return this._entryFactory;
    }

    public ArrayEntryManager<V> getEntryManager() {
        return this._entryManager;
    }

    @Override
    public boolean hasIndex(int index) {
        return 0 <= index && index < this._length;
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public void sync() throws IOException {
        this._entryManager.sync();
        _log.info((Object)("array saved: length=" + this.length()));
    }

    @Override
    public void persist() throws IOException {
        this._entryManager.persist();
        _log.info((Object)("array persisted: length=" + this.length()));
    }

    @Override
    public long getHWMark() {
        return this._entryManager.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._entryManager.getLWMark();
    }

    @Override
    public void updateArrayFile(List<Entry<V>> entryList) throws IOException {
        this._arrayFile.update(entryList);
    }
}

