/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.List;
import krati.core.array.basic.MemoryIntArray;
import krati.core.array.basic.MemoryLongArray;
import krati.core.array.basic.MemoryShortArray;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryUtility;
import krati.core.array.entry.EntryValue;
import krati.io.ChannelReader;
import krati.io.ChannelWriter;
import krati.io.DataWriter;
import krati.io.MappedWriter;
import krati.util.Chronos;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFile {
    public static final long STORAGE_VERSION = 0L;
    public static final int ARRAY_HEADER_LENGTH = 1024;
    static final int VERSION_POSITION = 0;
    static final int LWM_SCN_POSITION = 8;
    static final int HWM_SCN_POSITION = 16;
    static final int ARRAY_LENGTH_POSITION = 24;
    static final int ELEMENT_SIZE_POSITION = 28;
    static final long DATA_START_POSITION = 1024L;
    static final Logger _log = Logger.getLogger(ArrayFile.class);
    private File _file;
    private DataWriter _writer;
    private long _version;
    private long _arrayLwmScn;
    private long _arrayHwmScn;
    private int _arrayLength;
    private int _elementSize;

    public ArrayFile(File file, int initialLength, int elementSize) throws IOException {
        boolean newFile = false;
        long initialFileLength = 1024L + (long)(initialLength * elementSize);
        if (!file.exists()) {
            if (!file.createNewFile()) {
                throw new IOException("Failed to create " + file.getAbsolutePath());
            }
            newFile = true;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        if (newFile) {
            raf.setLength(initialFileLength);
        }
        if (raf.length() < 1024L) {
            throw new IOException("Failed to open " + file.getAbsolutePath());
        }
        this._file = file;
        this._writer = this.createWriter(this._file, raf.length());
        this._writer.open();
        if (newFile) {
            this._version = 0L;
            this._arrayLwmScn = 0L;
            this._arrayHwmScn = 0L;
            this._arrayLength = initialLength;
            this._elementSize = elementSize;
            this.saveHeader();
        } else {
            this.loadHeader();
        }
        this.initCheck();
        _log.info((Object)(this._file.getName() + " header: " + this.getHeader()));
    }

    protected DataWriter createWriter(File file, long fileLength) {
        return fileLength < Integer.MAX_VALUE ? new MappedWriter(file) : new ChannelWriter(file);
    }

    protected void initCheck() throws IOException {
        if (this._version != 0L) {
            throw new IOException("Invalid version in " + this._file.getName() + ": " + this._version + ", " + 0L + " expected");
        }
        if (!this.checkHeader()) {
            throw new IOException("Invalid header in " + this._file.getName() + ": " + this.getHeader());
        }
    }

    private void saveHeader() throws IOException {
        this._writer.writeLong(0L, this._version);
        this._writer.writeLong(8L, this._arrayLwmScn);
        this._writer.writeLong(16L, this._arrayHwmScn);
        this._writer.writeInt(24L, this._arrayLength);
        this._writer.writeInt(28L, this._elementSize);
        this._writer.flush();
    }

    private void loadHeader() throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(1024);
        RandomAccessFile raf = new RandomAccessFile(this._file, "rw");
        raf.getChannel().read(headerBuffer, 0L);
        this._version = headerBuffer.getLong(0);
        this._arrayLwmScn = headerBuffer.getLong(8);
        this._arrayHwmScn = headerBuffer.getLong(16);
        this._arrayLength = headerBuffer.getInt(24);
        this._elementSize = headerBuffer.getInt(28);
        raf.close();
    }

    private boolean checkHeader() {
        return this._arrayHwmScn >= this._arrayLwmScn;
    }

    private String getHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append("version=");
        buf.append(this._version);
        buf.append(" lwmScn=");
        buf.append(this._arrayLwmScn);
        buf.append(" hwmScn=");
        buf.append(this._arrayHwmScn);
        buf.append(" arrayLength=");
        buf.append(this._arrayLength);
        buf.append(" elementSize=");
        buf.append(this._elementSize);
        return buf.toString();
    }

    public final String getName() {
        return this._file.getName();
    }

    public final String getPath() {
        return this._file.getPath();
    }

    public final String getAbsolutePath() {
        return this._file.getAbsolutePath();
    }

    public final String getCanonicalPath() throws IOException {
        return this._file.getCanonicalPath();
    }

    public final long getVersion() {
        return this._version;
    }

    public final long getLwmScn() {
        return this._arrayLwmScn;
    }

    public final long getHwmScn() {
        return this._arrayHwmScn;
    }

    public final int getArrayLength() {
        return this._arrayLength;
    }

    public final int getElementSize() {
        return this._elementSize;
    }

    public void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        this._writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(MemoryIntArray intArray) throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            for (int i = 0; i < this._arrayLength; ++i) {
                intArray.set(i, in.readInt());
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(MemoryLongArray longArray) throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            for (int i = 0; i < this._arrayLength; ++i) {
                longArray.set(i, in.readLong());
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(MemoryShortArray shortArray) throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            for (int i = 0; i < this._arrayLength; ++i) {
                shortArray.set(i, in.readShort());
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] loadIntArray() throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return null;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            int[] array = new int[this._arrayLength];
            for (int i = 0; i < this._arrayLength; ++i) {
                array[i] = in.readInt();
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
            int[] nArray = array;
            return nArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] loadLongArray() throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return null;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            long[] array = new long[this._arrayLength];
            for (int i = 0; i < this._arrayLength; ++i) {
                array[i] = in.readLong();
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
            long[] lArray = array;
            return lArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] loadShortArray() throws IOException {
        if (!this._file.exists() || this._file.length() == 0L) {
            return null;
        }
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(this._file);
        try {
            in.open();
            in.position(1024L);
            short[] array = new short[this._arrayLength];
            for (int i = 0; i < this._arrayLength; ++i) {
                array[i] = in.readShort();
            }
            _log.info((Object)(this._file.getName() + " loaded in " + c.getElapsedTime()));
            short[] sArray = array;
            return sArray;
        }
        finally {
            in.close();
        }
    }

    protected long getPosition(int index) {
        return 1024L + (long)(index * this._elementSize);
    }

    public void writeInt(int index, int value) throws IOException {
        this._writer.writeInt(this.getPosition(index), value);
    }

    public void writeLong(int index, long value) throws IOException {
        this._writer.writeLong(this.getPosition(index), value);
    }

    public void writeShort(int index, short value) throws IOException {
        this._writer.writeShort(this.getPosition(index), value);
    }

    public synchronized <T extends EntryValue> void update(List<Entry<T>> entryList) throws IOException {
        Chronos c = new Chronos();
        EntryValue[] values = EntryUtility.sortEntriesToValues(entryList);
        if (values == null || values.length == 0) {
            return;
        }
        long maxScn = 0L;
        for (Entry<T> e : entryList) {
            maxScn = Math.max(e.getMaxScn(), maxScn);
        }
        _log.info((Object)("write hwmScn:" + maxScn));
        this._writer.writeLong(16L, maxScn);
        this._writer.flush();
        for (EntryValue v : values) {
            v.updateArrayFile(this._writer, this.getPosition(v.pos));
        }
        this._writer.flush();
        _log.info((Object)("write lwmScn:" + maxScn));
        this._writer.writeLong(8L, maxScn);
        this._writer.flush();
        this._arrayLwmScn = maxScn;
        this._arrayHwmScn = maxScn;
        _log.info((Object)(entryList.size() + " entries flushed to " + this._file.getAbsolutePath() + " in " + c.getElapsedTime()));
    }

    protected void writeVersion(long value) throws IOException {
        this._writer.writeLong(0L, value);
        this._version = value;
    }

    protected void writeLwmScn(long value) throws IOException {
        this._writer.writeLong(8L, value);
        this._arrayLwmScn = value;
    }

    protected void writeHwmScn(long value) throws IOException {
        this._writer.writeLong(16L, value);
        this._arrayHwmScn = value;
    }

    protected void writeArrayLength(int value) throws IOException {
        this._writer.writeInt(24L, value);
        this._arrayLength = value;
    }

    protected void writeElementSize(int value) throws IOException {
        this._writer.writeInt(28L, value);
        this._elementSize = value;
    }

    public synchronized void reset(MemoryIntArray intArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        int cnt = intArray.length();
        for (int i = 0; i < cnt; ++i) {
            this._writer.writeInt(intArray.get(i));
        }
        this._writer.flush();
    }

    public synchronized void reset(MemoryIntArray intArray, long maxScn) throws IOException {
        this.reset(intArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void reset(MemoryLongArray longArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        int cnt = longArray.length();
        for (int i = 0; i < cnt; ++i) {
            this._writer.writeLong(longArray.get(i));
        }
        this._writer.flush();
    }

    public synchronized void reset(MemoryLongArray longArray, long maxScn) throws IOException {
        this.reset(longArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void reset(MemoryShortArray shortArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        int cnt = shortArray.length();
        for (int i = 0; i < cnt; ++i) {
            this._writer.writeShort(shortArray.get(i));
        }
        this._writer.flush();
    }

    public synchronized void reset(MemoryShortArray shortArray, long maxScn) throws IOException {
        this.reset(shortArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void reset(int[] intArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        for (int i = 0; i < intArray.length; ++i) {
            this._writer.writeInt(intArray[i]);
        }
        this._writer.flush();
    }

    public synchronized void reset(int[] intArray, long maxScn) throws IOException {
        this.reset(intArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void reset(long[] longArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        for (int i = 0; i < longArray.length; ++i) {
            this._writer.writeLong(longArray[i]);
        }
        this._writer.flush();
    }

    public synchronized void reset(long[] longArray, long maxScn) throws IOException {
        this.reset(longArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void reset(short[] shortArray) throws IOException {
        this._writer.flush();
        this._writer.position(1024L);
        for (int i = 0; i < shortArray.length; ++i) {
            this._writer.writeShort(shortArray[i]);
        }
        this._writer.flush();
    }

    public synchronized void reset(short[] shortArray, long maxScn) throws IOException {
        this.reset(shortArray);
        _log.info((Object)("update hwmScn and lwmScn:" + maxScn));
        this.writeHwmScn(maxScn);
        this.writeLwmScn(maxScn);
        this.flush();
    }

    public synchronized void setArrayLength(int arrayLength, File renameToFile) throws IOException {
        if (arrayLength < 0) {
            throw new IllegalArgumentException("Illegal array length: " + arrayLength);
        }
        if (this._arrayLength == arrayLength) {
            return;
        }
        this.flush();
        long fileLength = 1024L + (long)(arrayLength * this._elementSize);
        RandomAccessFile raf = new RandomAccessFile(this._file, "rw");
        raf.setLength(fileLength);
        raf.close();
        this.writeArrayLength(arrayLength);
        this.flush();
        if (renameToFile != null) {
            if (this._file.renameTo(renameToFile)) {
                this._writer.close();
                this._file = renameToFile;
                this._writer = this.createWriter(this._file, fileLength);
                this._writer.open();
                return;
            }
            _log.warn((Object)("Failed to rename " + this._file.getAbsolutePath() + " to " + renameToFile.getAbsolutePath()));
        }
        this._writer.close();
        this._writer = this.createWriter(this._file, fileLength);
        this._writer.open();
    }
}

