/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.DynamicArray;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.basic.ArrayExpandListener;
import krati.core.array.basic.MemoryLongArray;
import krati.core.array.entry.EntryLongFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryValueLong;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicLongArray
extends AbstractRecoverableArray<EntryValueLong>
implements AddressArray,
DynamicArray,
ArrayExpandListener {
    private static final int _subArrayBits = 16;
    private static final int _subArraySize = 65536;
    private static final Logger _log = Logger.getLogger(DynamicLongArray.class);
    private MemoryLongArray _internalArray;

    public DynamicLongArray(int entrySize, int maxEntries, File directory) throws Exception {
        super(65536, 8, entrySize, maxEntries, directory, new EntryLongFactory());
    }

    @Override
    protected void loadArrayFileData() {
        long maxScn = this._arrayFile.getLwmScn();
        try {
            this._internalArray = new MemoryLongArray(16);
            this._arrayFile.load(this._internalArray);
            this.expandCapacity(this._internalArray.length() - 1);
            this._internalArray.setArrayExpandListener(this);
        }
        catch (Exception e) {
            maxScn = 0L;
            this.clear();
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)e);
            }
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            this._internalArray.clear();
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long get(int index) {
        return this._internalArray.get(index);
    }

    @Override
    public void set(int index, long value, long scn) throws Exception {
        this._internalArray.set(index, value);
        this._entryManager.addToPreFillEntryLong(index, value, scn);
    }

    @Override
    public void setCompactionAddress(int index, long address, long scn) throws Exception {
        this._internalArray.set(index, address);
        this._entryManager.addToPreFillEntryLongCompaction(index, address, scn);
    }

    @Override
    public long[] getInternalArray() {
        return this._internalArray.getInternalArray();
    }

    @Override
    public EntryPersistListener getPersistListener() {
        return this.getEntryManager().getEntryPersistListener();
    }

    @Override
    public void setPersistListener(EntryPersistListener persistListener) {
        this.getEntryManager().setEntryPersistListener(persistListener);
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        int newLength;
        if (index < this._length) {
            return;
        }
        this._length = newLength = ((index >> 16) + 1) * 65536;
        if (this._internalArray.length() < newLength) {
            this._internalArray.expandCapacity(index);
        }
        this._arrayFile.setArrayLength(newLength, null);
        _log.info((Object)("Expanded: _length=" + this._length));
    }

    @Override
    public void arrayExpanded(DynamicArray dynArray) {
        if (dynArray == this._internalArray) {
            try {
                this.expandCapacity(dynArray.length() - 1);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to expand: length=" + dynArray.length()));
            }
        }
    }

    public final int subArrayLength() {
        return 65536;
    }
}

