/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.DynamicArray;
import krati.array.ShortArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.basic.ArrayExpandListener;
import krati.core.array.basic.MemoryShortArray;
import krati.core.array.entry.EntryShortFactory;
import krati.core.array.entry.EntryValueShort;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicShortArray
extends AbstractRecoverableArray<EntryValueShort>
implements ShortArray,
DynamicArray,
ArrayExpandListener {
    private static final int _subArrayBits = 16;
    private static final int _subArraySize = 65536;
    private static final Logger _log = Logger.getLogger(DynamicShortArray.class);
    private MemoryShortArray _internalArray;

    public DynamicShortArray(int entrySize, int maxEntries, File directory) throws Exception {
        super(65536, 2, entrySize, maxEntries, directory, new EntryShortFactory());
    }

    @Override
    protected void loadArrayFileData() {
        long maxScn = this._arrayFile.getLwmScn();
        try {
            this._internalArray = new MemoryShortArray(16);
            this._arrayFile.load(this._internalArray);
            this.expandCapacity(this._internalArray.length() - 1);
            this._internalArray.setArrayExpandListener(this);
        }
        catch (Exception e) {
            maxScn = 0L;
            this.clear();
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)e);
            }
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            this._internalArray.clear();
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public short get(int index) {
        return this._internalArray.get(index);
    }

    @Override
    public void set(int index, short value, long scn) throws Exception {
        this._internalArray.set(index, value);
        this._entryManager.addToPreFillEntryShort(index, value, scn);
    }

    @Override
    public short[] getInternalArray() {
        return this._internalArray.getInternalArray();
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        if (index < this._length) {
            return;
        }
        int newLength = ((index >> 16) + 1) * 65536;
        if (this._internalArray.length() < newLength) {
            this._internalArray.expandCapacity(index);
        }
        this._arrayFile.setArrayLength(newLength, null);
        this._length = newLength;
        _log.info((Object)("Expanded: _length=" + this._length));
    }

    @Override
    public void arrayExpanded(DynamicArray dynArray) {
        if (dynArray == this._internalArray) {
            try {
                this.expandCapacity(dynArray.length() - 1);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to expand: " + dynArray.length()));
            }
        }
    }

    public final int subArrayLength() {
        return 65536;
    }
}

