/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.util.Arrays;
import krati.array.DynamicArray;
import krati.array.ShortArray;
import krati.core.array.basic.ArrayExpandListener;

public class MemoryShortArray
implements ShortArray,
DynamicArray {
    protected short[][] _subArrays;
    protected final int _subArrayBits;
    protected final int _subArraySize;
    protected final int _subArrayMask;
    protected final boolean _autoExpand;
    private ArrayExpandListener _expandListener;

    public MemoryShortArray() throws Exception {
        this(16, true);
    }

    public MemoryShortArray(int subArrayBits) throws Exception {
        this(subArrayBits, true);
    }

    public MemoryShortArray(int subArrayBits, boolean autoExpand) throws Exception {
        this._subArrayBits = subArrayBits;
        this._subArraySize = 1 << subArrayBits;
        this._subArrayMask = this._subArraySize - 1;
        this._subArrays = new short[1][this._subArraySize];
        this._autoExpand = autoExpand;
    }

    public void clear() {
        for (short[] subArray : this._subArrays) {
            Arrays.fill(subArray, (short)0);
        }
    }

    public int length() {
        return this._subArrays.length * this._subArraySize;
    }

    public boolean hasIndex(int index) {
        return index < 0 ? false : index >> this._subArrayBits < this._subArrays.length;
    }

    public short get(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subInd = index >> this._subArrayBits;
        int offset = index & this._subArrayMask;
        return this._subArrays[subInd][offset];
    }

    public void set(int index, short value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int subInd = index >> this._subArrayBits;
        int offset = index & this._subArrayMask;
        if (subInd >= this._subArrays.length && this._autoExpand) {
            this.expandCapacity(index);
        }
        this._subArrays[subInd][offset] = value;
    }

    public void set(int index, short value, long scn) {
        this.set(index, value);
    }

    public synchronized void expandCapacity(int index) {
        int i;
        if (index < 0) {
            return;
        }
        int numSubArrays = (index >> this._subArrayBits) + 1;
        if (numSubArrays <= this._subArrays.length) {
            return;
        }
        short[][] tmpArrays = new short[numSubArrays][];
        for (i = 0; i < this._subArrays.length; ++i) {
            tmpArrays[i] = this._subArrays[i];
        }
        while (i < numSubArrays) {
            tmpArrays[i] = new short[this._subArraySize];
            ++i;
        }
        this._subArrays = tmpArrays;
        if (this.getArrayExpandListener() != null) {
            this.getArrayExpandListener().arrayExpanded(this);
        }
    }

    public synchronized short[] getInternalArray() {
        short[] result = new short[this.length()];
        for (int i = 0; i < this._subArrays.length; ++i) {
            System.arraycopy(this._subArrays[i], 0, result, i * this._subArraySize, this._subArraySize);
        }
        return result;
    }

    protected void setArrayExpandListener(ArrayExpandListener listener) {
        this._expandListener = listener;
    }

    protected ArrayExpandListener getArrayExpandListener() {
        return this._expandListener;
    }
}

