/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.IntArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.entry.EntryIntFactory;
import krati.core.array.entry.EntryValueInt;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticIntArray
extends AbstractRecoverableArray<EntryValueInt>
implements IntArray {
    private static final Logger _log = Logger.getLogger(StaticIntArray.class);
    private int[] _internalArray;

    public StaticIntArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        super(length, 4, entrySize, maxEntries, homeDirectory, new EntryIntFactory());
    }

    @Override
    protected void loadArrayFileData() {
        long maxScn = 0L;
        try {
            maxScn = this._arrayFile.getLwmScn();
            this._internalArray = this._arrayFile.loadIntArray();
            if (this._internalArray.length != this._length) {
                maxScn = 0L;
                this._internalArray = new int[this._length];
                this.clear();
                _log.warn((Object)"Allocated _internalArray due to invalid length");
            } else {
                _log.info((Object)("Data loaded successfully from file " + this._arrayFile.getName()));
            }
        }
        catch (Exception e) {
            maxScn = 0L;
            this._internalArray = new int[this._length];
            this.clear();
            _log.warn((Object)("Allocated _internalArray due to a thrown exception: " + e.getMessage()));
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)e);
            }
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            for (int i = 0; i < this._internalArray.length; ++i) {
                this._internalArray[i] = 0;
            }
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int get(int index) {
        return this._internalArray[index];
    }

    @Override
    public void set(int index, int value, long scn) throws Exception {
        this._internalArray[index] = value;
        this._entryManager.addToPreFillEntryInt(index, value, scn);
    }

    @Override
    public int[] getInternalArray() {
        return this._internalArray;
    }
}

