/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.LongArray;
import krati.core.array.AddressArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.entry.EntryLongFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryValueLong;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticLongArray
extends AbstractRecoverableArray<EntryValueLong>
implements AddressArray {
    private static final Logger _log = Logger.getLogger(StaticLongArray.class);
    private long[] _internalArray;

    public StaticLongArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        super(length, 8, entrySize, maxEntries, homeDirectory, new EntryLongFactory());
    }

    @Override
    protected void loadArrayFileData() {
        long maxScn = 0L;
        try {
            maxScn = this._arrayFile.getLwmScn();
            this._internalArray = this._arrayFile.loadLongArray();
            if (this._internalArray.length != this._length) {
                maxScn = 0L;
                this._internalArray = new long[this._length];
                this.clear();
                _log.warn((Object)"Allocated _internalArray due to invalid length");
            } else {
                _log.info((Object)("Data loaded successfully from file " + this._arrayFile.getName()));
            }
        }
        catch (Exception e) {
            maxScn = 0L;
            this._internalArray = new long[this._length];
            this.clear();
            _log.warn((Object)("Allocated _internalArray due to a thrown exception: " + e.getMessage()));
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)e);
            }
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            for (int i = 0; i < this._internalArray.length; ++i) {
                this._internalArray[i] = 0L;
            }
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long get(int index) {
        return this._internalArray[index];
    }

    @Override
    public void set(int index, long value, long scn) throws Exception {
        this._internalArray[index] = value;
        this._entryManager.addToPreFillEntryLong(index, value, scn);
    }

    @Override
    public void setCompactionAddress(int index, long address, long scn) throws Exception {
        this._internalArray[index] = address;
        this._entryManager.addToPreFillEntryLongCompaction(index, address, scn);
    }

    @Override
    public long[] getInternalArray() {
        return this._internalArray;
    }

    public void wrap(LongArray newArray) throws Exception {
        if (this.length() != newArray.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._internalArray = newArray.getInternalArray();
        this._arrayFile.reset(this._internalArray);
        this._entryManager.clear();
    }

    @Override
    public EntryPersistListener getPersistListener() {
        return this.getEntryManager().getEntryPersistListener();
    }

    @Override
    public void setPersistListener(EntryPersistListener persistListener) {
        this.getEntryManager().setEntryPersistListener(persistListener);
    }
}

