/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.IOException;
import krati.core.array.entry.EntryValue;
import krati.io.DataWriter;

public class EntryValueLong
extends EntryValue {
    public long val;

    public EntryValueLong(int pos, long val, long scn) {
        super(pos, scn);
        this.val = val;
    }

    public final void reinit(int pos, long val, long scn) {
        this.pos = pos;
        this.val = val;
        this.scn = scn;
    }

    public final long getValue() {
        return this.val;
    }

    public String toString() {
        return this.pos + ":" + this.val + ":" + this.scn;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof EntryValueLong) {
            EntryValueLong v = (EntryValueLong)o;
            return this.pos == v.pos && this.val == v.val && this.scn == v.scn;
        }
        return false;
    }

    public int hashCode() {
        int result = this.pos / 29 + (int)(this.val / 113L);
        result = 19 * result + (int)(this.scn ^ this.scn >>> 32);
        return result;
    }

    public void write(DataWriter writer) throws IOException {
        writer.writeInt(this.pos);
        writer.writeLong(this.val);
        writer.writeLong(this.scn);
    }

    public void updateArrayFile(DataWriter writer, long position) throws IOException {
        writer.writeLong(position, this.val);
    }
}

