/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import krati.core.array.entry.AbstractEntry;
import krati.core.array.entry.EntryValue;
import krati.core.array.entry.EntryValueFactory;
import krati.io.DataReader;
import krati.io.DataWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEntry<T extends EntryValue>
extends AbstractEntry<T> {
    protected final ArrayList<T> _valArray;

    public SimpleEntry(int entryId, EntryValueFactory<T> valFactory, int initialCapacity) {
        super(entryId, valFactory, initialCapacity);
        this._valArray = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this._valArray.size();
    }

    @Override
    public void clear() {
        super.clear();
        this._valArray.clear();
    }

    @Override
    public void add(T value) {
        this._valArray.add(value);
        this.maintainScn(((EntryValue)value).scn);
    }

    @Override
    public List<T> getValueList() {
        return this._valArray;
    }

    @Override
    protected void loadDataSection(DataReader in, int cnt) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            this._valArray.add(this._valFactory.newValue(in));
        }
    }

    @Override
    protected void saveDataSection(DataWriter out) throws IOException {
        for (EntryValue val : this._valArray) {
            val.write(out);
        }
    }
}

