/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import krati.core.segment.AbstractSegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentFileSizeException;
import krati.core.segment.SegmentOverflowException;
import krati.core.segment.SegmentReadOnlyException;
import org.apache.log4j.Logger;

public class MemorySegment
extends AbstractSegment {
    private static final Logger _log = Logger.getLogger(MemorySegment.class);
    private ByteBuffer _buffer;

    public MemorySegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        super(segmentId, segmentFile, initialSizeMB, mode);
    }

    protected void init() throws IOException {
        this._buffer = this.initByteBuffer();
        if (!this.getSegmentFile().exists()) {
            if (!this.getSegmentFile().createNewFile()) {
                String msg = "Failed to create " + this.getSegmentFile().getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            RandomAccessFile raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            raf.setLength(this.getInitialSize());
            raf.close();
        }
        if (this.getMode() == Segment.Mode.READ_ONLY) {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "r");
            if (this._raf.length() != this.getInitialSize()) {
                int rafSizeMB = (int)(this._raf.length() / 1024L / 1024L);
                throw new SegmentFileSizeException(this.getSegmentFile().getCanonicalPath(), rafSizeMB, this.getInitialSizeMB());
            }
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this._channel.read(this._buffer);
            this.loadHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " loaded: " + this.getHeader()));
        } else {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            if (this._raf.length() != this.getInitialSize()) {
                int rafSizeMB = (int)(this._raf.length() / 1024L / 1024L);
                throw new SegmentFileSizeException(this.getSegmentFile().getCanonicalPath(), rafSizeMB, this.getInitialSizeMB());
            }
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this.initHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " initialized: " + this.getStatus()));
        }
    }

    protected ByteBuffer initByteBuffer() {
        int bufferLength = (int)(this._initSizeMB < 2048 ? this._initSizeBytes : this._initSizeBytes - 1L);
        return ByteBuffer.wrap(new byte[bufferLength]);
    }

    public long getAppendPosition() throws IOException {
        return this._buffer.position();
    }

    public void setAppendPosition(long newPosition) throws IOException {
        this._buffer.position((int)newPosition);
    }

    public int appendInt(int value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putInt(value);
            this.incrLoadSize(4);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    public int appendLong(long value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putLong(value);
            this.incrLoadSize(8);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    public int appendShort(short value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putShort(value);
            this.incrLoadSize(2);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    public int append(byte[] data) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.put(data);
            this.incrLoadSize(data.length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    public int append(byte[] data, int offset, int length) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.put(data, offset, length);
            this.incrLoadSize(length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    public int readInt(int pos) throws IOException {
        return this._buffer.getInt(pos);
    }

    public long readLong(int pos) throws IOException {
        return this._buffer.getLong(pos);
    }

    public short readShort(int pos) throws IOException {
        return this._buffer.getShort(pos);
    }

    public void read(int pos, byte[] dst) throws IOException {
        System.arraycopy(this._buffer.array(), pos, dst, 0, dst.length);
    }

    public void read(int pos, byte[] dst, int offset, int length) throws IOException {
        System.arraycopy(this._buffer.array(), pos, dst, offset, length);
    }

    public int transferTo(int pos, int length, Segment targetSegment) throws IOException {
        if (pos + length <= this._buffer.position()) {
            targetSegment.append(this._buffer.array(), pos, length);
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    public int transferTo(int pos, int length, WritableByteChannel targetChannel) throws IOException {
        if (pos + length <= this._buffer.position()) {
            targetChannel.write(ByteBuffer.wrap(this._buffer.array(), pos, length));
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    public synchronized void asReadOnly() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            this.force();
            this._segMode = Segment.Mode.READ_ONLY;
            _log.info((Object)("Segment " + this.getSegmentId() + " switched to " + (Object)((Object)this.getMode())));
        }
    }

    public synchronized void force() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            int offset = (int)this._channel.position();
            int length = this._buffer.position() - offset;
            if (length > 0) {
                this._channel.write(ByteBuffer.wrap(this._buffer.array(), offset, length));
            }
            long currentTime = System.currentTimeMillis();
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            bb.putLong(currentTime);
            bb.flip();
            this._channel.write(bb, 0L);
            this._lastForcedTime = currentTime;
        }
        this._channel.force(true);
        _log.info((Object)("Segment " + this.getSegmentId() + " forced: " + this.getStatus()));
    }

    public synchronized void close(boolean force) throws IOException {
        if (force) {
            this.force();
        }
        if (this._channel != null) {
            this._channel.close();
            this._channel = null;
        }
        if (this._raf != null) {
            this._raf.close();
            this._raf = null;
        }
    }

    public synchronized void reinit() throws IOException {
        this._buffer.clear();
        this._segMode = Segment.Mode.READ_WRITE;
        if (!this.getSegmentFile().exists()) {
            if (!this.getSegmentFile().createNewFile()) {
                String msg = "Failed to create " + this.getSegmentFile().getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            RandomAccessFile raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            raf.setLength(this.getInitialSize());
            raf.close();
        }
        this._raf = new RandomAccessFile(this.getSegmentFile(), "rw");
        if (this._raf.length() != this.getInitialSize()) {
            int rafSizeMB = (int)(this._raf.length() / 1024L / 1024L);
            throw new SegmentFileSizeException(this.getSegmentFile().getCanonicalPath(), rafSizeMB, this.getInitialSizeMB());
        }
        this._channel = this._raf.getChannel();
        this._channel.position(0L);
        this.initHeader();
        _log.info((Object)("Segment " + this.getSegmentId() + " initialized: " + this.getStatus()));
    }

    public final boolean isRecyclable() {
        return true;
    }

    public final boolean canReadFromBuffer() {
        return true;
    }

    public final boolean canAppendToBuffer() {
        return true;
    }
}

