/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import krati.core.segment.MappedSegmentFactory;
import krati.core.segment.Segment;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentMeta;
import org.apache.log4j.Logger;

public final class SegmentManager {
    private static final Logger _log = Logger.getLogger(SegmentManager.class);
    private static final Map<String, SegmentManager> _segManagerMap = new HashMap<String, SegmentManager>();
    private final List<Segment> _segList = new ArrayList<Segment>(100);
    private final LinkedList<Segment> _recycleList = new LinkedList();
    private final int _recycleLimit;
    private final SegmentFactory _segFactory;
    private final SegmentMeta _segMeta;
    private final String _segHomePath;
    private final int _segFileSizeMB;
    private Segment _segCurrent;

    private SegmentManager(String segmentHomePath) throws IOException {
        this(segmentHomePath, new MappedSegmentFactory());
    }

    private SegmentManager(String segmentHomePath, SegmentFactory segmentFactory) throws IOException {
        this(segmentHomePath, segmentFactory, 256);
    }

    private SegmentManager(String segmentHomePath, SegmentFactory segmentFactory, int segmentFileSizeMB) throws IOException {
        _log.info((Object)("init segHomePath=" + segmentHomePath + " segFileSizeMB=" + segmentFileSizeMB));
        this._segFactory = segmentFactory;
        this._segHomePath = segmentHomePath;
        this._segFileSizeMB = segmentFileSizeMB;
        this._segMeta = new SegmentMeta(new File(this._segHomePath, ".meta"));
        this._recycleLimit = this.computeRecycleLimit(segmentFileSizeMB);
        this.init();
    }

    private int computeRecycleLimit(int segmentFileSizeMB) {
        return segmentFileSizeMB <= 64 ? 5 : (segmentFileSizeMB <= 256 ? 3 : 2);
    }

    public int getSegmentFileSizeMB() {
        return this._segFileSizeMB;
    }

    public String getSegmentHomePath() {
        return this._segHomePath;
    }

    public SegmentFactory getSegmentFactory() {
        return this._segFactory;
    }

    public Segment getCurrentSegment() {
        return this._segCurrent;
    }

    public Segment getSegment(int index) {
        return this._segList.get(index);
    }

    public int getSegmentCount() {
        return this._segList.size();
    }

    public int getLiveSegmentCount() {
        int num = 0;
        for (int i = 0; i < this._segList.size(); ++i) {
            if (this._segList.get(i) == null) continue;
            ++num;
        }
        return num;
    }

    public synchronized void clear() {
        this._segList.clear();
        this._segCurrent = null;
        this._recycleList.clear();
    }

    public synchronized boolean freeSegment(Segment seg) throws IOException {
        if (seg == null) {
            return false;
        }
        int segId = seg.getSegmentId();
        if (segId < this._segList.size() && this._segList.get(segId) == seg) {
            this._segList.set(segId, null);
            seg.close(false);
            if (seg.isRecyclable() && this._recycleList.size() < this._recycleLimit) {
                this._recycleList.add(seg);
                _log.info((Object)("Segment " + seg.getSegmentId() + " recycled"));
            } else {
                _log.info((Object)("Segment " + seg.getSegmentId() + " freed"));
            }
            return true;
        }
        return false;
    }

    public synchronized Segment nextSegment() throws IOException {
        this._segCurrent = this.nextSegment(false);
        return this._segCurrent;
    }

    private synchronized Segment nextSegment(boolean newOnly) throws IOException {
        int index;
        if (newOnly) {
            index = this._segList.size();
        } else {
            if (this._recycleList.size() > 0) {
                Segment seg = this._recycleList.remove();
                seg.reinit();
                this._segList.set(seg.getSegmentId(), seg);
                _log.info((Object)("reinit Segment " + seg.getSegmentId()));
                return seg;
            }
            for (index = 0; index < this._segList.size() && this._segList.get(index) != null; ++index) {
            }
        }
        File segFile = new File(this._segHomePath, index + ".seg");
        Segment seg = this.getSegmentFactory().createSegment(index, segFile, this._segFileSizeMB, Segment.Mode.READ_WRITE);
        if (index < this._segList.size()) {
            this._segList.set(index, seg);
        } else {
            this._segList.add(seg);
        }
        return seg;
    }

    protected synchronized void init() throws IOException {
        File[] segFiles = this.listSegmentFiles();
        if (segFiles.length == 0) {
            return;
        }
        try {
            for (int i = 0; i < segFiles.length; ++i) {
                File segFile = segFiles[i];
                int segId = Integer.parseInt(segFile.getName().substring(0, segFile.getName().indexOf(46)));
                if (segId != i) {
                    throw new IOException("Segment file " + i + ".seg missing");
                }
                if (this.getMeta().hasSegmentInService(segId)) {
                    Segment s = this.getSegmentFactory().createSegment(segId, segFile, this._segFileSizeMB, Segment.Mode.READ_ONLY);
                    s.incrLoadSize(this.getMeta().getSegmentLoadSize(segId));
                    this._segList.add(s);
                    continue;
                }
                this._segList.add(null);
            }
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage());
            this.clear();
            throw e;
        }
        _log.info((Object)"init done");
    }

    protected File[] listSegmentFiles() {
        File segDir = new File(this._segHomePath);
        File[] segFiles = segDir.listFiles(new FileFilter(){

            public boolean accept(File filePath) {
                String fileName = filePath.getName();
                return fileName.matches("^[0-9]+\\.seg$");
            }
        });
        if (segFiles == null) {
            segFiles = new File[]{};
        } else if (segFiles.length > 0) {
            Arrays.sort(segFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    int segId2;
                    int segId1 = Integer.parseInt(f1.getName().substring(0, f1.getName().indexOf(46)));
                    return segId1 < (segId2 = Integer.parseInt(f2.getName().substring(0, f2.getName().indexOf(46)))) ? -1 : (segId1 == segId2 ? 0 : 1);
                }
            });
        }
        return segFiles;
    }

    public SegmentMeta getMeta() {
        return this._segMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMeta() throws IOException {
        FileLock lock = null;
        AbstractInterruptibleChannel channel = null;
        try {
            channel = new RandomAccessFile(this.getMeta().getMetaFile(), "rw").getChannel();
            lock = ((FileChannel)channel).lock(0L, Long.MAX_VALUE, false);
            this._segMeta.wrap(this);
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (channel != null) {
                channel.close();
            }
        }
    }

    public static synchronized SegmentManager getInstance(String segmentHomePath, SegmentFactory segmentFactory, int segmentFileSizeMB) throws IOException {
        if (segmentFileSizeMB < 8) {
            throw new IllegalArgumentException("Invalid argument segmentFileSizeMB " + segmentFileSizeMB + ", smaller than " + 8);
        }
        if (segmentFileSizeMB > 2048) {
            throw new IllegalArgumentException("Invalid argument segmentFileSizeMB " + segmentFileSizeMB + ", greater than " + 2048);
        }
        File segDir = new File(segmentHomePath);
        if (!segDir.exists() && !segDir.mkdirs()) {
            throw new IOException("Failed to create directory " + segmentHomePath);
        }
        if (segDir.isFile()) {
            throw new IOException("File " + segmentHomePath + " is not a directory");
        }
        String key = segDir.getCanonicalPath();
        SegmentManager mgr = _segManagerMap.get(key);
        if (mgr == null) {
            mgr = new SegmentManager(key, segmentFactory, segmentFileSizeMB);
            _segManagerMap.put(key, mgr);
        }
        return mgr;
    }
}

