/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import krati.core.segment.Segment;
import krati.core.segment.SegmentException;

public class SegmentOverflowException
extends SegmentException {
    private static final long serialVersionUID = 1L;
    private final Segment _segment;
    private final Type _overflowType;

    public SegmentOverflowException(Segment seg) {
        super("Overflow at segment: " + seg.getSegmentId());
        this._segment = seg;
        this._overflowType = Type.WRITE_OVERFLOW;
    }

    public SegmentOverflowException(Segment seg, Type type) {
        super((Object)((Object)type) + " at segment: " + seg.getSegmentId());
        this._segment = seg;
        this._overflowType = type;
    }

    public Segment getSegment() {
        return this._segment;
    }

    public Type getOverflowType() {
        return this._overflowType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        READ_OVERFLOW{

            public String toString() {
                return "Read overflow";
            }
        }
        ,
        WRITE_OVERFLOW{

            public String toString() {
                return "Write overflow";
            }
        };

    }
}

