/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.core.segment.AbstractSegment;
import krati.core.segment.Segment;
import krati.core.segment.SegmentFileSizeException;
import krati.core.segment.SegmentOverflowException;
import krati.core.segment.SegmentReadOnlyException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteBufferSegment
extends AbstractSegment {
    private static final Logger _log = Logger.getLogger(WriteBufferSegment.class);
    private Queue<ByteBuffer> _bufferQueue = null;
    private ByteBuffer _buffer = null;

    public WriteBufferSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode, ConcurrentLinkedQueue<ByteBuffer> bufferQueue) throws IOException {
        super(segmentId, segmentFile, initialSizeMB, mode);
        this._bufferQueue = bufferQueue;
        if (mode == Segment.Mode.READ_WRITE) {
            this._buffer = bufferQueue.poll();
            if (this._buffer != null) {
                _log.info((Object)"ByteBuffer obtained");
            }
        }
        this.init();
    }

    @Override
    protected void init() throws IOException {
        if (this._bufferQueue == null) {
            return;
        }
        if (!this.getSegmentFile().exists()) {
            if (!this.getSegmentFile().createNewFile()) {
                String msg = "Failed to create " + this.getSegmentFile().getAbsolutePath();
                _log.error((Object)msg);
                throw new IOException(msg);
            }
            RandomAccessFile raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            raf.setLength(this.getInitialSize());
            raf.close();
        }
        if (this.getMode() == Segment.Mode.READ_ONLY) {
            this._raf = new RandomAccessFile(this.getSegmentFile(), "r");
            if (this._raf.length() != this.getInitialSize()) {
                int rafSizeMB = (int)(this._raf.length() / 1024L / 1024L);
                throw new SegmentFileSizeException(this.getSegmentFile().getCanonicalPath(), rafSizeMB, this.getInitialSizeMB());
            }
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this.loadHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " loaded: " + this.getHeader()));
        } else {
            if (this._buffer == null) {
                int bufferLength = (int)(this._initSizeMB < 2048 ? this._initSizeBytes : this._initSizeBytes - 1L);
                this._buffer = ByteBuffer.wrap(new byte[bufferLength]);
                _log.info((Object)("ByteBuffer created: " + bufferLength));
            }
            this._buffer.clear();
            this._raf = new RandomAccessFile(this.getSegmentFile(), "rw");
            if (this._raf.length() != this.getInitialSize()) {
                int rafSizeMB = (int)(this._raf.length() / 1024L / 1024L);
                throw new SegmentFileSizeException(this.getSegmentFile().getCanonicalPath(), rafSizeMB, this.getInitialSizeMB());
            }
            this._channel = this._raf.getChannel();
            this._channel.position(0L);
            this.initHeader();
            _log.info((Object)("Segment " + this.getSegmentId() + " initialized: " + this.getStatus()));
        }
    }

    @Override
    public long getAppendPosition() throws IOException {
        return this.isReadOnly() ? this._channel.position() : (long)this._buffer.position();
    }

    @Override
    public void setAppendPosition(long newPosition) throws IOException {
        if (this.isReadOnly()) {
            this._channel.position(newPosition);
        } else {
            this._buffer.position((int)newPosition);
        }
    }

    @Override
    public int appendInt(int value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putInt(value);
            this.incrLoadSize(4);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendLong(long value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putLong(value);
            this.incrLoadSize(8);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int appendShort(short value) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.putShort(value);
            this.incrLoadSize(2);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.put(data);
            this.incrLoadSize(data.length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int append(byte[] data, int offset, int length) throws IOException, SegmentOverflowException, SegmentReadOnlyException {
        if (this.isReadOnly()) {
            throw new SegmentReadOnlyException(this);
        }
        try {
            int pos = this._buffer.position();
            this._buffer.put(data, offset, length);
            this.incrLoadSize(length);
            return pos;
        }
        catch (BufferOverflowException boe) {
            this.asReadOnly();
            throw new SegmentOverflowException(this);
        }
    }

    @Override
    public int readInt(int pos) throws IOException {
        if (this.isReadOnly()) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
            this._channel.read(bb, pos);
            return bb.getInt(0);
        }
        return this._buffer.getInt(pos);
    }

    @Override
    public long readLong(int pos) throws IOException {
        if (this.isReadOnly()) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            this._channel.read(bb, pos);
            return bb.getLong(0);
        }
        return this._buffer.getLong(pos);
    }

    @Override
    public short readShort(int pos) throws IOException {
        if (this.isReadOnly()) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[2]);
            this._channel.read(bb, pos);
            return bb.getShort(0);
        }
        return this._buffer.getShort(pos);
    }

    @Override
    public void read(int pos, byte[] dst) throws IOException {
        if (this.isReadOnly()) {
            ByteBuffer bb = ByteBuffer.wrap(dst);
            this._channel.read(bb, pos);
        } else {
            System.arraycopy(this._buffer.array(), pos, dst, 0, dst.length);
        }
    }

    @Override
    public void read(int pos, byte[] dst, int offset, int length) throws IOException {
        if (this.isReadOnly()) {
            ByteBuffer bb = ByteBuffer.wrap(dst, offset, length);
            this._channel.read(bb, pos);
        } else {
            System.arraycopy(this._buffer.array(), pos, dst, offset, length);
        }
    }

    @Override
    public int transferTo(int pos, int length, Segment targetSegment) throws IOException {
        if (this.isReadOnly()) {
            if ((long)(pos + length) <= this._initSizeBytes) {
                byte[] dst = new byte[length];
                this.read(pos, dst);
                targetSegment.append(dst);
                return length;
            }
        } else if (pos + length <= this._buffer.position()) {
            targetSegment.append(this._buffer.array(), pos, length);
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public int transferTo(int pos, int length, WritableByteChannel targetChannel) throws IOException {
        if (this.isReadOnly()) {
            return (int)this._channel.transferTo(pos, length, targetChannel);
        }
        if (pos + length <= this._buffer.position()) {
            targetChannel.write(ByteBuffer.wrap(this._buffer.array(), pos, length));
            return length;
        }
        throw new SegmentOverflowException(this, SegmentOverflowException.Type.READ_OVERFLOW);
    }

    @Override
    public synchronized void asReadOnly() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            this.force();
            this._segMode = Segment.Mode.READ_ONLY;
            if (this._buffer != null) {
                _log.info((Object)"ByteBuffer returned");
                this._bufferQueue.add(this._buffer);
                this._buffer = null;
            }
            _log.info((Object)("Segment " + this.getSegmentId() + " switched to " + (Object)((Object)this.getMode())));
        }
    }

    @Override
    public synchronized void force() throws IOException {
        if (this.getMode() == Segment.Mode.READ_WRITE) {
            int offset = (int)this._channel.position();
            int length = this._buffer.position() - offset;
            if (length > 0) {
                this._channel.write(ByteBuffer.wrap(this._buffer.array(), offset, length));
            }
            long currentTime = System.currentTimeMillis();
            ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
            bb.putLong(currentTime);
            bb.flip();
            this._channel.write(bb, 0L);
            this._lastForcedTime = currentTime;
        }
        this._channel.force(true);
        _log.info((Object)("Segment " + this.getSegmentId() + " forced: " + this.getStatus()));
    }

    @Override
    public synchronized void close(boolean force) throws IOException {
        if (force) {
            this.force();
        }
        if (this._buffer != null) {
            this._bufferQueue.add(this._buffer);
            this._buffer = null;
        }
        if (this._channel != null) {
            this._channel.close();
            this._channel = null;
        }
        if (this._raf != null) {
            this._raf.close();
            this._raf = null;
        }
    }

    @Override
    public void reinit() throws IOException {
        throw new UnsupportedOperationException("reinit not supported");
    }

    @Override
    public boolean isRecyclable() {
        return false;
    }

    @Override
    public boolean canReadFromBuffer() {
        return false;
    }

    @Override
    public boolean canAppendToBuffer() {
        return true;
    }
}

