/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.core.segment.Segment;
import krati.core.segment.SegmentFactory;
import krati.core.segment.WriteBufferSegment;

public class WriteBufferSegmentFactory
implements SegmentFactory {
    private final ConcurrentLinkedQueue<ByteBuffer> _bufferQueue = new ConcurrentLinkedQueue();

    public WriteBufferSegmentFactory(int segmentFileSizeMB) {
        int bufferLength = (int)((long)segmentFileSizeMB * 1024L * 1024L);
        for (int i = 0; i < 3; ++i) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferLength]);
            this._bufferQueue.add(buffer);
        }
    }

    public Segment createSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        return new WriteBufferSegment(segmentId, segmentFile, initialSizeMB, mode, this._bufferQueue);
    }
}

