/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.DataReader;

public class ChannelReader
implements DataReader {
    private final File _file;
    private FileChannel _channel;
    private RandomAccessFile _raf;
    private final ByteBuffer _bbInt = ByteBuffer.wrap(new byte[4]);
    private final ByteBuffer _bbLong = ByteBuffer.wrap(new byte[8]);
    private final ByteBuffer _bbShort = ByteBuffer.wrap(new byte[2]);

    public ChannelReader(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public void open() throws IOException {
        if (!this._file.exists()) {
            throw new IOException("Cannot find file " + this._file.getAbsolutePath());
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "r");
        this._channel = this._raf.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._channel != null) {
                this._channel.close();
            }
            if (this._raf != null) {
                this._raf.close();
            }
        }
        finally {
            this._channel = null;
            this._raf = null;
        }
    }

    public int readInt() throws IOException {
        this._bbInt.clear();
        this._channel.read(this._bbInt);
        this._bbInt.flip();
        return this._bbInt.getInt();
    }

    public long readLong() throws IOException {
        this._bbLong.clear();
        this._channel.read(this._bbLong);
        this._bbLong.flip();
        return this._bbLong.getLong();
    }

    public short readShort() throws IOException {
        this._bbShort.clear();
        this._channel.read(this._bbShort);
        this._bbShort.flip();
        return this._bbShort.getShort();
    }

    public int readInt(long position) throws IOException {
        this._bbInt.clear();
        this._channel.read(this._bbInt, position);
        this._bbInt.flip();
        return this._bbInt.getInt();
    }

    public long readLong(long position) throws IOException {
        this._bbLong.clear();
        this._channel.read(this._bbLong, position);
        this._bbLong.flip();
        return this._bbLong.getLong();
    }

    public short readShort(long position) throws IOException {
        this._bbShort.clear();
        this._channel.read(this._bbShort, position);
        this._bbShort.flip();
        return this._bbShort.getShort();
    }

    public long position() throws IOException {
        return this._channel.position();
    }

    public void position(long newPosition) throws IOException {
        this._channel.position(newPosition);
    }
}

