/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.DataWriter;

public class ChannelWriter
implements DataWriter {
    private final File _file;
    private FileChannel _channel;
    private RandomAccessFile _raf;
    private final ByteBuffer _bbInt = ByteBuffer.wrap(new byte[4]);
    private final ByteBuffer _bbLong = ByteBuffer.wrap(new byte[8]);
    private final ByteBuffer _bbShort = ByteBuffer.wrap(new byte[2]);

    public ChannelWriter(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public void open() throws IOException {
        if (!this._file.exists()) {
            File dir = this._file.getParentFile();
            if (dir.exists()) {
                this._file.createNewFile();
            } else if (dir.mkdirs()) {
                this._file.createNewFile();
            } else {
                throw new IOException("Failed to create file " + this._file.getAbsolutePath());
            }
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "rw");
        this._channel = this._raf.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._channel.force(true);
            this._channel.close();
            this._raf.close();
        }
        finally {
            this._channel = null;
            this._raf = null;
        }
    }

    public void flush() throws IOException {
        this._channel.force(true);
    }

    public void writeInt(int value) throws IOException {
        this._bbInt.position(0);
        this._bbInt.putInt(value);
        this._bbInt.flip();
        this._channel.write(this._bbInt);
    }

    public void writeLong(long value) throws IOException {
        this._bbLong.position(0);
        this._bbLong.putLong(value);
        this._bbLong.flip();
        this._channel.write(this._bbLong);
    }

    public void writeShort(short value) throws IOException {
        this._bbShort.position(0);
        this._bbShort.putShort(value);
        this._bbShort.flip();
        this._channel.write(this._bbShort);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this._channel.write(ByteBuffer.wrap(bytes));
    }

    public void writeInt(long position, int value) throws IOException {
        this._bbInt.position(0);
        this._bbInt.putInt(value);
        this._bbInt.flip();
        this._channel.write(this._bbInt, position);
    }

    public void writeLong(long position, long value) throws IOException {
        this._bbLong.position(0);
        this._bbLong.putLong(value);
        this._bbLong.flip();
        this._channel.write(this._bbLong, position);
    }

    public void writeShort(long position, short value) throws IOException {
        this._bbShort.position(0);
        this._bbShort.putShort(value);
        this._bbShort.flip();
        this._channel.write(this._bbShort, position);
    }

    public void writeBytes(long position, byte[] bytes) throws IOException {
        this._channel.write(ByteBuffer.wrap(bytes), position);
    }

    public long position() throws IOException {
        return this._channel.position();
    }

    public void position(long newPosition) throws IOException {
        this._channel.position(newPosition);
    }
}

