/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import krati.sos.ObjectCache;
import krati.sos.ObjectHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCacheAgent<T>
implements ObjectCache<T> {
    protected ObjectCache<T> _cache;
    protected ObjectHandler<T> _inboundHandler;
    protected ObjectHandler<T> _outboundHandler;

    public ObjectCacheAgent(ObjectCache<T> cache, ObjectHandler<T> inboundHandler, ObjectHandler<T> outboundHandler) {
        this._cache = cache;
        this._inboundHandler = inboundHandler;
        this._outboundHandler = outboundHandler;
    }

    public ObjectCache<T> getObjectCache() {
        return this._cache;
    }

    public ObjectHandler<T> getInboundHandler() {
        return this._inboundHandler;
    }

    public ObjectHandler<T> getOutboundHandler() {
        return this._outboundHandler;
    }

    @Override
    public int getObjectIdCount() {
        return this._cache.getObjectIdCount();
    }

    @Override
    public int getObjectIdStart() {
        return this._cache.getObjectIdStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(int objectId, long scn) throws Exception {
        ObjectCache<T> objectCache = this._cache;
        synchronized (objectCache) {
            return this._cache.delete(objectId, scn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(int objectId, T object, long scn) throws Exception {
        if (object != null && this._inboundHandler != null && this._inboundHandler.getEnabled()) {
            this._inboundHandler.process(object);
        }
        ObjectCache<T> objectCache = this._cache;
        synchronized (objectCache) {
            return this._cache.set(objectId, object, scn);
        }
    }

    @Override
    public T get(int objectId) {
        T object = this._cache.get(objectId);
        if (object != null && this._outboundHandler != null && this._outboundHandler.getEnabled()) {
            this._outboundHandler.process(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        ObjectCache<T> objectCache = this._cache;
        synchronized (objectCache) {
            this._cache.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws IOException {
        ObjectCache<T> objectCache = this._cache;
        synchronized (objectCache) {
            this._cache.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        ObjectCache<T> objectCache = this._cache;
        synchronized (objectCache) {
            this._cache.clear();
        }
    }

    @Override
    public long getHWMark() {
        return this._cache.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._cache.getLWMark();
    }

    @Override
    public void saveHWMark(long endOfPeriod) throws Exception {
        this._cache.saveHWMark(endOfPeriod);
    }

    @Override
    public byte[] getBytes(int objectId) {
        throw new UnsupportedOperationException();
    }
}

