/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.sos.ObjectHandler;
import krati.sos.ObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreAgent<K, V>
implements ObjectStore<K, V> {
    protected ObjectStore<K, V> _store;
    protected ObjectHandler<V> _inboundHandler;
    protected ObjectHandler<V> _outboundHandler;

    public ObjectStoreAgent(ObjectStore<K, V> store, ObjectHandler<V> inboundHandler, ObjectHandler<V> outboundHandler) {
        this._store = store;
        this._inboundHandler = inboundHandler;
        this._outboundHandler = outboundHandler;
    }

    public ObjectStore<K, V> getObjectStore() {
        return this._store;
    }

    public ObjectHandler<V> getInboundHandler() {
        return this._inboundHandler;
    }

    public ObjectHandler<V> getOutboundHandler() {
        return this._outboundHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key) throws Exception {
        ObjectStore<K, V> objectStore = this._store;
        synchronized (objectStore) {
            return this._store.delete(key);
        }
    }

    @Override
    public V get(K key) {
        Object value = this._store.get(key);
        if (value != null && this._outboundHandler != null && this._outboundHandler.getEnabled()) {
            this._outboundHandler.process(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) throws Exception {
        if (value != null && this._inboundHandler != null && this._inboundHandler.getEnabled()) {
            this._inboundHandler.process(value);
        }
        ObjectStore<K, V> objectStore = this._store;
        synchronized (objectStore) {
            return this._store.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        ObjectStore<K, V> objectStore = this._store;
        synchronized (objectStore) {
            this._store.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws IOException {
        ObjectStore<K, V> objectStore = this._store;
        synchronized (objectStore) {
            this._store.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        ObjectStore<K, V> objectStore = this._store;
        synchronized (objectStore) {
            this._store.clear();
        }
    }

    @Override
    public byte[] getBytes(K key) {
        return this._store.getBytes(key);
    }

    @Override
    public byte[] getBytes(byte[] keyBytes) {
        return this._store.getBytes(keyBytes);
    }

    @Override
    public Iterator<K> keyIterator() {
        return this._store.keyIterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this._store.iterator();
    }
}

