/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import krati.sos.ObjectCache;
import krati.sos.ObjectSerializer;
import krati.store.DataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableObjectCache<T>
implements ObjectCache<T> {
    protected final DataCache _cache;
    protected final ObjectSerializer<T> _serializer;

    public SerializableObjectCache(DataCache cache, ObjectSerializer<T> serializer) {
        this._cache = cache;
        this._serializer = serializer;
    }

    protected DataCache getContentCache() {
        return this._cache;
    }

    public ObjectSerializer<T> getSerializer() {
        return this._serializer;
    }

    @Override
    public int getObjectIdCount() {
        return this._cache.getIdCount();
    }

    @Override
    public int getObjectIdStart() {
        return this._cache.getIdStart();
    }

    @Override
    public T get(int objectId) {
        return this.getSerializer().construct(this._cache.get(objectId));
    }

    @Override
    public boolean set(int objectId, T object, long scn) throws Exception {
        if (object == null) {
            return this.delete(objectId, scn);
        }
        this._cache.set(objectId, this.getSerializer().serialize(object), scn);
        return true;
    }

    @Override
    public boolean delete(int objectId, long scn) throws Exception {
        this._cache.delete(objectId, scn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        DataCache dataCache = this._cache;
        synchronized (dataCache) {
            this._cache.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws IOException {
        DataCache dataCache = this._cache;
        synchronized (dataCache) {
            this._cache.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        DataCache dataCache = this._cache;
        synchronized (dataCache) {
            this._cache.clear();
        }
    }

    @Override
    public long getHWMark() {
        return this._cache.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._cache.getLWMark();
    }

    @Override
    public void saveHWMark(long endOfPeriod) throws Exception {
        this._cache.saveHWMark(endOfPeriod);
    }

    @Override
    public byte[] getBytes(int objectId) {
        return this._cache.get(objectId);
    }
}

