/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.sos.ObjectSerializer;
import krati.sos.ObjectStore;
import krati.sos.ObjectStoreIterator;
import krati.sos.ObjectStoreKeyIterator;
import krati.store.DataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableObjectStore<K, V>
implements ObjectStore<K, V> {
    protected final DataStore<byte[], byte[]> _store;
    protected final ObjectSerializer<K> _keySerializer;
    protected final ObjectSerializer<V> _valSerializer;

    public SerializableObjectStore(DataStore<byte[], byte[]> store, ObjectSerializer<K> keySerializer, ObjectSerializer<V> valSerializer) {
        this._store = store;
        this._keySerializer = keySerializer;
        this._valSerializer = valSerializer;
    }

    protected DataStore<byte[], byte[]> getContentStore() {
        return this._store;
    }

    public ObjectSerializer<K> getKeySerializer() {
        return this._keySerializer;
    }

    public ObjectSerializer<V> getValueSerializer() {
        return this._valSerializer;
    }

    @Override
    public V get(K key) {
        return this.getValueSerializer().construct(this._store.get(this.getKeySerializer().serialize(key)));
    }

    @Override
    public byte[] getBytes(K key) {
        return this._store.get(this.getKeySerializer().serialize(key));
    }

    @Override
    public byte[] getBytes(byte[] keyBytes) {
        return this._store.get(keyBytes);
    }

    @Override
    public boolean put(K key, V value) throws Exception {
        return this._store.put(this.getKeySerializer().serialize(key), this.getValueSerializer().serialize(value));
    }

    @Override
    public boolean delete(K key) throws Exception {
        return this._store.delete(this.getKeySerializer().serialize(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        DataStore<byte[], byte[]> dataStore = this._store;
        synchronized (dataStore) {
            this._store.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() throws IOException {
        DataStore<byte[], byte[]> dataStore = this._store;
        synchronized (dataStore) {
            this._store.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        DataStore<byte[], byte[]> dataStore = this._store;
        synchronized (dataStore) {
            this._store.clear();
        }
    }

    @Override
    public Iterator<K> keyIterator() {
        return new ObjectStoreKeyIterator<K>(this._store.keyIterator(), this._keySerializer);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new ObjectStoreIterator<K, V>(this._store.iterator(), this._keySerializer, this._valSerializer);
    }
}

