/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import krati.Persistable;
import krati.array.DataArray;
import krati.core.array.AddressArray;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;

public abstract class AbstractDataArray
implements DataArray,
Persistable {
    protected final SimpleDataArray _dataArray;
    protected final AddressArray _addrArray;
    protected final String _homePath;
    protected final File _homeDir;

    protected AbstractDataArray(int length, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        this._homeDir = homeDirectory;
        this._homePath = homeDirectory.getCanonicalPath();
        this._addrArray = this.createAddressArray(length, batchSize, numSyncBatches, homeDirectory);
        String segmentHome = this._homePath + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, segmentCompactFactor);
    }

    protected abstract AddressArray createAddressArray(int var1, int var2, int var3, File var4) throws Exception;

    public File getHomeDir() {
        return this._homeDir;
    }

    public String getHomePath() {
        return this._homePath;
    }

    public String getStatus() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("path");
        buffer.append("=");
        buffer.append(this._homePath);
        buffer.append(" ");
        buffer.append("length");
        buffer.append("=");
        buffer.append(this.length());
        buffer.append(" ");
        buffer.append("lwMark");
        buffer.append("=");
        buffer.append(this.getLWMark());
        buffer.append(" ");
        buffer.append("hwMark");
        buffer.append("=");
        buffer.append(this.getHWMark());
        return buffer.toString();
    }

    public int length() {
        return this._dataArray.length();
    }

    public boolean hasIndex(int index) {
        return this._dataArray.hasIndex(index);
    }

    public byte[] get(int index) {
        return this._dataArray.get(index);
    }

    public int get(int index, byte[] dst) {
        return this._dataArray.get(index, dst);
    }

    public int get(int index, byte[] dst, int offset) {
        return this._dataArray.get(index, dst, offset);
    }

    public int getLength(int index) {
        return this._dataArray.getLength(index);
    }

    public boolean hasData(int index) {
        return this._dataArray.hasData(index);
    }

    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this._dataArray.set(index, data, scn);
    }

    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this._dataArray.set(index, data, offset, length, scn);
    }

    public int transferTo(int index, WritableByteChannel channel) {
        return this._dataArray.transferTo(index, channel);
    }

    public synchronized void clear() {
        this._dataArray.clear();
    }

    public long getHWMark() {
        return this._dataArray.getHWMark();
    }

    public long getLWMark() {
        return this._dataArray.getLWMark();
    }

    public synchronized void saveHWMark(long endOfPeriod) throws Exception {
        this._dataArray.saveHWMark(endOfPeriod);
    }

    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }
}

