/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import krati.core.array.SimpleDataArray;
import krati.core.array.basic.DynamicLongArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import org.apache.log4j.Logger;

public final class BytesDB {
    static final Logger _logger = Logger.getLogger(BytesDB.class);
    private final SimpleDataArray _dataArray;
    private final DynamicLongArray _addrArray;
    private volatile int _nextIndexCount = 0;
    private final int _nextIndexQueueCapacity = 10000;
    private final LinkedBlockingQueue<Integer> _nextIndexQueue = new LinkedBlockingQueue(10000);
    private final ExecutorService _nextIndexExecutor = Executors.newSingleThreadExecutor(new LookupThreadFactory());

    public BytesDB(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5);
    }

    public BytesDB(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        _logger.info((Object)("init " + homeDir.getAbsolutePath()));
        this._addrArray = this.createAddressArray(batchSize, numSyncBatches, homeDir);
        if (initLevel > 0) {
            this._addrArray.expandCapacity(this._addrArray.subArrayLength() * (1 << initLevel) - 1);
        }
        String segmentHomePath = new File(homeDir, "segs").getAbsolutePath();
        SegmentManager segManager = SegmentManager.getInstance(segmentHomePath, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(this._addrArray, segManager, segmentCompactFactor);
        this.initNextIndexCount();
        this._nextIndexExecutor.execute(new NextIndexLookup());
        _logger.info((Object)"init done");
    }

    protected DynamicLongArray createAddressArray(int batchSize, int numSyncBatches, File homeDirectory) throws Exception {
        return new DynamicLongArray(batchSize, numSyncBatches, homeDirectory);
    }

    public boolean hasData(int index) {
        return this._dataArray.hasData(index);
    }

    public boolean hasIndex(int index) {
        return this._dataArray.hasIndex(index);
    }

    public int getLength(int index) {
        return this._dataArray.getLength(index);
    }

    public byte[] get(int index) {
        return this._dataArray.get(index);
    }

    public int get(int index, byte[] data) {
        return this._dataArray.get(index, data);
    }

    public int get(int index, byte[] data, int offset) {
        return this._dataArray.get(index, data, offset);
    }

    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this._dataArray.set(index, data, scn);
        if (data == null) {
            ++this._nextIndexCount;
        }
    }

    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this._dataArray.set(index, data, offset, length, scn);
        if (data == null) {
            ++this._nextIndexCount;
        }
    }

    public synchronized int add(byte[] data, long scn) throws Exception {
        int index = this._nextIndexQueue.take();
        this._dataArray.set(index, data, scn);
        --this._nextIndexCount;
        return index;
    }

    public synchronized int add(byte[] data, int offset, int length, long scn) throws Exception {
        int index = this._nextIndexQueue.take();
        this._dataArray.set(index, data, offset, length, scn);
        --this._nextIndexCount;
        return index;
    }

    public synchronized void clear() {
        this._dataArray.clear();
    }

    public synchronized void close() throws IOException {
        this._dataArray.sync();
        this._nextIndexExecutor.shutdown();
    }

    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    private void initNextIndexCount() {
        int length = this._addrArray.length();
        for (int index = 0; index < length; ++index) {
            long addr = this._addrArray.get(index);
            if (addr >= 128L) continue;
            ++this._nextIndexCount;
        }
        _logger.info((Object)("load " + (length - this._nextIndexCount) + "/" + length));
    }

    private static class LookupThreadFactory
    implements ThreadFactory {
        private LookupThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    private class NextIndexLookup
    implements Runnable {
        private NextIndexLookup() {
        }

        public void run() {
            int index = 0;
            int lastPut = -1;
            while (true) {
                if (index < BytesDB.this._addrArray.length()) {
                    long addr = BytesDB.this._addrArray.get(index);
                    if (addr < 128L) {
                        try {
                            BytesDB.this._nextIndexQueue.put(index);
                            lastPut = index;
                        }
                        catch (InterruptedException e) {
                            _logger.warn((Object)"Failed to add to _nextIndexQueue", (Throwable)e);
                        }
                    }
                    ++index;
                    continue;
                }
                int threshold = (int)((double)BytesDB.this._addrArray.length() * 0.1);
                if (BytesDB.this._nextIndexCount < threshold) {
                    try {
                        BytesDB.this._addrArray.expandCapacity(BytesDB.this._addrArray.length());
                        int cnt = BytesDB.this._nextIndexQueue.remainingCapacity();
                        for (int i = 0; i < cnt; ++i) {
                            if (index >= BytesDB.this._addrArray.length()) continue;
                            long addr = BytesDB.this._addrArray.get(index);
                            if (addr < 128L) {
                                try {
                                    BytesDB.this._nextIndexQueue.put(index);
                                    lastPut = index;
                                }
                                catch (InterruptedException e) {
                                    _logger.warn((Object)"Failed to add to _nextIndexQueue", (Throwable)e);
                                }
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        _logger.error((Object)"failed to expand _addrArray", (Throwable)e);
                    }
                }
                int nextPossible = 0;
                while (!BytesDB.this._nextIndexQueue.isEmpty()) {
                    if (nextPossible >= BytesDB.this._addrArray.length()) continue;
                    long addr = BytesDB.this._addrArray.get(nextPossible);
                    if (addr < 128L) {
                        try {
                            Thread.sleep(0L, 100);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    ++nextPossible;
                }
                if (nextPossible == lastPut) {
                    // empty if block
                }
                index = ++nextPossible;
            }
        }
    }
}

