/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import krati.core.array.SimpleDataArray;
import krati.core.array.basic.StaticLongArray;
import krati.core.segment.MemorySegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataCache;
import org.apache.log4j.Logger;

public class DataCacheImpl
implements DataCache {
    private static final Logger _log = Logger.getLogger(DataCacheImpl.class);
    private final SimpleDataArray _dataArray;
    private final int _idCount;
    private final int _idStart;
    private final int _idEnd;

    public DataCacheImpl(int memberIdStart, int memberIdCount, File cacheDirectory) throws Exception {
        this(memberIdStart, memberIdCount, cacheDirectory, new MemorySegmentFactory(), 256);
    }

    public DataCacheImpl(int memberIdStart, int memberIdCount, File cacheDirectory, int segmentFileSizeMB) throws Exception {
        this(memberIdStart, memberIdCount, cacheDirectory, new MemorySegmentFactory(), segmentFileSizeMB);
    }

    public DataCacheImpl(int memberIdStart, int memberIdCount, File cacheDirectory, SegmentFactory segmentFactory) throws Exception {
        this(memberIdStart, memberIdCount, cacheDirectory, segmentFactory, 256);
    }

    public DataCacheImpl(int memberIdStart, int memberIdCount, File cacheDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(memberIdStart, memberIdCount, 10000, 5, cacheDirectory, segmentFactory, segmentFileSizeMB, false);
    }

    public DataCacheImpl(int memberIdStart, int memberIdCount, int maxEntrySize, int maxEntries, File cacheDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, boolean checked) throws Exception {
        this._idStart = memberIdStart;
        this._idCount = memberIdCount;
        this._idEnd = memberIdStart + memberIdCount;
        StaticLongArray addressArray = new StaticLongArray(memberIdCount, maxEntrySize, maxEntries, cacheDirectory);
        if (addressArray.length() != memberIdCount) {
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + memberIdCount);
        }
        String segmentHome = cacheDirectory.getCanonicalPath() + File.separator + "segs";
        SegmentManager segManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(addressArray, segManager);
        if (checked) {
            // empty if block
        }
        _log.info((Object)("DataCache initiated: " + this.getStatus()));
    }

    public DataCacheImpl(int memberIdStart, int memberIdCount, int maxEntrySize, int maxEntries, File cacheDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor, boolean checked) throws Exception {
        this._idStart = memberIdStart;
        this._idCount = memberIdCount;
        this._idEnd = memberIdStart + memberIdCount;
        StaticLongArray addressArray = new StaticLongArray(memberIdCount, maxEntrySize, maxEntries, cacheDirectory);
        if (addressArray.length() != memberIdCount) {
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + memberIdCount);
        }
        String segmentHome = cacheDirectory.getCanonicalPath() + File.separator + "segs";
        SegmentManager segManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(addressArray, segManager, segmentCompactFactor);
        if (checked) {
            // empty if block
        }
        _log.info((Object)("DataCache initiated: " + this.getStatus()));
    }

    protected String getStatus() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("idStart");
        buffer.append("=");
        buffer.append(this.getIdStart());
        buffer.append(" ");
        buffer.append("idCount");
        buffer.append("=");
        buffer.append(this.getIdCount());
        buffer.append(" ");
        buffer.append("lwMark");
        buffer.append("=");
        buffer.append(this.getLWMark());
        buffer.append(" ");
        buffer.append("hwMark");
        buffer.append("=");
        buffer.append(this.getHWMark());
        return buffer.toString();
    }

    private void rangeCheck(int memberId) {
        if (memberId < this._idStart || this._idEnd <= memberId) {
            throw new ArrayIndexOutOfBoundsException(memberId);
        }
    }

    public int capacity() {
        return this._idCount;
    }

    public int getIdCount() {
        return this._idCount;
    }

    public int getIdStart() {
        return this._idStart;
    }

    public byte[] get(int memberId) {
        this.rangeCheck(memberId);
        return this._dataArray.get(memberId - this._idStart);
    }

    public int get(int memberId, byte[] dst) {
        this.rangeCheck(memberId);
        return this._dataArray.get(memberId - this._idStart, dst);
    }

    public int get(int memberId, byte[] dst, int offset) {
        this.rangeCheck(memberId);
        return this._dataArray.get(memberId - this._idStart, dst, offset);
    }

    public void set(int memberId, byte[] data, long scn) throws Exception {
        this.rangeCheck(memberId);
        this._dataArray.set(memberId - this._idStart, data, scn);
    }

    public void set(int memberId, byte[] data, int offset, int length, long scn) throws Exception {
        this.rangeCheck(memberId);
        this._dataArray.set(memberId - this._idStart, data, offset, length, scn);
    }

    public void delete(int memberId, long scn) throws Exception {
        this.rangeCheck(memberId);
        this._dataArray.set(memberId - this._idStart, null, scn);
    }

    public void sync() throws IOException {
        _log.info((Object)("prior sync: " + this.getStatus()));
        this._dataArray.sync();
        _log.info((Object)("after sync: " + this.getStatus()));
    }

    public void persist() throws IOException {
        _log.info((Object)("prior persist: " + this.getStatus()));
        this._dataArray.persist();
        _log.info((Object)("after persist: " + this.getStatus()));
    }

    public long getHWMark() {
        return this._dataArray.getHWMark();
    }

    public long getLWMark() {
        return this._dataArray.getLWMark();
    }

    public void saveHWMark(long endOfPeriod) throws Exception {
        this._dataArray.saveHWMark(endOfPeriod);
    }

    public void clear() throws IOException {
        this._dataArray.clear();
    }
}

