/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.nio.ByteBuffer;
import krati.store.DataSetHandler;

public final class DefaultDataSetHandler
implements DataSetHandler {
    public final byte[] assemble(byte[] value) {
        byte[] result = new byte[8 + value.length];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.putInt(1);
        bb.putInt(value.length);
        bb.put(value);
        return result;
    }

    public final byte[] assemble(byte[] value, byte[] data) {
        byte[] result = new byte[data.length + 4 + value.length];
        System.arraycopy(data, 0, result, 0, data.length);
        ByteBuffer bb = ByteBuffer.wrap(result);
        int cnt = bb.getInt();
        bb.position(0);
        bb.putInt(cnt + 1);
        bb.position(data.length);
        bb.putInt(value.length);
        bb.put(value);
        return result;
    }

    public final int count(byte[] data) {
        if (data.length >= 4) {
            ByteBuffer bb = ByteBuffer.wrap(data, 0, 4);
            return bb.getInt();
        }
        return 0;
    }

    public final int countCollisions(byte[] value, byte[] data) {
        try {
            int originalCnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                if (DefaultDataSetHandler.bytesEqual(value, data, bb.position(), len)) {
                    return originalCnt;
                }
                bb.position(bb.position() + len);
            }
            return -originalCnt;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public final int remove(byte[] value, byte[] data) {
        int originalCnt;
        int offset1 = 0;
        int offset2 = 0;
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
            offset1 = bb.position();
            int len = bb.getInt();
            if (DefaultDataSetHandler.bytesEqual(value, data, bb.position(), len)) {
                offset2 = bb.position() + len;
                break;
            }
            bb.position(bb.position() + len);
        }
        if (offset1 < offset2) {
            int newLength = data.length - (offset2 - offset1);
            if (newLength <= 4) {
                return 0;
            }
            bb.position(0);
            bb.putInt(originalCnt - 1);
            int len = data.length - offset2;
            for (int i = 0; i < len; ++i) {
                data[offset1 + i] = data[offset2 + i];
            }
            return newLength;
        }
        return data.length;
    }

    public final boolean find(byte[] value, byte[] data) {
        try {
            ByteBuffer bb = ByteBuffer.wrap(data);
            for (int cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                if (DefaultDataSetHandler.bytesEqual(value, data, bb.position(), len)) {
                    return true;
                }
                bb.position(bb.position() + len);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean bytesEqual(byte[] bytes, byte[] bytesSource, int offset, int length) {
        if (bytes.length == length) {
            for (int i = 0; i < length; ++i) {
                if (bytes[i] == bytesSource[offset + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

