/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import krati.array.DynamicArray;
import krati.core.array.AddressArray;
import krati.core.array.basic.DynamicLongArray;
import krati.core.segment.SegmentFactory;
import krati.store.AbstractDataArray;
import krati.store.ArrayStore;
import org.apache.log4j.Logger;

public final class DynamicDataArray
extends AbstractDataArray
implements DynamicArray,
ArrayStore {
    private static final Logger _log = Logger.getLogger(DynamicDataArray.class);

    public DynamicDataArray(int initialLength, File homeDirectory, SegmentFactory segmentFactory) throws Exception {
        this(initialLength, 10000, 5, homeDirectory, segmentFactory, 256, 0.5);
    }

    public DynamicDataArray(int initialLength, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(initialLength, 10000, 5, homeDirectory, segmentFactory, segmentFileSizeMB, 0.5);
    }

    public DynamicDataArray(int initialLength, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        super(initialLength, batchSize, numSyncBatches, homeDirectory, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
        _log.info((Object)("init " + this.getStatus()));
    }

    protected AddressArray createAddressArray(int length, int batchSize, int numSyncBatches, File homeDirectory) throws Exception {
        DynamicLongArray addrArray = new DynamicLongArray(batchSize, numSyncBatches, homeDirectory);
        addrArray.expandCapacity(length - 1);
        if (length != addrArray.length()) {
            _log.warn((Object)("array file length " + addrArray.length() + " is different from specified " + length));
        }
        return addrArray;
    }

    public synchronized void expandCapacity(int index) throws Exception {
        ((DynamicLongArray)this._addrArray).expandCapacity(index);
    }

    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        ((DynamicLongArray)this._addrArray).expandCapacity(index);
        this._dataArray.set(index, data, scn);
    }

    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        ((DynamicLongArray)this._addrArray).expandCapacity(index);
        this._dataArray.set(index, data, offset, length, scn);
    }

    public int capacity() {
        return this.length();
    }

    public synchronized void delete(int index, long scn) throws Exception {
        if (this.hasIndex(index)) {
            this._dataArray.set(index, null, scn);
        }
    }
}

