/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import krati.array.DataArray;
import krati.core.array.SimpleDataArray;
import krati.core.array.basic.DynamicLongArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataStore;
import krati.store.DataStoreHandler;
import krati.store.DataStoreIterator;
import krati.store.DataStoreKeyIterator;
import krati.store.DefaultDataStoreHandler;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _log = Logger.getLogger(DynamicDataStore.class);
    private final double _loadThreshold;
    private final SimpleDataArray _dataArray;
    private final DynamicLongArray _addrArray;
    private final DataStoreHandler _dataHandler = new DefaultDataStoreHandler();
    private final HashFunction<byte[]> _hashFunction;
    private volatile int _split;
    private volatile int _level;
    private volatile int _levelCapacity;
    private int _levelThreshold;
    private int _unitCapacity;
    private int _loadCount;

    public DynamicDataStore(File homeDir, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, 0, 10000, 5, 256, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 5, 256, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 5, 256, segmentFactory, 0.5, 0.75, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 5, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadThreshold, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 5, segmentFileSizeMB, segmentFactory, 0.5, hashLoadThreshold, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataStore(File homeDir, int initLevel, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadThreshold, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, hashLoadThreshold, hashFunction);
    }

    public DynamicDataStore(File homeDir, int initLevel, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, double hashLoadThreshold, HashFunction<byte[]> hashFunction) throws Exception {
        this._addrArray = this.createAddressArray(entrySize, maxEntries, homeDir);
        this._unitCapacity = this._addrArray.subArrayLength();
        if (initLevel > 0) {
            this._addrArray.expandCapacity(this._unitCapacity * (1 << initLevel) - 1);
        }
        String segmentHome = homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, segmentCompactFactor);
        this._hashFunction = hashFunction;
        this._loadThreshold = hashLoadThreshold;
        this._loadCount = this.scan();
        this.initLinearHashing();
        _log.info((Object)this.getStatus());
    }

    protected DynamicLongArray createAddressArray(int entrySize, int maxEntries, File homeDirectory) throws Exception {
        return new DynamicLongArray(entrySize, maxEntries, homeDirectory);
    }

    protected long hash(byte[] key) {
        return this._hashFunction.hash(key);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public byte[] get(byte[] key) {
        byte[] existingData;
        long hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        while (true) {
            existingData = this._dataArray.get(index);
            int indexNew = this.getIndex(hashCode);
            if (index == indexNew) break;
            index = indexNew;
        }
        return existingData == null ? null : this._dataHandler.extractByKey(key, existingData);
    }

    @Override
    public synchronized boolean put(byte[] key, byte[] value) throws Exception {
        if (value == null) {
            return this.delete(key);
        }
        if (0 < this._split || this._levelThreshold < this._loadCount) {
            this.split();
        }
        int index = this.getIndex(key);
        return this.putInternal(index, key, value);
    }

    @Override
    public synchronized boolean delete(byte[] key) throws Exception {
        if (0 < this._split || this._levelThreshold < this._loadCount) {
            this.split();
        }
        int index = this.getIndex(key);
        return this.deleteInternal(index, key);
    }

    @Override
    public synchronized void clear() throws IOException {
        this._dataArray.clear();
        this._loadCount = 0;
    }

    protected final int getIndex(byte[] key) {
        int capacity;
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)(capacity = this._levelCapacity));
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (long)(capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected final int getIndex(long hashCode) {
        int capacity = this._levelCapacity;
        int index = (int)(hashCode % (long)capacity);
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (long)(capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected boolean putInternal(int index, byte[] key, byte[] value) throws Exception {
        byte[] existingData = this._dataArray.get(index);
        if (existingData == null || existingData.length == 0) {
            this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            ++this._loadCount;
        } else {
            try {
                this._dataArray.set(index, this._dataHandler.assemble(key, value, existingData), this.nextScn());
            }
            catch (Exception e) {
                _log.warn((Object)("Value reset at index=" + index + " key=\"" + new String(key) + "\""));
                this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            }
        }
        return true;
    }

    protected boolean deleteInternal(int index, byte[] key) throws Exception {
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.removeByKey(key, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    --this._loadCount;
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete key=\"" + new String(key) + "\" : " + e.getMessage()));
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    public final int getLevel() {
        return this._level;
    }

    public final int getSplit() {
        return this._split;
    }

    public final int getCapacity() {
        return this._dataArray.length();
    }

    public final int getUnitCapacity() {
        return this._unitCapacity;
    }

    public final int getLevelCapacity() {
        return this._levelCapacity;
    }

    public final int getLoadCount() {
        return this._loadCount;
    }

    public final double getLoadFactor() {
        return (double)this._loadCount / (double)this.getCapacity();
    }

    public final double getLoadThreshold() {
        return this._loadThreshold;
    }

    private void initLinearHashing() throws Exception {
        int unitCount = this._dataArray.length() / this.getUnitCapacity();
        if (unitCount == 1) {
            this._level = 0;
            this._split = 0;
            this._levelCapacity = this.getUnitCapacity();
            this._levelThreshold = (int)((double)this._levelCapacity * this._loadThreshold);
        } else {
            this._level = 0;
            for (int remainder = unitCount - 1 >> 1; remainder > 0; remainder >>= 1) {
                ++this._level;
            }
            this._split = (unitCount - (1 << this._level) - 1) * this.getUnitCapacity();
            this._levelCapacity = this.getUnitCapacity() * (1 << this._level);
            this._levelThreshold = (int)((double)this._levelCapacity * this._loadThreshold);
            int cnt = this.getUnitCapacity();
            for (int i = 0; i < cnt; ++i) {
                this.split();
            }
        }
    }

    protected synchronized void split() throws Exception {
        this._addrArray.expandCapacity(this._split + this._levelCapacity);
        byte[] data = this._dataArray.get(this._split);
        if (data != null && data.length > 0) {
            ByteBuffer bb = ByteBuffer.wrap(data);
            int newCapacity = this._levelCapacity << 1;
            for (int cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                byte[] key = new byte[len];
                bb.get(key);
                int newIndex = (int)(this.hash(key) % (long)newCapacity);
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                if (newIndex == this._split) {
                    len = bb.getInt();
                    bb.position(bb.position() + len);
                    continue;
                }
                len = bb.getInt();
                byte[] value = new byte[len];
                bb.get(value);
                this.deleteInternal(this._split, key);
                this.putInternal(newIndex, key, value);
            }
        }
        ++this._split;
        if (this._split % this._unitCapacity == 0) {
            _log.info((Object)("split " + this.getStatus()));
        }
        if (this._split == this._levelCapacity) {
            this._split = 0;
            ++this._level;
            this._levelCapacity = this.getUnitCapacity() * (1 << this._level);
            this._levelThreshold = (int)((double)this._levelCapacity * this._loadThreshold);
            _log.info((Object)this.getStatus());
        }
    }

    private int scan() {
        int cnt = 0;
        int len = this._dataArray.length();
        for (int i = 0; i < len; ++i) {
            if (!this._dataArray.hasData(i)) continue;
            ++cnt;
        }
        return cnt;
    }

    public synchronized void rehash() throws Exception {
        if (this._split > 0) {
            do {
                this.split();
            } while (this._split > 0);
            this.sync();
        } else if (this.getLoadFactor() > this._loadThreshold) {
            do {
                this.split();
            } while (this._split > 0);
            this.sync();
        }
    }

    public String getStatus() {
        StringBuffer buf = new StringBuffer();
        buf.append("level=");
        buf.append(this._level);
        buf.append(" split=");
        buf.append(this._split);
        buf.append(" capacity=");
        buf.append(this.getCapacity());
        buf.append(" loadCount=");
        buf.append(this._loadCount);
        buf.append(" loadFactor=");
        buf.append(this.getLoadFactor());
        return buf.toString();
    }

    public DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public Iterator<byte[]> keyIterator() {
        return new DataStoreKeyIterator(this._dataArray, this._dataHandler);
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return new DataStoreIterator(this._dataArray, this._dataHandler);
    }
}

