/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import krati.core.segment.SegmentFactory;
import krati.store.BytesDB;
import krati.store.DataStore;
import krati.store.index.HashIndex;
import krati.store.index.Index;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _logger = Logger.getLogger(IndexedDataStore.class);
    private final BytesDB _bytesDB;
    private final Index _index;
    private final File _indexHome;
    private final File _storeHome;
    private int _batchSize;
    private int _updateCnt;

    public IndexedDataStore(File homeDir, int batchSize, int numSyncBatches, SegmentFactory indexSegmentFactory, SegmentFactory storeSegmentFactory) throws Exception {
        this(homeDir, batchSize, numSyncBatches, 8, 32, indexSegmentFactory, 8, 256, storeSegmentFactory);
    }

    public IndexedDataStore(File homeDir, int batchSize, int numSyncBatches, int indexInitLevel, int indexSegmentFileSizeMB, SegmentFactory indexSegmentFactory, int storeInitLevel, int storeSegmentFileSizeMB, SegmentFactory storeSegmentFactory) throws Exception {
        this._storeHome = new File(homeDir, "store");
        this._bytesDB = new BytesDB(this._storeHome, storeInitLevel, batchSize, numSyncBatches, storeSegmentFileSizeMB, storeSegmentFactory);
        this._indexHome = new File(homeDir, "index");
        this._index = new HashIndex(this._indexHome, indexInitLevel, batchSize, numSyncBatches, indexSegmentFileSizeMB, indexSegmentFactory);
        this._batchSize = batchSize;
        _logger.info((Object)("opened indexHome=" + this._indexHome.getAbsolutePath() + " storeHome=" + this._storeHome.getAbsolutePath()));
    }

    public final File getIndexHome() {
        return this._indexHome;
    }

    public final File getStoreHome() {
        return this._storeHome;
    }

    @Override
    public byte[] get(byte[] key) {
        if (key == null) {
            return null;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return null;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return null;
        }
        return this._bytesDB.get(meta.getDataAddr());
    }

    @Override
    public boolean put(byte[] key, byte[] value) throws Exception {
        if (value == null) {
            return this.delete(key);
        }
        if (key == null) {
            return false;
        }
        IndexMeta meta = null;
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes != null) {
            meta = IndexMeta.parse(metaBytes);
        }
        if (meta == null) {
            int index = this._bytesDB.add(value, System.currentTimeMillis());
            metaBytes = IndexMeta.build(index);
            this._index.update(key, metaBytes);
        } else {
            int index = meta.getDataAddr();
            this._bytesDB.set(index, value, System.currentTimeMillis());
        }
        ++this._updateCnt;
        if (this._updateCnt >= this._batchSize) {
            this._updateCnt = 0;
            this.persist();
        }
        return true;
    }

    @Override
    public boolean delete(byte[] key) throws Exception {
        if (key == null) {
            return false;
        }
        byte[] metaBytes = this._index.lookup(key);
        if (metaBytes == null) {
            return false;
        }
        IndexMeta meta = IndexMeta.parse(metaBytes);
        if (meta == null) {
            return false;
        }
        this._bytesDB.set(meta.getDataAddr(), null, System.currentTimeMillis());
        this._index.update(key, null);
        ++this._updateCnt;
        if (this._updateCnt >= this._batchSize) {
            this._updateCnt = 0;
            this.persist();
        }
        return true;
    }

    @Override
    public void clear() throws IOException {
        this._bytesDB.clear();
        this._index.clear();
    }

    @Override
    public void persist() throws IOException {
        this._bytesDB.persist();
        this._index.persist();
    }

    @Override
    public void sync() throws IOException {
        this._bytesDB.sync();
        this._index.sync();
    }

    @Override
    public Iterator<byte[]> keyIterator() {
        return this._index.keyIterator();
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return new IndexedDataStoreIterator(this._index.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexedDataStoreIterator
    implements Iterator<Map.Entry<byte[], byte[]>> {
        final Iterator<Map.Entry<byte[], byte[]>> _indexIter;

        IndexedDataStoreIterator(Iterator<Map.Entry<byte[], byte[]>> indexIter) {
            this._indexIter = indexIter;
        }

        @Override
        public boolean hasNext() {
            return this._indexIter.hasNext();
        }

        @Override
        public Map.Entry<byte[], byte[]> next() {
            Map.Entry<byte[], byte[]> keyMeta = this._indexIter.next();
            if (keyMeta != null) {
                IndexMeta meta = IndexMeta.parse(keyMeta.getValue());
                if (meta == null) {
                    return null;
                }
                byte[] value = IndexedDataStore.this._bytesDB.get(meta.getDataAddr());
                return new AbstractMap.SimpleEntry<byte[], byte[]>(keyMeta.getKey(), value);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class IndexMeta {
        final int _dataAddr;
        static final int META_SIZE = 4;

        IndexMeta(int dataAddr) {
            this._dataAddr = dataAddr;
        }

        static byte[] build(int dataAddr) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(dataAddr);
            return bb.array();
        }

        static IndexMeta parse(byte[] metaBytes) {
            if (metaBytes.length != 4) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(metaBytes);
            int dataAddr = bb.getInt();
            return new IndexMeta(dataAddr);
        }

        int getDataAddr() {
            return this._dataAddr;
        }
    }
}

