/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import krati.core.array.AddressArray;
import krati.core.array.basic.StaticLongArray;
import krati.core.segment.SegmentFactory;
import krati.store.AbstractDataArray;
import krati.store.ArrayStore;
import org.apache.log4j.Logger;

public final class StaticDataArray
extends AbstractDataArray
implements ArrayStore {
    private static final Logger _log = Logger.getLogger(StaticDataArray.class);

    public StaticDataArray(int length, File homeDirectory, SegmentFactory segmentFactory) throws Exception {
        this(length, 10000, 5, homeDirectory, segmentFactory, 256, 0.5);
    }

    public StaticDataArray(int length, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(length, 10000, 5, homeDirectory, segmentFactory, segmentFileSizeMB, 0.5);
    }

    public StaticDataArray(int length, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        super(length, batchSize, numSyncBatches, homeDirectory, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
        _log.info((Object)("init " + this.getStatus()));
    }

    protected AddressArray createAddressArray(int length, int batchSize, int numSyncBatches, File homeDirectory) throws Exception {
        StaticLongArray addrArray = new StaticLongArray(length, batchSize, numSyncBatches, homeDirectory);
        if (length != addrArray.length()) {
            _log.warn((Object)("array file length " + addrArray.length() + " is different from specified " + length));
        }
        return addrArray;
    }

    public int capacity() {
        return this.length();
    }

    public void delete(int index, long scn) throws Exception {
        if (this.hasIndex(index)) {
            this._dataArray.set(index, null, scn);
        }
    }
}

