/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import krati.array.DataArray;
import krati.core.array.AddressArray;
import krati.core.array.SimpleDataArray;
import krati.core.array.basic.StaticLongArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataSet;
import krati.store.DataSetHandler;
import krati.store.DefaultDataSetHandler;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticDataSet
implements DataSet<byte[]> {
    private static final Logger _log = Logger.getLogger(StaticDataSet.class);
    private final SimpleDataArray _dataArray;
    private final DataSetHandler _dataHandler = new DefaultDataSetHandler();
    private final HashFunction<byte[]> _hashFunction;

    public StaticDataSet(File homeDir, int capacity, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataSet(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, capacity, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, hashFunction);
    }

    public StaticDataSet(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, HashFunction<byte[]> hashFunction) throws Exception {
        AddressArray addressArray = this.createAddressArray(capacity, entrySize, maxEntries, homeDir);
        if (addressArray.length() != capacity) {
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + capacity);
        }
        String segmentHome = homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, segmentCompactFactor);
        this._hashFunction = hashFunction;
    }

    protected AddressArray createAddressArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        return new StaticLongArray(length, entrySize, maxEntries, homeDirectory);
    }

    protected long hash(byte[] value) {
        return this._hashFunction.hash(value);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public boolean has(byte[] value) {
        byte[] existingData;
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? false : this._dataHandler.find(value, existingData);
    }

    public final int countCollisions(byte[] value) {
        byte[] existingData;
        if (value == null) {
            return 0;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? 0 : this._dataHandler.countCollisions(value, existingData);
    }

    public final boolean hasWithoutCollisions(byte[] value) {
        return this.countCollisions(value) == 1;
    }

    @Override
    public synchronized boolean add(byte[] value) throws Exception {
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        byte[] existingData = this._dataArray.get(index);
        try {
            if (existingData == null || existingData.length == 0) {
                this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
            } else if (!this._dataHandler.find(value, existingData)) {
                this._dataArray.set(index, this._dataHandler.assemble(value, existingData), this.nextScn());
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Value reset at index=" + index + " value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
        }
        return true;
    }

    @Override
    public synchronized boolean delete(byte[] value) throws Exception {
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.remove(value, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    @Override
    public synchronized void clear() throws IOException {
        this._dataArray.clear();
    }

    public final DataArray getDataArray() {
        return this._dataArray;
    }
}

