/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.array.DataArray;
import krati.core.array.AddressArray;
import krati.core.array.SimpleDataArray;
import krati.core.array.basic.StaticLongArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataStore;
import krati.store.DataStoreHandler;
import krati.store.DataStoreIterator;
import krati.store.DataStoreKeyIterator;
import krati.store.DefaultDataStoreHandler;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _log = Logger.getLogger(StaticDataStore.class);
    private final SimpleDataArray _dataArray;
    private final DataStoreHandler _dataHandler = new DefaultDataStoreHandler();
    private final HashFunction<byte[]> _hashFunction;

    public StaticDataStore(File homeDir, int capacity, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, capacity, entrySize, maxEntries, segmentFileSizeMB, segmentFactory, 0.5, hashFunction);
    }

    public StaticDataStore(File homeDir, int capacity, int entrySize, int maxEntries, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, HashFunction<byte[]> hashFunction) throws Exception {
        AddressArray addressArray = this.createAddressArray(capacity, entrySize, maxEntries, homeDir);
        if (addressArray.length() != capacity) {
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + capacity);
        }
        String segmentHome = homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, segmentFactory, segmentFileSizeMB);
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, segmentCompactFactor);
        this._hashFunction = hashFunction;
    }

    protected AddressArray createAddressArray(int length, int entrySize, int maxEntries, File homeDirectory) throws Exception {
        return new StaticLongArray(length, entrySize, maxEntries, homeDirectory);
    }

    protected long hash(byte[] key) {
        return this._hashFunction.hash(key);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public byte[] get(byte[] key) {
        byte[] existingData;
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? null : this._dataHandler.extractByKey(key, existingData);
    }

    @Override
    public synchronized boolean put(byte[] key, byte[] value) throws Exception {
        byte[] existingData;
        if (value == null) {
            return this.delete(key);
        }
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        if ((existingData = this._dataArray.get(index)) == null || existingData.length == 0) {
            this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
        } else {
            try {
                this._dataArray.set(index, this._dataHandler.assemble(key, value, existingData), this.nextScn());
            }
            catch (Exception e) {
                _log.warn((Object)("Value reset at index=" + index + " key=\"" + new String(key) + "\""));
                this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            }
        }
        return true;
    }

    @Override
    public synchronized boolean delete(byte[] key) throws Exception {
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.removeByKey(key, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete key=\"" + new String(key) + "\" : " + e.getMessage()));
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    @Override
    public synchronized void clear() throws IOException {
        this._dataArray.clear();
    }

    public DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public Iterator<byte[]> keyIterator() {
        return new DataStoreKeyIterator(this._dataArray, this._dataHandler);
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return new DataStoreIterator(this._dataArray, this._dataHandler);
    }
}

