/*
 * Decompiled with CFR 0.152.
 */
package krati.store.index;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.core.segment.SegmentFactory;
import krati.store.DynamicDataStore;
import krati.store.index.Index;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashIndex
implements Index {
    private static final Logger _logger = Logger.getLogger(HashIndex.class);
    private final DynamicDataStore _store;

    public HashIndex(File homeDir, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, 6, 1000, 5, 32, segmentFactory, new FnvHashFunction());
    }

    public HashIndex(File homeDir, int initLevel, int batchSize, int numSyncBatches, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, 32, segmentFactory, new FnvHashFunction());
    }

    public HashIndex(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, new FnvHashFunction());
    }

    public HashIndex(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        _logger.info((Object)("init from " + homeDir.getPath()));
        this._store = new DynamicDataStore(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, 0.75, hashFunction);
        _logger.info((Object)"init done");
    }

    @Override
    public void sync() throws IOException {
        this._store.sync();
    }

    @Override
    public void persist() throws IOException {
        this._store.persist();
    }

    @Override
    public void clear() throws IOException {
        this._store.clear();
    }

    @Override
    public byte[] lookup(byte[] keyBytes) {
        return this._store.get(keyBytes);
    }

    @Override
    public void update(byte[] keyBytes, byte[] metaBytes) throws Exception {
        this._store.put(keyBytes, metaBytes);
    }

    @Override
    public Iterator<byte[]> keyIterator() {
        return this._store.keyIterator();
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this._store.iterator();
    }
}

