/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import krati.store.DataCache;
import krati.util.DataCacheLoader;
import org.apache.log4j.Logger;

public class DataCacheLoaderImpl
implements DataCacheLoader {
    private static final Logger _log = Logger.getLogger(DataCacheLoaderImpl.class);

    public void load(DataCache cache, File dataFile) throws IOException {
        String line;
        int index;
        FileReader reader = new FileReader(dataFile);
        BufferedReader in = new BufferedReader(reader);
        int stopIndex = index + cache.getIdCount();
        for (index = cache.getIdStart(); (line = in.readLine()) != null && index < stopIndex; ++index) {
            try {
                cache.set(index, line.getBytes(), index);
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("index=" + index + ": " + e.getMessage()));
                e.printStackTrace();
            }
        }
        in.close();
        reader.close();
        cache.persist();
    }

    public void dump(DataCache cache, File dumpFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(dumpFile);
        PrintWriter out = new PrintWriter(fos);
        int cnt = cache.getIdCount();
        for (int index = cache.getIdStart(); index < cnt; ++index) {
            byte[] data = cache.get(index);
            if (data != null) {
                String line = new String(data);
                out.println(line);
            } else {
                out.println();
            }
            if (index % 10000 != 0) continue;
            out.flush();
        }
        out.flush();
        out.close();
        fos.close();
    }
}

