/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import krati.util.HashFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MurmurHashFunction
implements HashFunction<byte[]> {
    public static int hash(byte[] data, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ data.length;
        int len = data.length;
        int len_4 = len >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = len - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[len - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[len - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[len - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    @Override
    public final long hash(byte[] buffer) {
        long hash = MurmurHashFunction.hash(buffer, 1);
        return hash == 0L ? Long.MAX_VALUE : hash;
    }
}

