package org.logolith.kzgo;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

/**
 * JNA Structure mapping for the C InterpolateResult struct.
 * Used to return the result (polynomial coefficients) from the interpolate_poly function.
 * struct {
 *     CBuffer result_coeffs; // Note: This is CBuffer (buffer in C), returned BY VALUE
 *     int error_code;
 * } InterpolateResult;
 */
public class InterpolateResult extends Structure {
    // Use CBuffer.ByValue because the C struct contains CBuffer directly,
    // not a pointer to a CBuffer.
    public CBuffer.ByValue result_coeffs;
    public int error_code;      // Error code (0 for success)

    public InterpolateResult() {
        super();
    }

    // Constructor might need adjustment if used directly, but likely not needed
    // public InterpolateResult(CBuffer.ByValue result_coeffs, int error_code) { ... }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("result_coeffs", "error_code");
    }

    // These are less relevant now, but harmless
    public static class ByReference extends InterpolateResult implements Structure.ByReference {}
    public static class ByValue extends InterpolateResult implements Structure.ByValue {}
} 