package org.logolith.kzgo;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;

/**
 * JNA interface mapping to the native functions exported from the Go shared library.
 */
public interface KZGBridgeNative extends Library {
    KZGBridgeNative INSTANCE = Native.load("kzgo", KZGBridgeNative.class);

    // Define methods matching the exported C functions
    // Use output pointers for structs and error codes

    // Commit function (takes coefficients)
    int commit_to_poly(CBuffer.ByValue coeffs_bytes_c,
                         CBuffer result_out, // Pointer type for output struct
                         IntByReference error_code_out);

    // New commit function (takes evaluations)
    int commit_from_evaluations(CBuffer.ByValue evaluations_bytes_c,
                                  CBuffer result_out, // Pointer type for output struct
                                  IntByReference error_code_out);

    // New hash-to-field function
    int hash_to_fr(CBuffer.ByValue msg_bytes_c, CBuffer.ByValue domain_bytes_c,
                     CBuffer result_out, // Pointer type for output struct
                     IntByReference error_code_out);

    // New commit function taking raw node data
    int commit_node(CBuffer.ByValue node_data_c,
                      CBuffer result_out,
                      IntByReference error_code_out);

    // Added: Interpolate function taking raw node data
    int interpolate_node(CBuffer.ByValue node_data_c,
                         CBuffer result_out,
                         IntByReference error_code_out);

    // Open function (takes coefficients)
    int open_poly(CBuffer.ByValue coeffs_bytes_c, CBuffer.ByValue point_z_bytes_c,
                    CBuffer proof_h_out, CBuffer claimed_value_out, // Output struct pointers
                    IntByReference error_code_out);

    int verify_poly_proof(CBuffer.ByValue commitment_bytes_c,
                          CBuffer.ByValue proof_h_bytes_c,
                          CBuffer.ByValue point_z_bytes_c,
                          CBuffer.ByValue claimed_value_bytes_c);

    int verify_poly_proof_with_vk(CBuffer.ByValue commitment_bytes_c,
                                  CBuffer.ByValue proof_h_bytes_c,
                                  CBuffer.ByValue point_z_bytes_c,
                                  CBuffer.ByValue claimed_value_bytes_c,
                                  CBuffer.ByValue vk_bytes_c);

    int interpolate_poly(CBuffer.ByValue values_bytes_c,
                         CBuffer result_coeffs_out,
                         IntByReference error_code_out);

    void free_buffer(CBuffer.ByValue buf);
}
