/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.Constants;

public abstract class AnnotationVisitor {
    protected final int api;
    protected AnnotationVisitor av;

    public AnnotationVisitor(int api) {
        this(api, null);
    }

    public AnnotationVisitor(int api, AnnotationVisitor annotationVisitor) {
        if (api != 589824 && api != 524288 && api != 458752 && api != 393216 && api != 327680 && api != 262144 && api != 0x10A0000) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == 0x10A0000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = api;
        this.av = annotationVisitor;
    }

    public void visit(String name2, Object value) {
        if (this.av != null) {
            this.av.visit(name2, value);
        }
    }

    public void visitEnum(String name2, String descriptor2, String value) {
        if (this.av != null) {
            this.av.visitEnum(name2, descriptor2, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name2, String descriptor2) {
        if (this.av != null) {
            return this.av.visitAnnotation(name2, descriptor2);
        }
        return null;
    }

    public AnnotationVisitor visitArray(String name2) {
        if (this.av != null) {
            return this.av.visitArray(name2);
        }
        return null;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }
}

