// Compiled by ClojureScript 1.10.773 {}
goog.provide('tiltontec.cell.evaluate');
goog.require('cljs.core');
goog.require('tiltontec.cell.integrity');
goog.require('tiltontec.util.trace');
goog.require('tiltontec.util.ref');
goog.require('tiltontec.util.core');
goog.require('clojure.string');
goog.require('tiltontec.cell.base');
goog.require('tiltontec.cell.diagnostic');
goog.require('tiltontec.cell.poly');
/**
 * Do watch on cell & record the watched pulse (Checkout
 *   `c-pulse-unwatched?`).
 */
tiltontec.cell.evaluate.c_watch = (function tiltontec$cell$evaluate$c_watch(var_args){
var G__4621 = arguments.length;
switch (G__4621) {
case 2:
return tiltontec.cell.evaluate.c_watch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tiltontec.cell.evaluate.c_watch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tiltontec.cell.evaluate.c_watch.cljs$core$IFn$_invoke$arity$2 = (function (c,why){
return tiltontec.cell.evaluate.c_watch.call(null,c,tiltontec.cell.base.unbound,why);
}));

(tiltontec.cell.evaluate.c_watch.cljs$core$IFn$_invoke$arity$3 = (function (c,prior_value,_why){
if(tiltontec.cell.base.c_ref_QMARK_.call(null,c)){
} else {
throw (new Error("Assert failed: (c-ref? c)"));
}

if(cljs.core.integer_QMARK_.call(null,cljs.core.deref.call(null,tiltontec.cell.base._STAR_pulse_STAR_))){
} else {
throw (new Error("Assert failed: (integer? (clojure.core/deref *pulse*))"));
}

var v__1174__auto___4623 = cljs.core.deref.call(null,tiltontec.cell.base._STAR_pulse_STAR_);
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword(null,"pulse-watched","pulse-watched",33719362),v__1174__auto___4623);


tiltontec.cell.poly.watch.call(null,tiltontec.cell.base.c_prop.call(null,c),tiltontec.cell.base.c_model.call(null,c),tiltontec.cell.base.c_value.call(null,c),prior_value,c);

var temp__5804__auto__ = new cljs.core.Keyword(null,"watch","watch",380988277).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,c));
if(cljs.core.truth_(temp__5804__auto__)){
var cw = temp__5804__auto__;
return cw.call(null,tiltontec.cell.base.c_prop.call(null,c),tiltontec.cell.base.c_model.call(null,c),tiltontec.cell.base.c_value.call(null,c),prior_value,c);
} else {
return null;
}
}));

(tiltontec.cell.evaluate.c_watch.cljs$lang$maxFixedArity = 3);

/**
 * Checkout `tiltontec.cell.base/c-value` &
 *   `tiltontec.cell.base/c-optimized-away?`.
 * 
 *   returns [value-state/:non-ref value].
 */
tiltontec.cell.evaluate.cget_value = (function tiltontec$cell$evaluate$cget_value(c){
if(tiltontec.cell.base.c_ref_QMARK_.call(null,c)){
var v = cljs.core.deref.call(null,c);
if(((cljs.core.map_QMARK_.call(null,v)) && (cljs.core.contains_QMARK_.call(null,v,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396).cljs$core$IFn$_invoke$arity$1(v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(v)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimized-away","optimized-away",876765856),v], null);
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"non-ref","non-ref",-1706863294),c], null);
}
});
tiltontec.cell.evaluate.ephemeral_reset = (function tiltontec$cell$evaluate$ephemeral_reset(rc){
if(cljs.core.truth_(tiltontec.cell.base.c_ephemeral_QMARK_.call(null,rc))){
return tiltontec.cell.integrity.call_with_integrity.call(null,new cljs.core.Keyword(null,"ephemeral-reset","ephemeral-reset",-1442676603),rc,(function (opcode,defer_info){
var temp__5804__auto___4624 = tiltontec.cell.base.c_model.call(null,rc);
if(cljs.core.truth_(temp__5804__auto___4624)){
var me_4625 = temp__5804__auto___4624;
var temp__5804__auto___4626__$1 = tiltontec.cell.base.c_prop.call(null,rc);
if(cljs.core.truth_(temp__5804__auto___4626__$1)){
var p_4627 = temp__5804__auto___4626__$1;
cljs.core.swap_BANG_.call(null,me_4625,cljs.core.assoc,p_4627,null);
} else {
}
} else {
}

return cljs.core.swap_BANG_.call(null,rc,cljs.core.assoc,new cljs.core.Keyword(null,"value","value",305978217),null);
}));
} else {
return null;
}
});


/**
 * The key to data integrity: recursively check the known dependency
 *   graph to decide if we are current, and if not kick off recalculation
 *   and propagation.
 */
tiltontec.cell.evaluate.ensure_value_is_current = (function tiltontec$cell$evaluate$ensure_value_is_current(c){
if(cljs.core.truth_(tiltontec.cell.integrity.c_current_QMARK_.call(null,c))){
return tiltontec.cell.base.c_value.call(null,c);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = tiltontec.cell.base.c_input_QMARK_.call(null,c);
if(cljs.core.truth_(and__4115__auto__)){
return ((tiltontec.cell.base.c_valid_QMARK_.call(null,c)) && ((!(((tiltontec.cell.base.c_formula_QMARK_.call(null,c)) && (cljs.core._EQ_.call(null,tiltontec.cell.base.c_optimize.call(null,c),new cljs.core.Keyword(null,"when-value-t","when-value-t",1756613336))) && ((tiltontec.cell.base.c_value.call(null,c) == null)))))));
} else {
return and__4115__auto__;
}
})())){
return tiltontec.cell.base.c_value.call(null,c);
} else {
if(cljs.core.truth_((function (){var G__4628 = tiltontec.cell.base.c_model.call(null,c);
if((G__4628 == null)){
return null;
} else {
return tiltontec.cell.base.md_dead_QMARK_.call(null,G__4628);
}
})())){
throw cljs.core.ex_info.call(null,"evic> model of cell is dead",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cell","cell",764245084),c], null));
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = (!(tiltontec.cell.base.c_valid_QMARK_.call(null,c)));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var G__4642 = cljs.core.seq.call(null,tiltontec.cell.base.c_useds.call(null,c));
var vec__4643 = G__4642;
var seq__4644 = cljs.core.seq.call(null,vec__4643);
var first__4645 = cljs.core.first.call(null,seq__4644);
var seq__4644__$1 = cljs.core.next.call(null,seq__4644);
var used = first__4645;
var urest = seq__4644__$1;
var G__4642__$1 = G__4642;
while(true){
var vec__4646 = G__4642__$1;
var seq__4647 = cljs.core.seq.call(null,vec__4646);
var first__4648 = cljs.core.first.call(null,seq__4647);
var seq__4647__$1 = cljs.core.next.call(null,seq__4647);
var used__$1 = first__4648;
var urest__$1 = seq__4647__$1;
if(cljs.core.truth_(used__$1)){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ensure-value-is-current","ensure-value-is-current",-2094864823),new cljs.core.Keyword(null,"check-used","check-used",1178610678)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ensure-value-is-current","ensure-value-is-current",-2094864823),new cljs.core.Keyword(null,"check-used","check-used",1178610678)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"used-cinfo","used-cinfo",-1509441217),tiltontec.cell.diagnostic.cinfo.call(null,used__$1)));
} else {
}

tiltontec.cell.evaluate.ensure_value_is_current.call(null,used__$1);

var or__4126__auto____$1 = (function (){var temp__5804__auto__ = tiltontec.cell.base.c_pulse_last_changed.call(null,used__$1);
if(cljs.core.truth_(temp__5804__auto__)){
var last_changed = temp__5804__auto__;
return (last_changed > tiltontec.cell.base.c_pulse.call(null,c));
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var G__4649 = urest__$1;
G__4642__$1 = G__4649;
continue;
}
} else {
return null;
}
break;
}
}
})())){
if(cljs.core.truth_(tiltontec.cell.integrity.c_current_QMARK_.call(null,c))){
} else {
tiltontec.cell.evaluate.calculate_and_set.call(null,c);
}

return cljs.core.second.call(null,tiltontec.cell.evaluate.cget_value.call(null,c));
} else {
tiltontec.cell.integrity.c_pulse_update.call(null,c,new cljs.core.Keyword(null,"valid-uninfluenced","valid-uninfluenced",676756797));

return tiltontec.cell.base.c_value.call(null,c);

}
}
}
}
});
/**
 * The API for determing the value associated with a Cell.
 *   Ensures value is current, records any dependent, and
 *   notices if a standalone cell has never been watched.
 */
tiltontec.cell.evaluate.cget = (function tiltontec$cell$evaluate$cget(c){
var vec__4650 = tiltontec.cell.evaluate.cget_value.call(null,c);
var value_state = cljs.core.nth.call(null,vec__4650,(0),null);
var v = cljs.core.nth.call(null,vec__4650,(1),null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"optimized-away","optimized-away",876765856),null,new cljs.core.Keyword(null,"non-ref","non-ref",-1706863294),null], null), null).call(null,value_state))){
return v;
} else {
var result__1261__auto__ = (function (){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cget","cget",1794378742)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"cget","cget",1794378742)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

return tiltontec.cell.integrity.call_with_integrity.call(null,null,null,(function (opcode,defer_info){
if(tiltontec.cell.base.c_ref_QMARK_.call(null,c)){
} else {
throw (new Error(["Assert failed: ","c lost c-refness","\n","(c-ref? c)"].join('')));
}

var prior_value = tiltontec.cell.base.c_value.call(null,c);
var result__1261__auto__ = tiltontec.cell.evaluate.ensure_value_is_current.call(null,c);
if((((tiltontec.cell.base.c_model.call(null,c) == null)) && (cljs.core._EQ_.call(null,tiltontec.cell.base.c_state.call(null,c),new cljs.core.Keyword(null,"nascent","nascent",443401807))) && (tiltontec.cell.base.c_pulse_unwatched_QMARK_.call(null,c)))){
var v__1174__auto___4653 = new cljs.core.Keyword(null,"awake","awake",1922840899);
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1174__auto___4653);


tiltontec.cell.evaluate.c_watch.call(null,c,prior_value,new cljs.core.Keyword(null,"cget","cget",1794378742));

tiltontec.cell.evaluate.ephemeral_reset.call(null,c);
} else {
}

return result__1261__auto__;
}));
})()
;
if(cljs.core.truth_(tiltontec.cell.base._STAR_depender_STAR_)){
tiltontec.cell.base.dependency_record.call(null,c);
} else {
}

return result__1261__auto__;
}
});
/**
 * Calculate, link, record, and propagate.
 */
tiltontec.cell.evaluate.calculate_and_set = (function tiltontec$cell$evaluate$calculate_and_set(c){
var vec__4654 = tiltontec.cell.evaluate.calculate_and_link.call(null,c);
var raw_value = cljs.core.nth.call(null,vec__4654,(0),null);
var propagation_code = cljs.core.nth.call(null,vec__4654,(1),null);
if(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c)){
return null;
} else {
if(cljs.core.map_QMARK_.call(null,cljs.core.deref.call(null,c))){
} else {
throw (new Error(["Assert failed: ","calc-n-set","\n","(map? (deref c))"].join('')));
}

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-set","calculate-and-set",-1815122691),new cljs.core.Keyword(null,"not-optimized","not-optimized",1450019337)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-set","calculate-and-set",-1815122691),new cljs.core.Keyword(null,"not-optimized","not-optimized",1450019337)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

return tiltontec.cell.evaluate.c_value_assume.call(null,c,raw_value,propagation_code);
}
});
/**
 * Stringify cell's belonging model & prop-name & the current
 *   callstack.
 */
tiltontec.cell.evaluate.prop_info__AMPERSAND__callstack = (function tiltontec$cell$evaluate$prop_info__AMPERSAND__callstack(c){
var prop = tiltontec.cell.base.c_prop_name.call(null,c);
var code = tiltontec.cell.base.c_code$.call(null,c);
var md_name = tiltontec.cell.base.c_md_name.call(null,c);
return ["prop '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"' of model '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_name),"'.","\n...> formula for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),":\n",code,"\n...> full cell:\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,c)),"\n\n...> callstack, latest first:\n",clojure.string.join.call(null,"\n",(function (){var iter__4529__auto__ = (function tiltontec$cell$evaluate$prop_info__AMPERSAND__callstack_$_iter__4661(s__4662){
return (new cljs.core.LazySeq(null,(function (){
var s__4662__$1 = s__4662;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__4662__$1);
if(temp__5804__auto__){
var s__4662__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__4662__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__4662__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__4664 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__4663 = (0);
while(true){
if((i__4663 < size__4528__auto__)){
var cd = cljs.core._nth.call(null,c__4527__auto__,i__4663);
var md_name_SINGLEQUOTE_ = tiltontec.cell.base.c_md_name.call(null,cd);
var prop_SINGLEQUOTE_ = tiltontec.cell.base.c_prop_name.call(null,cd);
var code_SINGLEQUOTE_ = tiltontec.cell.base.c_code$.call(null,cd);
cljs.core.chunk_append.call(null,b__4664,["....> md-name:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_name_SINGLEQUOTE_)," prop: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop_SINGLEQUOTE_),"\n....>    code:",code_SINGLEQUOTE_].join(''));

var G__4665 = (i__4663 + (1));
i__4663 = G__4665;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4664),tiltontec$cell$evaluate$prop_info__AMPERSAND__callstack_$_iter__4661.call(null,cljs.core.chunk_rest.call(null,s__4662__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__4664),null);
}
} else {
var cd = cljs.core.first.call(null,s__4662__$2);
var md_name_SINGLEQUOTE_ = tiltontec.cell.base.c_md_name.call(null,cd);
var prop_SINGLEQUOTE_ = tiltontec.cell.base.c_prop_name.call(null,cd);
var code_SINGLEQUOTE_ = tiltontec.cell.base.c_code$.call(null,cd);
return cljs.core.cons.call(null,["....> md-name:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(md_name_SINGLEQUOTE_)," prop: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop_SINGLEQUOTE_),"\n....>    code:",code_SINGLEQUOTE_].join(''),tiltontec$cell$evaluate$prop_info__AMPERSAND__callstack_$_iter__4661.call(null,cljs.core.rest.call(null,s__4662__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,tiltontec.cell.base._STAR_call_stack_STAR_);
})())].join('');
});
/**
 * The name is accurate: we do no more than invoke the rule of a formula
 *   and return its value*, but along the way the links between
 *   dependencies and dependents get determined anew.
 * 
 *   * Well, we also look to see if a synaptic cell has attached a
 *   propagaion code to a vector used to wrap the raw value, which we
 *   then unpack.
 */
tiltontec.cell.evaluate.calculate_and_link = (function tiltontec$cell$evaluate$calculate_and_link(c){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([c]),tiltontec.cell.base._STAR_call_stack_STAR_))){
if(cljs.core.truth_(cljs.core.deref.call(null,tiltontec.cell.base._PLUS_stop_PLUS_))){
} else {
var _STAR_print_level_STAR__orig_val__4666_4675 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_level_STAR__temp_val__4667_4676 = (function (){var or__4126__auto__ = cljs.core._STAR_print_level_STAR_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (1);
}
})();
(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__temp_val__4667_4676);

try{if(cljs.core.truth_(tiltontec.util.trace._STAR_disable_warnings_STAR_)){
} else {
cljs.core.println.call(null,cljs.core.apply.call(null,cljs.core.str,"WARNING: ",(new cljs.core.List(null,"MXAPI_COMPUTE_CYCLE_DETECTED> cyclic dependency detected while computing ",(new cljs.core.List(null,tiltontec.cell.evaluate.prop_info__AMPERSAND__callstack.call(null,c),null,(1),null)),(2),null))));
}
}finally {(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__orig_val__4666_4675);
}}

throw cljs.core.ex_info.call(null,"MXAPI_COMPUTE_CYCLE_DETECTED> cyclic dependency detected while computing cell",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cell","cell",764245084),c], null));
} else {
}

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-link","calculate-and-link",1894417876),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-link","calculate-and-link",1894417876),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

var _STAR_call_stack_STAR__orig_val__4668 = tiltontec.cell.base._STAR_call_stack_STAR_;
var _STAR_depender_STAR__orig_val__4669 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_defer_changes_STAR__orig_val__4670 = tiltontec.cell.base._STAR_defer_changes_STAR_;
var _STAR_call_stack_STAR__temp_val__4671 = cljs.core.cons.call(null,c,tiltontec.cell.base._STAR_call_stack_STAR_);
var _STAR_depender_STAR__temp_val__4672 = c;
var _STAR_defer_changes_STAR__temp_val__4673 = true;
(tiltontec.cell.base._STAR_call_stack_STAR_ = _STAR_call_stack_STAR__temp_val__4671);

(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__4672);

(tiltontec.cell.base._STAR_defer_changes_STAR_ = _STAR_defer_changes_STAR__temp_val__4673);

try{tiltontec.cell.base.unlink_from_used.call(null,c,new cljs.core.Keyword(null,"pre-rule-clear","pre-rule-clear",258781380));

var rule = tiltontec.cell.base.c_rule.call(null,c);
if(cljs.core.truth_(rule)){
} else {
throw (new Error(["Assert failed: ",["No rule in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tiltontec.cell.base.c_prop_name.call(null,c))," type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tiltontec.util.core.mx_type.call(null,c))].join(''),"\n","rule"].join('')));
}

try{var raw_value = rule.call(null,c);
if(cljs.core.truth_((function (){var and__4115__auto__ = tiltontec.cell.base.c_synaptic_QMARK_.call(null,c);
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.vector_QMARK_.call(null,raw_value)) && (cljs.core.contains_QMARK_.call(null,cljs.core.meta.call(null,raw_value),new cljs.core.Keyword(null,"propagate","propagate",274376905))));
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,raw_value),new cljs.core.Keyword(null,"propagate","propagate",274376905).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,raw_value))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [raw_value,null], null);
}
}catch (e4674){if((e4674 instanceof Error)){
var e = e4674;
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-link","calculate-and-link",1894417876),new cljs.core.Keyword(null,"emsg","emsg",-583328980)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"calculate-and-link","calculate-and-link",1894417876),new cljs.core.Keyword(null,"emsg","emsg",-583328980)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"emsg","emsg",-583328980),e.message()));
} else {
}

throw e;
} else {
throw e4674;

}
}}finally {(tiltontec.cell.base._STAR_defer_changes_STAR_ = _STAR_defer_changes_STAR__orig_val__4670);

(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__4669);

(tiltontec.cell.base._STAR_call_stack_STAR_ = _STAR_call_stack_STAR__orig_val__4668);
}});
cljs.core._add_method.call(null,tiltontec.cell.poly.c_awaken,new cljs.core.Keyword(null,"default","default",-1987822328),(function (c){
if(cljs.core.coll_QMARK_.call(null,c)){
var seq__4677 = cljs.core.seq.call(null,c);
var chunk__4678 = null;
var count__4679 = (0);
var i__4680 = (0);
while(true){
if((i__4680 < count__4679)){
var ce = cljs.core._nth.call(null,chunk__4678,i__4680);
tiltontec.cell.poly.c_awaken.call(null,ce);


var G__4681 = seq__4677;
var G__4682 = chunk__4678;
var G__4683 = count__4679;
var G__4684 = (i__4680 + (1));
seq__4677 = G__4681;
chunk__4678 = G__4682;
count__4679 = G__4683;
i__4680 = G__4684;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__4677);
if(temp__5804__auto__){
var seq__4677__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4677__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__4677__$1);
var G__4685 = cljs.core.chunk_rest.call(null,seq__4677__$1);
var G__4686 = c__4556__auto__;
var G__4687 = cljs.core.count.call(null,c__4556__auto__);
var G__4688 = (0);
seq__4677 = G__4685;
chunk__4678 = G__4686;
count__4679 = G__4687;
i__4680 = G__4688;
continue;
} else {
var ce = cljs.core.first.call(null,seq__4677__$1);
tiltontec.cell.poly.c_awaken.call(null,ce);


var G__4689 = cljs.core.next.call(null,seq__4677__$1);
var G__4690 = null;
var G__4691 = (0);
var G__4692 = (0);
seq__4677 = G__4689;
chunk__4678 = G__4690;
count__4679 = G__4691;
i__4680 = G__4692;
continue;
}
} else {
return null;
}
}
break;
}
} else {
throw cljs.core.ex_info.call(null,"cannot do c-awaken on cell",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cell","cell",764245084),c], null));
}
}));
cljs.core._add_method.call(null,tiltontec.cell.poly.c_awaken,new cljs.core.Keyword("tiltontec.cell.base","cell","tiltontec.cell.base/cell",608738071),(function (c){
if(cljs.core.truth_(tiltontec.cell.base.c_input_QMARK_.call(null,c))){
} else {
throw (new Error("Assert failed: (c-input? c)"));
}

if(tiltontec.cell.base.c_pulse_unwatched_QMARK_.call(null,c)){
var temp__5804__auto___4693 = tiltontec.cell.base.c_me.call(null,c);
if(cljs.core.truth_(temp__5804__auto___4693)){
var me_4694 = temp__5804__auto___4693;
var v__1174__auto___4695 = tiltontec.cell.base.c_value.call(null,c);
cljs.core.swap_BANG_.call(null,me_4694,cljs.core.assoc,tiltontec.cell.base.c_prop.call(null,c),v__1174__auto___4695);

} else {
}

tiltontec.cell.evaluate.c_watch.call(null,c,new cljs.core.Keyword(null,"cell-awaken","cell-awaken",2137807704));

return tiltontec.cell.evaluate.ephemeral_reset.call(null,c);
} else {
return null;
}
}));
cljs.core._add_method.call(null,tiltontec.cell.poly.c_awaken,new cljs.core.Keyword("tiltontec.cell.base","c-formula","tiltontec.cell.base/c-formula",-1020749037),(function (c){
var _STAR_depender_STAR__orig_val__4696 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__4697 = null;
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__4697);

try{if(cljs.core.truth_(tiltontec.cell.integrity.c_current_QMARK_.call(null,c))){
return null;
} else {
return tiltontec.cell.evaluate.calculate_and_set.call(null,c);
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__4696);
}}));


tiltontec.cell.evaluate.md_prop_value_store = (function tiltontec$cell$evaluate$md_prop_value_store(me,prop,value){
if(cljs.core.truth_(me)){
} else {
throw (new Error("Assert failed: me"));
}

if((me instanceof cljs.core.Atom)){
} else {
throw (new Error("Assert failed: (any-ref? me)"));
}

var v__1174__auto__ = value;
cljs.core.swap_BANG_.call(null,me,cljs.core.assoc,prop,v__1174__auto__);

return v__1174__auto__;
});
/**
 * The Cell assumes a new value at awakening, on c-reset!, or after
 *   formula recalculation.
 * 
 *   We record the new value, set the Cell state to :awake, make its
 *   pulse current, check to see if a formula cell can be optimized away,
 *   and then propagate to any dependent formula cells.
 */
tiltontec.cell.evaluate.c_value_assume = (function tiltontec$cell$evaluate$c_value_assume(c,new_value,propagation_code){
if(tiltontec.cell.base.c_ref_QMARK_.call(null,c)){
} else {
throw (new Error("Assert failed: (c-ref? c)"));
}

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"new-value","new-value",1087038368),new_value,new cljs.core.Keyword(null,"propagation-code","propagation-code",1116163217),propagation_code));
} else {
}

var _STAR_depender_STAR__orig_val__4698_4700 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__4699_4701 = null;
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__4699_4701);

try{var prior_value_4702 = tiltontec.cell.base.c_value.call(null,c);
var prior_state_4703 = tiltontec.cell.base.c_value_state.call(null,c);
var callers_4704 = tiltontec.cell.base.c_callers.call(null,c);
var value_changed_QMARK__4705 = tiltontec.cell.evaluate.c_value_changed_QMARK_.call(null,c,new_value,prior_value_4702);
var force_propagate_QMARK__4706 = propagation_code === true;
var force_no_propagate_QMARK__4707 = ((propagation_code === false) || (cljs.core._EQ_.call(null,propagation_code,new cljs.core.Keyword(null,"no-propagate","no-propagate",-573850970))));
var temp__5808__auto___4708 = tiltontec.cell.base.c_model.call(null,c);
if((temp__5808__auto___4708 == null)){
} else {
var m_4709 = temp__5808__auto___4708;
if(cljs.core.not.call(null,tiltontec.cell.base.c_synaptic_QMARK_.call(null,c))){
} else {
throw (new Error("Assert failed: (not (c-synaptic? c))"));
}

var v__1174__auto___4710 = new_value;
cljs.core.swap_BANG_.call(null,m_4709,cljs.core.assoc,tiltontec.cell.base.c_prop.call(null,c),v__1174__auto___4710);

}

var v__1174__auto___4711 = new_value;
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword(null,"value","value",305978217),v__1174__auto___4711);


var v__1174__auto___4712 = new cljs.core.Keyword(null,"awake","awake",1922840899);
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1174__auto___4712);


tiltontec.cell.integrity.c_pulse_update.call(null,c,new cljs.core.Keyword(null,"propv-assume","propv-assume",528209981));

if(cljs.core.truth_((((!(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c))))?(((!(force_no_propagate_QMARK__4707)))?value_changed_QMARK__4705:false):false))){
var v__1174__auto___4713 = cljs.core.deref.call(null,tiltontec.cell.base._STAR_pulse_STAR_);
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword(null,"pulse-last-changed","pulse-last-changed",1035703380),v__1174__auto___4713);

} else {
}

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"new-value-installed","new-value-installed",1507915016)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"new-value-installed","new-value-installed",1507915016)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"new-value","new-value",1087038368),new_value));
} else {
}

if(cljs.core.truth_(((tiltontec.cell.base.c_formula_QMARK_.call(null,c))?tiltontec.cell.base.c_optimize.call(null,c):false))){
tiltontec.cell.evaluate.optimize_away_QMARK__BANG_.call(null,c,prior_value_4702);

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"post-optimized-away","post-optimized-away",1796852758)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"post-optimized-away","post-optimized-away",1796852758)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"new-value","new-value",1087038368),new_value,new cljs.core.Keyword(null,"optimized-away?","optimized-away?",330898432),tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c)));
} else {
}
} else {
}

if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"valid","valid",155614240),null,new cljs.core.Keyword(null,"uncurrent","uncurrent",-217246265),null], null), null).call(null,prior_state_4703));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = force_propagate_QMARK__4706;
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if(force_no_propagate_QMARK__4707){
return null;
} else {
return value_changed_QMARK__4705;
}
}
}
})())){
if(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c)){
} else {
if(cljs.core.map_QMARK_.call(null,cljs.core.deref.call(null,c))){
} else {
throw (new Error("Assert failed: (map? (clojure.core/deref c))"));
}

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"calls-propagate","calls-propagate",-810825805)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c-value-assume","c-value-assume",-1528592564),new cljs.core.Keyword(null,"calls-propagate","calls-propagate",-810825805)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"callers-count","callers-count",722682074),cljs.core.count.call(null,callers_4704),new cljs.core.Keyword(null,"prior-value","prior-value",224788832),prior_value_4702));
} else {
}

tiltontec.cell.evaluate.propagate.call(null,c,prior_value_4702,callers_4704);
}
} else {
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__4698_4700);
}
return new_value;
});
/**
 * Flushes it from its model if it has one & record the flush.
 */
tiltontec.cell.evaluate.md_cell_flush = (function tiltontec$cell$evaluate$md_cell_flush(c){
var temp__5804__auto__ = tiltontec.cell.base.c_model.call(null,c);
if(cljs.core.truth_(temp__5804__auto__)){
var me = temp__5804__auto__;
var p = tiltontec.cell.base.c_prop.call(null,c);
var r = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,new cljs.core.Keyword(null,"val","val",128701612),tiltontec.cell.base.c_value.call(null,c),new cljs.core.Keyword(null,"pulse","pulse",-244494476),tiltontec.cell.base.c_pulse_watched.call(null,c)], null);
var p__1180__auto___4714 = new cljs.core.Keyword(null,"cz","cz",1670864932);
cljs.core.get.call(null,cljs.core.alter_meta_BANG_.call(null,me,cljs.core.update,p__1180__auto___4714,cljs.core.assoc,p,null),p__1180__auto___4714);

var p__1180__auto___4715 = new cljs.core.Keyword(null,"cells-flushed","cells-flushed",-1653073949);
cljs.core.get.call(null,cljs.core.alter_meta_BANG_.call(null,me,cljs.core.update,p__1180__auto___4715,cljs.core.conj,r),p__1180__auto___4715);

if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"md-cell-flush","md-cell-flush",-1378613750)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
return tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"md-cell-flush","md-cell-flush",-1378613750)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"minfo","minfo",1596261345),tiltontec.cell.diagnostic.minfo.call(null,me)));
} else {
return null;
}
} else {
return null;
}
});
/**
 * Optimizes away cells who turn out not to depend on anyone,
 *   saving a lot of work at runtime. A caller/user will not bother
 *   establishing a link, and when we get to models `cget` will find a
 *   non-cell in a prop and Just Use It.
 */
tiltontec.cell.evaluate.optimize_away_QMARK__BANG_ = (function tiltontec$cell$evaluate$optimize_away_QMARK__BANG_(c,prior_value){
var temp__5804__auto__ = ((tiltontec.cell.base.c_formula_QMARK_.call(null,c))?((cljs.core.not.call(null,tiltontec.cell.base.c_synaptic_QMARK_.call(null,c)))?((cljs.core.not.call(null,tiltontec.cell.base.c_input_QMARK_.call(null,c)))?tiltontec.cell.base.c_optimize.call(null,c):false):false):false);
if(cljs.core.truth_(temp__5804__auto__)){
var optimize = temp__5804__auto__;
if(((((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"freeze","freeze",2043466309),optimize)) || (cljs.core.empty_QMARK_.call(null,tiltontec.cell.base.c_useds.call(null,c))) || (((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"when-value-t","when-value-t",1756613336),optimize)) && ((!((tiltontec.cell.base.c_value.call(null,c) == null)))))))) && ((!(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c)))) && (tiltontec.cell.base.c_valid_QMARK_.call(null,c)))){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"optimize-away!","optimize-away!",1144082996)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"optimize-away!","optimize-away!",1144082996)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,c)))){
if(cljs.core.truth_(cljs.core.deref.call(null,tiltontec.cell.base._PLUS_stop_PLUS_))){
} else {
var _STAR_print_level_STAR__orig_val__4716_4722 = cljs.core._STAR_print_level_STAR_;
var _STAR_print_level_STAR__temp_val__4717_4723 = (function (){var or__4126__auto__ = cljs.core._STAR_print_level_STAR_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (1);
}
})();
(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__temp_val__4717_4723);

try{if(cljs.core.truth_(tiltontec.util.trace._STAR_disable_warnings_STAR_)){
} else {
cljs.core.println.call(null,cljs.core.apply.call(null,cljs.core.str,"WARNING: ",(new cljs.core.List(null,"optimize-away?!> on-quiesce detected on cell, ",(new cljs.core.List(null,"but it will be ignored since the cell is being optimized away ",(new cljs.core.List(null,tiltontec.cell.evaluate.prop_info__AMPERSAND__callstack.call(null,c),null,(1),null)),(2),null)),(3),null))));
}
}finally {(cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR__orig_val__4716_4722);
}}
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"freeze","freeze",2043466309),tiltontec.cell.base.c_optimize.call(null,c))){
tiltontec.cell.base.unlink_from_used.call(null,c,new cljs.core.Keyword(null,"freeze","freeze",2043466309));
} else {
}

var v__1174__auto___4724 = new cljs.core.Keyword(null,"optimized-away","optimized-away",876765856);
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1174__auto___4724);


tiltontec.cell.evaluate.c_watch.call(null,c,prior_value,new cljs.core.Keyword(null,"opti-away","opti-away",1290785499));

tiltontec.cell.evaluate.md_cell_flush.call(null,c);

var seq__4718_4725 = cljs.core.seq.call(null,cljs.core.seq.call(null,tiltontec.cell.base.c_callers.call(null,c)));
var chunk__4719_4726 = null;
var count__4720_4727 = (0);
var i__4721_4728 = (0);
while(true){
if((i__4721_4728 < count__4720_4727)){
var caller_4729 = cljs.core._nth.call(null,chunk__4719_4726,i__4721_4728);
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"runs-caller","runs-caller",1888277682)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"runs-caller","runs-caller",1888277682)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"caller-cinfo","caller-cinfo",-623029212),tiltontec.cell.diagnostic.cinfo.call(null,caller_4729)));
} else {
}

tiltontec.cell.evaluate.ensure_value_is_current.call(null,caller_4729);

if(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,caller_4729)){
} else {
tiltontec.cell.base.dependency_drop.call(null,c,caller_4729);
}


var G__4730 = seq__4718_4725;
var G__4731 = chunk__4719_4726;
var G__4732 = count__4720_4727;
var G__4733 = (i__4721_4728 + (1));
seq__4718_4725 = G__4730;
chunk__4719_4726 = G__4731;
count__4720_4727 = G__4732;
i__4721_4728 = G__4733;
continue;
} else {
var temp__5804__auto___4734__$1 = cljs.core.seq.call(null,seq__4718_4725);
if(temp__5804__auto___4734__$1){
var seq__4718_4735__$1 = temp__5804__auto___4734__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4718_4735__$1)){
var c__4556__auto___4736 = cljs.core.chunk_first.call(null,seq__4718_4735__$1);
var G__4737 = cljs.core.chunk_rest.call(null,seq__4718_4735__$1);
var G__4738 = c__4556__auto___4736;
var G__4739 = cljs.core.count.call(null,c__4556__auto___4736);
var G__4740 = (0);
seq__4718_4725 = G__4737;
chunk__4719_4726 = G__4738;
count__4720_4727 = G__4739;
i__4721_4728 = G__4740;
continue;
} else {
var caller_4741 = cljs.core.first.call(null,seq__4718_4735__$1);
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"runs-caller","runs-caller",1888277682)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optimize","optimize",-1912349448),new cljs.core.Keyword(null,"runs-caller","runs-caller",1888277682)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c),new cljs.core.Keyword(null,"caller-cinfo","caller-cinfo",-623029212),tiltontec.cell.diagnostic.cinfo.call(null,caller_4741)));
} else {
}

tiltontec.cell.evaluate.ensure_value_is_current.call(null,caller_4741);

if(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,caller_4741)){
} else {
tiltontec.cell.base.dependency_drop.call(null,c,caller_4741);
}


var G__4742 = cljs.core.next.call(null,seq__4718_4735__$1);
var G__4743 = null;
var G__4744 = (0);
var G__4745 = (0);
seq__4718_4725 = G__4742;
chunk__4719_4726 = G__4743;
count__4720_4727 = G__4744;
i__4721_4728 = G__4745;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,c,tiltontec.cell.base.c_value.call(null,c));
} else {
return null;
}
} else {
return null;
}
});
tiltontec.cell.evaluate.c_quiesce = (function tiltontec$cell$evaluate$c_quiesce(c){
if(tiltontec.cell.base.c_ref_QMARK_.call(null,c)){
} else {
throw (new Error("Assert failed: (c-ref? c)"));
}

var temp__5804__auto___4746 = new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,c));
if(cljs.core.truth_(temp__5804__auto___4746)){
var onq_4747 = temp__5804__auto___4746;
onq_4747.call(null,c);
} else {
}

tiltontec.cell.base.unlink_from_callers.call(null,c);

tiltontec.cell.base.unlink_from_used.call(null,c,new cljs.core.Keyword(null,"quiesce","quiesce",-798294121));

return cljs.core.reset_BANG_.call(null,c,new cljs.core.Keyword(null,"dead-c","dead-c",385485497));
});
cljs.core._add_method.call(null,tiltontec.cell.poly.md_quiesce_self,new cljs.core.Keyword(null,"default","default",-1987822328),(function (me){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quiesce","quiesce",-798294121),new cljs.core.Keyword(null,"qself-fallthru","qself-fallthru",1150526183)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quiesce","quiesce",-798294121),new cljs.core.Keyword(null,"qself-fallthru","qself-fallthru",1150526183)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"minfo","minfo",1596261345),tiltontec.cell.diagnostic.minfo.call(null,me)));
} else {
}

var temp__5804__auto___4754 = new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me));
if(cljs.core.truth_(temp__5804__auto___4754)){
var onq_4755 = temp__5804__auto___4754;
onq_4755.call(null,me);
} else {
}

var seq__4748_4756 = cljs.core.seq.call(null,cljs.core.vals.call(null,new cljs.core.Keyword(null,"cz","cz",1670864932).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me))));
var chunk__4750_4757 = null;
var count__4751_4758 = (0);
var i__4752_4759 = (0);
while(true){
if((i__4752_4759 < count__4751_4758)){
var c_4760 = cljs.core._nth.call(null,chunk__4750_4757,i__4752_4759);
if(cljs.core.truth_(c_4760)){
tiltontec.cell.evaluate.c_quiesce.call(null,c_4760);


var G__4761 = seq__4748_4756;
var G__4762 = chunk__4750_4757;
var G__4763 = count__4751_4758;
var G__4764 = (i__4752_4759 + (1));
seq__4748_4756 = G__4761;
chunk__4750_4757 = G__4762;
count__4751_4758 = G__4763;
i__4752_4759 = G__4764;
continue;
} else {
var G__4765 = seq__4748_4756;
var G__4766 = chunk__4750_4757;
var G__4767 = count__4751_4758;
var G__4768 = (i__4752_4759 + (1));
seq__4748_4756 = G__4765;
chunk__4750_4757 = G__4766;
count__4751_4758 = G__4767;
i__4752_4759 = G__4768;
continue;
}
} else {
var temp__5804__auto___4769 = cljs.core.seq.call(null,seq__4748_4756);
if(temp__5804__auto___4769){
var seq__4748_4770__$1 = temp__5804__auto___4769;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4748_4770__$1)){
var c__4556__auto___4771 = cljs.core.chunk_first.call(null,seq__4748_4770__$1);
var G__4772 = cljs.core.chunk_rest.call(null,seq__4748_4770__$1);
var G__4773 = c__4556__auto___4771;
var G__4774 = cljs.core.count.call(null,c__4556__auto___4771);
var G__4775 = (0);
seq__4748_4756 = G__4772;
chunk__4750_4757 = G__4773;
count__4751_4758 = G__4774;
i__4752_4759 = G__4775;
continue;
} else {
var c_4776 = cljs.core.first.call(null,seq__4748_4770__$1);
if(cljs.core.truth_(c_4776)){
tiltontec.cell.evaluate.c_quiesce.call(null,c_4776);


var G__4777 = cljs.core.next.call(null,seq__4748_4770__$1);
var G__4778 = null;
var G__4779 = (0);
var G__4780 = (0);
seq__4748_4756 = G__4777;
chunk__4750_4757 = G__4778;
count__4751_4758 = G__4779;
i__4752_4759 = G__4780;
continue;
} else {
var G__4781 = cljs.core.next.call(null,seq__4748_4770__$1);
var G__4782 = null;
var G__4783 = (0);
var G__4784 = (0);
seq__4748_4756 = G__4781;
chunk__4750_4757 = G__4782;
count__4751_4758 = G__4783;
i__4752_4759 = G__4784;
continue;
}
}
} else {
}
}
break;
}

cljs.core.reset_BANG_.call(null,me,null);

var v__1186__auto__ = new cljs.core.Keyword(null,"dead","dead",-1946604091);
cljs.core.alter_meta_BANG_.call(null,me,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1186__auto__);

return v__1186__auto__;
}));
cljs.core._add_method.call(null,tiltontec.cell.poly.md_quiesce,new cljs.core.Keyword(null,"default","default",-1987822328),(function (me){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quiesce","quiesce",-798294121),new cljs.core.Keyword(null,"def-fall-thru!","def-fall-thru!",301736197)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quiesce","quiesce",-798294121),new cljs.core.Keyword(null,"def-fall-thru!","def-fall-thru!",301736197)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"minfo","minfo",1596261345),tiltontec.cell.diagnostic.minfo.call(null,me)));
} else {
}

return tiltontec.cell.poly.md_quiesce_self.call(null,me);
}));
tiltontec.cell.evaluate.c_value_changed_QMARK_ = (function tiltontec$cell$evaluate$c_value_changed_QMARK_(c,new_value,old_value){
return cljs.core.not.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"unchanged-if","unchanged-if",-923210106).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,c));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return tiltontec.cell.poly.unchanged_test.call(null,tiltontec.cell.base.c_model.call(null,c),tiltontec.cell.base.c_prop.call(null,c));
}
})().call(null,new_value,old_value));
});
/**
 * A cell:
 *   - notifies its callers of its change;
 *   - calls any watch; and
 *   - if ephemeral, silently reverts to nil.
 */
tiltontec.cell.evaluate.propagate = (function tiltontec$cell$evaluate$propagate(c,prior_value,callers){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"entry","entry",505168823)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

if(cljs.core.truth_(tiltontec.cell.base._STAR_one_pulse_QMARK__STAR_)){
if(cljs.core.truth_(tiltontec.cell.base._STAR_custom_propagator_STAR_)){
return tiltontec.cell.base._STAR_custom_propagator_STAR_.call(null,c,prior_value);
} else {
return null;
}
} else {
var _STAR_depender_STAR__orig_val__4785 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_call_stack_STAR__orig_val__4786 = tiltontec.cell.base._STAR_call_stack_STAR_;
var _STAR_c_prop_depth_STAR__orig_val__4787 = tiltontec.cell.base._STAR_c_prop_depth_STAR_;
var _STAR_defer_changes_STAR__orig_val__4788 = tiltontec.cell.base._STAR_defer_changes_STAR_;
var _STAR_depender_STAR__temp_val__4789 = null;
var _STAR_call_stack_STAR__temp_val__4790 = null;
var _STAR_c_prop_depth_STAR__temp_val__4791 = (tiltontec.cell.base._STAR_c_prop_depth_STAR_ + (1));
var _STAR_defer_changes_STAR__temp_val__4792 = true;
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__4789);

(tiltontec.cell.base._STAR_call_stack_STAR_ = _STAR_call_stack_STAR__temp_val__4790);

(tiltontec.cell.base._STAR_c_prop_depth_STAR_ = _STAR_c_prop_depth_STAR__temp_val__4791);

(tiltontec.cell.base._STAR_defer_changes_STAR_ = _STAR_defer_changes_STAR__temp_val__4792);

try{tiltontec.cell.evaluate.propagate_to_callers.call(null,c,callers);

if(tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c)){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = tiltontec.cell.base.c_pulse_unwatched_QMARK_.call(null,c);
if(or__4126__auto__){
return or__4126__auto__;
} else {
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([tiltontec.cell.base.c_lazy.call(null,c)]),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-asked","once-asked",-1758934854),new cljs.core.Keyword(null,"always","always",-1772028770),true], null));
}
})())){
tiltontec.cell.evaluate.c_watch.call(null,c,prior_value,new cljs.core.Keyword(null,"propagate","propagate",274376905));
} else {
}
}

return tiltontec.cell.evaluate.ephemeral_reset.call(null,c);
}finally {(tiltontec.cell.base._STAR_defer_changes_STAR_ = _STAR_defer_changes_STAR__orig_val__4788);

(tiltontec.cell.base._STAR_c_prop_depth_STAR_ = _STAR_c_prop_depth_STAR__orig_val__4787);

(tiltontec.cell.base._STAR_call_stack_STAR_ = _STAR_call_stack_STAR__orig_val__4786);

(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__4785);
}}
});
tiltontec.cell.evaluate.propagate_to_callers = (function tiltontec$cell$evaluate$propagate_to_callers(c,callers){
if(cljs.core.empty_QMARK_.call(null,callers)){
return null;
} else {
var causation = cljs.core.cons.call(null,c,tiltontec.cell.base._STAR_causation_STAR_);
return tiltontec.cell.integrity.call_with_integrity.call(null,new cljs.core.Keyword(null,"tell-dependents","tell-dependents",1916330388),tiltontec.cell.diagnostic.cinfo.call(null,c),(function (opcode,defer_info){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"with-integrity","with-integrity",432448490),new cljs.core.Keyword(null,"tell-dependents","tell-dependents",1916330388)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"with-integrity","with-integrity",432448490),new cljs.core.Keyword(null,"tell-dependents","tell-dependents",1916330388)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"cinfo","cinfo",-259107143),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

if(tiltontec.cell.base.md_dead_QMARK_.call(null,tiltontec.cell.base.c_model.call(null,c))){
return tiltontec.util.trace.call_trc.call(null,"WHOAA!!!! dead by time :tell-deps dispatched; bailing",c);
} else {
var _STAR_causation_STAR__orig_val__4793 = tiltontec.cell.base._STAR_causation_STAR_;
var _STAR_causation_STAR__temp_val__4794 = causation;
(tiltontec.cell.base._STAR_causation_STAR_ = _STAR_causation_STAR__temp_val__4794);

try{var seq__4795 = cljs.core.seq.call(null,cljs.core.seq.call(null,callers));
var chunk__4799 = null;
var count__4800 = (0);
var i__4801 = (0);
while(true){
if((i__4801 < count__4800)){
var caller = cljs.core._nth.call(null,chunk__4799,i__4801);
var skip_propagation_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,tiltontec.cell.base.c_state.call(null,caller),new cljs.core.Keyword(null,"quiesced","quiesced",421940903));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = tiltontec.cell.integrity.c_current_QMARK_.call(null,caller);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([tiltontec.cell.base.c_lazy.call(null,caller)]),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,new cljs.core.Keyword(null,"always","always",-1772028770),new cljs.core.Keyword(null,"once-asked","once-asked",-1758934854)], null));
}
}
})();
if(cljs.core.not.call(null,skip_propagation_QMARK_)){
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([c]),tiltontec.cell.base.c_useds.call(null,caller));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c);
}
})())){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"noti-caller","noti-caller",1776477848)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"noti-caller","noti-caller",1776477848)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"caller-cinfo","caller-cinfo",-623029212),tiltontec.cell.diagnostic.cinfo.call(null,caller),new cljs.core.Keyword(null,"callee-cinfo","callee-cinfo",945855866),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

tiltontec.cell.evaluate.calculate_and_set.call(null,caller);


var G__4805 = seq__4795;
var G__4806 = chunk__4799;
var G__4807 = count__4800;
var G__4808 = (i__4801 + (1));
seq__4795 = G__4805;
chunk__4799 = G__4806;
count__4800 = G__4807;
i__4801 = G__4808;
continue;
} else {
var G__4809 = seq__4795;
var G__4810 = chunk__4799;
var G__4811 = count__4800;
var G__4812 = (i__4801 + (1));
seq__4795 = G__4809;
chunk__4799 = G__4810;
count__4800 = G__4811;
i__4801 = G__4812;
continue;
}
} else {
var G__4813 = seq__4795;
var G__4814 = chunk__4799;
var G__4815 = count__4800;
var G__4816 = (i__4801 + (1));
seq__4795 = G__4813;
chunk__4799 = G__4814;
count__4800 = G__4815;
i__4801 = G__4816;
continue;
}
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__4795);
if(temp__5804__auto__){
var seq__4795__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4795__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__4795__$1);
var G__4817 = cljs.core.chunk_rest.call(null,seq__4795__$1);
var G__4818 = c__4556__auto__;
var G__4819 = cljs.core.count.call(null,c__4556__auto__);
var G__4820 = (0);
seq__4795 = G__4817;
chunk__4799 = G__4818;
count__4800 = G__4819;
i__4801 = G__4820;
continue;
} else {
var caller = cljs.core.first.call(null,seq__4795__$1);
var skip_propagation_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,tiltontec.cell.base.c_state.call(null,caller),new cljs.core.Keyword(null,"quiesced","quiesced",421940903));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = tiltontec.cell.integrity.c_current_QMARK_.call(null,caller);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([tiltontec.cell.base.c_lazy.call(null,caller)]),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,new cljs.core.Keyword(null,"always","always",-1772028770),new cljs.core.Keyword(null,"once-asked","once-asked",-1758934854)], null));
}
}
})();
if(cljs.core.not.call(null,skip_propagation_QMARK_)){
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([c]),tiltontec.cell.base.c_useds.call(null,caller));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return tiltontec.cell.base.c_optimized_away_QMARK_.call(null,c);
}
})())){
if(cljs.core.truth_(tiltontec.cell.diagnostic.match_loose.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"noti-caller","noti-caller",1776477848)], null),tiltontec.cell.diagnostic._STAR_mx_trace_STAR_))){
tiltontec.cell.diagnostic.print_trace.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"propagate","propagate",274376905),new cljs.core.Keyword(null,"noti-caller","noti-caller",1776477848)], null),tiltontec.cell.diagnostic.build_trace_values.call(null,new cljs.core.Keyword(null,"caller-cinfo","caller-cinfo",-623029212),tiltontec.cell.diagnostic.cinfo.call(null,caller),new cljs.core.Keyword(null,"callee-cinfo","callee-cinfo",945855866),tiltontec.cell.diagnostic.cinfo.call(null,c)));
} else {
}

tiltontec.cell.evaluate.calculate_and_set.call(null,caller);


var G__4821 = cljs.core.next.call(null,seq__4795__$1);
var G__4822 = null;
var G__4823 = (0);
var G__4824 = (0);
seq__4795 = G__4821;
chunk__4799 = G__4822;
count__4800 = G__4823;
i__4801 = G__4824;
continue;
} else {
var G__4825 = cljs.core.next.call(null,seq__4795__$1);
var G__4826 = null;
var G__4827 = (0);
var G__4828 = (0);
seq__4795 = G__4825;
chunk__4799 = G__4826;
count__4800 = G__4827;
i__4801 = G__4828;
continue;
}
} else {
var G__4829 = cljs.core.next.call(null,seq__4795__$1);
var G__4830 = null;
var G__4831 = (0);
var G__4832 = (0);
seq__4795 = G__4829;
chunk__4799 = G__4830;
count__4800 = G__4831;
i__4801 = G__4832;
continue;
}
}
} else {
return null;
}
}
break;
}
}finally {(tiltontec.cell.base._STAR_causation_STAR_ = _STAR_causation_STAR__orig_val__4793);
}}
}));
}
});
