// Compiled by ClojureScript 1.10.773 {}
goog.provide('tiltontec.matrix.api');
goog.require('cljs.core');
goog.require('tiltontec.cell.base');
goog.require('tiltontec.cell.core');
goog.require('tiltontec.cell.diagnostic');
goog.require('tiltontec.model.accessors');
goog.require('tiltontec.model.core');
goog.require('tiltontec.model.family');
goog.require('tiltontec.model.navigate');
goog.require('tiltontec.util.core');
tiltontec.matrix.api.unbound = tiltontec.cell.base.unbound;
/**
 * Optionally populated with the root of a tree of Models.
 */
tiltontec.matrix.api.matrix = tiltontec.model.core.matrix;
var ret__4785__auto___5325 = (function (){
tiltontec.matrix.api.with_mx = (function tiltontec$matrix$api$with_mx(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5326 = arguments.length;
var i__4737__auto___5327 = (0);
while(true){
if((i__4737__auto___5327 < len__4736__auto___5326)){
args__4742__auto__.push((arguments[i__4737__auto___5327]));

var G__5328 = (i__4737__auto___5327 + (1));
i__4737__auto___5327 = G__5328;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.with_mx.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_mx.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","call-with-mx","tiltontec.cell.core/call-with-mx",1212627376,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null)))),null,(1),null)),body))),null,(1),null)))));
}));

(tiltontec.matrix.api.with_mx.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.with_mx.cljs$lang$applyTo = (function (seq5322){
var G__5323 = cljs.core.first.call(null,seq5322);
var seq5322__$1 = cljs.core.next.call(null,seq5322);
var G__5324 = cljs.core.first.call(null,seq5322__$1);
var seq5322__$2 = cljs.core.next.call(null,seq5322__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5323,G__5324,seq5322__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.with_mx.cljs$lang$macro = true);

/**
 * Return the type of the matrix reference `me`.
 * 
 *   A cell reference's type could be
 *   - `:tiltontec.cell.base/cell`
 *   - `:tiltontec.cell.base/c-formula` (which derives the `:tiltontec.cell.base/cell`)
 * 
 *   A model's reference type is given by `make`'s `mx-type` option
 *   - defaults to be `:tiltontec.cell.base/model`
 */
tiltontec.matrix.api.mx_type = (function tiltontec$matrix$api$mx_type(it){
return tiltontec.util.core.mx_type.call(null,it);
});
/**
 * Return true if `it`'s type (as returned by `mx-type`) is
 *   `type` (check with `isa?`).
 */
tiltontec.matrix.api.mx_type_QMARK_ = (function tiltontec$matrix$api$mx_type_QMARK_(it,type){
return tiltontec.util.core.mx_type_QMARK_.call(null,it,type);
});
/**
 * Return true if `me` is a model (reference).
 */
tiltontec.matrix.api.md_ref_QMARK_ = (function tiltontec$matrix$api$md_ref_QMARK_(me){
return tiltontec.cell.base.md_ref_QMARK_.call(null,me);
});
/**
 * Return the name of the model `me`.
 */
tiltontec.matrix.api.md_name = (function tiltontec$matrix$api$md_name(me){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,me));
});
/**
 * Return the state of the model `me`.
 * 
 *   The state can be one of the following
 *   - :nascent
 *   - :awakening
 *   - :awake
 *   - :optimized-away
 *   - :dead
 */
tiltontec.matrix.api.md_state = (function tiltontec$matrix$api$md_state(me){
return tiltontec.cell.base.md_state.call(null,me);
});
/**
 * Return true if `md-state` of `me` is `:dead`.
 */
tiltontec.matrix.api.md_dead_QMARK_ = (function tiltontec$matrix$api$md_dead_QMARK_(me){
return tiltontec.cell.base.md_dead_QMARK_.call(null,me);
});
/**
 * Return the value of the cell `c`.
 */
tiltontec.matrix.api.c_value = (function tiltontec$matrix$api$c_value(c){
return tiltontec.cell.base.c_value.call(null,c);
});
/**
 * Return the model of the cell `c` (possibly `nil`).
 */
tiltontec.matrix.api.c_model = (function tiltontec$matrix$api$c_model(c){
return tiltontec.cell.base.c_model.call(null,c);
});
/**
 * Return the name of the property (of the cell model) of the cell
 *   `c` (possibly `nil`).
 */
tiltontec.matrix.api.c_prop_name = (function tiltontec$matrix$api$c_prop_name(c){
return tiltontec.cell.base.c_prop_name.call(null,c);
});
var ret__4785__auto___5332 = (function (){
/**
 * Macro to execute `body` without establishing cell dependency.
 */
tiltontec.matrix.api.without_c_dependency = (function tiltontec$matrix$api$without_c_dependency(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5333 = arguments.length;
var i__4737__auto___5334 = (0);
while(true){
if((i__4737__auto___5334 < len__4736__auto___5333)){
args__4742__auto__.push((arguments[i__4737__auto___5334]));

var G__5335 = (i__4737__auto___5334 + (1));
i__4737__auto___5334 = G__5335;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.without_c_dependency.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.without_c_dependency.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body)));
}));

(tiltontec.matrix.api.without_c_dependency.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.without_c_dependency.cljs$lang$applyTo = (function (seq5329){
var G__5330 = cljs.core.first.call(null,seq5329);
var seq5329__$1 = cljs.core.next.call(null,seq5329);
var G__5331 = cljs.core.first.call(null,seq5329__$1);
var seq5329__$2 = cljs.core.next.call(null,seq5329__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5330,G__5331,seq5329__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.without_c_dependency.cljs$lang$macro = true);

var ret__4785__auto___5343 = (function (){
/**
 * Stop listening to dependents.
 * 
 *   Return the specified optional value, or the current latest value.
 */
tiltontec.matrix.api.cf_freeze = (function tiltontec$matrix$api$cf_freeze(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5344 = arguments.length;
var i__4737__auto___5345 = (0);
while(true){
if((i__4737__auto___5345 < len__4736__auto___5344)){
args__4742__auto__.push((arguments[i__4737__auto___5345]));

var G__5346 = (i__4737__auto___5345 + (1));
i__4737__auto___5345 = G__5346;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cf_freeze.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cf_freeze.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5339){
var vec__5340 = p__5339;
var value_form = cljs.core.nth.call(null,vec__5340,(0),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","cf-freeze","tiltontec.cell.core/cf-freeze",203193191,null),null,(1),null)),(new cljs.core.List(null,value_form,null,(1),null)))));
}));

(tiltontec.matrix.api.cf_freeze.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cf_freeze.cljs$lang$applyTo = (function (seq5336){
var G__5337 = cljs.core.first.call(null,seq5336);
var seq5336__$1 = cljs.core.next.call(null,seq5336);
var G__5338 = cljs.core.first.call(null,seq5336__$1);
var seq5336__$2 = cljs.core.next.call(null,seq5336__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5337,G__5338,seq5336__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cf_freeze.cljs$lang$macro = true);

var ret__4785__auto___5351 = (function (){
/**
 * Define a reader function for a model's property.
 */
tiltontec.matrix.api.def_mget = (function tiltontec$matrix$api$def_mget(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5352 = arguments.length;
var i__4737__auto___5353 = (0);
while(true){
if((i__4737__auto___5353 < len__4736__auto___5352)){
args__4742__auto__.push((arguments[i__4737__auto___5353]));

var G__5354 = (i__4737__auto___5353 + (1));
i__4737__auto___5353 = G__5354;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.def_mget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.def_mget.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,reader_prefix,props){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.accessors","def-mget","tiltontec.model.accessors/def-mget",541687686,null),null,(1),null)),(new cljs.core.List(null,reader_prefix,null,(1),null)),props)));
}));

(tiltontec.matrix.api.def_mget.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.def_mget.cljs$lang$applyTo = (function (seq5347){
var G__5348 = cljs.core.first.call(null,seq5347);
var seq5347__$1 = cljs.core.next.call(null,seq5347);
var G__5349 = cljs.core.first.call(null,seq5347__$1);
var seq5347__$2 = cljs.core.next.call(null,seq5347__$1);
var G__5350 = cljs.core.first.call(null,seq5347__$2);
var seq5347__$3 = cljs.core.next.call(null,seq5347__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5348,G__5349,G__5350,seq5347__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.def_mget.cljs$lang$macro = true);

var ret__4785__auto___5358 = (function (){
/**
 * Macro to flatten kids in `tree` and relate them to `me` via the
 *   `tiltontec.model.core/*parent*` dynamic binding
 */
tiltontec.matrix.api.the_kids = (function tiltontec$matrix$api$the_kids(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5359 = arguments.length;
var i__4737__auto___5360 = (0);
while(true){
if((i__4737__auto___5360 < len__4736__auto___5359)){
args__4742__auto__.push((arguments[i__4737__auto___5360]));

var G__5361 = (i__4737__auto___5360 + (1));
i__4737__auto___5360 = G__5361;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.the_kids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.the_kids.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,tree){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.family","the-kids","tiltontec.model.family/the-kids",-869691941,null),null,(1),null)),tree)));
}));

(tiltontec.matrix.api.the_kids.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.the_kids.cljs$lang$applyTo = (function (seq5355){
var G__5356 = cljs.core.first.call(null,seq5355);
var seq5355__$1 = cljs.core.next.call(null,seq5355);
var G__5357 = cljs.core.first.call(null,seq5355__$1);
var seq5355__$2 = cljs.core.next.call(null,seq5355__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5356,G__5357,seq5355__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.the_kids.cljs$lang$macro = true);

var ret__4785__auto___5365 = (function (){
/**
 * Syntax sugar for formulae that define :kids props
 */
tiltontec.matrix.api.cFkids = (function tiltontec$matrix$api$cFkids(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5366 = arguments.length;
var i__4737__auto___5367 = (0);
while(true){
if((i__4737__auto___5367 < len__4736__auto___5366)){
args__4742__auto__.push((arguments[i__4737__auto___5367]));

var G__5368 = (i__4737__auto___5367 + (1));
i__4737__auto___5367 = G__5368;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cFkids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cFkids.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,tree){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.family","cFkids","tiltontec.model.family/cFkids",1007011770,null),null,(1),null)),tree)));
}));

(tiltontec.matrix.api.cFkids.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cFkids.cljs$lang$applyTo = (function (seq5362){
var G__5363 = cljs.core.first.call(null,seq5362);
var seq5362__$1 = cljs.core.next.call(null,seq5362);
var G__5364 = cljs.core.first.call(null,seq5362__$1);
var seq5362__$2 = cljs.core.next.call(null,seq5362__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5363,G__5364,seq5362__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cFkids.cljs$lang$macro = true);

var ret__4785__auto___5373 = (function (){
/**
 * Macro to bind `tiltontec.model.core/*parent*` to model `m` in
 *   `body`.
 */
tiltontec.matrix.api.with_par = (function tiltontec$matrix$api$with_par(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5374 = arguments.length;
var i__4737__auto___5375 = (0);
while(true){
if((i__4737__auto___5375 < len__4736__auto___5374)){
args__4742__auto__.push((arguments[i__4737__auto___5375]));

var G__5376 = (i__4737__auto___5375 + (1));
i__4737__auto___5375 = G__5376;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.with_par.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_par.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,m,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.core","with-par","tiltontec.model.core/with-par",-1936945574,null),null,(1),null)),(new cljs.core.List(null,m,null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_par.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.with_par.cljs$lang$applyTo = (function (seq5369){
var G__5370 = cljs.core.first.call(null,seq5369);
var seq5369__$1 = cljs.core.next.call(null,seq5369);
var G__5371 = cljs.core.first.call(null,seq5369__$1);
var seq5369__$2 = cljs.core.next.call(null,seq5369__$1);
var G__5372 = cljs.core.first.call(null,seq5369__$2);
var seq5369__$3 = cljs.core.next.call(null,seq5369__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5370,G__5371,G__5372,seq5369__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.with_par.cljs$lang$macro = true);

/**
 * A pattern commonly employed in matrix applications is to define
 *   a :kid-factory on some 'parent' cell, and use it to enrich the value
 *   extracted from the parent's kid cells.
 * 
 * This function maps across the :kids-values, invoking the factory as
 *   it goes.
 * 
 *   ```clojure
 *   (cF (make :some-mx-type
 *      :kid-values some-sequence-value
 *      ;;
 *      ;; the built kid is cached by sequence item's value,
 *      ;; `:kid-key` is a function retrieves the items'value from built children.
 *      ;;
 *      :kid-key (fn [child] (mx/mget child :your-key-prop))
 *      :kid-factory (fn [me item-val]
 *                     (make :your-child-type
 *                       :your-key-prop item-val
 *                       ...))
 *      (kid-values-kids me _cache)))
 *   ```
 */
tiltontec.matrix.api.kid_values_kids = (function tiltontec$matrix$api$kid_values_kids(me,existing_kids){
return tiltontec.model.family.kid_values_kids.call(null,me,existing_kids);
});
var ret__4785__auto___5380 = (function (){
/**
 * Shortcut definer for cell-specific watchs.
 * 
 *   body can be multiple sexprs with access to call parameters: `prop`,
 *   `me`, `new`, `old`, and `c`.
 */
tiltontec.matrix.api.fn_watch = (function tiltontec$matrix$api$fn_watch(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5381 = arguments.length;
var i__4737__auto___5382 = (0);
while(true){
if((i__4737__auto___5382 < len__4736__auto___5381)){
args__4742__auto__.push((arguments[i__4737__auto___5382]));

var G__5383 = (i__4737__auto___5382 + (1));
i__4737__auto___5382 = G__5383;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.fn_watch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.fn_watch.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"prop","prop",1125363195,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"me","me",1501524834,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"new","new",-444906321,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"old","old",-184691163,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"c","c",-122660552,null),null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.fn_watch.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.fn_watch.cljs$lang$applyTo = (function (seq5377){
var G__5378 = cljs.core.first.call(null,seq5377);
var seq5377__$1 = cljs.core.next.call(null,seq5377);
var G__5379 = cljs.core.first.call(null,seq5377__$1);
var seq5377__$2 = cljs.core.next.call(null,seq5377__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5378,G__5379,seq5377__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.fn_watch.cljs$lang$macro = true);

/**
 * Create a `Input` cell with the given initial `value` and cell options.
 */
tiltontec.matrix.api.cI = (function tiltontec$matrix$api$cI(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5386 = arguments.length;
var i__4737__auto___5387 = (0);
while(true){
if((i__4737__auto___5387 < len__4736__auto___5386)){
args__4742__auto__.push((arguments[i__4737__auto___5387]));

var G__5388 = (i__4737__auto___5387 + (1));
i__4737__auto___5387 = G__5388;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tiltontec.matrix.api.cI.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cI.cljs$core$IFn$_invoke$arity$variadic = (function (value,options){
return cljs.core.apply.call(null,tiltontec.cell.core.make_cell,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"input?","input?",-1792843173),true,options);
}));

(tiltontec.matrix.api.cI.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tiltontec.matrix.api.cI.cljs$lang$applyTo = (function (seq5384){
var G__5385 = cljs.core.first.call(null,seq5384);
var seq5384__$1 = cljs.core.next.call(null,seq5384);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5385,seq5384__$1);
}));

var ret__4785__auto___5392 = (function (){
/**
 * Create a `Formula` cell with formula `body`.
 * 
 *   the `body` will be executed with following symbol bound:
 *   - `me`: the cell's associated model (`c-model`)
 *   - `_prop-name`: the cell's property name (`c-prop-name`)
 *   - `_cache`: the cell's current value (`c-value`)
 *   - `_cell`: the cell itself
 */
tiltontec.matrix.api.cF = (function tiltontec$matrix$api$cF(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5393 = arguments.length;
var i__4737__auto___5394 = (0);
while(true){
if((i__4737__auto___5394 < len__4736__auto___5393)){
args__4742__auto__.push((arguments[i__4737__auto___5394]));

var G__5395 = (i__4737__auto___5394 + (1));
i__4737__auto___5394 = G__5395;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cF.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cF.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","make-c-formula","tiltontec.cell.core/make-c-formula",-143496150,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"code","code",1586293142),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,body,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"rule","rule",729973257),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","c-fn","tiltontec.cell.core/c-fn",1198019642,null),null,(1),null)),body))),null,(1),null)))));
}));

(tiltontec.matrix.api.cF.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cF.cljs$lang$applyTo = (function (seq5389){
var G__5390 = cljs.core.first.call(null,seq5389);
var seq5389__$1 = cljs.core.next.call(null,seq5389);
var G__5391 = cljs.core.first.call(null,seq5389__$1);
var seq5389__$2 = cljs.core.next.call(null,seq5389__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5390,G__5391,seq5389__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cF.cljs$lang$macro = true);

var ret__4785__auto___5404 = (function (){
/**
 * A version `cF` that takes extra cell options.
 */
tiltontec.matrix.api.cF_PLUS_ = (function tiltontec$matrix$api$cF_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5405 = arguments.length;
var i__4737__auto___5406 = (0);
while(true){
if((i__4737__auto___5406 < len__4736__auto___5405)){
args__4742__auto__.push((arguments[i__4737__auto___5406]));

var G__5407 = (i__4737__auto___5406 + (1));
i__4737__auto___5406 = G__5407;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.cF_PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cF_PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5400,body){
var vec__5401 = p__5400;
var seq__5402 = cljs.core.seq.call(null,vec__5401);
var options = seq__5402;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","make-c-formula","tiltontec.cell.core/make-c-formula",-143496150,null),null,(1),null)),options,(new cljs.core.List(null,new cljs.core.Keyword(null,"code","code",1586293142),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,body,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"rule","rule",729973257),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","c-fn","tiltontec.cell.core/c-fn",1198019642,null),null,(1),null)),body))),null,(1),null)))));
}));

(tiltontec.matrix.api.cF_PLUS_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.cF_PLUS_.cljs$lang$applyTo = (function (seq5396){
var G__5397 = cljs.core.first.call(null,seq5396);
var seq5396__$1 = cljs.core.next.call(null,seq5396);
var G__5398 = cljs.core.first.call(null,seq5396__$1);
var seq5396__$2 = cljs.core.next.call(null,seq5396__$1);
var G__5399 = cljs.core.first.call(null,seq5396__$2);
var seq5396__$3 = cljs.core.next.call(null,seq5396__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5397,G__5398,G__5399,seq5396__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.cF_PLUS_.cljs$lang$macro = true);

var ret__4785__auto___5411 = (function (){
/**
 * Start as formula for initial value computation, then convert to input cell.
 */
tiltontec.matrix.api.cFn = (function tiltontec$matrix$api$cFn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5412 = arguments.length;
var i__4737__auto___5413 = (0);
while(true){
if((i__4737__auto___5413 < len__4736__auto___5412)){
args__4742__auto__.push((arguments[i__4737__auto___5413]));

var G__5414 = (i__4737__auto___5413 + (1));
i__4737__auto___5413 = G__5414;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cFn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cFn.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","make-c-formula","tiltontec.cell.core/make-c-formula",-143496150,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"code","code",1586293142),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"input?","input?",-1792843173),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"rule","rule",729973257),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","c-fn","tiltontec.cell.core/c-fn",1198019642,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)))));
}));

(tiltontec.matrix.api.cFn.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cFn.cljs$lang$applyTo = (function (seq5408){
var G__5409 = cljs.core.first.call(null,seq5408);
var seq5408__$1 = cljs.core.next.call(null,seq5408);
var G__5410 = cljs.core.first.call(null,seq5408__$1);
var seq5408__$2 = cljs.core.next.call(null,seq5408__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5409,G__5410,seq5408__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cFn.cljs$lang$macro = true);

var ret__4785__auto___5423 = (function (){
/**
 * A version `cFn` that takes extra cell options.
 */
tiltontec.matrix.api.cF_PLUS_n = (function tiltontec$matrix$api$cF_PLUS_n(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5424 = arguments.length;
var i__4737__auto___5425 = (0);
while(true){
if((i__4737__auto___5425 < len__4736__auto___5424)){
args__4742__auto__.push((arguments[i__4737__auto___5425]));

var G__5426 = (i__4737__auto___5425 + (1));
i__4737__auto___5425 = G__5426;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.cF_PLUS_n.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cF_PLUS_n.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5419,body){
var vec__5420 = p__5419;
var seq__5421 = cljs.core.seq.call(null,vec__5420);
var options = seq__5421;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","make-c-formula","tiltontec.cell.core/make-c-formula",-143496150,null),null,(1),null)),options,(new cljs.core.List(null,new cljs.core.Keyword(null,"code","code",1586293142),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"input?","input?",-1792843173),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"rule","rule",729973257),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","c-fn","tiltontec.cell.core/c-fn",1198019642,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)))));
}));

(tiltontec.matrix.api.cF_PLUS_n.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.cF_PLUS_n.cljs$lang$applyTo = (function (seq5415){
var G__5416 = cljs.core.first.call(null,seq5415);
var seq5415__$1 = cljs.core.next.call(null,seq5415);
var G__5417 = cljs.core.first.call(null,seq5415__$1);
var seq5415__$2 = cljs.core.next.call(null,seq5415__$1);
var G__5418 = cljs.core.first.call(null,seq5415__$2);
var seq5415__$3 = cljs.core.next.call(null,seq5415__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5416,G__5417,G__5418,seq5415__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.cF_PLUS_n.cljs$lang$macro = true);

var ret__4785__auto___5430 = (function (){
/**
 * Start as formula for initial computation, then behave as immutable property.
 */
tiltontec.matrix.api.cFonce = (function tiltontec$matrix$api$cFonce(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5431 = arguments.length;
var i__4737__auto___5432 = (0);
while(true){
if((i__4737__auto___5432 < len__4736__auto___5431)){
args__4742__auto__.push((arguments[i__4737__auto___5432]));

var G__5433 = (i__4737__auto___5432 + (1));
i__4737__auto___5432 = G__5433;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cFonce.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cFonce.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","make-c-formula","tiltontec.cell.core/make-c-formula",-143496150,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"code","code",1586293142),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"input?","input?",-1792843173),null,(1),null)),(new cljs.core.List(null,null,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"rule","rule",729973257),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","c-fn","tiltontec.cell.core/c-fn",1198019642,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.base","without-c-dependency","tiltontec.cell.base/without-c-dependency",-1335265675,null),null,(1),null)),body))),null,(1),null))))),null,(1),null)))));
}));

(tiltontec.matrix.api.cFonce.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cFonce.cljs$lang$applyTo = (function (seq5427){
var G__5428 = cljs.core.first.call(null,seq5427);
var seq5427__$1 = cljs.core.next.call(null,seq5427);
var G__5429 = cljs.core.first.call(null,seq5427__$1);
var seq5427__$2 = cljs.core.next.call(null,seq5427__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5428,G__5429,seq5427__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cFonce.cljs$lang$macro = true);

var ret__4785__auto___5437 = (function (){
/**
 * Alias to `cFonce`.
 */
tiltontec.matrix.api.cF1 = (function tiltontec$matrix$api$cF1(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5438 = arguments.length;
var i__4737__auto___5439 = (0);
while(true){
if((i__4737__auto___5439 < len__4736__auto___5438)){
args__4742__auto__.push((arguments[i__4737__auto___5439]));

var G__5440 = (i__4737__auto___5439 + (1));
i__4737__auto___5439 = G__5440;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.cF1.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.cF1.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.core","cFonce","tiltontec.cell.core/cFonce",1541505458,null),null,(1),null)),body)));
}));

(tiltontec.matrix.api.cF1.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.cF1.cljs$lang$applyTo = (function (seq5434){
var G__5435 = cljs.core.first.call(null,seq5434);
var seq5434__$1 = cljs.core.next.call(null,seq5434);
var G__5436 = cljs.core.first.call(null,seq5434__$1);
var seq5434__$2 = cljs.core.next.call(null,seq5434__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5435,G__5436,seq5434__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.cF1.cljs$lang$macro = true);

/**
 * Create a model whose parent is `tiltontec.model.core/*parent*`.
 * 
 *   When `arg-list` is odd, convert the first element to value of `:mx-type`.
 * 
 *   - `:mx-type` is the type of the model, defaulting to `:tiltontec.cell.base/model`.
 *   - `:on-quiesce` is a function to be called when the model quiesces.
 *   - The rest of the elements are treated as key-value pairs to be used
 *   as properties of the model.
 */
tiltontec.matrix.api.make = (function tiltontec$matrix$api$make(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5442 = arguments.length;
var i__4737__auto___5443 = (0);
while(true){
if((i__4737__auto___5443 < len__4736__auto___5442)){
args__4742__auto__.push((arguments[i__4737__auto___5443]));

var G__5444 = (i__4737__auto___5443 + (1));
i__4737__auto___5443 = G__5444;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tiltontec.matrix.api.make.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tiltontec.matrix.api.make.cljs$core$IFn$_invoke$arity$variadic = (function (arg_list){
return cljs.core.apply.call(null,tiltontec.model.core.make,arg_list);
}));

(tiltontec.matrix.api.make.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tiltontec.matrix.api.make.cljs$lang$applyTo = (function (seq5441){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq5441));
}));

/**
 * Set the `prop`'s value of model `me` to be `new-value`. Returns the
 *   new-value.
 */
tiltontec.matrix.api.mset_BANG_ = (function tiltontec$matrix$api$mset_BANG_(me,prop,new_value){
return tiltontec.model.accessors.mset_BANG_.call(null,me,prop,new_value);
});
/**
 * Swaps the `prop`'s value of model `me` to be
 *   (apply swap-fn current-value-of-prop args).
 */
tiltontec.matrix.api.mswap_BANG_ = (function tiltontec$matrix$api$mswap_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5449 = arguments.length;
var i__4737__auto___5450 = (0);
while(true){
if((i__4737__auto___5450 < len__4736__auto___5449)){
args__4742__auto__.push((arguments[i__4737__auto___5450]));

var G__5451 = (i__4737__auto___5450 + (1));
i__4737__auto___5450 = G__5451;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.mswap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.mswap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (me,prop,swap_fn,swap_fn_args){
return cljs.core.apply.call(null,tiltontec.model.accessors.mswap_BANG_,me,prop,swap_fn,swap_fn_args);
}));

(tiltontec.matrix.api.mswap_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.mswap_BANG_.cljs$lang$applyTo = (function (seq5445){
var G__5446 = cljs.core.first.call(null,seq5445);
var seq5445__$1 = cljs.core.next.call(null,seq5445);
var G__5447 = cljs.core.first.call(null,seq5445__$1);
var seq5445__$2 = cljs.core.next.call(null,seq5445__$1);
var G__5448 = cljs.core.first.call(null,seq5445__$2);
var seq5445__$3 = cljs.core.next.call(null,seq5445__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5446,G__5447,G__5448,seq5445__$3);
}));

/**
 * Get the `prop`'s value of model `me`. Throw exception if no `prop`
 *   found in model `me`.
 */
tiltontec.matrix.api.mget = (function tiltontec$matrix$api$mget(me,prop){
return tiltontec.model.accessors.mget.call(null,me,prop);
});
/**
 * Get the `prop`'s value of model `me`. Returns `alt-value` if no
 *   `prop` found in model `me`.
 */
tiltontec.matrix.api.mget_QMARK_ = (function tiltontec$matrix$api$mget_QMARK_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5459 = arguments.length;
var i__4737__auto___5460 = (0);
while(true){
if((i__4737__auto___5460 < len__4736__auto___5459)){
args__4742__auto__.push((arguments[i__4737__auto___5460]));

var G__5461 = (i__4737__auto___5460 + (1));
i__4737__auto___5460 = G__5461;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.mget_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.mget_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (me,prop,p__5455){
var vec__5456 = p__5455;
var alt_value = cljs.core.nth.call(null,vec__5456,(0),null);
return tiltontec.model.accessors.mget_QMARK_.call(null,me,prop,alt_value);
}));

(tiltontec.matrix.api.mget_QMARK_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.mget_QMARK_.cljs$lang$applyTo = (function (seq5452){
var G__5453 = cljs.core.first.call(null,seq5452);
var seq5452__$1 = cljs.core.next.call(null,seq5452);
var G__5454 = cljs.core.first.call(null,seq5452__$1);
var seq5452__$2 = cljs.core.next.call(null,seq5452__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5453,G__5454,seq5452__$2);
}));

var ret__4785__auto___5470 = (function (){
tiltontec.matrix.api.with_integrity = (function tiltontec$matrix$api$with_integrity(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5471 = arguments.length;
var i__4737__auto___5472 = (0);
while(true){
if((i__4737__auto___5472 < len__4736__auto___5471)){
args__4742__auto__.push((arguments[i__4737__auto___5472]));

var G__5473 = (i__4737__auto___5472 + (1));
i__4737__auto___5472 = G__5473;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.with_integrity.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_integrity.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5466,body){
var vec__5467 = p__5466;
var opcode = cljs.core.nth.call(null,vec__5467,(0),null);
var info = cljs.core.nth.call(null,vec__5467,(1),null);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.integrity","with-integrity","tiltontec.cell.integrity/with-integrity",-1374442056,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,opcode,null,(1),null)),(new cljs.core.List(null,info,null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_integrity.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.with_integrity.cljs$lang$applyTo = (function (seq5462){
var G__5463 = cljs.core.first.call(null,seq5462);
var seq5462__$1 = cljs.core.next.call(null,seq5462);
var G__5464 = cljs.core.first.call(null,seq5462__$1);
var seq5462__$2 = cljs.core.next.call(null,seq5462__$1);
var G__5465 = cljs.core.first.call(null,seq5462__$2);
var seq5462__$3 = cljs.core.next.call(null,seq5462__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5463,G__5464,G__5465,seq5462__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.with_integrity.cljs$lang$macro = true);

var ret__4785__auto___5478 = (function (){
tiltontec.matrix.api.with_cc = (function tiltontec$matrix$api$with_cc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5479 = arguments.length;
var i__4737__auto___5480 = (0);
while(true){
if((i__4737__auto___5480 < len__4736__auto___5479)){
args__4742__auto__.push((arguments[i__4737__auto___5480]));

var G__5481 = (i__4737__auto___5480 + (1));
i__4737__auto___5480 = G__5481;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.with_cc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_cc.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,id,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.integrity","with-integrity","tiltontec.cell.integrity/with-integrity",-1374442056,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"change","change",-1163046502),null,(1),null)),(new cljs.core.List(null,id,null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_cc.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.with_cc.cljs$lang$applyTo = (function (seq5474){
var G__5475 = cljs.core.first.call(null,seq5474);
var seq5474__$1 = cljs.core.next.call(null,seq5474);
var G__5476 = cljs.core.first.call(null,seq5474__$1);
var seq5474__$2 = cljs.core.next.call(null,seq5474__$1);
var G__5477 = cljs.core.first.call(null,seq5474__$2);
var seq5474__$3 = cljs.core.next.call(null,seq5474__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5475,G__5476,G__5477,seq5474__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.with_cc.cljs$lang$macro = true);

var ret__4785__auto___5489 = (function (){
tiltontec.matrix.api.mpar = (function tiltontec$matrix$api$mpar(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5490 = arguments.length;
var i__4737__auto___5491 = (0);
while(true){
if((i__4737__auto___5491 < len__4736__auto___5490)){
args__4742__auto__.push((arguments[i__4737__auto___5491]));

var G__5492 = (i__4737__auto___5491 + (1));
i__4737__auto___5491 = G__5492;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.mpar.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.mpar.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5485){
var vec__5486 = p__5485;
var me = cljs.core.nth.call(null,vec__5486,(0),null);
var me__$1 = (function (){var or__4126__auto__ = me;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Symbol(null,"me","me",1501524834,null);
}
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"parent","parent",-878878779),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,me__$1,null,(1),null))))),null,(1),null)))));
}));

(tiltontec.matrix.api.mpar.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.mpar.cljs$lang$applyTo = (function (seq5482){
var G__5483 = cljs.core.first.call(null,seq5482);
var seq5482__$1 = cljs.core.next.call(null,seq5482);
var G__5484 = cljs.core.first.call(null,seq5482__$1);
var seq5482__$2 = cljs.core.next.call(null,seq5482__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5483,G__5484,seq5482__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.mpar.cljs$lang$macro = true);

tiltontec.matrix.api.fm_navig = (function tiltontec$matrix$api$fm_navig(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5496 = arguments.length;
var i__4737__auto___5497 = (0);
while(true){
if((i__4737__auto___5497 < len__4736__auto___5496)){
args__4742__auto__.push((arguments[i__4737__auto___5497]));

var G__5498 = (i__4737__auto___5497 + (1));
i__4737__auto___5497 = G__5498;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.fm_navig.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.fm_navig.cljs$core$IFn$_invoke$arity$variadic = (function (what,where,options){
return cljs.core.apply.call(null,tiltontec.model.navigate.fm_navig,what,where,options);
}));

(tiltontec.matrix.api.fm_navig.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.fm_navig.cljs$lang$applyTo = (function (seq5493){
var G__5494 = cljs.core.first.call(null,seq5493);
var seq5493__$1 = cljs.core.next.call(null,seq5493);
var G__5495 = cljs.core.first.call(null,seq5493__$1);
var seq5493__$2 = cljs.core.next.call(null,seq5493__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5494,G__5495,seq5493__$2);
}));

/**
 * Search up from `where`, excluding where and following only parent
 *   links for `what`.
 */
tiltontec.matrix.api.fasc = (function tiltontec$matrix$api$fasc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5502 = arguments.length;
var i__4737__auto___5503 = (0);
while(true){
if((i__4737__auto___5503 < len__4736__auto___5502)){
args__4742__auto__.push((arguments[i__4737__auto___5503]));

var G__5504 = (i__4737__auto___5503 + (1));
i__4737__auto___5503 = G__5504;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.fasc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.fasc.cljs$core$IFn$_invoke$arity$variadic = (function (what,where,options){
return cljs.core.apply.call(null,tiltontec.model.navigate.fasc,what,where,options);
}));

(tiltontec.matrix.api.fasc.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.fasc.cljs$lang$applyTo = (function (seq5499){
var G__5500 = cljs.core.first.call(null,seq5499);
var seq5499__$1 = cljs.core.next.call(null,seq5499);
var G__5501 = cljs.core.first.call(null,seq5499__$1);
var seq5499__$2 = cljs.core.next.call(null,seq5499__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5500,G__5501,seq5499__$2);
}));

var ret__4785__auto___5513 = (function (){
/**
 * Search matrix ascendents from node 'me' (defaulting to 'me in current scope)
 *   looking for element with given name
 */
tiltontec.matrix.api.fmu = (function tiltontec$matrix$api$fmu(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5514 = arguments.length;
var i__4737__auto___5515 = (0);
while(true){
if((i__4737__auto___5515 < len__4736__auto___5514)){
args__4742__auto__.push((arguments[i__4737__auto___5515]));

var G__5516 = (i__4737__auto___5515 + (1));
i__4737__auto___5515 = G__5516;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.fmu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.fmu.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,p__5509){
var vec__5510 = p__5509;
var _me = cljs.core.nth.call(null,vec__5510,(0),null);
var options = vec__5510;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","fmu","tiltontec.model.navigate/fmu",-1633592998,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)),options)));
}));

(tiltontec.matrix.api.fmu.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.fmu.cljs$lang$applyTo = (function (seq5505){
var G__5506 = cljs.core.first.call(null,seq5505);
var seq5505__$1 = cljs.core.next.call(null,seq5505);
var G__5507 = cljs.core.first.call(null,seq5505__$1);
var seq5505__$2 = cljs.core.next.call(null,seq5505__$1);
var G__5508 = cljs.core.first.call(null,seq5505__$2);
var seq5505__$3 = cljs.core.next.call(null,seq5505__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5506,G__5507,G__5508,seq5505__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.fmu.cljs$lang$macro = true);

var ret__4785__auto___5525 = (function (){
/**
 * `fmu` inclusive of the starting node `me`.
 */
tiltontec.matrix.api.fmuinc = (function tiltontec$matrix$api$fmuinc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5526 = arguments.length;
var i__4737__auto___5527 = (0);
while(true){
if((i__4737__auto___5527 < len__4736__auto___5526)){
args__4742__auto__.push((arguments[i__4737__auto___5527]));

var G__5528 = (i__4737__auto___5527 + (1));
i__4737__auto___5527 = G__5528;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.fmuinc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.fmuinc.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,p__5521){
var vec__5522 = p__5521;
var _me = cljs.core.nth.call(null,vec__5522,(0),null);
var options = vec__5522;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","fmuinc","tiltontec.model.navigate/fmuinc",-325022109,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)),options)));
}));

(tiltontec.matrix.api.fmuinc.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.fmuinc.cljs$lang$applyTo = (function (seq5517){
var G__5518 = cljs.core.first.call(null,seq5517);
var seq5517__$1 = cljs.core.next.call(null,seq5517);
var G__5519 = cljs.core.first.call(null,seq5517__$1);
var seq5517__$2 = cljs.core.next.call(null,seq5517__$1);
var G__5520 = cljs.core.first.call(null,seq5517__$2);
var seq5517__$3 = cljs.core.next.call(null,seq5517__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5518,G__5519,G__5520,seq5517__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.fmuinc.cljs$lang$macro = true);

/**
 * Search matrix ascendents and descendents from node 'where', for
 *   'what', throwing an error when not found
 */
tiltontec.matrix.api.fm_BANG_ = (function tiltontec$matrix$api$fm_BANG_(what,where){
return tiltontec.model.navigate.fm_BANG_.call(null,what,where);
});
/**
 * Search matrix ascendants from node `me` for first with given tag
 */
tiltontec.matrix.api.mxu_find_type = (function tiltontec$matrix$api$mxu_find_type(me,type){
if(cljs.core.truth_(me)){
} else {
throw (new Error("Assert failed: me"));
}

return tiltontec.matrix.api.fasc.call(null,(function (visited){
return cljs.core._EQ_.call(null,type,tiltontec.matrix.api.mx_type.call(null,visited));
}),me);
});
var ret__4785__auto___5538 = (function (){
/**
 * Search matrix ascendents from node 'me' looking for `what`, and
 *   extract `slot`
 */
tiltontec.matrix.api.mdv_BANG_ = (function tiltontec$matrix$api$mdv_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5539 = arguments.length;
var i__4737__auto___5540 = (0);
while(true){
if((i__4737__auto___5540 < len__4736__auto___5539)){
args__4742__auto__.push((arguments[i__4737__auto___5540]));

var G__5541 = (i__4737__auto___5540 + (1));
i__4737__auto___5540 = G__5541;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((4) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((4)),(0),null)):null);
return tiltontec.matrix.api.mdv_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.mdv_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,what,slot,p__5534){
var vec__5535 = p__5534;
var _me = cljs.core.nth.call(null,vec__5535,(0),null);
var options = vec__5535;
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","mdv!","tiltontec.model.navigate/mdv!",1695330218,null),null,(1),null)),(new cljs.core.List(null,what,null,(1),null)),(new cljs.core.List(null,slot,null,(1),null)),options)));
}));

(tiltontec.matrix.api.mdv_BANG_.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(tiltontec.matrix.api.mdv_BANG_.cljs$lang$applyTo = (function (seq5529){
var G__5530 = cljs.core.first.call(null,seq5529);
var seq5529__$1 = cljs.core.next.call(null,seq5529);
var G__5531 = cljs.core.first.call(null,seq5529__$1);
var seq5529__$2 = cljs.core.next.call(null,seq5529__$1);
var G__5532 = cljs.core.first.call(null,seq5529__$2);
var seq5529__$3 = cljs.core.next.call(null,seq5529__$2);
var G__5533 = cljs.core.first.call(null,seq5529__$3);
var seq5529__$4 = cljs.core.next.call(null,seq5529__$3);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5530,G__5531,G__5532,G__5533,seq5529__$4);
}));

return null;
})()
;
(tiltontec.matrix.api.mdv_BANG_.cljs$lang$macro = true);

var ret__4785__auto___5546 = (function (){
tiltontec.matrix.api.with_mx_trace = (function tiltontec$matrix$api$with_mx_trace(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5547 = arguments.length;
var i__4737__auto___5548 = (0);
while(true){
if((i__4737__auto___5548 < len__4736__auto___5547)){
args__4742__auto__.push((arguments[i__4737__auto___5548]));

var G__5549 = (i__4737__auto___5548 + (1));
i__4737__auto___5548 = G__5549;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.with_mx_trace.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_mx_trace.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,target,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.diagnostic","*mx-trace*","tiltontec.cell.diagnostic/*mx-trace*",-193711574,null),null,(1),null)),(new cljs.core.List(null,target,null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_mx_trace.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.with_mx_trace.cljs$lang$applyTo = (function (seq5542){
var G__5543 = cljs.core.first.call(null,seq5542);
var seq5542__$1 = cljs.core.next.call(null,seq5542);
var G__5544 = cljs.core.first.call(null,seq5542__$1);
var seq5542__$2 = cljs.core.next.call(null,seq5542__$1);
var G__5545 = cljs.core.first.call(null,seq5542__$2);
var seq5542__$3 = cljs.core.next.call(null,seq5542__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5543,G__5544,G__5545,seq5542__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.with_mx_trace.cljs$lang$macro = true);

var ret__4785__auto___5554 = (function (){
tiltontec.matrix.api.mxtrc = (function tiltontec$matrix$api$mxtrc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5555 = arguments.length;
var i__4737__auto___5556 = (0);
while(true){
if((i__4737__auto___5556 < len__4736__auto___5555)){
args__4742__auto__.push((arguments[i__4737__auto___5556]));

var G__5557 = (i__4737__auto___5556 + (1));
i__4737__auto___5556 = G__5557;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.mxtrc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.mxtrc.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,tag,bits){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.diagnostic","mxtrc","tiltontec.cell.diagnostic/mxtrc",-26737721,null),null,(1),null)),(new cljs.core.List(null,tag,null,(1),null)),bits)));
}));

(tiltontec.matrix.api.mxtrc.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.mxtrc.cljs$lang$applyTo = (function (seq5550){
var G__5551 = cljs.core.first.call(null,seq5550);
var seq5550__$1 = cljs.core.next.call(null,seq5550);
var G__5552 = cljs.core.first.call(null,seq5550__$1);
var seq5550__$2 = cljs.core.next.call(null,seq5550__$1);
var G__5553 = cljs.core.first.call(null,seq5550__$2);
var seq5550__$3 = cljs.core.next.call(null,seq5550__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5551,G__5552,G__5553,seq5550__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.mxtrc.cljs$lang$macro = true);

var ret__4785__auto___5562 = (function (){
tiltontec.matrix.api.with_minfo = (function tiltontec$matrix$api$with_minfo(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5563 = arguments.length;
var i__4737__auto___5564 = (0);
while(true){
if((i__4737__auto___5564 < len__4736__auto___5563)){
args__4742__auto__.push((arguments[i__4737__auto___5564]));

var G__5565 = (i__4737__auto___5564 + (1));
i__4737__auto___5564 = G__5565;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.matrix.api.with_minfo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_minfo.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,minfo_body,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.diagnostic","*mx-minfo*","tiltontec.cell.diagnostic/*mx-minfo*",-1697634792,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"me","me",1501524834,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,minfo_body,null,(1),null))))),null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_minfo.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.matrix.api.with_minfo.cljs$lang$applyTo = (function (seq5558){
var G__5559 = cljs.core.first.call(null,seq5558);
var seq5558__$1 = cljs.core.next.call(null,seq5558);
var G__5560 = cljs.core.first.call(null,seq5558__$1);
var seq5558__$2 = cljs.core.next.call(null,seq5558__$1);
var G__5561 = cljs.core.first.call(null,seq5558__$2);
var seq5558__$3 = cljs.core.next.call(null,seq5558__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5559,G__5560,G__5561,seq5558__$3);
}));

return null;
})()
;
(tiltontec.matrix.api.with_minfo.cljs$lang$macro = true);

var ret__4785__auto___5569 = (function (){
tiltontec.matrix.api.with_minfo_std = (function tiltontec$matrix$api$with_minfo_std(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5570 = arguments.length;
var i__4737__auto___5571 = (0);
while(true){
if((i__4737__auto___5571 < len__4736__auto___5570)){
args__4742__auto__.push((arguments[i__4737__auto___5571]));

var G__5572 = (i__4737__auto___5571 + (1));
i__4737__auto___5571 = G__5572;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.matrix.api.with_minfo_std.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.matrix.api.with_minfo_std.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.cell.diagnostic","*mx-minfo*","tiltontec.cell.diagnostic/*mx-minfo*",-1697634792,null),null,(1),null)),(new cljs.core.List(null,null,null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.matrix.api.with_minfo_std.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.matrix.api.with_minfo_std.cljs$lang$applyTo = (function (seq5566){
var G__5567 = cljs.core.first.call(null,seq5566);
var seq5566__$1 = cljs.core.next.call(null,seq5566);
var G__5568 = cljs.core.first.call(null,seq5566__$1);
var seq5566__$2 = cljs.core.next.call(null,seq5566__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5567,G__5568,seq5566__$2);
}));

return null;
})()
;
(tiltontec.matrix.api.with_minfo_std.cljs$lang$macro = true);

tiltontec.matrix.api.minfo = (function tiltontec$matrix$api$minfo(me){
return tiltontec.cell.diagnostic.minfo.call(null,me);
});
tiltontec.matrix.api.cinfo = (function tiltontec$matrix$api$cinfo(c){
return tiltontec.cell.diagnostic.cinfo.call(null,c);
});
