// Compiled by ClojureScript 1.10.773 {}
goog.provide('tiltontec.model.core');
goog.require('cljs.core');
goog.require('tiltontec.cell.base');
goog.require('tiltontec.cell.integrity');
goog.require('tiltontec.cell.poly');
goog.require('tiltontec.util.trace');
/**
 * Each app will populate this with the root of its application matrix.
 */
tiltontec.model.core.matrix = cljs.core.atom.call(null,null);
/**
 * `cz` is a map of prop-name (of model `me`) to cells.
 */
tiltontec.model.core.md_cz = (function tiltontec$model$core$md_cz(me){
return new cljs.core.Keyword(null,"cz","cz",1670864932).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me));
});
/**
 * Return the cell for `prop` in model `me`.
 */
tiltontec.model.core.md_cell = (function tiltontec$model$core$md_cell(var_args){
var G__5056 = arguments.length;
switch (G__5056) {
case 2:
return tiltontec.model.core.md_cell.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tiltontec.model.core.md_cell.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tiltontec.model.core.md_cell.cljs$core$IFn$_invoke$arity$2 = (function (me,prop){
return prop.call(null,new cljs.core.Keyword(null,"cz","cz",1670864932).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me)));
}));

(tiltontec.model.core.md_cell.cljs$core$IFn$_invoke$arity$3 = (function (me,prop,not_found){
return prop.call(null,new cljs.core.Keyword(null,"cz","cz",1670864932).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me)),not_found);
}));

(tiltontec.model.core.md_cell.cljs$lang$maxFixedArity = 3);

tiltontec.model.core.md_name = (function tiltontec$model$core$md_name(me){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,me));
});
tiltontec.model.core._STAR_parent_STAR_ = null;
/**
 * Install a cell in a model, and return true if the cell is a `c-ref?`.
 * If the cell is a ref, then the model will be installed as the
 *   cell's :me.
 * 
 *   note that c (a misnomer) might not be a Cell.
 */
tiltontec.model.core.md_install_cell = (function tiltontec$model$core$md_install_cell(me,prop,c){
var is_c_ref = tiltontec.cell.base.c_ref_QMARK_.call(null,c);
if(is_c_ref){
cljs.core.swap_BANG_.call(null,c,cljs.core.assoc,new cljs.core.Keyword(null,"prop","prop",-515168332),prop,new cljs.core.Keyword(null,"me","me",-139006693),me);

var v__1174__auto___5058 = (cljs.core.truth_(tiltontec.cell.base.c_input_QMARK_.call(null,c))?tiltontec.cell.base.c_value.call(null,c):null);
cljs.core.swap_BANG_.call(null,me,cljs.core.assoc,prop,v__1174__auto___5058);

} else {
var v__1174__auto___5059 = c;
cljs.core.swap_BANG_.call(null,me,cljs.core.assoc,prop,v__1174__auto___5059);

}

return is_c_ref;
});
/**
 * (1) do initial evaluation of all ruled props
 * (2) call watchs of all props
 */
tiltontec.model.core.md_awaken = (function tiltontec$model$core$md_awaken(me){
if(cljs.core.truth_(me)){
} else {
throw (new Error(["Assert failed: ","md-awaken passed nil","\n","me"].join('')));
}

tiltontec.cell.poly.md_awaken_before.call(null,me);

var s_5064 = tiltontec.cell.base.md_state.call(null,me);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nascent","nascent",443401807),s_5064)){
} else {
throw (new Error(["Assert failed: ",["md-awaken> state not nascent post-awaken-before: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = s_5064;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"NIL","NIL",757349226);
}
})())," meta: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me))].join(''),"\n","(= :nascent s)"].join('')));
}

var v__1186__auto___5065 = new cljs.core.Keyword(null,"awakening","awakening",838364227);
cljs.core.alter_meta_BANG_.call(null,me,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1186__auto___5065);


var seq__5060_5066 = cljs.core.seq.call(null,cljs.core.keys.call(null,cljs.core.deref.call(null,me)));
var chunk__5061_5067 = null;
var count__5062_5068 = (0);
var i__5063_5069 = (0);
while(true){
if((i__5063_5069 < count__5062_5068)){
var prop_5070 = cljs.core._nth.call(null,chunk__5061_5067,i__5063_5069);
var temp__5806__auto___5071 = tiltontec.model.core.md_cell.call(null,me,prop_5070);
if((temp__5806__auto___5071 == null)){
tiltontec.cell.poly.watch.call(null,prop_5070,me,prop_5070.call(null,cljs.core.deref.call(null,me)),tiltontec.cell.base.unbound,null);
} else {
var c_5072 = temp__5806__auto___5071;
tiltontec.cell.poly.c_awaken.call(null,c_5072);
}


var G__5073 = seq__5060_5066;
var G__5074 = chunk__5061_5067;
var G__5075 = count__5062_5068;
var G__5076 = (i__5063_5069 + (1));
seq__5060_5066 = G__5073;
chunk__5061_5067 = G__5074;
count__5062_5068 = G__5075;
i__5063_5069 = G__5076;
continue;
} else {
var temp__5804__auto___5077 = cljs.core.seq.call(null,seq__5060_5066);
if(temp__5804__auto___5077){
var seq__5060_5078__$1 = temp__5804__auto___5077;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5060_5078__$1)){
var c__4556__auto___5079 = cljs.core.chunk_first.call(null,seq__5060_5078__$1);
var G__5080 = cljs.core.chunk_rest.call(null,seq__5060_5078__$1);
var G__5081 = c__4556__auto___5079;
var G__5082 = cljs.core.count.call(null,c__4556__auto___5079);
var G__5083 = (0);
seq__5060_5066 = G__5080;
chunk__5061_5067 = G__5081;
count__5062_5068 = G__5082;
i__5063_5069 = G__5083;
continue;
} else {
var prop_5084 = cljs.core.first.call(null,seq__5060_5078__$1);
var temp__5806__auto___5085 = tiltontec.model.core.md_cell.call(null,me,prop_5084);
if((temp__5806__auto___5085 == null)){
tiltontec.cell.poly.watch.call(null,prop_5084,me,prop_5084.call(null,cljs.core.deref.call(null,me)),tiltontec.cell.base.unbound,null);
} else {
var c_5086 = temp__5806__auto___5085;
tiltontec.cell.poly.c_awaken.call(null,c_5086);
}


var G__5087 = cljs.core.next.call(null,seq__5060_5078__$1);
var G__5088 = null;
var G__5089 = (0);
var G__5090 = (0);
seq__5060_5066 = G__5087;
chunk__5061_5067 = G__5088;
count__5062_5068 = G__5089;
i__5063_5069 = G__5090;
continue;
}
} else {
}
}
break;
}

var v__1186__auto___5091 = new cljs.core.Keyword(null,"awake","awake",1922840899);
cljs.core.alter_meta_BANG_.call(null,me,cljs.core.assoc,new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),v__1186__auto___5091);


return me;
});
/**
 * Create a model whose parent is *parent*.
 */
tiltontec.model.core.make = (function tiltontec$model$core$make(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5101 = arguments.length;
var i__4737__auto___5102 = (0);
while(true){
if((i__4737__auto___5102 < len__4736__auto___5101)){
args__4742__auto__.push((arguments[i__4737__auto___5102]));

var G__5103 = (i__4737__auto___5102 + (1));
i__4737__auto___5102 = G__5103;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tiltontec.model.core.make.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tiltontec.model.core.make.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,args))){
return cljs.core.apply.call(null,tiltontec.model.core.make,new cljs.core.Keyword(null,"mx-type","mx-type",2136489290),args);
} else {
var arg_map = cljs.core.apply.call(null,cljs.core.hash_map,args);
var mx_type = cljs.core.get.call(null,arg_map,new cljs.core.Keyword(null,"mx-type","mx-type",2136489290),new cljs.core.Keyword("tiltontec.cell.base","model","tiltontec.cell.base/model",284743830));
var meta_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007),null,new cljs.core.Keyword(null,"mx-type","mx-type",2136489290),null], null), null);
var props_map = cljs.core.apply.call(null,cljs.core.dissoc,arg_map,meta_keys);
var me = cljs.core.atom.call(null,cljs.core.into.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"parent","parent",-878878779),tiltontec.model.core._STAR_parent_STAR_], null),cljs.core.map.call(null,(function (p__5093){
var vec__5094 = p__5093;
var k = cljs.core.nth.call(null,vec__5094,(0),null);
var v = cljs.core.nth.call(null,vec__5094,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,((tiltontec.cell.base.c_ref_QMARK_.call(null,v))?tiltontec.cell.base.unbound:v)], null);
}),props_map)),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("tiltontec.cell.base","state","tiltontec.cell.base/state",-1967920396),new cljs.core.Keyword(null,"nascent","nascent",443401807),new cljs.core.Keyword(null,"mx-sid","mx-sid",-508332951),tiltontec.util.trace.mx_sid_next.call(null),new cljs.core.Keyword(null,"mx-type","mx-type",2136489290),mx_type,new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007),cljs.core.get.call(null,arg_map,new cljs.core.Keyword(null,"on-quiesce","on-quiesce",1946284007))], null));
var cz = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.vec,cljs.core.filter.call(null,(function (p__5097){
var vec__5098 = p__5097;
var prop = cljs.core.nth.call(null,vec__5098,(0),null);
var v = cljs.core.nth.call(null,vec__5098,(1),null);
return tiltontec.model.core.md_install_cell.call(null,me,prop,v);
}),props_map)));
var v__1186__auto___5104 = cz;
cljs.core.alter_meta_BANG_.call(null,me,cljs.core.assoc,new cljs.core.Keyword(null,"cz","cz",1670864932),v__1186__auto___5104);


tiltontec.cell.integrity.call_with_integrity.call(null,new cljs.core.Keyword(null,"awaken","awaken",-1899628152),me,(function (opcode,defer_info){
return tiltontec.model.core.md_awaken.call(null,me);
}));

return me;
}
}));

(tiltontec.model.core.make.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tiltontec.model.core.make.cljs$lang$applyTo = (function (seq5092){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq5092));
}));

var ret__4785__auto___5109 = (function (){
tiltontec.model.core.with_par = (function tiltontec$model$core$with_par(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5110 = arguments.length;
var i__4737__auto___5111 = (0);
while(true){
if((i__4737__auto___5111 < len__4736__auto___5110)){
args__4742__auto__.push((arguments[i__4737__auto___5111]));

var G__5112 = (i__4737__auto___5111 + (1));
i__4737__auto___5111 = G__5112;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.model.core.with_par.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.model.core.with_par.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,m,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.core","*parent*","tiltontec.model.core/*parent*",43086772,null),null,(1),null)),(new cljs.core.List(null,m,null,(1),null)))))),null,(1),null)),body)));
}));

(tiltontec.model.core.with_par.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.model.core.with_par.cljs$lang$applyTo = (function (seq5105){
var G__5106 = cljs.core.first.call(null,seq5105);
var seq5105__$1 = cljs.core.next.call(null,seq5105);
var G__5107 = cljs.core.first.call(null,seq5105__$1);
var seq5105__$2 = cljs.core.next.call(null,seq5105__$1);
var G__5108 = cljs.core.first.call(null,seq5105__$2);
var seq5105__$3 = cljs.core.next.call(null,seq5105__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5106,G__5107,G__5108,seq5105__$3);
}));

return null;
})()
;
(tiltontec.model.core.with_par.cljs$lang$macro = true);

tiltontec.model.core.md_par = (function tiltontec$model$core$md_par(me){
return new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,me));
});
var ret__4785__auto___5120 = (function (){
tiltontec.model.core.mpar = (function tiltontec$model$core$mpar(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5121 = arguments.length;
var i__4737__auto___5122 = (0);
while(true){
if((i__4737__auto___5122 < len__4736__auto___5121)){
args__4742__auto__.push((arguments[i__4737__auto___5122]));

var G__5123 = (i__4737__auto___5122 + (1));
i__4737__auto___5122 = G__5123;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.model.core.mpar.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.model.core.mpar.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,p__5116){
var vec__5117 = p__5116;
var me = cljs.core.nth.call(null,vec__5117,(0),null);
var me__$1 = (function (){var or__4126__auto__ = me;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Symbol(null,"me","me",1501524834,null);
}
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Keyword(null,"parent","parent",-878878779),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null),null,(1),null)),(new cljs.core.List(null,me__$1,null,(1),null))))),null,(1),null)))));
}));

(tiltontec.model.core.mpar.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.model.core.mpar.cljs$lang$applyTo = (function (seq5113){
var G__5114 = cljs.core.first.call(null,seq5113);
var seq5113__$1 = cljs.core.next.call(null,seq5113);
var G__5115 = cljs.core.first.call(null,seq5113__$1);
var seq5113__$2 = cljs.core.next.call(null,seq5113__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5114,G__5115,seq5113__$2);
}));

return null;
})()
;
(tiltontec.model.core.mpar.cljs$lang$macro = true);

