// Compiled by ClojureScript 1.10.773 {}
goog.provide('tiltontec.model.navigate');
goog.require('cljs.core');
goog.require('tiltontec.util.core');
goog.require('tiltontec.cell.base');
goog.require('tiltontec.cell.diagnostic');
goog.require('tiltontec.model.accessors');
tiltontec.model.navigate.nextsib = (function tiltontec$model$navigate$nextsib(mx){
var _STAR_depender_STAR__orig_val__5242 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__5243 = null;
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__5243);

try{var sibs = tiltontec.model.accessors.mget_QMARK_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,mx)),new cljs.core.Keyword(null,"kids","kids",1156670771));
while(true){
if(cljs.core.truth_(sibs)){
if(cljs.core._EQ_.call(null,mx,cljs.core.first.call(null,sibs))){
return cljs.core.second.call(null,sibs);
} else {
var G__5244 = cljs.core.rest.call(null,sibs);
sibs = G__5244;
continue;
}
} else {
return null;
}
break;
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__5242);
}});
tiltontec.model.navigate.prevsib = (function tiltontec$model$navigate$prevsib(mx){
var _STAR_depender_STAR__orig_val__5245 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__5246 = null;
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__5246);

try{var sibs = tiltontec.model.accessors.mget_QMARK_.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,mx)),new cljs.core.Keyword(null,"kids","kids",1156670771));
while(true){
if(cljs.core.truth_(sibs)){
if(cljs.core._EQ_.call(null,mx,cljs.core.first.call(null,sibs))){
return null;
} else {
if(cljs.core._EQ_.call(null,mx,cljs.core.second.call(null,sibs))){
return cljs.core.first.call(null,sibs);
} else {
var G__5247 = cljs.core.rest.call(null,sibs);
sibs = G__5247;
continue;

}
}
} else {
return null;
}
break;
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__5245);
}});
/**
 * Return true if 'poss' is the matrix reference we 'seek'
 * 
 * There are 4 branches to this.
 * 
 * 'poss' is not a ref, return false
 * 'seek' is a fn?, we return result of invoke it with 'poss'
 * 'seek' is a keyword?, we return true if it is = with (:name poss)
 * :else compare 'poss' and 'seek' directly using =
 */
tiltontec.model.navigate.fm_navig_EQ_ = (function tiltontec$model$navigate$fm_navig_EQ_(seek,poss){
if((!((poss instanceof cljs.core.Atom)))){
return false;
} else {
if(cljs.core.fn_QMARK_.call(null,seek)){
return seek.call(null,poss);
} else {
if((seek instanceof cljs.core.Keyword)){
return cljs.core._EQ_.call(null,seek,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,poss)));
} else {
return cljs.core._EQ_.call(null,seek,poss);

}
}
}
});
tiltontec.model.navigate.fasc_higher = (function tiltontec$model$navigate$fasc_higher(what,where,options){
while(true){
var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"me?","me?",-625404259).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tiltontec.model.navigate.fm_navig_EQ_.call(null,what,where);
if(cljs.core.truth_(and__4115__auto____$1)){
return where;
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((where instanceof cljs.core.Atom)){
var G__5248 = what;
var G__5249 = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,where));
var G__5250 = cljs.core.assoc.call(null,options,new cljs.core.Keyword(null,"me?","me?",-625404259),true);
what = G__5248;
where = G__5249;
options = G__5250;
continue;
} else {
return null;
}
}
break;
}
});
/**
 * Search matrix ascendents for 'what', starting at 'where'
 * See fm-navig= for options about 'what' can be
 * if :me? is true, and (fm-navig= what where) return 'where'
 * if (:parent @where) returns a parent, recurse up the family tree
 * return an error when (:must? options) is true and we nothing is found
 */
tiltontec.model.navigate.fasc = (function tiltontec$model$navigate$fasc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5256 = arguments.length;
var i__4737__auto___5257 = (0);
while(true){
if((i__4737__auto___5257 < len__4736__auto___5256)){
args__4742__auto__.push((arguments[i__4737__auto___5257]));

var G__5258 = (i__4737__auto___5257 + (1));
i__4737__auto___5257 = G__5258;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.model.navigate.fasc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.model.navigate.fasc.cljs$core$IFn$_invoke$arity$variadic = (function (what,where,options){
if(cljs.core.truth_(where)){
} else {
throw (new Error(["Assert failed: ",["fasc> 'where' arg is nil seeking ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(what),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(options)].join(''),"\n","where"].join('')));
}

if((((!((where instanceof cljs.core.Atom)))) || ((!(tiltontec.cell.base.md_dead_QMARK_.call(null,where)))))){
} else {
throw (new Error(["Assert failed: ",["fasc> pass dead 'where' ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tiltontec.cell.diagnostic.minfo.call(null,where)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"seeking","seeking",-1543638812)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(what)].join(''),"\n","(or (not (any-ref? where)) (not (md-dead? where)))"].join('')));
}

if(cljs.core.truth_(what)){
} else {
throw (new Error(["Assert failed: ",["fasc> 'what' arg is nil searching from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tiltontec.cell.diagnostic.minfo.call(null,where)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(options)].join(''),"\n","what"].join('')));
}

var options__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"me?","me?",-625404259),false,new cljs.core.Keyword(null,"wocd?","wocd?",-195637516),true,new cljs.core.Keyword(null,"must?","must?",1639898554),true], null),cljs.core.apply.call(null,cljs.core.hash_map,options));
var _STAR_depender_STAR__orig_val__5254 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__5255 = (cljs.core.truth_(new cljs.core.Keyword(null,"wocd?","wocd?",-195637516).cljs$core$IFn$_invoke$arity$1(options__$1))?null:tiltontec.cell.base._STAR_depender_STAR_);
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__5255);

try{var or__4126__auto__ = tiltontec.model.navigate.fasc_higher.call(null,what,where,options__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"must?","must?",1639898554).cljs$core$IFn$_invoke$arity$1(options__$1))){
throw cljs.core.ex_info.call(null,"fasc: model not found",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"what","what",987290269),what,new cljs.core.Keyword(null,"where","where",-2044795965),where,new cljs.core.Keyword(null,"options","options",99638489),options__$1], null));
} else {
return null;
}
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__5254);
}}));

(tiltontec.model.navigate.fasc.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.model.navigate.fasc.cljs$lang$applyTo = (function (seq5251){
var G__5252 = cljs.core.first.call(null,seq5251);
var seq5251__$1 = cljs.core.next.call(null,seq5251);
var G__5253 = cljs.core.first.call(null,seq5251__$1);
var seq5251__$2 = cljs.core.next.call(null,seq5251__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5252,G__5253,seq5251__$2);
}));

/**
 * Search matrix ascendents and descendents for `what`, starting at `where`.
 * 
 * if `:me?` is true, and (fm-navig= what where) return
 *   'where' (`:me?` is `false` by default)
 * 
 * if `:inside?` is true, try kids recursively (after removing any
 *   listed in `:skip` option)
 * 
 * if `:up?` is true, invoke fm-navig on ancestor (skipping 'where')
 */
tiltontec.model.navigate.fm_navig = (function tiltontec$model$navigate$fm_navig(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5269 = arguments.length;
var i__4737__auto___5270 = (0);
while(true){
if((i__4737__auto___5270 < len__4736__auto___5269)){
args__4742__auto__.push((arguments[i__4737__auto___5270]));

var G__5271 = (i__4737__auto___5270 + (1));
i__4737__auto___5270 = G__5271;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tiltontec.model.navigate.fm_navig.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tiltontec.model.navigate.fm_navig.cljs$core$IFn$_invoke$arity$variadic = (function (what,where,options){
var options__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"must?","must?",1639898554),true,new cljs.core.Keyword(null,"me?","me?",-625404259),false,new cljs.core.Keyword(null,"inside?","inside?",639243696),false,new cljs.core.Keyword(null,"up?","up?",77854972),true,new cljs.core.Keyword(null,"wocd?","wocd?",-195637516),true], null),cljs.core.apply.call(null,cljs.core.hash_map,options));
var or__4126__auto__ = (cljs.core.truth_((function (){var and__4115__auto__ = where;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = what;
if(cljs.core.truth_(and__4115__auto____$1)){
return (where instanceof cljs.core.Atom);
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})())?(function (){var _STAR_depender_STAR__orig_val__5265 = tiltontec.cell.base._STAR_depender_STAR_;
var _STAR_depender_STAR__temp_val__5266 = (cljs.core.truth_(new cljs.core.Keyword(null,"wocd?","wocd?",-195637516).cljs$core$IFn$_invoke$arity$1(options__$1))?null:tiltontec.cell.base._STAR_depender_STAR_);
(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__temp_val__5266);

try{var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"me?","me?",-625404259).cljs$core$IFn$_invoke$arity$1(options__$1);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tiltontec.model.navigate.fm_navig_EQ_.call(null,what,where);
if(cljs.core.truth_(and__4115__auto____$1)){
return where;
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"inside?","inside?",639243696).cljs$core$IFn$_invoke$arity$1(options__$1);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.some.call(null,(function (p1__5259_SHARP_){
return tiltontec.model.navigate.fm_navig.call(null,what,p1__5259_SHARP_,new cljs.core.Keyword(null,"must?","must?",1639898554),false,new cljs.core.Keyword(null,"me?","me?",-625404259),true,new cljs.core.Keyword(null,"inside?","inside?",639243696),true,new cljs.core.Keyword(null,"up?","up?",77854972),false);
}),cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"skip","skip",602715391).cljs$core$IFn$_invoke$arity$1(options__$1)]),tiltontec.model.accessors.mget_QMARK_.call(null,where,new cljs.core.Keyword(null,"kids","kids",1156670771))));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"up?","up?",77854972).cljs$core$IFn$_invoke$arity$1(options__$1);
if(cljs.core.truth_(and__4115__auto__)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,where));
if(cljs.core.truth_(temp__5804__auto__)){
var par = temp__5804__auto__;
return tiltontec.model.navigate.fm_navig.call(null,what,par,new cljs.core.Keyword(null,"must?","must?",1639898554),false,new cljs.core.Keyword(null,"up?","up?",77854972),true,new cljs.core.Keyword(null,"me?","me?",-625404259),true,new cljs.core.Keyword(null,"skip","skip",602715391),where,new cljs.core.Keyword(null,"inside?","inside?",639243696),true);
} else {
return null;
}
} else {
return and__4115__auto__;
}
}
}
}finally {(tiltontec.cell.base._STAR_depender_STAR_ = _STAR_depender_STAR__orig_val__5265);
}})():null);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"must?","must?",1639898554).cljs$core$IFn$_invoke$arity$1(options__$1))){
var what_code$ = new cljs.core.Keyword(null,"what-code$","what-code$",-1414906969).cljs$core$IFn$_invoke$arity$1(options__$1);
var options__$2 = cljs.core.dissoc.call(null,options__$1,new cljs.core.Keyword(null,"what-code$","what-code$",-1414906969));
var d = (function (){var G__5267 = (function (){var G__5268 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"what","what",987290269),what,new cljs.core.Keyword(null,"where","where",-2044795965),where,new cljs.core.Keyword(null,"options","options",99638489),options__$2], null);
return G__5268;
})();
if(cljs.core.truth_(what_code$)){
return cljs.core.assoc.call(null,G__5267,new cljs.core.Keyword(null,"what-code$","what-code$",-1414906969),what_code$);
} else {
return G__5267;
}
})();
throw cljs.core.ex_info.call(null,"fm-navig: model not found",d);
} else {
return null;
}
}
}));

(tiltontec.model.navigate.fm_navig.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tiltontec.model.navigate.fm_navig.cljs$lang$applyTo = (function (seq5260){
var G__5261 = cljs.core.first.call(null,seq5260);
var seq5260__$1 = cljs.core.next.call(null,seq5260);
var G__5262 = cljs.core.first.call(null,seq5260__$1);
var seq5260__$2 = cljs.core.next.call(null,seq5260__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5261,G__5262,seq5260__$2);
}));

/**
 * Search matrix ascendents and descendents from node 'where', for
 *   'what', throwing an error when not found
 */
tiltontec.model.navigate.fm_BANG_ = (function tiltontec$model$navigate$fm_BANG_(what,where){
return tiltontec.model.navigate.fm_navig.call(null,what,where,new cljs.core.Keyword(null,"me?","me?",-625404259),false,new cljs.core.Keyword(null,"inside?","inside?",639243696),true,new cljs.core.Keyword(null,"must?","must?",1639898554),true,new cljs.core.Keyword(null,"up?","up?",77854972),true);
});
var ret__4785__auto___5283 = (function (){
/**
 * Search matrix ascendents from node 'me' (defaulting to 'me in current scope)
 *   looking for element with given name
 */
tiltontec.model.navigate.fmu = (function tiltontec$model$navigate$fmu(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5284 = arguments.length;
var i__4737__auto___5285 = (0);
while(true){
if((i__4737__auto___5285 < len__4736__auto___5284)){
args__4742__auto__.push((arguments[i__4737__auto___5285]));

var G__5286 = (i__4737__auto___5285 + (1));
i__4737__auto___5285 = G__5286;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.model.navigate.fmu.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.model.navigate.fmu.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,p__5279){
var vec__5280 = p__5279;
var me = cljs.core.nth.call(null,vec__5280,(0),null);
var me_ref = (function (){var or__4126__auto__ = me;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Symbol(null,"me","me",1501524834,null);
}
})();
var code$ = tiltontec.util.core.pr_code_str.call(null,name);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"name__5273__auto__","name__5273__auto__",421808172,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","fm-navig","tiltontec.model.navigate/fm-navig",151252299,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"p1__5272__5274__auto__","p1__5272__5274__auto__",661324745,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"name__5273__auto__","name__5273__auto__",421808172,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.accessors","mget?","tiltontec.model.accessors/mget?",-263515561,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"p1__5272__5274__auto__","p1__5272__5274__auto__",661324745,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"name","name",1843675177),null,(1),null))))),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,me_ref,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"me?","me?",-625404259),null,(1),null)),(new cljs.core.List(null,false,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"up?","up?",77854972),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"inside?","inside?",639243696),null,(1),null)),(new cljs.core.List(null,false,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"what-code$","what-code$",-1414906969),null,(1),null)),(new cljs.core.List(null,code$,null,(1),null))))),null,(1),null)))));
}));

(tiltontec.model.navigate.fmu.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.model.navigate.fmu.cljs$lang$applyTo = (function (seq5275){
var G__5276 = cljs.core.first.call(null,seq5275);
var seq5275__$1 = cljs.core.next.call(null,seq5275);
var G__5277 = cljs.core.first.call(null,seq5275__$1);
var seq5275__$2 = cljs.core.next.call(null,seq5275__$1);
var G__5278 = cljs.core.first.call(null,seq5275__$2);
var seq5275__$3 = cljs.core.next.call(null,seq5275__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5276,G__5277,G__5278,seq5275__$3);
}));

return null;
})()
;
(tiltontec.model.navigate.fmu.cljs$lang$macro = true);

var ret__4785__auto___5298 = (function (){
/**
 * `fmu` with `me` inclusive.
 */
tiltontec.model.navigate.fmuinc = (function tiltontec$model$navigate$fmuinc(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5299 = arguments.length;
var i__4737__auto___5300 = (0);
while(true){
if((i__4737__auto___5300 < len__4736__auto___5299)){
args__4742__auto__.push((arguments[i__4737__auto___5300]));

var G__5301 = (i__4737__auto___5300 + (1));
i__4737__auto___5300 = G__5301;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return tiltontec.model.navigate.fmuinc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(tiltontec.model.navigate.fmuinc.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,name,p__5294){
var vec__5295 = p__5294;
var me = cljs.core.nth.call(null,vec__5295,(0),null);
var me_ref = (function (){var or__4126__auto__ = me;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Symbol(null,"me","me",1501524834,null);
}
})();
var code$ = tiltontec.util.core.pr_code_str.call(null,name);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"name__5288__auto__","name__5288__auto__",-1235971259,null),null,(1),null)),(new cljs.core.List(null,name,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","fm-navig","tiltontec.model.navigate/fm-navig",151252299,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"p1__5287__5289__auto__","p1__5287__5289__auto__",-1167447211,null),null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","=","cljs.core/=",-1891498332,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"name__5288__auto__","name__5288__auto__",-1235971259,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.accessors","mget?","tiltontec.model.accessors/mget?",-263515561,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"p1__5287__5289__auto__","p1__5287__5289__auto__",-1167447211,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"name","name",1843675177),null,(1),null))))),null,(1),null))))),null,(1),null))))),null,(1),null)),(new cljs.core.List(null,me_ref,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"me?","me?",-625404259),null,(1),null)),(new cljs.core.List(null,false,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"up?","up?",77854972),null,(1),null)),(new cljs.core.List(null,true,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"inside?","inside?",639243696),null,(1),null)),(new cljs.core.List(null,false,null,(1),null)),(new cljs.core.List(null,new cljs.core.Keyword(null,"what-code$","what-code$",-1414906969),null,(1),null)),(new cljs.core.List(null,code$,null,(1),null))))),null,(1),null)))));
}));

(tiltontec.model.navigate.fmuinc.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(tiltontec.model.navigate.fmuinc.cljs$lang$applyTo = (function (seq5290){
var G__5291 = cljs.core.first.call(null,seq5290);
var seq5290__$1 = cljs.core.next.call(null,seq5290);
var G__5292 = cljs.core.first.call(null,seq5290__$1);
var seq5290__$2 = cljs.core.next.call(null,seq5290__$1);
var G__5293 = cljs.core.first.call(null,seq5290__$2);
var seq5290__$3 = cljs.core.next.call(null,seq5290__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5291,G__5292,G__5293,seq5290__$3);
}));

return null;
})()
;
(tiltontec.model.navigate.fmuinc.cljs$lang$macro = true);

/**
 * Search matrix ascendents from node 'where' looking for element with
 *   given name
 */
tiltontec.model.navigate.mxu_find_name = (function tiltontec$model$navigate$mxu_find_name(where,name){
return tiltontec.model.navigate.fm_navig.call(null,(function (p1__5302_SHARP_){
return cljs.core._EQ_.call(null,name,tiltontec.model.accessors.mget_QMARK_.call(null,p1__5302_SHARP_,new cljs.core.Keyword(null,"name","name",1843675177)));
}),where,new cljs.core.Keyword(null,"me?","me?",-625404259),false,new cljs.core.Keyword(null,"up?","up?",77854972),true,new cljs.core.Keyword(null,"inside?","inside?",639243696),false);
});
/**
 * Search matrix ascendents from node 'where' looking for element with
 *   given id
 */
tiltontec.model.navigate.mxu_find_id = (function tiltontec$model$navigate$mxu_find_id(where,id){
return tiltontec.model.navigate.fm_navig.call(null,(function (p1__5303_SHARP_){
return cljs.core._EQ_.call(null,id,tiltontec.model.accessors.mget_QMARK_.call(null,p1__5303_SHARP_,new cljs.core.Keyword(null,"id","id",-1388402092)));
}),where,new cljs.core.Keyword(null,"me?","me?",-625404259),false,new cljs.core.Keyword(null,"up?","up?",77854972),true,new cljs.core.Keyword(null,"inside?","inside?",639243696),false);
});
/**
 * Search matrix ascendents from node 'where' for `id-or-name`, trying first as
 *   a `name`, then as an `id`.
 */
tiltontec.model.navigate.fmo = (function tiltontec$model$navigate$fmo(where,id_or_name){
var or__4126__auto__ = tiltontec.model.navigate.mxu_find_name.call(null,where,id_or_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = tiltontec.model.navigate.mxu_find_id.call(null,where,id_or_name);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
throw cljs.core.ex_info.call(null,["fmo> not id or name ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_or_name)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id-name","id-name",-2029013470),id_or_name], null));
}
}
});
/**
 * Use `fmo` and extract `:value` (or prop indicated by `:prop-name`)
 */
tiltontec.model.navigate.fmov = (function tiltontec$model$navigate$fmov(var_args){
var G__5305 = arguments.length;
switch (G__5305) {
case 2:
return tiltontec.model.navigate.fmov.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return tiltontec.model.navigate.fmov.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tiltontec.model.navigate.fmov.cljs$core$IFn$_invoke$arity$2 = (function (where,id_or_name){
return tiltontec.model.navigate.fmov.call(null,where,id_or_name,new cljs.core.Keyword(null,"value","value",305978217));
}));

(tiltontec.model.navigate.fmov.cljs$core$IFn$_invoke$arity$3 = (function (where,id_or_name,prop_name){
var temp__5804__auto__ = tiltontec.model.navigate.fmo.call(null,where,id_or_name);
if(cljs.core.truth_(temp__5804__auto__)){
var mx = temp__5804__auto__;
if(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,mx),prop_name)){
return tiltontec.model.accessors.mget.call(null,mx,prop_name);
} else {
throw cljs.core.ex_info.call(null,["fmov> ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_or_name)," lacks ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop_name)," property"].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id-name","id-name",-2029013470),id_or_name,new cljs.core.Keyword(null,"prop-name","prop-name",-1200968058),prop_name], null));
}
} else {
return null;
}
}));

(tiltontec.model.navigate.fmov.cljs$lang$maxFixedArity = 3);

var ret__4785__auto___5316 = (function (){
/**
 * Search matrix ascendents from node 'me' looking for `what`, and extract `prop`
 */
tiltontec.model.navigate.mdv_BANG_ = (function tiltontec$model$navigate$mdv_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___5317 = arguments.length;
var i__4737__auto___5318 = (0);
while(true){
if((i__4737__auto___5318 < len__4736__auto___5317)){
args__4742__auto__.push((arguments[i__4737__auto___5318]));

var G__5319 = (i__4737__auto___5318 + (1));
i__4737__auto___5318 = G__5319;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((4) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((4)),(0),null)):null);
return tiltontec.model.navigate.mdv_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4743__auto__);
});

(tiltontec.model.navigate.mdv_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,what,prop,p__5312){
var vec__5313 = p__5312;
var me = cljs.core.nth.call(null,vec__5313,(0),null);
var me__$1 = (function (){var or__4126__auto__ = me;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Symbol(null,"me","me",1501524834,null);
}
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.accessors","mget","tiltontec.model.accessors/mget",1103594552,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("tiltontec.model.navigate","fm!","tiltontec.model.navigate/fm!",-379937655,null),null,(1),null)),(new cljs.core.List(null,what,null,(1),null)),(new cljs.core.List(null,me__$1,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,prop,null,(1),null)))));
}));

(tiltontec.model.navigate.mdv_BANG_.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(tiltontec.model.navigate.mdv_BANG_.cljs$lang$applyTo = (function (seq5307){
var G__5308 = cljs.core.first.call(null,seq5307);
var seq5307__$1 = cljs.core.next.call(null,seq5307);
var G__5309 = cljs.core.first.call(null,seq5307__$1);
var seq5307__$2 = cljs.core.next.call(null,seq5307__$1);
var G__5310 = cljs.core.first.call(null,seq5307__$2);
var seq5307__$3 = cljs.core.next.call(null,seq5307__$2);
var G__5311 = cljs.core.first.call(null,seq5307__$3);
var seq5307__$4 = cljs.core.next.call(null,seq5307__$3);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5308,G__5309,G__5310,G__5311,seq5307__$4);
}));

return null;
})()
;
(tiltontec.model.navigate.mdv_BANG_.cljs$lang$macro = true);

