(defproject org.lotuc/nubank-k8s-api "0.2.2-SNAPSHOT"
  :description "A library to talk with kubernetes api"
  :url "https://github.com/nubank/k8s-api"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :plugins [[lein-cljfmt "0.5.7"]
            [lein-kibit "0.1.6"]
            [lein-nsorg "0.2.0"]]
  :cljfmt {:indents {providing [[:inner 0]]}}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 [martian "0.1.12-20191222.142233-2"]
                 [martian-httpkit "0.1.11"]
                 [io.forward/yaml "1.0.9"]
                 [less-awful-ssl "1.0.4"]]
  :main ^:skip-aot kubernetes-api.core
  :resource-paths ["resources"]
  :target-path "target/%s"
  :aliases {"lint"     ["do" ["cljfmt" "check"] ["nsorg"] ["kibit"]]
            "lint-fix" ["do" ["cljfmt" "fix"] ["nsorg" "--replace"] ["kibit" "--replace"]]}
  :deploy-repositories [["releases"  {:sign-releases false :url "https://clojars.org/repo"}]
                        ["snapshots" {:sign-releases false :url "https://clojars.org/repo"
                                      :username "lotuc"
                                      :password "CLOJARS_b15f5b8f833bcc96810a5b3e59f5f7b346d269cc7956f5ef5a9c7c6362e7"}]]
  :profiles {:uberjar {:aot :all}
             :dev {:dependencies [[nubank/matcher-combinators "3.8.5"]
                                  [nubank/mockfn "0.7.0"]]}})
